/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.UsersGroupsExtractionRecordsDeletedEvent;
import com.atlassian.jira.migration.events.UsersGroupsExtractionRecordsInsertedEvent;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsExtraction;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsExtractionTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\f\u001a\u00020\nJ\u0014\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "deleteByExecutionId", "", "executionId", "", "deleteByUserKey", "userKey", "findByExecutionId", "", "Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtraction;", "findByUserKey", "saveAll", "usersGroupsExtractions", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUsersGroupsExtractionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsersGroupsExtractionRepository.kt\ncom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,210:1\n1477#2:211\n1502#2,3:212\n1505#2,3:222\n1549#2:227\n1620#2,3:228\n1549#2:231\n1620#2,3:232\n1855#2,2:235\n372#3,7:215\n215#4,2:225\n*S KotlinDebug\n*F\n+ 1 UsersGroupsExtractionRepository.kt\ncom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository\n*L\n76#1:211\n76#1:212,3\n76#1:222,3\n49#1:227\n49#1:228,3\n63#1:231\n63#1:232,3\n80#1:235,2\n76#1:215,7\n76#1:225,2\n*E\n"})
public final class UsersGroupsExtractionRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(UsersGroupsExtractionRepository.class);

    @Inject
    public UsersGroupsExtractionRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.databaseAccessor = databaseAccessor;
        this.migrationEventBus = migrationEventBus;
    }

    @NotNull
    public final List<UsersGroupsExtraction> findByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object object = this.databaseAccessor.run(arg_0 -> UsersGroupsExtractionRepository.findByExecutionId$lambda$0(executionId, arg_0), UsersGroupsExtractionRepository::findByExecutionId$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @NotNull
    public final List<UsersGroupsExtraction> findByUserKey(@NotNull String userKey) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        List extractionsByUserKey = CollectionsKt.emptyList();
        try {
            Object object = this.databaseAccessor.run(arg_0 -> UsersGroupsExtractionRepository.findByUserKey$lambda$3(userKey, arg_0), UsersGroupsExtractionRepository::findByUserKey$lambda$4);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
            extractionsByUserKey = (List)object;
        }
        catch (RuntimeException e) {
            log.error("Could not find users groups extractions by userKey: " + userKey + '.', (Throwable)e);
        }
        return extractionsByUserKey;
    }

    /*
     * WARNING - void declaration
     */
    public final void saveAll(@NotNull List<UsersGroupsExtraction> usersGroupsExtractions) {
        Intrinsics.checkNotNullParameter(usersGroupsExtractions, (String)"usersGroupsExtractions");
        try {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = usersGroupsExtractions;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                UsersGroupsExtraction it = (UsersGroupsExtraction)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getExecutionId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                String executionId = (String)entry.getKey();
                List extractions = (List)entry.getValue();
                Integer numberOfRecordsInserted = (Integer)this.databaseAccessor.run(arg_0 -> UsersGroupsExtractionRepository.saveAll$lambda$10$lambda$8(usersGroupsExtractions, extractions, arg_0), UsersGroupsExtractionRepository::saveAll$lambda$10$lambda$9);
                this.migrationEventBus.post(new UsersGroupsExtractionRecordsInsertedEvent(numberOfRecordsInserted.intValue(), executionId));
            }
        }
        catch (RuntimeException e) {
            log.error("Could not save users groups extractions.", (Throwable)e);
        }
    }

    public final void deleteByUserKey(@NotNull String userKey) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        try {
            Long numberOfRecordsDeleted = (Long)this.databaseAccessor.run(arg_0 -> UsersGroupsExtractionRepository.deleteByUserKey$lambda$11(userKey, arg_0), UsersGroupsExtractionRepository::deleteByUserKey$lambda$12);
            Intrinsics.checkNotNull((Object)numberOfRecordsDeleted);
            this.migrationEventBus.post(new UsersGroupsExtractionRecordsDeletedEvent(numberOfRecordsDeleted, null, 2, null));
        }
        catch (RuntimeException e) {
            log.error("Could not delete users groups extractions by userKey: " + userKey + '.', (Throwable)e);
        }
    }

    public final void deleteByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        try {
            Long numberOfRecordsDeleted = (Long)this.databaseAccessor.run(arg_0 -> UsersGroupsExtractionRepository.deleteByExecutionId$lambda$13(executionId, arg_0), UsersGroupsExtractionRepository::deleteByExecutionId$lambda$14);
            Intrinsics.checkNotNull((Object)numberOfRecordsDeleted);
            this.migrationEventBus.post(new UsersGroupsExtractionRecordsDeletedEvent(numberOfRecordsDeleted, executionId));
        }
        catch (RuntimeException e) {
            log.error("Could not delete users groups extractions by executionId: " + executionId + '.', (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List findByExecutionId$lambda$0(String $executionId, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Object object = UsersGroupsExtractionTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)UsersGroupsExtractionTable.INSTANCE)).where((Predicate)UsersGroupsExtractionTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = UsersGroupsExtractionTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((UsersGroupsExtractionTable)((Object)object)).toUsersGroupsExtraction((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findByExecutionId$lambda$1() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List findByUserKey$lambda$3(String $userKey, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$userKey, (String)"$userKey");
        Object object = UsersGroupsExtractionTable.INSTANCE.all();
        List list = ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(object, ((Path[])object).length)).from((Expression)UsersGroupsExtractionTable.INSTANCE)).where((Predicate)UsersGroupsExtractionTable.INSTANCE.getUSER_KEY().eq((Object)$userKey))).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable iterable = list;
        object = UsersGroupsExtractionTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((UsersGroupsExtractionTable)((Object)object)).toUsersGroupsExtraction((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void findByUserKey$lambda$4() {
    }

    private static final Integer saveAll$lambda$10$lambda$8(List $usersGroupsExtractions, List $extractions, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        Intrinsics.checkNotNullParameter((Object)$usersGroupsExtractions, (String)"$usersGroupsExtractions");
        Intrinsics.checkNotNullParameter((Object)$extractions, (String)"$extractions");
        SQLInsertClause $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247 = sQLInsertClause = db.insert((RelationalPath)UsersGroupsExtractionTable.INSTANCE);
        boolean bl = false;
        Iterable $this$forEach$iv = $extractions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UsersGroupsExtraction it = (UsersGroupsExtraction)element$iv;
            boolean bl2 = false;
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getEXECUTION_ID(), (Object)it.getExecutionId());
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getNAME(), (Object)it.getName());
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getTYPE(), (Object)it.getType().toString());
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getREFERENCED_BY(), (Object)it.getReferencedBy());
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getREFERENCED_BY_GROUPS(), (Object)it.getReferencedByGroups());
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getUSER_KEY(), (Object)it.getUserKey());
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getUSER_EMAIL(), (Object)it.getUserEmail());
            Boolean bl3 = it.getPreserveMembership();
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getPRESERVE_MEMBERSHIP(), (Object)(bl3 != null ? bl3 : false));
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.set((Path)UsersGroupsExtractionTable.INSTANCE.getVERSION(), (Object)it.getVersion());
            $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.addBatch();
        }
        $this$saveAll_u24lambda_u2410_u24lambda_u248_u24lambda_u247.execute();
        return $usersGroupsExtractions.size();
    }

    private static final void saveAll$lambda$10$lambda$9() {
    }

    private static final Long deleteByUserKey$lambda$11(String $userKey, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$userKey, (String)"$userKey");
        return db.delete((RelationalPath)UsersGroupsExtractionTable.INSTANCE).where((Predicate)UsersGroupsExtractionTable.INSTANCE.getUSER_KEY().eq((Object)$userKey)).execute();
    }

    private static final void deleteByUserKey$lambda$12() {
    }

    private static final Long deleteByExecutionId$lambda$13(String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return db.delete((RelationalPath)UsersGroupsExtractionTable.INSTANCE).where((Predicate)UsersGroupsExtractionTable.INSTANCE.getEXECUTION_ID().eq((Object)$executionId)).execute();
    }

    private static final void deleteByExecutionId$lambda$14() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

