/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.reports;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.reports.AbstractReportService;
import com.atlassian.jira.migration.preflight.reports.ExtractionType;
import com.atlassian.jira.migration.preflight.reports.MigrationReportStatusRepository;
import com.atlassian.jira.migration.preflight.reports.ReportType;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsExtraction;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsExtractionReportOutput;
import com.atlassian.jira.migration.preflight.reports.UsersGroupsExtractionRepository;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissions;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.References;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersWithReferences;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016J(\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsReportService;", "Lcom/atlassian/jira/migration/preflight/reports/AbstractReportService;", "usersGroupsExtractionRepository", "Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository;", "usersGroupsExtractionReportOutput", "Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionReportOutput;", "reportStatusRepository", "Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "executor", "Ljava/util/concurrent/Executor;", "(Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionRepository;Lcom/atlassian/jira/migration/preflight/reports/UsersGroupsExtractionReportOutput;Lcom/atlassian/jira/migration/preflight/reports/MigrationReportStatusRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;Ljava/util/concurrent/Executor;)V", "reportType", "Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "getReportType", "()Lcom/atlassian/jira/migration/preflight/reports/ReportType;", "deleteReportDataByExecutionId", "", "executionId", "", "generateReportData", "Ljava/util/concurrent/CompletableFuture;", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "usersAndGroups", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "saveScopedUsersExtraction", "usersWithReferences", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersWithReferences;", "groupsWithReferences", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/GroupsWithReferences;", "preserveMembership", "", "writeReportToStream", "outputStream", "Ljava/io/OutputStream;", "jira-migration-plugin"})
public final class UsersGroupsReportService
extends AbstractReportService {
    @NotNull
    private final UsersGroupsExtractionRepository usersGroupsExtractionRepository;
    @NotNull
    private final UsersGroupsExtractionReportOutput usersGroupsExtractionReportOutput;
    @NotNull
    private final Executor executor;
    @NotNull
    private final ReportType reportType;

    @Inject
    public UsersGroupsReportService(@NotNull UsersGroupsExtractionRepository usersGroupsExtractionRepository, @NotNull UsersGroupsExtractionReportOutput usersGroupsExtractionReportOutput, @NotNull MigrationReportStatusRepository reportStatusRepository, @NotNull MigrationEventBus migrationEventBus, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)usersGroupsExtractionRepository, (String)"usersGroupsExtractionRepository");
        Intrinsics.checkNotNullParameter((Object)usersGroupsExtractionReportOutput, (String)"usersGroupsExtractionReportOutput");
        Intrinsics.checkNotNullParameter((Object)reportStatusRepository, (String)"reportStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super(reportStatusRepository, migrationEventBus);
        this.usersGroupsExtractionRepository = usersGroupsExtractionRepository;
        this.usersGroupsExtractionReportOutput = usersGroupsExtractionReportOutput;
        this.executor = executor;
        this.reportType = ReportType.USERS_AND_GROUPS;
    }

    @Override
    @NotNull
    protected ReportType getReportType() {
        return this.reportType;
    }

    @NotNull
    public final CompletableFuture<Unit> generateReportData(@NotNull String executionId, @NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, @NotNull CompletableFuture<UsersGroupsExtractionResult> usersAndGroups) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
        Intrinsics.checkNotNullParameter(usersAndGroups, (String)"usersAndGroups");
        CompletionStage completionStage = ((CompletableFuture)usersAndGroups.thenApplyAsync(arg_0 -> UsersGroupsReportService.generateReportData$lambda$0((Function1)new Function1<UsersGroupsExtractionResult, Unit>(this, executionId, usersGroupsMigrationOption){
            final /* synthetic */ UsersGroupsReportService this$0;
            final /* synthetic */ String $executionId;
            final /* synthetic */ UsersGroupsMigrationOption $usersGroupsMigrationOption;
            {
                this.this$0 = $receiver;
                this.$executionId = $executionId;
                this.$usersGroupsMigrationOption = $usersGroupsMigrationOption;
                super(1);
            }

            public final void invoke(UsersGroupsExtractionResult it) {
                UsersGroupsReportService.access$saveScopedUsersExtraction(this.this$0, it.getUsersWithReferences(), it.getGroupsWithReferences(), this.$executionId, this.$usersGroupsMigrationOption.getMemberships());
                AbstractReportService.setReportGenerationCompleted$default(this.this$0, this.$executionId, null, 2, null);
            }
        }, arg_0), this.executor)).exceptionally(arg_0 -> UsersGroupsReportService.generateReportData$lambda$1(this, executionId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"exceptionally(...)");
        return completionStage;
    }

    @Override
    public void writeReportToStream(@NotNull String executionId, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        List<UsersGroupsExtraction> scopedUsersGroupsExtraction = this.usersGroupsExtractionRepository.findByExecutionId(executionId);
        this.usersGroupsExtractionReportOutput.write(outputStream, scopedUsersGroupsExtraction);
    }

    private final void saveScopedUsersExtraction(UsersWithReferences usersWithReferences, GroupsWithReferences groupsWithReferences, String executionId, boolean preserveMembership) {
        List scopedUserExtractions2 = usersWithReferences.map((Function1)new Function1<Map.Entry<? extends JiraUser, ? extends References>, UsersGroupsExtraction>(executionId, preserveMembership){
            final /* synthetic */ String $executionId;
            final /* synthetic */ boolean $preserveMembership;
            {
                this.$executionId = $executionId;
                this.$preserveMembership = $preserveMembership;
                super(1);
            }

            @NotNull
            public final UsersGroupsExtraction invoke(@NotNull Map.Entry<JiraUser, References> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                JiraUser user = entry.getKey();
                References references = entry.getValue();
                return new UsersGroupsExtraction(this.$executionId, user.getFullName(), ExtractionType.USER, CollectionsKt.joinToString$default((Iterable)references.getProjects(), null, null, null, (int)0, null, null, (int)63, null), CollectionsKt.joinToString$default((Iterable)references.getGroups(), null, null, null, (int)0, null, null, (int)63, null), user.getUserKey(), user.getEmail(), this.$preserveMembership, 0, 256, null);
            }
        });
        List scopedGroupExtractions2 = groupsWithReferences.map((Function1)new Function1<Map.Entry<? extends JiraGroupWithPermissions, ? extends References>, UsersGroupsExtraction>(executionId){
            final /* synthetic */ String $executionId;
            {
                this.$executionId = $executionId;
                super(1);
            }

            @NotNull
            public final UsersGroupsExtraction invoke(@NotNull Map.Entry<JiraGroupWithPermissions, References> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                JiraGroupWithPermissions group = entry.getKey();
                References references = entry.getValue();
                return new UsersGroupsExtraction(this.$executionId, group.getName(), ExtractionType.GROUP, CollectionsKt.joinToString$default((Iterable)references.getProjects(), null, null, null, (int)0, null, null, (int)63, null), "", null, null, null, 0, 480, null);
            }
        });
        this.deleteReportDataByExecutionId(executionId);
        this.usersGroupsExtractionRepository.saveAll(CollectionsKt.plus((Collection)scopedUserExtractions2, (Iterable)scopedGroupExtractions2));
    }

    public final void deleteReportDataByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.usersGroupsExtractionRepository.deleteByExecutionId(executionId);
    }

    private static final Unit generateReportData$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit generateReportData$lambda$1(UsersGroupsReportService this$0, String $executionId, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        AbstractReportService abstractReportService = this$0;
        Intrinsics.checkNotNull((Object)it);
        AbstractReportService.setReportGenerationFailed$default(abstractReportService, $executionId, it, null, 4, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$saveScopedUsersExtraction(UsersGroupsReportService $this, UsersWithReferences usersWithReferences, GroupsWithReferences groupsWithReferences, String executionId, boolean preserveMembership) {
        $this.saveScopedUsersExtraction(usersWithReferences, groupsWithReferences, executionId, preserveMembership);
    }
}

