/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.rest;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.dto.ChecksResultDto;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.infrastructure.rest.ErrorResponse;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.migration.plan.AppsMigrationOption;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.CrossProjectExportConfig;
import com.atlassian.jira.migration.plan.PbpMigrationMode;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.plan.rest.PlanConfig;
import com.atlassian.jira.migration.plan.rest.PlanPreflightChecks;
import com.atlassian.jira.migration.preflight.AllInOnPbpHelper;
import com.atlassian.jira.migration.preflight.AllInOnPbpPlanInfo;
import com.atlassian.jira.migration.preflight.PreflightLockException;
import com.atlassian.jira.migration.preflight.PreflightMandatoryUrlsCheck;
import com.atlassian.jira.migration.preflight.PreflightMandatoryUrlsCheckResult;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.csv.PreflightCSVWriter;
import com.atlassian.jira.migration.preflight.csv.UnableToWriteCsvException;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.ProjectKey;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="check")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0007J.\u0010\u001a\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J&\u0010 \u001a\u00020\u00132\b\b\u0001\u0010!\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u0019H\u0007J\u001a\u0010\"\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010#\u001a\u00020\u00132\b\b\u0001\u0010!\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0007J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010'\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0007J&\u0010*\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020\u00192\b\b\u0001\u0010,\u001a\u00020\u0019H\u0007J(\u0010-\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010.\u001a\u00020\u001c2\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u0019H\u0007J\u0012\u00100\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0007J\u001c\u00101\u001a\u00020\u00132\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0007J\u001a\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u00192\b\b\u0002\u00104\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/preflight/rest/PreflightResource;", "", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "allInOnPbpHelper", "Lcom/atlassian/jira/migration/preflight/AllInOnPbpHelper;", "preflightMandatoryUrlsCheck", "Lcom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsCheck;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/migration/preflight/AllInOnPbpHelper;Lcom/atlassian/jira/migration/preflight/PreflightMandatoryUrlsCheck;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkMandatoryUrls", "Ljavax/ws/rs/core/Response;", "convertToResponse", "statuses", "Lcom/atlassian/cmpt/check/base/CheckExecutionStatus;", "deleteCheckExecutionResults", "executionId", "", "executeCheck", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "serverAppKey", "planConfig", "Lcom/atlassian/jira/migration/plan/rest/PlanConfig;", "executeCheckForAppOnSavedPlan", "planId", "executeChecks", "executeChecksOnSavedPlan", "planPreflightChecks", "Lcom/atlassian/jira/migration/plan/rest/PlanPreflightChecks;", "executeChecksWithLockHandling", "exportErrorLogs", "projectKey", "Lcom/atlassian/jira/migration/preflight/model/ProjectKey;", "generateAppVendorCheckCSV", "appKey", "checkId", "generateCSV", "type", "planName", "getCheckExecutionStatus", "getExecutionStatusForIndividualCheck", "sanitiseString", "stringToSanitise", "pattern", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightResource.kt\ncom/atlassian/jira/migration/preflight/rest/PreflightResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1#2:330\n*E\n"})
public final class PreflightResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final AllInOnPbpHelper allInOnPbpHelper;
    @NotNull
    private final PreflightMandatoryUrlsCheck preflightMandatoryUrlsCheck;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;
    @NotNull
    private static final String APPLICATION_ZIP = "application/zip";
    @NotNull
    private static final String SERVER_APP_KEY_REGEX = "^[a-zA-Z0-9-._]+$";

    @Inject
    public PreflightResource(@NotNull PreflightService preflightService, @NotNull MigrationLogsService migrationLogsService, @NotNull AllInOnPbpHelper allInOnPbpHelper, @NotNull PreflightMandatoryUrlsCheck preflightMandatoryUrlsCheck, @NotNull PlanRepository planRepository, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)allInOnPbpHelper, (String)"allInOnPbpHelper");
        Intrinsics.checkNotNullParameter((Object)preflightMandatoryUrlsCheck, (String)"preflightMandatoryUrlsCheck");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.preflightService = preflightService;
        this.migrationLogsService = migrationLogsService;
        this.allInOnPbpHelper = allInOnPbpHelper;
        this.preflightMandatoryUrlsCheck = preflightMandatoryUrlsCheck;
        this.planRepository = planRepository;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(PreflightResource.class);
    }

    @GET
    @Path(value="/{executionId}/status")
    @NotNull
    public final Response getCheckExecutionStatus(@PathParam(value="executionId") @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return this.convertToResponse(this.preflightService.getStatus(executionId));
    }

    @GET
    @Path(value="/{executionId}/status/{checkType}")
    @NotNull
    public final Response getExecutionStatusForIndividualCheck(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="checkType") @NotNull CheckType checkType) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        return this.convertToResponse(this.preflightService.getStatus(executionId, checkType));
    }

    @POST
    @Path(value="/{executionId}")
    @NotNull
    public final Response executeChecks(@PathParam(value="executionId") @NotNull String executionId, @NotNull PlanConfig planConfig) {
        EnumSet<CheckType> enumSet;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)planConfig, (String)"planConfig");
        String sanitisedExecutionId = PreflightResource.sanitiseString$default(this, executionId, null, 2, null);
        if (this.migrationFeatures.getEnablePreflightLock()) {
            String planId;
            Plan plan2 = this.planRepository.getByExecutionId(sanitisedExecutionId);
            String string = planId = plan2 != null ? plan2.getId() : null;
            if (planId == null) {
                this.log.error("Preflight lock requires plan to be saved before running preflights - plan name: " + planConfig.getName());
            } else {
                EnumSet<CheckType> enumSet2 = planConfig.getPreflightChecksToRun();
                if (enumSet2 == null) {
                    enumSet2 = CheckType.Companion.getEmptyCheckTypeSet();
                }
                PlanPreflightChecks planPreflightChecks = new PlanPreflightChecks(enumSet2, planConfig.getPreflightChecksToOverride());
                return this.executeChecksWithLockHandling(planId, planPreflightChecks);
            }
        }
        if (planConfig.getPbpMigrationMode() == PbpMigrationMode.SELECT_ALL_DATA) {
            this.allInOnPbpHelper.logAndEmitAllInOnDraftPlanPreflightStats(sanitisedExecutionId, new AllInOnPbpPlanInfo(planConfig.getProjectKeys(), planConfig.getPlanIds(), planConfig.getExcludedProjectKeys(), null, null, false, 56, null));
        }
        if ((enumSet = planConfig.getPreflightChecksToRun()) == null) {
            enumSet = CheckType.Companion.getEmptyCheckTypeSet();
        }
        EnumSet<CheckType> enumSet3 = planConfig.getPreflightChecksToOverride();
        String string = planConfig.getCloudSite().getCloudId();
        List<String> list = planConfig.getProjectKeys();
        UsersGroupsMigrationOption usersGroupsMigrationOption = planConfig.getUsersGroupsMigrationOption();
        AppsMigrationOption appsMigrationOption = planConfig.getAppsMigrationOption();
        Intrinsics.checkNotNull((Object)appsMigrationOption);
        return this.convertToResponse(PreflightService.executeChecksForDraftPlan$default(this.preflightService, sanitisedExecutionId, enumSet, enumSet3, string, list, usersGroupsMigrationOption, appsMigrationOption, planConfig.getProjectDataMigrationMode(), planConfig.getMigrationType(), planConfig.getPlanIds(), planConfig.isCustomFieldsDeleted(), planConfig.getSinglePathMode(), planConfig.getName(), planConfig.getLiftAndShiftMode(), planConfig.getManualImportFile(), false, null, null, new CrossProjectConfig(new CrossProjectExportConfig(planConfig.getCrossProjectBoardsAndFiltersMigrationOption(), planConfig.getDashboardsMigrationMode())), planConfig.getMigrateArchivedIssues(), planConfig.getAdvancedRoadmapsMigrationOption(), planConfig.getMigrationTag(), planConfig.getIssueFilters(), planConfig.getAttachmentFilters(), 229376, null));
    }

    @POST
    @Path(value="/{executionId}/{checkType}")
    @NotNull
    public final Response executeCheck(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="checkType") @NotNull CheckType checkType, @QueryParam(value="appKey") @NotNull String serverAppKey, @NotNull PlanConfig planConfig) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        Intrinsics.checkNotNullParameter((Object)planConfig, (String)"planConfig");
        String sanitisedExecutionId = PreflightResource.sanitiseString$default(this, executionId, null, 2, null);
        if (planConfig.getPbpMigrationMode() == PbpMigrationMode.SELECT_ALL_DATA) {
            this.allInOnPbpHelper.logAndEmitAllInOnDraftPlanPreflightStats(sanitisedExecutionId, new AllInOnPbpPlanInfo(planConfig.getProjectKeys(), planConfig.getPlanIds(), planConfig.getExcludedProjectKeys(), null, null, false, 56, null));
        }
        String string = this.sanitiseString(serverAppKey, SERVER_APP_KEY_REGEX);
        EnumSet<Enum> enumSet = EnumSet.of((Enum)checkType);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return this.convertToResponse(this.preflightService.executeChecksForAppOnDraftPlan(string, sanitisedExecutionId, enumSet, planConfig.getPreflightChecksToOverride(), planConfig.getCloudSite().getCloudId(), planConfig.getProjectKeys(), planConfig.getUsersGroupsMigrationOption(), planConfig.getProjectDataMigrationMode(), planConfig.getMigrationType(), planConfig.getPlanIds(), planConfig.isCustomFieldsDeleted(), planConfig.getSinglePathMode(), planConfig.getName(), new CrossProjectConfig(new CrossProjectExportConfig(planConfig.getCrossProjectBoardsAndFiltersMigrationOption(), planConfig.getDashboardsMigrationMode())), planConfig.getMigrateArchivedIssues(), planConfig.getAdvancedRoadmapsMigrationOption(), planConfig.getIssueFilters(), planConfig.getAttachmentFilters()));
    }

    @POST
    @Path(value="/plan/{planId}")
    @NotNull
    public final Response executeChecksOnSavedPlan(@PathParam(value="planId") @NotNull String planId, @NotNull PlanPreflightChecks planPreflightChecks) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)planPreflightChecks, (String)"planPreflightChecks");
        return this.executeChecksWithLockHandling(planId, planPreflightChecks);
    }

    private final Response executeChecksWithLockHandling(String planId, PlanPreflightChecks planPreflightChecks) {
        Response response2;
        EnumSet<CheckType> enumSet = planPreflightChecks.getPreflightChecksToOverride();
        if (enumSet != null) {
            EnumSet<CheckType> it = enumSet;
            boolean bl = false;
            this.preflightService.updateOverriddenChecksForSavedPlan(planId, it);
        }
        try {
            String string = PreflightResource.sanitiseString$default(this, planId, null, 2, null);
            EnumSet<CheckType> enumSet2 = planPreflightChecks.getPreflightChecksToRun();
            if (enumSet2 == null) {
                enumSet2 = CheckType.Companion.getEmptyCheckTypeSet();
            }
            response2 = this.convertToResponse(PreflightService.executeChecksForPlan$default(this.preflightService, string, enumSet2, null, null, null, 28, null));
        }
        catch (PreflightLockException e) {
            this.log.warn("Plan with ID: " + planId + " is already running a preflight.", (Throwable)e);
            Response response3 = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ErrorResponse("PREFLIGHT_LOCKED")).build();
            Intrinsics.checkNotNull((Object)response3);
            response2 = response3;
        }
        return response2;
    }

    @POST
    @Path(value="/plan/{planId}/{checkType}")
    @NotNull
    public final Response executeCheckForAppOnSavedPlan(@PathParam(value="planId") @NotNull String planId, @PathParam(value="checkType") @NotNull CheckType checkType, @QueryParam(value="appKey") @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        String string = PreflightResource.sanitiseString$default(this, planId, null, 2, null);
        EnumSet<Enum> enumSet = EnumSet.of((Enum)checkType);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        return this.convertToResponse(this.preflightService.executeCheckForAppOnSavedPlan(string, enumSet, serverAppKey));
    }

    @DELETE
    @Path(value="/{executionId}")
    @NotNull
    public final Response deleteCheckExecutionResults(@PathParam(value="executionId") @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.preflightService.deleteExecution(PreflightResource.sanitiseString$default(this, executionId, null, 2, null));
        Response response2 = Response.ok().build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/{executionId}/{type}/csv")
    @NotNull
    public final Response generateCSV(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="type") @NotNull CheckType type, @QueryParam(value="planName") @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        PreflightCSVWriter writer = new PreflightCSVWriter();
        Map<String, Object> csvMapping = this.preflightService.buildCSVMap(executionId, type);
        String fileName = this.preflightService.getCSVFileName(executionId, type, planName);
        Response response2 = Response.ok(arg_0 -> PreflightResource.generateCSV$lambda$1(writer, csvMapping, arg_0)).type("text/csv").header("Content-disposition", (Object)("attachment; filename=" + fileName)).build();
        Intrinsics.checkNotNull((Object)response2);
        return response2;
    }

    @GET
    @Path(value="/{executionId}/AppVendorCheck/{appKey}/{checkId}/csv")
    @NotNull
    public final Response generateAppVendorCheckCSV(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="appKey") @NotNull String appKey, @PathParam(value="checkId") @NotNull String checkId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Intrinsics.checkNotNullParameter((Object)checkId, (String)"checkId");
        PreflightCSVWriter writer = new PreflightCSVWriter();
        Map<String, Object> csvMapping = this.preflightService.buildAppVendorCheckCSVMap(PreflightResource.sanitiseString$default(this, executionId, null, 2, null), appKey, checkId);
        String fileName = this.preflightService.getAppVendorCheckCSVFileName(PreflightResource.sanitiseString$default(this, executionId, null, 2, null), appKey, checkId);
        if (csvMapping.isEmpty()) {
            UnableToWriteCsvException exception = new UnableToWriteCsvException("Csv content is empty");
            Object[] objectArray = new Object[]{executionId, appKey, checkId};
            this.log.error("CsvMapping for executionId: {} appKey: {} checkId: {} is empty", objectArray);
            throw exception;
        }
        Response response2 = Response.ok(arg_0 -> PreflightResource.generateAppVendorCheckCSV$lambda$2(writer, csvMapping, arg_0)).type("text/csv").header("Content-disposition", (Object)("attachment; filename=" + fileName)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @POST
    @Produces(value={"application/zip"})
    @Path(value="error-logs/{executionId}")
    @NotNull
    public final Response exportErrorLogs(@PathParam(value="executionId") @NotNull String executionId, @NotNull ProjectKey projectKey) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        java.nio.file.Path path = this.migrationLogsService.getGeneratedErrorLogsZipForProjects(PreflightResource.sanitiseString$default(this, projectKey.getProjectKey(), null, 2, null), PreflightResource.sanitiseString$default(this, executionId, null, 2, null));
        if (path != null) {
            java.nio.file.Path filePath = path;
            boolean bl = false;
            Response response3 = ResponseUtils.INSTANCE.ok(filePath, "export-error-logs.zip", APPLICATION_ZIP);
            if (response3 != null) {
                response2 = response3;
                return response2;
            }
        }
        response2 = ResponseUtils.INSTANCE.notFound();
        return response2;
    }

    @GET
    @Path(value="mandatory-urls")
    @NotNull
    public final Response checkMandatoryUrls() {
        PreflightMandatoryUrlsCheckResult result2 = this.preflightMandatoryUrlsCheck.performCheck();
        Response response2 = Response.ok((Object)result2).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    private final Response convertToResponse(CheckExecutionStatus statuses) {
        ChecksResultDto checksResultDto;
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        CheckExecutionStatus checkExecutionStatus = statuses;
        if (checkExecutionStatus != null) {
            void it;
            CheckExecutionStatus checkExecutionStatus2 = checkExecutionStatus;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            checksResultDto = this.preflightService.toCheckResultDto((CheckExecutionStatus)it);
            responseUtils = responseUtils2;
        } else {
            checksResultDto = null;
        }
        return responseUtils.okOrNotFound(checksResultDto);
    }

    private final String sanitiseString(String stringToSanitise, String pattern) {
        CharSequence charSequence = stringToSanitise;
        if (!new Regex(pattern).matches(charSequence)) {
            throw new IllegalArgumentException("Invalid input: '" + stringToSanitise + "'. The string must only contain alphanumeric characters and -,_$");
        }
        return stringToSanitise;
    }

    static /* synthetic */ String sanitiseString$default(PreflightResource preflightResource, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "^[a-zA-Z0-9,-_$]*$";
        }
        return preflightResource.sanitiseString(string, string2);
    }

    private static final void generateCSV$lambda$1(PreflightCSVWriter $writer, Map $csvMapping, OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)$writer, (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$csvMapping, (String)"$csvMapping");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        $writer.writeResultsInStream(output, $csvMapping);
    }

    private static final void generateAppVendorCheckCSV$lambda$2(PreflightCSVWriter $writer, Map $csvMapping, OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)$writer, (String)"$writer");
        Intrinsics.checkNotNullParameter((Object)$csvMapping, (String)"$csvMapping");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        $writer.writeAppVendorCheckResultsInStream(output, $csvMapping);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/rest/PreflightResource$Companion;", "", "()V", "APPLICATION_ZIP", "", "SERVER_APP_KEY_REGEX", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

