/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.rest;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import com.atlassian.jira.migration.preflight.PrepareUserBaseService;
import com.atlassian.jira.migration.preflight.ScanSummary;
import com.atlassian.jira.migration.preflight.ScanSummaryService;
import com.atlassian.jira.migration.utils.UDCConverterKt;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.migration.udc.scan.UserBaseScanRunner;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="userbase")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u00020\u00122\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/preflight/rest/UserBaseScanResource;", "", "prepareUserBaseService", "Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService;", "authenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "scanSummaryService", "Lcom/atlassian/jira/migration/preflight/ScanSummaryService;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "userBaseScanRunner", "Lcom/atlassian/migration/udc/scan/UserBaseScanRunner;", "(Lcom/atlassian/jira/migration/preflight/PrepareUserBaseService;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/preflight/ScanSummaryService;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/migration/udc/scan/UserBaseScanRunner;)V", "getScanSummary", "Ljavax/ws/rs/core/Response;", "scanUserBaseForCloudID", "cloudId", "", "jira-migration-plugin"})
public final class UserBaseScanResource {
    @NotNull
    private final PrepareUserBaseService prepareUserBaseService;
    @NotNull
    private final JiraAuthenticationContext authenticationContext;
    @NotNull
    private final ScanSummaryService scanSummaryService;
    @NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final UserBaseScanRunner userBaseScanRunner;

    @Inject
    public UserBaseScanResource(@NotNull PrepareUserBaseService prepareUserBaseService, @NotNull JiraAuthenticationContext authenticationContext, @NotNull ScanSummaryService scanSummaryService, @NotNull ContainerTokenTTLService containerTokenTTLService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull UserBaseScanRunner userBaseScanRunner) {
        Intrinsics.checkNotNullParameter((Object)prepareUserBaseService, (String)"prepareUserBaseService");
        Intrinsics.checkNotNullParameter((Object)authenticationContext, (String)"authenticationContext");
        Intrinsics.checkNotNullParameter((Object)scanSummaryService, (String)"scanSummaryService");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)userBaseScanRunner, (String)"userBaseScanRunner");
        this.prepareUserBaseService = prepareUserBaseService;
        this.authenticationContext = authenticationContext;
        this.scanSummaryService = scanSummaryService;
        this.containerTokenTTLService = containerTokenTTLService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationFeatures = migrationFeatures;
        this.userBaseScanRunner = userBaseScanRunner;
    }

    @GET
    @Path(value="/scan/summary")
    @NotNull
    public final Response getScanSummary() {
        ScanSummary scanSummary = ScanSummaryService.getScanSummary$default(this.scanSummaryService, null, 1, null);
        Response response2 = Response.ok((Object)scanSummary).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @POST
    @Path(value="/scan/{cloudId}")
    @NotNull
    public final Response scanUserBaseForCloudID(@PathParam(value="cloudId") @NotNull String cloudId2) {
        Response response2;
        CloudSite cloudSite2;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        CloudSite cloudSite3 = cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        String containerToken = cloudSite3 != null ? cloudSite3.getContainerToken() : null;
        if (containerToken == null) {
            Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            response2 = response3;
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        } else if (!this.containerTokenTTLService.isValidToken(containerToken)) {
            Response response4 = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("Cloud-token-expired", (Object)"true").build();
            Intrinsics.checkNotNull((Object)response4);
            response2 = response4;
        } else {
            if (this.migrationFeatures.getUseUDCLibraryForUserBaseScan()) {
                ApplicationUser applicationUser = this.authenticationContext.getLoggedInUser();
                Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
                this.userBaseScanRunner.safelyStartUserBaseScan(UDCConverterKt.toUDC(applicationUser), UDCConverterKt.toUDC(cloudSite2));
            } else {
                ApplicationUser applicationUser = this.authenticationContext.getLoggedInUser();
                Intrinsics.checkNotNullExpressionValue((Object)applicationUser, (String)"getLoggedInUser(...)");
                this.prepareUserBaseService.safelyStartUserBaseScan(applicationUser, cloudSite2);
            }
            Response response5 = Response.status((Response.Status)Response.Status.ACCEPTED).build();
            Intrinsics.checkNotNull((Object)response5);
            response2 = response5;
        }
        return response2;
    }
}

