/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.ums;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.email.UsersFixedData;
import com.atlassian.jira.migration.log.LogLevel;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.ums.checks.UmsPreflightCheck;
import com.atlassian.jira.migration.preflight.ums.exceptions.UmsPreflightCheckException;
import com.atlassian.jira.migration.preflight.ums.factory.UmsPreflightCheckLookupFactory;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckDetails;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckExecutionContext;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckType;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightResponse;
import com.atlassian.jira.migration.preflight.ums.orchestrator.UmsPreflightOrchestratorService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.utils.PreflightLogMessage;
import com.atlassian.jira.migration.utils.PreflightLogger;
import com.atlassian.jira.migration.workers.usersgroups.UsersGroupsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001c\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JB\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\fJ4\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\f2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015JB\u0010\"\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\f2\u0006\u0010\u0019\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0&0\u0010H\u0002J(\u0010'\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0&0\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0&H\u0002J \u0010(\u001a\u0004\u0018\u00010!2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\f2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0018\u0010)\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\fH\u0002JJ\u0010*\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0&0\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0002J*\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0&0\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/atlassian/jira/migration/preflight/ums/UmsPreflightService;", "", "umsPreflightCheckLookup", "Lcom/atlassian/jira/migration/preflight/ums/factory/UmsPreflightCheckLookupFactory;", "umsPreflightOrchestratorService", "Lcom/atlassian/jira/migration/preflight/ums/orchestrator/UmsPreflightOrchestratorService;", "usersGroupsUtil", "Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil;", "(Lcom/atlassian/jira/migration/preflight/ums/factory/UmsPreflightCheckLookupFactory;Lcom/atlassian/jira/migration/preflight/ums/orchestrator/UmsPreflightOrchestratorService;Lcom/atlassian/jira/migration/workers/usersgroups/UsersGroupsUtil;)V", "cleanUmsPreflightCheckFileId", "", "fileId", "Ljava/util/concurrent/CompletableFuture;", "", "cleanUmsPreflightCheckResponses", "umsPreflightChecks", "", "Lcom/atlassian/jira/migration/preflight/ums/model/UmsPreflightCheckType;", "Lcom/atlassian/jira/migration/preflight/ums/model/UmsPreflightResponse;", "cleanUmsPreflightChecksResults", "umsPreflightCheckDetails", "Lcom/atlassian/jira/migration/preflight/ums/model/UmsPreflightCheckDetails;", "dispatchUmsPreflightChecks", "preflightCheckExecutionId", "containerToken", "migrationScopeId", "checksToRun", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "usersFixedData", "Lcom/atlassian/jira/migration/email/UsersFixedData;", "executeInvalidEmailsUmsCheck", "usersAndGroups", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "executeUmsPreflightChecks", "formInitialUmsPreflightCheckResults", "umsPreflightChecksToPreflightChecksMap", "Lcom/atlassian/jira/migration/preflight/ums/checks/UmsPreflightCheck;", "", "formUmsPreflightChecksToRun", "getUsersAndGroups", "getUsersFixedData", "runChecks", "umsPreflightChecksMap", "migrationData", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserGroupMigrationData;", "verifyIfChecksAreRequired", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUmsPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UmsPreflightService.kt\ncom/atlassian/jira/migration/preflight/ums/UmsPreflightService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,272:1\n819#2:273\n847#2,2:274\n1271#2,2:280\n1285#2,2:282\n766#2:284\n857#2,2:285\n1288#2:287\n1549#2:295\n1620#2,3:296\n1271#2,2:299\n1285#2,4:301\n819#2:305\n847#2,2:306\n1855#2,2:308\n11065#3:276\n11400#3,3:277\n551#4:288\n536#4,6:289\n*S KotlinDebug\n*F\n+ 1 UmsPreflightService.kt\ncom/atlassian/jira/migration/preflight/ums/UmsPreflightService\n*L\n112#1:273\n112#1:274,2\n233#1:280,2\n233#1:282,2\n234#1:284\n234#1:285,2\n233#1:287\n247#1:295\n247#1:296,3\n248#1:299,2\n248#1:301,4\n262#1:305\n262#1:306,2\n262#1:308,2\n233#1:276\n233#1:277,3\n237#1:288\n237#1:289,6\n*E\n"})
public final class UmsPreflightService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UmsPreflightCheckLookupFactory umsPreflightCheckLookup;
    @NotNull
    private final UmsPreflightOrchestratorService umsPreflightOrchestratorService;
    @NotNull
    private final UsersGroupsUtil usersGroupsUtil;
    private static final Logger log = LoggerFactory.getLogger(UmsPreflightService.class);

    @Inject
    public UmsPreflightService(@NotNull UmsPreflightCheckLookupFactory umsPreflightCheckLookup, @NotNull UmsPreflightOrchestratorService umsPreflightOrchestratorService, @NotNull UsersGroupsUtil usersGroupsUtil) {
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckLookup, (String)"umsPreflightCheckLookup");
        Intrinsics.checkNotNullParameter((Object)umsPreflightOrchestratorService, (String)"umsPreflightOrchestratorService");
        Intrinsics.checkNotNullParameter((Object)usersGroupsUtil, (String)"usersGroupsUtil");
        this.umsPreflightCheckLookup = umsPreflightCheckLookup;
        this.umsPreflightOrchestratorService = umsPreflightOrchestratorService;
        this.usersGroupsUtil = usersGroupsUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeInvalidEmailsUmsCheck(@NotNull String preflightCheckExecutionId, @NotNull String containerToken, @NotNull CompletableFuture<UsersGroupsExtractionResult> usersAndGroups, @NotNull String migrationScopeId2, @NotNull UmsPreflightCheckDetails umsPreflightCheckDetails) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(usersAndGroups, (String)"usersAndGroups");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckDetails, (String)"umsPreflightCheckDetails");
        try {
            UsersGroupsExtractionResult usersGroupsExtractionResult = this.getUsersAndGroups(usersAndGroups, containerToken);
            Intrinsics.checkNotNull((Object)usersGroupsExtractionResult);
            UsersGroupsExtractionResult usersAndGroupsExtractionResult = usersGroupsExtractionResult;
            if (!Intrinsics.areEqual((Object)usersAndGroupsExtractionResult, (Object)UsersGroupsExtractionResult.Companion.getEMPTY())) {
                umsPreflightCheckDetails.setUmsPreflightCheckResults(MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)UmsPreflightCheckType.InvalidEmails), (Object)new UmsPreflightResponse(null, null, 3, null))));
                this.umsPreflightOrchestratorService.runAndPollInvalidEmailCheck(preflightCheckExecutionId, containerToken, migrationScopeId2, usersAndGroupsExtractionResult, umsPreflightCheckDetails);
            } else {
                Logger logger2 = log;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
                PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Skipping calling UMS as no users provided for execution for invalid emails check", null, null, preflightCheckExecutionId, null, null, 54, null));
            }
        }
        catch (Exception e) {
            Logger logger3 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
            LogLevel logLevel = LogLevel.ERROR;
            PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("Ums Invalid Emails Preflight Check Execution failed", logLevel, null, preflightCheckExecutionId, null, e, 20, null));
        }
        finally {
            this.cleanUmsPreflightChecksResults(umsPreflightCheckDetails);
        }
    }

    public final void dispatchUmsPreflightChecks(@NotNull String preflightCheckExecutionId, @NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull EnumSet<CheckType> checksToRun, @NotNull UmsPreflightCheckDetails umsPreflightCheckDetails, @NotNull CompletableFuture<UsersFixedData> usersFixedData) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter(checksToRun, (String)"checksToRun");
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckDetails, (String)"umsPreflightCheckDetails");
        Intrinsics.checkNotNullParameter(usersFixedData, (String)"usersFixedData");
        this.executeUmsPreflightChecks(preflightCheckExecutionId, containerToken, usersFixedData, migrationScopeId2, checksToRun, umsPreflightCheckDetails);
    }

    /*
     * WARNING - void declaration
     */
    public final void executeUmsPreflightChecks(@NotNull String preflightCheckExecutionId, @NotNull String containerToken, @NotNull CompletableFuture<UsersFixedData> usersFixedData, @NotNull String migrationScopeId2, @NotNull EnumSet<CheckType> checksToRun, @NotNull UmsPreflightCheckDetails umsPreflightCheckDetails) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(usersFixedData, (String)"usersFixedData");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter(checksToRun, (String)"checksToRun");
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckDetails, (String)"umsPreflightCheckDetails");
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Executing UMS Preflight Checks", null, null, preflightCheckExecutionId, null, null, 54, null));
        try {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = checksToRun;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                CheckType it = (CheckType)((Object)element$iv$iv);
                boolean bl = false;
                if (it.equals((Object)CheckType.InvalidEmails)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set checks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Map<UmsPreflightCheck, Set<CheckType>> umsPreflightChecksMap = this.formUmsPreflightChecksToRun(checks);
            UsersFixedData usersFixedData2 = this.getUsersFixedData(usersFixedData);
            Intrinsics.checkNotNull((Object)usersFixedData2);
            UsersFixedData fixedData = usersFixedData2;
            this.runChecks(umsPreflightCheckDetails, umsPreflightChecksMap, fixedData.getUsersMigrationData(), preflightCheckExecutionId, containerToken, migrationScopeId2);
        }
        catch (Exception e) {
            Logger logger3 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
            LogLevel logLevel = LogLevel.ERROR;
            PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("Exception Occurred when executing UMS Preflight Checks", logLevel, null, preflightCheckExecutionId, null, e, 20, null));
            this.cleanUmsPreflightChecksResults(umsPreflightCheckDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runChecks(UmsPreflightCheckDetails umsPreflightCheckDetails, Map<UmsPreflightCheck, ? extends Set<? extends CheckType>> umsPreflightChecksMap, JiraUserGroupMigrationData migrationData, String preflightCheckExecutionId, String containerToken, String migrationScopeId2) {
        umsPreflightCheckDetails.setUmsPreflightCheckResults(this.formInitialUmsPreflightCheckResults(umsPreflightChecksMap));
        try {
            if (this.verifyIfChecksAreRequired(migrationData, umsPreflightChecksMap)) {
                this.umsPreflightOrchestratorService.orchestrateChecks(new UmsPreflightCheckExecutionContext(preflightCheckExecutionId, containerToken, migrationScopeId2, umsPreflightChecksMap, migrationData), umsPreflightCheckDetails);
            } else {
                Logger logger2 = log;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
                PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Skipping calling UMS as no users or preflight checks provided to execute", null, null, preflightCheckExecutionId, null, null, 54, null));
            }
        }
        catch (Exception e) {
            Logger logger3 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
            LogLevel logLevel = LogLevel.ERROR;
            PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("Ums Preflight Checks did not execute successfully", logLevel, null, null, null, e, 28, null));
        }
        finally {
            this.cleanUmsPreflightChecksResults(umsPreflightCheckDetails);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final UsersGroupsExtractionResult getUsersAndGroups(CompletableFuture<UsersGroupsExtractionResult> usersAndGroups, String containerToken) {
        void var3_3;
        try {
            UsersGroupsExtractionResult usersGroupsExtractionResult;
            UsersGroupsExtractionResult usersAndGroupsExtractionResult = usersAndGroups.get();
            CloudSite cloudSite2 = this.usersGroupsUtil.fetchCloudSiteFromContainerToken(containerToken);
            if (this.usersGroupsUtil.shouldSkipJwmAccessPermissionsInMigration(cloudSite2)) {
                Intrinsics.checkNotNull((Object)usersAndGroupsExtractionResult);
                usersGroupsExtractionResult = this.usersGroupsUtil.skipJwmProductAccessPermissions(usersAndGroupsExtractionResult);
            } else {
                usersGroupsExtractionResult = var3_3;
            }
            var3_3 = usersGroupsExtractionResult;
        }
        catch (InterruptedException e) {
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            LogLevel logLevel = LogLevel.WARN;
            PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Failed to get UsersGroupsExtractionResult", logLevel, null, null, null, e, 28, null));
            usersAndGroups.cancel(true);
            Thread.currentThread().interrupt();
            throw e;
        }
        return var3_3;
    }

    private final UsersFixedData getUsersFixedData(CompletableFuture<UsersFixedData> usersFixedData) {
        UsersFixedData usersFixedData2;
        try {
            usersFixedData2 = usersFixedData.get();
        }
        catch (InterruptedException e) {
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            LogLevel logLevel = LogLevel.WARN;
            PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Failed to get UsersFixedData", logLevel, null, null, null, e, 28, null));
            usersFixedData.cancel(true);
            Thread.currentThread().interrupt();
            throw e;
        }
        return usersFixedData2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UmsPreflightCheck, Set<CheckType>> formUmsPreflightChecksToRun(Set<? extends CheckType> checksToRun) {
        void $this$filterNotTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        UmsPreflightCheckType[] $this$map$iv = UmsPreflightCheckType.values();
        boolean $i$f$map = false;
        UmsPreflightCheckType[] umsPreflightCheckTypeArray = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (UmsPreflightCheck item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var10_13 = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.umsPreflightCheckLookup.get((UmsPreflightCheckType)it));
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            UmsPreflightCheck item$iv$iv;
            item$iv$iv = (UmsPreflightCheck)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = checksToRun;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void umsPreflightCheck;
                CheckType checkType = (CheckType)((Object)element$iv$iv2);
                boolean bl2 = false;
                if (!umsPreflightCheck.getPreflightChecks().contains((Object)checkType)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            object.put(t, set);
        }
        Map $this$filterNot$iv = result$iv;
        boolean $i$f$filterNot = false;
        result$iv = $this$filterNot$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator<Object> iterator2 = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            if (((Set)it.getValue()).isEmpty()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    private final boolean verifyIfChecksAreRequired(JiraUserGroupMigrationData migrationData, Map<UmsPreflightCheck, ? extends Set<? extends CheckType>> umsPreflightChecksMap) {
        return !((Collection)migrationData.getUsers()).isEmpty() && !umsPreflightChecksMap.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UmsPreflightCheckType, UmsPreflightResponse> formInitialUmsPreflightCheckResults(Map<UmsPreflightCheck, ? extends Set<? extends CheckType>> umsPreflightChecksToPreflightChecksMap) {
        UmsPreflightCheckType it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = umsPreflightChecksToPreflightChecksMap.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UmsPreflightCheck umsPreflightCheck = (UmsPreflightCheck)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getUmsPreflightCheckType());
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (UmsPreflightCheckType)((Object)element$iv$iv);
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            UmsPreflightResponse umsPreflightResponse = new UmsPreflightResponse(null, null, 3, null);
            object.put(t, umsPreflightResponse);
        }
        return result$iv;
    }

    private final void cleanUmsPreflightChecksResults(UmsPreflightCheckDetails umsPreflightCheckDetails) {
        this.cleanUmsPreflightCheckFileId(umsPreflightCheckDetails.getFileId());
        this.cleanUmsPreflightCheckResponses(umsPreflightCheckDetails.getUmsPreflightCheckResults());
    }

    private final void cleanUmsPreflightCheckFileId(CompletableFuture<String> fileId) {
        if (!fileId.isDone()) {
            fileId.completeExceptionally(new UmsPreflightCheckException("UMS preflight check has been skipped or User Group Extraction or Data Upload Failed"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanUmsPreflightCheckResponses(Map<UmsPreflightCheckType, UmsPreflightResponse> umsPreflightChecks) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = umsPreflightChecks.entrySet();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (((UmsPreflightResponse)it.getValue()).getTaskId().isDone()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((UmsPreflightResponse)it.getValue()).getTaskId().completeExceptionally(new UmsPreflightCheckException("Failed to fetch Task Id"));
            ((UmsPreflightResponse)it.getValue()).getResult().completeExceptionally(new UmsPreflightCheckException("Failed to fetch Check Response"));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/ums/UmsPreflightService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

