/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.ums.orchestrator;

import com.atlassian.jira.migration.log.LogLevel;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.ums.checks.UmsInvalidEmailsPreflightCheck;
import com.atlassian.jira.migration.preflight.ums.checks.UmsPreflightCheck;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckDetails;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckExecutionBaseContext;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckExecutionContext;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckType;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightResponse;
import com.atlassian.jira.migration.preflight.ums.service.CheckPayloadEmailGeneratorService;
import com.atlassian.jira.migration.preflight.ums.service.UmsPreflightResult;
import com.atlassian.jira.migration.preflight.ums.service.UmsPreflightStartAndPollService;
import com.atlassian.jira.migration.preflight.ums.service.UsersAndGroupsUploadService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupWithPermissions;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.usersmigrationservice.InitiateCheckRequest;
import com.atlassian.jira.migration.usersmigrationservice.InitiateEmailCheckRequest;
import com.atlassian.jira.migration.utils.PreflightLogMessage;
import com.atlassian.jira.migration.utils.PreflightLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J6\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J.\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cJ(\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0012H\u0002J(\u0010&\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/preflight/ums/orchestrator/UmsPreflightOrchestratorService;", "", "usersAndGroupsUploadService", "Lcom/atlassian/jira/migration/preflight/ums/service/UsersAndGroupsUploadService;", "umsPreflightStartAndPollService", "Lcom/atlassian/jira/migration/preflight/ums/service/UmsPreflightStartAndPollService;", "checkPayloadEmailGeneratorService", "Lcom/atlassian/jira/migration/preflight/ums/service/CheckPayloadEmailGeneratorService;", "(Lcom/atlassian/jira/migration/preflight/ums/service/UsersAndGroupsUploadService;Lcom/atlassian/jira/migration/preflight/ums/service/UmsPreflightStartAndPollService;Lcom/atlassian/jira/migration/preflight/ums/service/CheckPayloadEmailGeneratorService;)V", "buildJiraUserGroupMigrationData", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserGroupMigrationData;", "usersAndGroups", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "migrationScopeId", "", "buildUmsCheckRequest", "", "Lcom/atlassian/jira/migration/preflight/ums/checks/UmsPreflightCheck;", "Lcom/atlassian/jira/migration/usersmigrationservice/InitiateCheckRequest;", "checksToRun", "", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "fileId", "orchestrateChecks", "", "ctx", "Lcom/atlassian/jira/migration/preflight/ums/model/UmsPreflightCheckExecutionContext;", "umsPreflightCheckDetails", "Lcom/atlassian/jira/migration/preflight/ums/model/UmsPreflightCheckDetails;", "runAndPollChecks", "Lcom/atlassian/jira/migration/preflight/ums/model/UmsPreflightCheckExecutionBaseContext;", "runAndPollInvalidEmailCheck", "preflightCheckExecutionId", "containerToken", "startAndPollUmsTask", "Lcom/atlassian/jira/migration/preflight/ums/service/UmsPreflightResult;", "umsPreflightCheck", "initiateCheckRequest", "uploadUserAndGroupsData", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUmsPreflightOrchestratorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UmsPreflightOrchestratorService.kt\ncom/atlassian/jira/migration/preflight/ums/orchestrator/UmsPreflightOrchestratorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1655#2,8:256\n1179#2,2:264\n1253#2,4:266\n1238#2,2:272\n1603#2,9:274\n1855#2:283\n1856#2:285\n1612#2:286\n1241#2:287\n1238#2,4:290\n453#3:270\n403#3:271\n453#3:288\n403#3:289\n1#4:284\n*S KotlinDebug\n*F\n+ 1 UmsPreflightOrchestratorService.kt\ncom/atlassian/jira/migration/preflight/ums/orchestrator/UmsPreflightOrchestratorService\n*L\n217#1:256,8\n220#1:264,2\n220#1:266,4\n224#1:272,2\n225#1:274,9\n225#1:283\n225#1:285\n225#1:286\n224#1:287\n234#1:290,4\n224#1:270\n224#1:271\n234#1:288\n234#1:289\n225#1:284\n*E\n"})
public final class UmsPreflightOrchestratorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsersAndGroupsUploadService usersAndGroupsUploadService;
    @NotNull
    private final UmsPreflightStartAndPollService umsPreflightStartAndPollService;
    @NotNull
    private final CheckPayloadEmailGeneratorService checkPayloadEmailGeneratorService;
    private static final Logger log = LoggerFactory.getLogger(UmsPreflightOrchestratorService.class);

    @Inject
    public UmsPreflightOrchestratorService(@NotNull UsersAndGroupsUploadService usersAndGroupsUploadService, @NotNull UmsPreflightStartAndPollService umsPreflightStartAndPollService, @NotNull CheckPayloadEmailGeneratorService checkPayloadEmailGeneratorService) {
        Intrinsics.checkNotNullParameter((Object)usersAndGroupsUploadService, (String)"usersAndGroupsUploadService");
        Intrinsics.checkNotNullParameter((Object)umsPreflightStartAndPollService, (String)"umsPreflightStartAndPollService");
        Intrinsics.checkNotNullParameter((Object)checkPayloadEmailGeneratorService, (String)"checkPayloadEmailGeneratorService");
        this.usersAndGroupsUploadService = usersAndGroupsUploadService;
        this.umsPreflightStartAndPollService = umsPreflightStartAndPollService;
        this.checkPayloadEmailGeneratorService = checkPayloadEmailGeneratorService;
    }

    public final void orchestrateChecks(@NotNull UmsPreflightCheckExecutionContext ctx, @NotNull UmsPreflightCheckDetails umsPreflightCheckDetails) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckDetails, (String)"umsPreflightCheckDetails");
        String fileId = this.usersAndGroupsUploadService.uploadUsersAndGroupsData(ctx.getFixedMigrationData(), ctx.getContainerToken(), ctx.getMigrationScopeId());
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        String string = ctx.getPreflightCheckExecutionId();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"fileId", (Object)fileId));
        PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("User Group Data for Ums Pre-flight Uploaded Successfully", null, null, string, map, null, 38, null));
        umsPreflightCheckDetails.getFileId().complete(fileId);
        this.runAndPollChecks(ctx, fileId, umsPreflightCheckDetails);
    }

    public final void runAndPollInvalidEmailCheck(@NotNull String preflightCheckExecutionId, @NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull UsersGroupsExtractionResult usersAndGroups, @NotNull UmsPreflightCheckDetails umsPreflightCheckDetails) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)usersAndGroups, (String)"usersAndGroups");
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckDetails, (String)"umsPreflightCheckDetails");
        String fileId = this.uploadUserAndGroupsData(preflightCheckExecutionId, usersAndGroups, containerToken, migrationScopeId2);
        umsPreflightCheckDetails.getFileId().complete(fileId);
        InitiateEmailCheckRequest invalidEmailCheckRequest = new InitiateEmailCheckRequest(fileId, "S2C_MIGRATION");
        try {
            UmsInvalidEmailsPreflightCheck umsInvalidEmailsPreflightCheck = new UmsInvalidEmailsPreflightCheck();
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("Starting and polling for UMS Preflight Invalid Emails Check Till Completion", null, null, preflightCheckExecutionId, null, null, 54, null));
            UmsPreflightResult umsPreflightResult = this.startAndPollUmsTask(containerToken, migrationScopeId2, umsInvalidEmailsPreflightCheck, invalidEmailCheckRequest);
            UmsPreflightResponse umsPreflightResponse = umsPreflightCheckDetails.getUmsPreflightCheckResults().get((Object)UmsPreflightCheckType.InvalidEmails);
            Intrinsics.checkNotNull((Object)umsPreflightResponse);
            UmsPreflightResponse umsPreflightResponse2 = umsPreflightResponse;
            umsPreflightResponse2.getTaskId().complete(umsPreflightResult.getTaskId());
            umsPreflightResponse2.getResult().complete(umsPreflightResult.getResult());
            Logger logger3 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"log");
            PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("UMS Preflight Invalid Emails Check Finished Successfully", null, null, preflightCheckExecutionId, MapsKt.mapOf((Pair)TuplesKt.to((Object)String.valueOf((Object)UmsPreflightCheckType.InvalidEmails), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"checkStatusResponse", (Object)umsPreflightResponse2.getResult().get())))), null, 38, null));
        }
        catch (Exception e) {
            Logger logger4 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"log");
            LogLevel logLevel = LogLevel.ERROR;
            PreflightLogger.INSTANCE.logMessage(logger4, new PreflightLogMessage("Ums Preflight Invalid Emails Check Failed", logLevel, null, preflightCheckExecutionId, null, e, 20, null));
        }
    }

    private final void runAndPollChecks(UmsPreflightCheckExecutionBaseContext ctx, String fileId, UmsPreflightCheckDetails umsPreflightCheckDetails) {
        Map<UmsPreflightCheck, InitiateCheckRequest> umsPreflightCheckRequestMap = this.buildUmsCheckRequest(ctx.getChecksToRun(), fileId);
        umsPreflightCheckRequestMap.entrySet().parallelStream().forEach(arg_0 -> UmsPreflightOrchestratorService.runAndPollChecks$lambda$0((Function1)new Function1<Map.Entry<? extends UmsPreflightCheck, ? extends InitiateCheckRequest>, Unit>(ctx, this, umsPreflightCheckDetails){
            final /* synthetic */ UmsPreflightCheckExecutionBaseContext $ctx;
            final /* synthetic */ UmsPreflightOrchestratorService this$0;
            final /* synthetic */ UmsPreflightCheckDetails $umsPreflightCheckDetails;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                this.$umsPreflightCheckDetails = $umsPreflightCheckDetails;
                super(1);
            }

            public final void invoke(Map.Entry<? extends UmsPreflightCheck, ? extends InitiateCheckRequest> it) {
                try {
                    Logger logger2 = UmsPreflightOrchestratorService.access$getLog$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getLog$cp(...)");
                    PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("UMS Preflight Check Started for " + (Object)((Object)it.getKey().getUmsPreflightCheckType()), null, null, this.$ctx.getPreflightCheckExecutionId(), null, null, 54, null));
                    UmsPreflightResult umsPreflightResult = UmsPreflightOrchestratorService.access$startAndPollUmsTask(this.this$0, this.$ctx.getContainerToken(), this.$ctx.getMigrationScopeId(), it.getKey(), it.getValue());
                    UmsPreflightResponse umsPreflightResponse = this.$umsPreflightCheckDetails.getUmsPreflightCheckResults().get((Object)((Object)it.getKey().getUmsPreflightCheckType()));
                    Intrinsics.checkNotNull((Object)umsPreflightResponse);
                    UmsPreflightResponse umsPreflightResponse2 = umsPreflightResponse;
                    umsPreflightResponse2.getTaskId().complete(umsPreflightResult.getTaskId());
                    umsPreflightResponse2.getResult().complete(umsPreflightResult.getResult());
                    Logger logger3 = UmsPreflightOrchestratorService.access$getLog$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"access$getLog$cp(...)");
                    PreflightLogger.INSTANCE.logMessage(logger3, new PreflightLogMessage("UMS Preflight Check " + (Object)((Object)it.getKey().getUmsPreflightCheckType()) + " finished Successfully", null, null, this.$ctx.getPreflightCheckExecutionId(), MapsKt.mapOf((Pair)TuplesKt.to((Object)String.valueOf((Object)((Object)it.getKey().getUmsPreflightCheckType())), (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"checkStatusResponse", (Object)umsPreflightResponse2.getResult().get())))), null, 38, null));
                }
                catch (Exception e) {
                    Logger logger4 = UmsPreflightOrchestratorService.access$getLog$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"access$getLog$cp(...)");
                    LogLevel logLevel = LogLevel.ERROR;
                    String string = "Ums Preflight Check " + (Object)((Object)it.getKey().getUmsPreflightCheckType()) + " Failed";
                    String string2 = this.$ctx.getPreflightCheckExecutionId();
                    PreflightLogger.INSTANCE.logMessage(logger4, new PreflightLogMessage(string, logLevel, null, string2, null, e, 20, null));
                }
            }
        }, arg_0));
    }

    private final String uploadUserAndGroupsData(String preflightCheckExecutionId, UsersGroupsExtractionResult usersAndGroups, String containerToken, String migrationScopeId2) {
        String fileId = this.usersAndGroupsUploadService.uploadUsersAndGroupsData(this.buildJiraUserGroupMigrationData(usersAndGroups, migrationScopeId2), containerToken, migrationScopeId2);
        Logger logger2 = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"fileId", (Object)fileId));
        PreflightLogger.INSTANCE.logMessage(logger2, new PreflightLogMessage("User Group Data for Ums Pre-flight Uploaded Successfully", null, null, preflightCheckExecutionId, map, null, 38, null));
        return fileId;
    }

    /*
     * WARNING - void declaration
     */
    private final JiraUserGroupMigrationData buildJiraUserGroupMigrationData(UsersGroupsExtractionResult usersAndGroups, String migrationScopeId2) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object it;
        void $this$associateTo$iv$iv;
        List list;
        Set<JiraUser> usersSet = usersAndGroups.getUsers();
        if (this.checkPayloadEmailGeneratorService.checkIfUdcGeneratesNewEmailsForDuplicates()) {
            list = this.checkPayloadEmailGeneratorService.generateRandomEmailsForDuplicates(usersSet);
        } else {
            Iterable $this$distinctBy$iv = usersSet;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                JiraUser it2 = (JiraUser)e$iv;
                boolean bl = false;
                String key$iv = it2.getEmail();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            list = list$iv;
        }
        List usersToMigrate = list;
        Object $this$associate$iv = usersToMigrate;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Object object = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            it = (JiraUser)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)((JiraUser)it).getUserKey(), (Object)((JiraUser)it).getEmail());
            map2.put(it.getFirst(), it.getSecond());
        }
        Map keyToEmailMap = destination$iv$iv;
        $this$associate$iv = usersAndGroups.getMembership();
        List list2 = CollectionsKt.toList((Iterable)usersAndGroups.getGroups());
        List list3 = usersToMigrate;
        boolean $i$f$mapValues = false;
        void capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void members;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map3;
            boolean bl2 = false;
            Iterable $this$mapNotNull$iv = (Iterable)members.getValue();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                boolean bl3 = false;
                String it3 = (String)element$iv$iv;
                boolean bl4 = false;
                if ((String)keyToEmailMap.get(it3) == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv2);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            map.put(k, set);
        }
        map = destination$iv$iv2;
        String string = migrationScopeId2;
        Map map4 = map;
        List list4 = list2;
        List list5 = list3;
        return new JiraUserGroupMigrationData((List<JiraUser>)list5, (List<JiraGroupWithPermissions>)list4, (Map<String, ? extends Set<String>>)map4, string);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<UmsPreflightCheck, InitiateCheckRequest> buildUmsCheckRequest(Map<UmsPreflightCheck, ? extends Set<? extends CheckType>> checksToRun, String fileId) {
        void $this$mapValuesTo$iv$iv;
        Map<UmsPreflightCheck, ? extends Set<? extends CheckType>> $this$mapValues$iv = checksToRun;
        boolean $i$f$mapValues = false;
        Map<UmsPreflightCheck, ? extends Set<? extends CheckType>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            InitiateCheckRequest initiateCheckRequest = ((UmsPreflightCheck)it.getKey()).buildUmsCheckRequest((Set)it.getValue(), fileId);
            map3.put(k, initiateCheckRequest);
        }
        return destination$iv$iv;
    }

    private final UmsPreflightResult startAndPollUmsTask(String containerToken, String migrationScopeId2, UmsPreflightCheck umsPreflightCheck, InitiateCheckRequest initiateCheckRequest) {
        return this.umsPreflightStartAndPollService.startAndPollUmsCheckTask(containerToken, migrationScopeId2, umsPreflightCheck.getStartPreflightCheckRoute(), initiateCheckRequest, umsPreflightCheck.getPreflightCheckResponseRoute(), umsPreflightCheck.getPreflightCheckResponseClass());
    }

    private static final void runAndPollChecks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ UmsPreflightResult access$startAndPollUmsTask(UmsPreflightOrchestratorService $this, String containerToken, String migrationScopeId2, UmsPreflightCheck umsPreflightCheck, InitiateCheckRequest initiateCheckRequest) {
        return $this.startAndPollUmsTask(containerToken, migrationScopeId2, umsPreflightCheck, initiateCheckRequest);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/ums/orchestrator/UmsPreflightOrchestratorService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

