/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.ums.service;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import com.atlassian.cmpt.check.email.EmailDuplicateChecker;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/preflight/ums/service/CheckPayloadEmailGeneratorService;", "", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "pluginSettings", "Lcom/atlassian/sal/api/pluginsettings/PluginSettings;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettings;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "checkIfUdcGeneratesNewEmailsForDuplicates", "", "generateRandomEmailsForDuplicates", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "jiraUsers", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCheckPayloadEmailGeneratorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckPayloadEmailGeneratorService.kt\ncom/atlassian/jira/migration/preflight/ums/service/CheckPayloadEmailGeneratorService\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n51#2:74\n1549#3:75\n1620#3,3:76\n1179#3,2:79\n1253#3,4:81\n1549#3:85\n1620#3,3:86\n*S KotlinDebug\n*F\n+ 1 CheckPayloadEmailGeneratorService.kt\ncom/atlassian/jira/migration/preflight/ums/service/CheckPayloadEmailGeneratorService\n*L\n37#1:74\n43#1:75\n43#1:76,3\n51#1:79,2\n51#1:81,4\n52#1:85\n52#1:86,3\n*E\n"})
public final class CheckPayloadEmailGeneratorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginSettings pluginSettings;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(CheckPayloadEmailGeneratorService.class);

    public CheckPayloadEmailGeneratorService(@NotNull PluginSettings pluginSettings, @NotNull ObjectMapper objectMapper2) {
        Intrinsics.checkNotNullParameter((Object)pluginSettings, (String)"pluginSettings");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        this.pluginSettings = pluginSettings;
        this.objectMapper = objectMapper2;
    }

    @Inject
    public CheckPayloadEmailGeneratorService(@NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)pluginSettingsFactory, (String)"pluginSettingsFactory");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        PluginSettings pluginSettings = pluginSettingsFactory.createGlobalSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pluginSettings, (String)"createGlobalSettings(...)");
        this(pluginSettings, objectMapperFactory.createObjectMapper());
    }

    public final boolean checkIfUdcGeneratesNewEmailsForDuplicates() {
        DuplicatedEmailsConfig savedConfig;
        Object object;
        DuplicatedEmailsConfig duplicatedEmailsConfig;
        String string = (String)this.pluginSettings.get("com.atlassian.jira.migration.jira-migration-plugin:duplicatedEmailsConfig");
        if (string != null) {
            String config2 = string;
            boolean bl = false;
            boolean $i$f$jacksonTypeRef = false;
            duplicatedEmailsConfig = (DuplicatedEmailsConfig)this.objectMapper.readValue(config2, (TypeReference)new TypeReference<DuplicatedEmailsConfig>(){});
        } else {
            duplicatedEmailsConfig = null;
        }
        return (object = (savedConfig = duplicatedEmailsConfig)) != null && (object = ((DuplicatedEmailsConfig)object).getOnMigration()) != null ? ((DuplicatedEmailsConfig.OnMigration)((Object)object)).createsNewEmails() : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JiraUser> generateRandomEmailsForDuplicates(@NotNull Set<JiraUser> jiraUsers) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(jiraUsers, (String)"jiraUsers");
        Iterable $this$map$iv = jiraUsers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JiraUser jiraUser = (JiraUser)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new EmailData(it.getUserName(), it.getEmail()));
        }
        List emailData = (List)destination$iv$iv;
        EmailCheckContext emailContext = new EmailCheckContext(emailData);
        CheckResult checkResult = new EmailDuplicateChecker().check(emailContext);
        if (!checkResult.success) {
            void $this$mapTo$iv$iv2;
            Object object2;
            Iterable $this$associateTo$iv$iv;
            List duplicatesList = EmailDuplicateChecker.retrieveEmailDuplicates((Map)checkResult.details);
            int countGeneratedEmails = 0;
            Intrinsics.checkNotNull((Object)duplicatesList);
            Iterable $this$associate$iv = duplicatesList;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable bl = $this$associate$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                object2 = destination$iv$iv2;
                EmailDuplicate it = (EmailDuplicate)element$iv$iv;
                boolean bl2 = false;
                String string = it.email;
                List list = it.ids;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ids");
                it = TuplesKt.to((Object)string, (Object)CollectionsKt.toSet((Iterable)CollectionsKt.drop((Iterable)list, (int)1)));
                object2.put(it.getFirst(), it.getSecond());
            }
            Map duplicateEmailMap = destination$iv$iv2;
            Iterable $this$map$iv2 = jiraUsers;
            boolean $i$f$map2 = false;
            $this$associateTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                JiraUser jiraUser;
                void jiraUser2;
                object2 = (JiraUser)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl3 = false;
                Set set = (Set)duplicateEmailMap.get(jiraUser2.getEmail());
                boolean bl4 = set != null ? set.contains(jiraUser2.getUserName()) : false;
                if (bl4) {
                    ++countGeneratedEmails;
                    StringBuilder stringBuilder = new StringBuilder().append("udcGeneratedEmail_");
                    String string = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    jiraUser = JiraUser.copy$default((JiraUser)jiraUser2, stringBuilder.append(StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null)).append('_').append(jiraUser2.getEmail()).toString(), null, false, null, null, null, null, null, null, 510, null);
                } else {
                    jiraUser = jiraUser2;
                }
                object.add(jiraUser);
            }
            List jiraUsersWithRandomEmails = (List)destination$iv$iv2;
            log.info("Generated " + countGeneratedEmails + " random emails for duplicates");
            return jiraUsersWithRandomEmails;
        }
        return CollectionsKt.toList((Iterable)jiraUsers);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/ums/service/CheckPayloadEmailGeneratorService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

