/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.ums.service;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.ums.exceptions.UmsPreflightCheckException;
import com.atlassian.jira.migration.preflight.ums.service.UmsPreflightResult;
import com.atlassian.jira.migration.usersmigrationservice.CheckStatusResponse;
import com.atlassian.jira.migration.usersmigrationservice.InitiateCheckRequest;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B;\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011J>\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00112\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/preflight/ums/service/UmsPreflightStartAndPollService;", "", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "umsPreflightStatusCheckInterval", "Lkotlin/Function1;", "", "", "umsCheckTimeOut", "umsExtendedCheckTimeOut", "(Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lkotlin/jvm/functions/Function1;JJLcom/atlassian/jira/migration/features/MigrationFeatures;)V", "pollTillCompletionOrTimeout", "Lcom/atlassian/jira/migration/usersmigrationservice/CheckStatusResponse;", "containerToken", "", "umsPreflightCheckResponseRoute", "umsPreflightResponseBody", "Ljava/lang/Class;", "migrationScopeId", "taskId", "startAndPollUmsCheckTask", "Lcom/atlassian/jira/migration/preflight/ums/service/UmsPreflightResult;", "startUmsPreflightCheckRoute", "umsPreflightRequestBody", "Lcom/atlassian/jira/migration/usersmigrationservice/InitiateCheckRequest;", "Companion", "jira-migration-plugin"})
public final class UmsPreflightStartAndPollService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final Function1<Long, Unit> umsPreflightStatusCheckInterval;
    private final long umsCheckTimeOut;
    private final long umsExtendedCheckTimeOut;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    public static final long UMS_PREFLIGHT_STATUS_POLL_INTERVAL_IN_MILLIS = 2500L;
    public static final long UMS_CHECK_TIMEOUT_IN_MILLIS = 1200000L;
    public static final long UMS_CHECK_EXTENDED_TIMEOUT_IN_MILLIS = 10800000L;

    @VisibleForTesting
    public UmsPreflightStartAndPollService(@NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull Function1<? super Long, Unit> umsPreflightStatusCheckInterval, long umsCheckTimeOut, long umsExtendedCheckTimeOut, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter(umsPreflightStatusCheckInterval, (String)"umsPreflightStatusCheckInterval");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.umsPreflightStatusCheckInterval = umsPreflightStatusCheckInterval;
        this.umsCheckTimeOut = umsCheckTimeOut;
        this.umsExtendedCheckTimeOut = umsExtendedCheckTimeOut;
        this.migrationFeatures = migrationFeatures;
    }

    @Inject
    public UmsPreflightStartAndPollService(@NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this(usersMigrationServiceClient, (Function1<? super Long, Unit>)((Function1)1.INSTANCE), 1200000L, 10800000L, migrationFeatures);
    }

    @NotNull
    public final UmsPreflightResult startAndPollUmsCheckTask(@NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull String startUmsPreflightCheckRoute, @NotNull InitiateCheckRequest umsPreflightRequestBody, @NotNull String umsPreflightCheckResponseRoute, @NotNull Class<? extends CheckStatusResponse> umsPreflightResponseBody) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)startUmsPreflightCheckRoute, (String)"startUmsPreflightCheckRoute");
        Intrinsics.checkNotNullParameter((Object)umsPreflightRequestBody, (String)"umsPreflightRequestBody");
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckResponseRoute, (String)"umsPreflightCheckResponseRoute");
        Intrinsics.checkNotNullParameter(umsPreflightResponseBody, (String)"umsPreflightResponseBody");
        String taskId2 = this.usersMigrationServiceClient.initiateCheck(containerToken, startUmsPreflightCheckRoute, migrationScopeId2, umsPreflightRequestBody).getTaskId();
        CheckStatusResponse response2 = this.pollTillCompletionOrTimeout(containerToken, umsPreflightCheckResponseRoute, umsPreflightResponseBody, migrationScopeId2, taskId2);
        return new UmsPreflightResult(taskId2, response2);
    }

    @NotNull
    public final CheckStatusResponse pollTillCompletionOrTimeout(@NotNull String containerToken, @NotNull String umsPreflightCheckResponseRoute, @NotNull Class<? extends CheckStatusResponse> umsPreflightResponseBody, @NotNull String migrationScopeId2, @NotNull String taskId2) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)umsPreflightCheckResponseRoute, (String)"umsPreflightCheckResponseRoute");
        Intrinsics.checkNotNullParameter(umsPreflightResponseBody, (String)"umsPreflightResponseBody");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        Instant timeout = Instant.now().plusMillis(this.migrationFeatures.getEnableExtendedUmsTimeout() ? this.umsExtendedCheckTimeOut : this.umsCheckTimeOut);
        while (Instant.now().compareTo(timeout) < 0) {
            CheckStatusResponse response2 = this.usersMigrationServiceClient.getCheckStatus(containerToken, umsPreflightCheckResponseRoute, migrationScopeId2, taskId2, umsPreflightResponseBody);
            if (response2.getComplete()) {
                return response2;
            }
            this.umsPreflightStatusCheckInterval.invoke((Object)2500L);
        }
        throw new UmsPreflightCheckException("Ums Preflight check " + umsPreflightCheckResponseRoute + " status polling timed out after " + this.umsCheckTimeOut + " milli-seconds");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/preflight/ums/service/UmsPreflightStartAndPollService$Companion;", "", "()V", "UMS_CHECK_EXTENDED_TIMEOUT_IN_MILLIS", "", "UMS_CHECK_TIMEOUT_IN_MILLIS", "UMS_PREFLIGHT_STATUS_POLL_INTERVAL_IN_MILLIS", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

