/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.utils;

import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/preflight/utils/CheckOverrideUtils;", "", "()V", "overridableChecks", "", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "isCheckOverridable", "", "checkStatus", "Lcom/atlassian/cmpt/check/dto/Status;", "checkType", "isOverridableCheckType", "validateOverrideChecks", "", "overrideChecks", "Ljava/util/EnumSet;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCheckOverrideUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckOverrideUtils.kt\ncom/atlassian/jira/migration/preflight/utils/CheckOverrideUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,29:1\n766#2:30\n857#2,2:31\n*S KotlinDebug\n*F\n+ 1 CheckOverrideUtils.kt\ncom/atlassian/jira/migration/preflight/utils/CheckOverrideUtils\n*L\n23#1:30\n23#1:31,2\n*E\n"})
public final class CheckOverrideUtils {
    @NotNull
    public static final CheckOverrideUtils INSTANCE = new CheckOverrideUtils();
    @NotNull
    private static final Set<CheckType> overridableChecks;

    private CheckOverrideUtils() {
    }

    private final boolean isOverridableCheckType(CheckType checkType) {
        return overridableChecks.contains((Object)checkType);
    }

    public final boolean isCheckOverridable(@NotNull Status checkStatus, @NotNull CheckType checkType) {
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        return checkStatus == Status.ERROR && this.isOverridableCheckType(checkType);
    }

    /*
     * WARNING - void declaration
     */
    public final void validateOverrideChecks(@NotNull EnumSet<CheckType> overrideChecks) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(overrideChecks, (String)"overrideChecks");
        Iterable $this$filter$iv = overrideChecks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CheckType it = (CheckType)((Object)element$iv$iv);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((Object)it));
            if (!(!INSTANCE.isOverridableCheckType(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notApplicableOverrideChecks = (List)destination$iv$iv;
        if (!((Collection)notApplicableOverrideChecks).isEmpty()) {
            throw new PublicApiException.CheckTypeNotExcludable(notApplicableOverrideChecks.toString());
        }
    }

    static {
        CheckType[] checkTypeArray = new CheckType[]{CheckType.AnonPermission, CheckType.MissingAttachments};
        overridableChecks = SetsKt.setOf((Object[])checkTypeArray);
    }
}

