/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.utils;

import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.validation.PlanValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b6\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/atlassian/jira/migration/preflight/utils/PreflightUtils;", "", "()V", "Companion", "jira-migration-plugin"})
public abstract class PreflightUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int PARALLEL_PROJECTS_MAX_THREADPOOL_SIZE = 4;
    public static final int PARALLEL_DRY_RUN_MAX_THREADPOOL_SIZE = 2;
    @NotNull
    public static final String DUMMY_MIGRATION_SCOPE_ID = "dummyMigrationScopeId";
    public static final int MAX_STACK_TRACE_LENGTH = 4000;

    private PreflightUtils() {
    }

    public /* synthetic */ PreflightUtils(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\n\u0010!\u001a\u00020\u000b*\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/preflight/utils/PreflightUtils$Companion;", "", "()V", "DUMMY_MIGRATION_SCOPE_ID", "", "MAX_STACK_TRACE_LENGTH", "", "PARALLEL_DRY_RUN_MAX_THREADPOOL_SIZE", "PARALLEL_PROJECTS_MAX_THREADPOOL_SIZE", "getLimitedStackTrace", "throwable", "", "limit", "getParallelDryRunThreadPoolSize", "getParallelProjectsThreadPoolSize", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "isProjectExportErrorCheck", "", "getParallelProjectsThreadPoolSizeInReferencedMode", "threadCount", "getProjectKeysNotSelectedForMigration", "", "referencedProjectKeys", "projectKeysSelectedForMigration", "getValidProjectKeysSelections", "selectedProjectKeys", "", "planValidation", "Lcom/atlassian/jira/migration/validation/PlanValidation;", "isCustomersMigrationInReferencedMode", "isUsersGroupsMigrationInReferencedMode", "isUsersGroupsOrCustomersMigrationInReferencedMode", "rootCause", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nPreflightUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightUtils.kt\ncom/atlassian/jira/migration/preflight/utils/PreflightUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n766#2:96\n857#2,2:97\n*S KotlinDebug\n*F\n+ 1 PreflightUtils.kt\ncom/atlassian/jira/migration/preflight/utils/PreflightUtils$Companion\n*L\n64#1:96\n64#1:97,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isUsersGroupsMigrationInReferencedMode(@NotNull UsersGroupsMigrationOption usersGroupsMigrationOption) {
            Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
            return usersGroupsMigrationOption.getMode() == UsersGroupsMigrationOption.MigrationMode.REFERENCED;
        }

        public final boolean isCustomersMigrationInReferencedMode(@NotNull UsersGroupsMigrationOption usersGroupsMigrationOption) {
            Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
            JsdCustomersMigrationOption jsdCustomersMigrationOption = usersGroupsMigrationOption.getJsdCustomersMigrationOption();
            return (jsdCustomersMigrationOption != null ? jsdCustomersMigrationOption.getMode() : null) == JsdCustomersMigrationOption.JsdCustomersMigrationMode.REFERENCED;
        }

        public final boolean isUsersGroupsOrCustomersMigrationInReferencedMode(@NotNull UsersGroupsMigrationOption usersGroupsMigrationOption) {
            Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
            return this.isUsersGroupsMigrationInReferencedMode(usersGroupsMigrationOption) || this.isCustomersMigrationInReferencedMode(usersGroupsMigrationOption);
        }

        public final int getParallelProjectsThreadPoolSize(@NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, boolean isProjectExportErrorCheck) {
            Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
            int threadCount = Math.min(Runtime.getRuntime().availableProcessors(), 4);
            if (!this.isUsersGroupsOrCustomersMigrationInReferencedMode(usersGroupsMigrationOption)) {
                return threadCount;
            }
            return this.getParallelProjectsThreadPoolSizeInReferencedMode(threadCount, isProjectExportErrorCheck);
        }

        public final int getParallelDryRunThreadPoolSize() {
            return Math.min(Runtime.getRuntime().availableProcessors(), 2);
        }

        @NotNull
        public final Set<String> getProjectKeysNotSelectedForMigration(@NotNull Set<String> referencedProjectKeys, @NotNull Set<String> projectKeysSelectedForMigration) {
            Intrinsics.checkNotNullParameter(referencedProjectKeys, (String)"referencedProjectKeys");
            Intrinsics.checkNotNullParameter(projectKeysSelectedForMigration, (String)"projectKeysSelectedForMigration");
            return CollectionsKt.toSet((Iterable)SetsKt.minus(referencedProjectKeys, (Iterable)projectKeysSelectedForMigration));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getValidProjectKeysSelections(@NotNull List<String> selectedProjectKeys, @NotNull PlanValidation planValidation) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
            Intrinsics.checkNotNullParameter((Object)planValidation, (String)"planValidation");
            Iterable $this$filter$iv = selectedProjectKeys;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String key = (String)element$iv$iv;
                boolean bl = false;
                if (!planValidation.validateProjectKey(key)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private final int getParallelProjectsThreadPoolSizeInReferencedMode(int threadCount, boolean isProjectExportErrorCheck) {
            int referencedModeThreadCount = threadCount / 2;
            if (isProjectExportErrorCheck) {
                referencedModeThreadCount = (threadCount + 1) / 2;
            }
            return Math.max(referencedModeThreadCount, 1);
        }

        @NotNull
        public final Throwable rootCause(@NotNull Throwable $this$rootCause) {
            Intrinsics.checkNotNullParameter((Object)$this$rootCause, (String)"<this>");
            Throwable cause = $this$rootCause;
            while (true) {
                Throwable throwable = cause;
                if ((throwable != null ? throwable.getCause() : null) == null) break;
                cause = cause.getCause();
            }
            Throwable throwable = cause;
            if (throwable == null) {
                throwable = $this$rootCause;
            }
            return throwable;
        }

        @NotNull
        public final String getLimitedStackTrace(@NotNull Throwable throwable, int limit) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object[] objectArray = stackTraceElementArray;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
            return StringsKt.take((String)ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)string, null, null, (int)0, null, null, (int)62, null), (int)limit);
        }

        public static /* synthetic */ String getLimitedStackTrace$default(Companion companion, Throwable throwable, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 4000;
            }
            return companion.getLimitedStackTrace(throwable, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

