/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight.utils;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u0017\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012J\"\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012J\"\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012J\"\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/project/ProjectManager;)V", "convertProjectKeysToProjectIds", "", "", "selectedProjectKeys", "", "getProjectIdFromKey", "key", "(Ljava/lang/String;)Ljava/lang/Long;", "getProjectKeyfromId", "id", "(Ljava/lang/Long;)Ljava/lang/String;", "processProjectIdGadgets", "userPrefs", "", "processProjectOrCategoriesGadgets", "processProjectOrFilterIdGadgets", "processTypeIdGadgets", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectKeysExtractorFromGadgets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectKeysExtractorFromGadgets.kt\ncom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1#2:90\n1549#3:76\n1620#3,3:77\n1603#3,9:80\n1855#3:89\n1856#3:91\n1612#3:92\n*S KotlinDebug\n*F\n+ 1 ProjectKeysExtractorFromGadgets.kt\ncom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets\n*L\n54#1:90\n41#1:76\n41#1:77,3\n54#1:80,9\n54#1:89\n54#1:91\n54#1:92\n*E\n"})
public final class ProjectKeysExtractorFromGadgets {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private static final String ALL_PROJECTS = "allprojects";
    @NotNull
    private static final String HYPHEN_DELIMITER = "-";
    @NotNull
    private static final String PIPE_DELIMITER = "|";
    @NotNull
    private static final String PROJECT_PREFIX = "project-";
    @NotNull
    private static final String PROJECT = "project";
    @NotNull
    private static final Logger log;

    @Inject
    public ProjectKeysExtractorFromGadgets(@NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.projectManager = projectManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<String> processTypeIdGadgets(@NotNull Map<String, String> userPrefs) {
        Object object;
        Intrinsics.checkNotNullParameter(userPrefs, (String)"userPrefs");
        String string = userPrefs.get("type");
        if (string != null) {
            String string2;
            Object object2 = string;
            String it = object2;
            boolean bl = false;
            String string3 = string2 = Intrinsics.areEqual((Object)it, (Object)PROJECT) ? object2 : null;
            if (string2 != null) {
                String $this$processTypeIdGadgets_u24lambda_u241 = string2;
                boolean bl2 = false;
                String string4 = userPrefs.get("id");
                object2 = CollectionsKt.listOf((Object)this.getProjectKeyfromId(string4 != null ? StringsKt.toLongOrNull((String)string4) : null));
                if (object2 != null) {
                    object = object2;
                    return object;
                }
            }
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<String> processProjectOrFilterIdGadgets(@NotNull Map<String, String> userPrefs) {
        Object object;
        Intrinsics.checkNotNullParameter(userPrefs, (String)"userPrefs");
        String string = userPrefs.get("projectOrFilterId");
        if (string != null) {
            String string2;
            Object object2 = string;
            String it = object2;
            boolean bl = false;
            String string3 = string2 = StringsKt.startsWith$default((String)it, (String)PROJECT_PREFIX, (boolean)false, (int)2, null) ? object2 : null;
            if (string2 != null) {
                String $this$processProjectOrFilterIdGadgets_u24lambda_u243 = string2;
                boolean bl2 = false;
                String[] stringArray = new String[]{HYPHEN_DELIMITER};
                object2 = CollectionsKt.listOf((Object)this.getProjectKeyfromId(StringsKt.toLongOrNull((String)((String)StringsKt.split$default((CharSequence)$this$processProjectOrFilterIdGadgets_u24lambda_u243, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))));
                if (object2 != null) {
                    object = object2;
                    return object;
                }
            }
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<String> processProjectIdGadgets(@NotNull Map<String, String> userPrefs) {
        List list;
        String string;
        String[] stringArray;
        List list2;
        Intrinsics.checkNotNullParameter(userPrefs, (String)"userPrefs");
        String string2 = userPrefs.get("projectid");
        if (string2 != null && (list2 = StringsKt.split$default((CharSequence)string2, (String[])(stringArray = new String[]{HYPHEN_DELIMITER}), (boolean)false, (int)0, (int)6, null)) != null && (string = (String)CollectionsKt.getOrNull((List)list2, (int)1)) != null) {
            String string3 = string;
            boolean bl = false;
            List list3 = CollectionsKt.listOf((Object)this.getProjectKeyfromId(StringsKt.toLongOrNull((String)string3)));
            if (list3 != null) {
                list = list3;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<String> processProjectOrCategoriesGadgets(@NotNull Map<String, String> userPrefs) {
        Object object;
        Intrinsics.checkNotNullParameter(userPrefs, (String)"userPrefs");
        String string = userPrefs.get("projectsOrCategories");
        if (string != null) {
            String string2;
            String string3;
            String it = string3 = string;
            boolean bl = false;
            String string4 = string2 = !Intrinsics.areEqual((Object)it, (Object)ALL_PROJECTS) ? string3 : null;
            if (string2 != null) {
                List list;
                String $this$processProjectOrCategoriesGadgets_u24lambda_u248 = string2;
                boolean bl2 = false;
                Object object2 = new String[]{PIPE_DELIMITER};
                Object it2 = object2 = StringsKt.split$default((CharSequence)$this$processProjectOrCategoriesGadgets_u24lambda_u248, (String[])object2, (boolean)false, (int)0, (int)6, null);
                boolean bl32 = false;
                Object object3 = !it2.contains(ALL_PROJECTS) ? object2 : null;
                if (object3 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object3;
                    boolean $i$f$map = false;
                    Iterable bl32 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void projectId;
                        String string5 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(this.getProjectKeyfromId(StringsKt.toLongOrNull((String)projectId)));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = null;
                }
                if ((string3 = list) != null) {
                    object = string3;
                    return object;
                }
            }
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    @Nullable
    public final String getProjectKeyfromId(@Nullable Long id) {
        Project project = this.projectManager.getProjectObj(id);
        return project != null ? project.getKey() : null;
    }

    @Nullable
    public final Long getProjectIdFromKey(@Nullable String key) {
        Project project = this.projectManager.getProjectObjByKey(key);
        return project != null ? project.getId() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> convertProjectKeysToProjectIds(@NotNull List<String> selectedProjectKeys) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(selectedProjectKeys, (String)"selectedProjectKeys");
        Iterable $this$mapNotNull$iv = selectedProjectKeys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Long it$iv$iv;
            Long l;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                Project project = this.projectManager.getProjectObjByKey(it);
                Long projectId = project != null ? project.getId() : null;
                log.debug("Selected project key: " + it + " refers to project with id: " + projectId);
                l = projectId;
            }
            catch (DataAccessException ex) {
                log.error("Could not fetch project with id " + it + " \n" + ex.getMessage());
                throw ex;
            }
            if (l == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(ProjectKeysExtractorFromGadgets.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets$Companion;", "", "()V", "ALL_PROJECTS", "", "HYPHEN_DELIMITER", "PIPE_DELIMITER", "PROJECT", "PROJECT_PREFIX", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

