/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.progress;

import com.atlassian.migration.utils.MigrationStatusCalculator;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator;", "", "()V", "AppMigrationStatus", "Companion", "CoreMigrationStatus", "OverallAppMigrationStatus", "OverallMigrationStatus", "jira-migration-plugin"})
public final class IncrementalMigrationStatusCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(MigrationStatusCalculator.class);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$AppMigrationStatus;", "", "(Ljava/lang/String;I)V", "UNKNOWN", "Companion", "jira-migration-plugin"})
    public static final class AppMigrationStatus
    extends Enum<AppMigrationStatus> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ AppMigrationStatus UNKNOWN;
        private static final /* synthetic */ AppMigrationStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AppMigrationStatus[] values() {
            return (AppMigrationStatus[])$VALUES.clone();
        }

        public static AppMigrationStatus valueOf(String value) {
            return Enum.valueOf(AppMigrationStatus.class, value);
        }

        @NotNull
        public static EnumEntries<AppMigrationStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            UNKNOWN = new AppMigrationStatus();
            $VALUES = appMigrationStatusArray = new AppMigrationStatus[]{AppMigrationStatus.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$AppMigrationStatus$Companion;", "", "()V", "fromStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$AppMigrationStatus;", "rawString", "", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AppMigrationStatus fromStatus(@Nullable String rawString) {
                Enum enum_ = EnumUtils.getEnumIgnoreCase(AppMigrationStatus.class, (String)rawString);
                Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getEnumIgnoreCase(...)");
                return (AppMigrationStatus)enum_;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "calculateAndGetOverallAppsStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallAppMigrationStatus;", "calculateAndGetOverallStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallMigrationStatus;", "coreMigrationStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$CoreMigrationStatus;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OverallMigrationStatus calculateAndGetOverallStatus(@NotNull CoreMigrationStatus coreMigrationStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)coreMigrationStatus), (String)"coreMigrationStatus");
            log.debug("Calculating and getting overall status for coreMigrationStatus={}", (Object)coreMigrationStatus);
            if (CoreMigrationStatus.Companion.isStatusSaved(coreMigrationStatus) || CoreMigrationStatus.VALIDATING == coreMigrationStatus) {
                return OverallMigrationStatus.SAVED;
            }
            if (CoreMigrationStatus.SYNCING == coreMigrationStatus) {
                return OverallMigrationStatus.SYNCING;
            }
            if (CoreMigrationStatus.FINAL_SYNC == coreMigrationStatus) {
                return OverallMigrationStatus.FINAL_SYNC;
            }
            if (CoreMigrationStatus.SYNCED == coreMigrationStatus) {
                return OverallMigrationStatus.SYNCED;
            }
            if (CoreMigrationStatus.FIX_ERRORS == coreMigrationStatus) {
                return OverallMigrationStatus.FIX_ERRORS;
            }
            if (CoreMigrationStatus.INCOMPLETE == coreMigrationStatus) {
                return OverallMigrationStatus.INCOMPLETE;
            }
            if (CoreMigrationStatus.COMPLETE == coreMigrationStatus) {
                return OverallMigrationStatus.COMPLETE;
            }
            if (CoreMigrationStatus.FAILED == coreMigrationStatus) {
                return OverallMigrationStatus.FAILED;
            }
            log.warn("Unable to calculate the overall migration state for core migration {}", (Object)coreMigrationStatus);
            return OverallMigrationStatus.UNKNOWN;
        }

        @NotNull
        public final OverallAppMigrationStatus calculateAndGetOverallAppsStatus() {
            return OverallAppMigrationStatus.NO_APPS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$CoreMigrationStatus;", "", "(Ljava/lang/String;I)V", "SAVED_READY", "SAVED_PREFLIGHT_ERROR", "SAVED_INCOMPLETE", "VALIDATING", "SYNCING", "FIX_ERRORS", "SYNCED", "FINAL_SYNC", "INCOMPLETE", "FAILED", "COMPLETE", "UNKNOWN", "Companion", "jira-migration-plugin"})
    public static final class CoreMigrationStatus
    extends Enum<CoreMigrationStatus> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ CoreMigrationStatus SAVED_READY;
        public static final /* enum */ CoreMigrationStatus SAVED_PREFLIGHT_ERROR;
        public static final /* enum */ CoreMigrationStatus SAVED_INCOMPLETE;
        public static final /* enum */ CoreMigrationStatus VALIDATING;
        public static final /* enum */ CoreMigrationStatus SYNCING;
        public static final /* enum */ CoreMigrationStatus FIX_ERRORS;
        public static final /* enum */ CoreMigrationStatus SYNCED;
        public static final /* enum */ CoreMigrationStatus FINAL_SYNC;
        public static final /* enum */ CoreMigrationStatus INCOMPLETE;
        public static final /* enum */ CoreMigrationStatus FAILED;
        public static final /* enum */ CoreMigrationStatus COMPLETE;
        public static final /* enum */ CoreMigrationStatus UNKNOWN;
        private static final /* synthetic */ CoreMigrationStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CoreMigrationStatus[] values() {
            return (CoreMigrationStatus[])$VALUES.clone();
        }

        public static CoreMigrationStatus valueOf(String value) {
            return Enum.valueOf(CoreMigrationStatus.class, value);
        }

        @NotNull
        public static EnumEntries<CoreMigrationStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            SAVED_READY = new CoreMigrationStatus();
            SAVED_PREFLIGHT_ERROR = new CoreMigrationStatus();
            SAVED_INCOMPLETE = new CoreMigrationStatus();
            VALIDATING = new CoreMigrationStatus();
            SYNCING = new CoreMigrationStatus();
            FIX_ERRORS = new CoreMigrationStatus();
            SYNCED = new CoreMigrationStatus();
            FINAL_SYNC = new CoreMigrationStatus();
            INCOMPLETE = new CoreMigrationStatus();
            FAILED = new CoreMigrationStatus();
            COMPLETE = new CoreMigrationStatus();
            UNKNOWN = new CoreMigrationStatus();
            $VALUES = coreMigrationStatusArray = new CoreMigrationStatus[]{CoreMigrationStatus.SAVED_READY, CoreMigrationStatus.SAVED_PREFLIGHT_ERROR, CoreMigrationStatus.SAVED_INCOMPLETE, CoreMigrationStatus.VALIDATING, CoreMigrationStatus.SYNCING, CoreMigrationStatus.FIX_ERRORS, CoreMigrationStatus.SYNCED, CoreMigrationStatus.FINAL_SYNC, CoreMigrationStatus.INCOMPLETE, CoreMigrationStatus.FAILED, CoreMigrationStatus.COMPLETE, CoreMigrationStatus.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$CoreMigrationStatus$Companion;", "", "()V", "fromStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$CoreMigrationStatus;", "rawString", "", "getComplete", "hasFinalIncrement", "", "getFailed", "getIncomplete", "getSyncing", "isStatusSaved", "coreMigrationStatus", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CoreMigrationStatus fromStatus(@Nullable String rawString) {
                Enum enum_ = EnumUtils.getEnumIgnoreCase(CoreMigrationStatus.class, (String)rawString, (Enum)UNKNOWN);
                Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getEnumIgnoreCase(...)");
                return (CoreMigrationStatus)enum_;
            }

            public final boolean isStatusSaved(@NotNull CoreMigrationStatus coreMigrationStatus) {
                Intrinsics.checkNotNullParameter((Object)((Object)coreMigrationStatus), (String)"coreMigrationStatus");
                return SAVED_INCOMPLETE == coreMigrationStatus || SAVED_PREFLIGHT_ERROR == coreMigrationStatus || SAVED_READY == coreMigrationStatus;
            }

            @NotNull
            public final CoreMigrationStatus getSyncing(boolean hasFinalIncrement) {
                return hasFinalIncrement ? FINAL_SYNC : SYNCING;
            }

            @NotNull
            public final CoreMigrationStatus getComplete(boolean hasFinalIncrement) {
                return hasFinalIncrement ? COMPLETE : SYNCED;
            }

            @NotNull
            public final CoreMigrationStatus getIncomplete(boolean hasFinalIncrement) {
                return hasFinalIncrement ? INCOMPLETE : FIX_ERRORS;
            }

            @NotNull
            public final CoreMigrationStatus getFailed(boolean hasFinalIncrement) {
                return hasFinalIncrement ? FAILED : FIX_ERRORS;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallAppMigrationStatus;", "", "(Ljava/lang/String;I)V", "NO_APPS", "Companion", "jira-migration-plugin"})
    public static final class OverallAppMigrationStatus
    extends Enum<OverallAppMigrationStatus> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ OverallAppMigrationStatus NO_APPS;
        private static final /* synthetic */ OverallAppMigrationStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OverallAppMigrationStatus[] values() {
            return (OverallAppMigrationStatus[])$VALUES.clone();
        }

        public static OverallAppMigrationStatus valueOf(String value) {
            return Enum.valueOf(OverallAppMigrationStatus.class, value);
        }

        @NotNull
        public static EnumEntries<OverallAppMigrationStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            NO_APPS = new OverallAppMigrationStatus();
            $VALUES = overallAppMigrationStatusArray = new OverallAppMigrationStatus[]{OverallAppMigrationStatus.NO_APPS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallAppMigrationStatus$Companion;", "", "()V", "fromStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallAppMigrationStatus;", "rawString", "", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final OverallAppMigrationStatus fromStatus(@Nullable String rawString) {
                Enum enum_ = EnumUtils.getEnumIgnoreCase(OverallAppMigrationStatus.class, (String)rawString);
                Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getEnumIgnoreCase(...)");
                return (OverallAppMigrationStatus)enum_;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallMigrationStatus;", "", "(Ljava/lang/String;I)V", "SAVED", "SYNCING", "FIX_ERRORS", "SYNCED", "FINAL_SYNC", "INCOMPLETE", "FAILED", "COMPLETE", "UNKNOWN", "Companion", "jira-migration-plugin"})
    public static final class OverallMigrationStatus
    extends Enum<OverallMigrationStatus> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ OverallMigrationStatus SAVED;
        public static final /* enum */ OverallMigrationStatus SYNCING;
        public static final /* enum */ OverallMigrationStatus FIX_ERRORS;
        public static final /* enum */ OverallMigrationStatus SYNCED;
        public static final /* enum */ OverallMigrationStatus FINAL_SYNC;
        public static final /* enum */ OverallMigrationStatus INCOMPLETE;
        public static final /* enum */ OverallMigrationStatus FAILED;
        public static final /* enum */ OverallMigrationStatus COMPLETE;
        public static final /* enum */ OverallMigrationStatus UNKNOWN;
        private static final /* synthetic */ OverallMigrationStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OverallMigrationStatus[] values() {
            return (OverallMigrationStatus[])$VALUES.clone();
        }

        public static OverallMigrationStatus valueOf(String value) {
            return Enum.valueOf(OverallMigrationStatus.class, value);
        }

        @NotNull
        public static EnumEntries<OverallMigrationStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            SAVED = new OverallMigrationStatus();
            SYNCING = new OverallMigrationStatus();
            FIX_ERRORS = new OverallMigrationStatus();
            SYNCED = new OverallMigrationStatus();
            FINAL_SYNC = new OverallMigrationStatus();
            INCOMPLETE = new OverallMigrationStatus();
            FAILED = new OverallMigrationStatus();
            COMPLETE = new OverallMigrationStatus();
            UNKNOWN = new OverallMigrationStatus();
            $VALUES = overallMigrationStatusArray = new OverallMigrationStatus[]{OverallMigrationStatus.SAVED, OverallMigrationStatus.SYNCING, OverallMigrationStatus.FIX_ERRORS, OverallMigrationStatus.SYNCED, OverallMigrationStatus.FINAL_SYNC, OverallMigrationStatus.INCOMPLETE, OverallMigrationStatus.FAILED, OverallMigrationStatus.COMPLETE, OverallMigrationStatus.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallMigrationStatus$Companion;", "", "()V", "fromStatus", "Lcom/atlassian/jira/migration/progress/IncrementalMigrationStatusCalculator$OverallMigrationStatus;", "rawString", "", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final OverallMigrationStatus fromStatus(@Nullable String rawString) {
                Enum enum_ = EnumUtils.getEnumIgnoreCase(OverallMigrationStatus.class, (String)rawString);
                Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"getEnumIgnoreCase(...)");
                return (OverallMigrationStatus)enum_;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

