/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.progress;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.migration.InProgressStatus;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.orchestratorclient.ApiModelKt;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.DeadTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.progress.MigrationTerminator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="MigrationTerminator")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J0\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/progress/MigrationTerminatorImpl;", "Lcom/atlassian/jira/migration/progress/MigrationTerminator;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "(Lcom/atlassian/jira/migration/migration/MigrationRepository;)V", "instantProvider", "Lkotlin/Function0;", "Ljava/time/Instant;", "(Lcom/atlassian/jira/migration/migration/MigrationRepository;Lkotlin/jvm/functions/Function0;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildDeadTaskOutcomeList", "", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "message", "", "buildFailedOutcomeFromProgressList", "status", "checkTerminateOrDefault", "migrationId", "defaultStatus", "terminateMigration", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationTerminator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationTerminator.kt\ncom/atlassian/jira/migration/progress/MigrationTerminatorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 MigrationTerminator.kt\ncom/atlassian/jira/migration/progress/MigrationTerminatorImpl\n*L\n62#1:81\n62#1:82,3\n*E\n"})
public final class MigrationTerminatorImpl
implements MigrationTerminator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final Function0<Instant> instantProvider;
    private final Logger log;
    private static final Duration START_UP_WINDOW = Duration.ofMinutes(5L);

    public MigrationTerminatorImpl(@NotNull MigrationRepository migrationRepository, @NotNull Function0<Instant> instantProvider) {
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter(instantProvider, (String)"instantProvider");
        this.migrationRepository = migrationRepository;
        this.instantProvider = instantProvider;
        this.log = LoggerFactory.getLogger(MigrationTerminatorImpl.class);
    }

    @Inject
    public MigrationTerminatorImpl(@NotNull MigrationRepository migrationRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        this(migrationRepository, (Function0<Instant>)((Function0)1.INSTANCE));
    }

    @Override
    @Nullable
    public synchronized List<GetTaskStatusResponse.TaskProgress> checkTerminateOrDefault(@NotNull String migrationId, @NotNull String message, @Nullable List<GetTaskStatusResponse.TaskProgress> defaultStatus) {
        List<GetTaskStatusResponse.TaskProgress> list;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        if (migration != null) {
            Migration it = migration;
            boolean bl = false;
            if (it.getCreated().compareTo(((Instant)this.instantProvider.invoke()).minus(START_UP_WINDOW)) < 0) {
                this.log.error("Migration with id " + migrationId + " is more than " + START_UP_WINDOW.toMinutes() + " minutes old, something is wrong, terminating migration");
                list = this.terminateMigration(migrationId, message);
            } else {
                this.log.error("Migration with id " + migrationId + " is less than " + START_UP_WINDOW.toMinutes() + " minutes old, retrying");
                list = defaultStatus;
            }
        } else {
            list = null;
        }
        return list;
    }

    @Override
    @NotNull
    public synchronized List<GetTaskStatusResponse.TaskProgress> terminateMigration(@NotNull String migrationId, @NotNull String message) {
        Object object;
        block8: {
            block4: {
                List<GetTaskStatusResponse.TaskProgress> list;
                block5: {
                    List<GetTaskStatusResponse.TaskProgress> list2;
                    Object object2;
                    block7: {
                        block6: {
                            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            object = this.migrationRepository.findByMigrationId(migrationId);
                            if (object == null) break block4;
                            Migration migration = object;
                            boolean bl = false;
                            list = migration.getOutcome();
                            if (list != null) break block5;
                            object2 = migration.getStatus();
                            if (object2 == null) break block6;
                            InProgressStatus it = object2;
                            boolean bl2 = false;
                            List<GetTaskStatusResponse.TaskProgress> list3 = this.buildFailedOutcomeFromProgressList(it.getStatus(), message);
                            object2 = list3;
                            if (list3 != null) break block7;
                        }
                        object2 = this.buildDeadTaskOutcomeList(message);
                    }
                    List<GetTaskStatusResponse.TaskProgress> outcome = list2 = object2;
                    boolean bl = false;
                    MigrationRepository.saveOutcome$default(this.migrationRepository, migrationId, outcome, null, 4, null);
                    list = list2;
                }
                object = list;
                if (list != null) break block8;
            }
            throw new Exception("migration with id " + migrationId + " not found");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<GetTaskStatusResponse.TaskProgress> buildFailedOutcomeFromProgressList(@NotNull List<GetTaskStatusResponse.TaskProgress> status, @NotNull String message) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$map$iv = status;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GetTaskStatusResponse.TaskProgress taskProgress = (GetTaskStatusResponse.TaskProgress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiModelKt.failIncompleteProgressItems((GetTaskStatusResponse.TaskProgress)it, message));
        }
        return (List)destination$iv$iv;
    }

    private final List<GetTaskStatusResponse.TaskProgress> buildDeadTaskOutcomeList(String message) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return CollectionsKt.listOf((Object)new GetTaskStatusResponse.TaskProgress(new DeadTask(string), MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)ProgressUnit.DEAD_MIGRATION), (Object)ProgressItem.Companion.makeFailedProgressItem(ProgressUnit.DEAD_MIGRATION, message)))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/progress/MigrationTerminatorImpl$Companion;", "", "()V", "START_UP_WINDOW", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

