/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.progress;

import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.migration.InProgressStatus;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.progress.MigrationTaskStatus;
import com.atlassian.jira.migration.progress.MigrationTerminator;
import com.atlassian.jira.migration.progress.TaskList;
import com.atlassian.jira.migration.progress.v3.PlatformStatusService;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J3\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0096\u0001J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ!\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0001R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/progress/StatusRetrievalService;", "Lcom/atlassian/jira/migration/progress/MigrationTerminator;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "platformStatusService", "Lcom/atlassian/jira/migration/progress/v3/PlatformStatusService;", "migrationTerminator", "(Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/progress/v3/PlatformStatusService;Lcom/atlassian/jira/migration/progress/MigrationTerminator;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkTerminateOrDefault", "", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "migrationId", "", "message", "defaultStatus", "getAdaptedMigrationStatus", "Lcom/atlassian/jira/migration/progress/MigrationTaskStatus;", "containerToken", "terminateMigration", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nStatusRetrievalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusRetrievalService.kt\ncom/atlassian/jira/migration/progress/StatusRetrievalService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class StatusRetrievalService
implements MigrationTerminator {
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlatformStatusService platformStatusService;
    private final /* synthetic */ MigrationTerminator $$delegate_0;
    private final Logger log;

    @Inject
    public StatusRetrievalService(@NotNull MigrationRepository migrationRepository, @NotNull PlatformStatusService platformStatusService, @Qualifier(value="MigrationTerminator") @NotNull MigrationTerminator migrationTerminator) {
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)platformStatusService, (String)"platformStatusService");
        Intrinsics.checkNotNullParameter((Object)migrationTerminator, (String)"migrationTerminator");
        this.migrationRepository = migrationRepository;
        this.platformStatusService = platformStatusService;
        this.$$delegate_0 = migrationTerminator;
        this.log = LoggerFactory.getLogger(StatusRetrievalService.class);
    }

    @Override
    @Nullable
    public List<GetTaskStatusResponse.TaskProgress> checkTerminateOrDefault(@NotNull String migrationId, @NotNull String message, @Nullable List<GetTaskStatusResponse.TaskProgress> defaultStatus) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.$$delegate_0.checkTerminateOrDefault(migrationId, message, defaultStatus);
    }

    @Override
    @Nullable
    public List<GetTaskStatusResponse.TaskProgress> terminateMigration(@NotNull String migrationId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.$$delegate_0.terminateMigration(migrationId, message);
    }

    @NotNull
    public final MigrationTaskStatus getAdaptedMigrationStatus(@NotNull String containerToken, @NotNull String migrationId) {
        TaskList taskList2;
        List<GetTaskStatusResponse.TaskProgress> list;
        Migration migration;
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Migration migration2 = migration = this.migrationRepository.findByMigrationId(migrationId);
        InProgressStatus previousStatus = migration2 != null ? migration2.getStatus() : null;
        boolean statusRetrievalSuccessful = true;
        try {
            List<GetTaskStatusResponse.TaskProgress> list2;
            Migration migration3 = migration;
            if (migration3 != null) {
                Migration it = migration3;
                boolean bl = false;
                list2 = this.platformStatusService.getStatus(new ContainerToken(containerToken), new MigrationId(migrationId), it.getPlanId());
            } else {
                list2 = null;
            }
            list = list2;
        }
        catch (UnexpectedStatusCodeException e) {
            List<GetTaskStatusResponse.TaskProgress> list3;
            statusRetrievalSuccessful = false;
            if (e.getStatusCode() == 404 || e.getStatusCode() == 400) {
                this.log.error("Failed to retrieve status from MCS for migration " + migrationId + " with fatal response with status code " + e.getStatusCode() + ". Will retry or terminate migration.", (Throwable)e);
                InProgressStatus inProgressStatus = previousStatus;
                list3 = this.checkTerminateOrDefault(migrationId, "Migration with id: " + migrationId + " has timed out. Create a new migration and run the migration again.", inProgressStatus != null ? inProgressStatus.getStatus() : null);
            } else {
                this.log.error("Failed to retrieve status from MCS for migration " + migrationId + " with status code " + e.getStatusCode() + ", will use last known status if possible", (Throwable)e);
                InProgressStatus inProgressStatus = previousStatus;
                list3 = inProgressStatus != null ? inProgressStatus.getStatus() : null;
            }
            list = list3;
        }
        catch (Throwable e) {
            statusRetrievalSuccessful = false;
            this.log.error("Failed to retrieve status from MO for migration " + migrationId + ", will use last known status if possible", e);
            InProgressStatus inProgressStatus = previousStatus;
            list = inProgressStatus != null ? inProgressStatus.getStatus() : null;
        }
        List<GetTaskStatusResponse.TaskProgress> list4 = list;
        if (list4 != null) {
            List<GetTaskStatusResponse.TaskProgress> p0 = list4;
            boolean bl = false;
            taskList2 = new TaskList(p0);
        } else {
            taskList2 = null;
        }
        TaskList currentStatus = taskList2;
        return MigrationTaskStatus.Companion.fromInProgressStatus(currentStatus, previousStatus, statusRetrievalSuccessful);
    }
}

