/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.progress.v3;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.platform.AbstractMcsContainer;
import com.atlassian.jira.migration.platform.ContainerStatus;
import com.atlassian.jira.migration.platform.ContainerType;
import com.atlassian.jira.migration.platform.ContainersFetchResponse;
import com.atlassian.jira.migration.platform.PlatformMigrationStatus;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.platform.TransferStatusResponse;
import com.atlassian.jira.migration.progress.v3.TransferProgressConvertor;
import com.atlassian.jira.migration.progress.v3.util.MigrationTaskMapping;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bH\u0007J4\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000b2\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0010J\u0010\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010,\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006.\u00b2\u0006\n\u0010\u001d\u001a\u00020\u001eX\u008a\u0084\u0002"}, d2={"Lcom/atlassian/jira/migration/progress/v3/PlatformStatusService;", "", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "progressConvertors", "", "Lcom/atlassian/jira/migration/progress/v3/TransferProgressConvertor;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/migration/MigrationRepository;Ljava/util/List;)V", "convertorsForOperationKey", "Lorg/springframework/util/MultiValueMap;", "", "expectedOperationKeysPerContainerType", "Lcom/atlassian/jira/migration/platform/ContainerType;", "getExpectedOperationKeysPerContainerType$annotations", "()V", "getExpectedOperationKeysPerContainerType", "()Lorg/springframework/util/MultiValueMap;", "addSkipStatusForMissingProgressItem", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "status", "convert", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "containers", "Lcom/atlassian/jira/migration/platform/AbstractMcsContainer;", "migrationStatus", "Lcom/atlassian/jira/migration/platform/PlatformMigrationStatus;", "determineMigrationStatus", "response", "Lcom/atlassian/jira/migration/platform/ContainersFetchResponse;", "getStatus", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "planId", "hasMigrationStatusFailedAndExecutionSuccess", "", "isV4Migration", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlatformStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformStatusService.kt\ncom/atlassian/jira/migration/progress/v3/PlatformStatusService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1045#2:163\n1855#2:164\n1855#2,2:165\n1856#2:167\n1549#2:168\n1620#2,3:169\n1360#2:172\n1446#2,2:173\n1194#2,2:175\n1222#2,4:177\n1360#2:181\n1446#2,2:182\n223#2,2:184\n1448#2,3:186\n1448#2,3:189\n*S KotlinDebug\n*F\n+ 1 PlatformStatusService.kt\ncom/atlassian/jira/migration/progress/v3/PlatformStatusService\n*L\n48#1:163\n49#1:164\n52#1:165,2\n49#1:167\n116#1:168\n116#1:169,3\n141#1:172\n141#1:173,2\n144#1:175,2\n144#1:177,4\n146#1:181\n146#1:182,2\n148#1:184,2\n146#1:186,3\n141#1:189,3\n*E\n"})
public final class PlatformStatusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final MultiValueMap<String, TransferProgressConvertor> convertorsForOperationKey;
    @NotNull
    private final MultiValueMap<ContainerType, String> expectedOperationKeysPerContainerType;
    private static final Logger log = LoggerFactory.getLogger(PlatformStatusService.class);

    /*
     * WARNING - void declaration
     */
    @Inject
    public PlatformStatusService(@NotNull PlatformService platformService, @NotNull PlanRepository planRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationRepository migrationRepository, @NotNull List<? extends TransferProgressConvertor> progressConvertors) {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter(progressConvertors, (String)"progressConvertors");
        this.platformService = platformService;
        this.planRepository = planRepository;
        this.migrationFeatures = migrationFeatures;
        this.migrationRepository = migrationRepository;
        this.convertorsForOperationKey = (MultiValueMap)new LinkedMultiValueMap();
        this.expectedOperationKeysPerContainerType = (MultiValueMap)new LinkedMultiValueMap();
        Iterable iterable = progressConvertors;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TransferProgressConvertor it = (TransferProgressConvertor)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTaskProgressOrder());
                it = (TransferProgressConvertor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTaskProgressOrder()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String operationKey;
            TransferProgressConvertor convertor = (TransferProgressConvertor)element$iv;
            boolean bl = false;
            String string = convertor.getOperationKey();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.toUpperCase(locale), (String)"toUpperCase(...)");
            this.convertorsForOperationKey.add((Object)operationKey, (Object)convertor);
            Iterable $this$forEach$iv2 = convertor.getSupportedContainerTypes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ContainerType containerType = (ContainerType)((Object)element$iv2);
                boolean bl2 = false;
                this.expectedOperationKeysPerContainerType.add((Object)containerType, (Object)operationKey);
            }
        }
    }

    @NotNull
    public final MultiValueMap<ContainerType, String> getExpectedOperationKeysPerContainerType() {
        return this.expectedOperationKeysPerContainerType;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExpectedOperationKeysPerContainerType$annotations() {
    }

    @NotNull
    public final List<GetTaskStatusResponse.TaskProgress> getStatus(@NotNull ContainerToken containerToken, @NotNull MigrationId migrationId, @NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        List<GetTaskStatusResponse.TaskProgress> status = new ArrayList();
        Lazy plan$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Plan>(this, planId){
            final /* synthetic */ PlatformStatusService this$0;
            final /* synthetic */ String $planId;
            {
                this.this$0 = $receiver;
                this.$planId = $planId;
                super(0);
            }

            @NotNull
            public final Plan invoke() {
                Plan plan2 = PlatformStatusService.access$getPlanRepository$p(this.this$0).get(this.$planId);
                String string = this.$planId;
                Plan plan3 = plan2;
                if (plan3 == null) {
                    boolean bl = false;
                    String string2 = "Failed to find plan entry for requested planId: " + string;
                    throw new IllegalArgumentException(string2.toString());
                }
                return plan3;
            }
        }));
        String nextId = null;
        PlatformMigrationStatus migrationStatus = null;
        do {
            ContainersFetchResponse response2 = PlatformService.getPageOfContainers$default(this.platformService, containerToken, migrationId, nextId, null, true, 200, true, PlatformStatusService.getStatus$lambda$3((Lazy<Plan>)plan$delegate).isLiftAndShift(), 8, null);
            List<AbstractMcsContainer> containersInPage = response2.getContainers();
            nextId = response2.getNextId();
            migrationStatus = this.determineMigrationStatus(response2, migrationId);
            status.addAll((Collection)this.convert(migrationId, PlatformStatusService.getStatus$lambda$3((Lazy<Plan>)plan$delegate), containersInPage, migrationStatus));
        } while (nextId != null);
        PlatformMigrationStatus platformMigrationStatus = migrationStatus;
        Intrinsics.checkNotNull((Object)((Object)platformMigrationStatus));
        return platformMigrationStatus.isTerminal() && this.isV4Migration(migrationId) ? this.addSkipStatusForMissingProgressItem(status) : status;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @NotNull
    public final PlatformMigrationStatus determineMigrationStatus(@NotNull ContainersFetchResponse response2, @NotNull MigrationId migrationId) {
        PlatformMigrationStatus platformMigrationStatus;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        if (this.migrationFeatures.getEnableExecutionStatusProcessing()) {
            PlatformMigrationStatus platformMigrationStatus2 = response2.getExecutionStatus();
            boolean bl = platformMigrationStatus2 != null ? platformMigrationStatus2.isTerminal() : false;
            if (bl) {
                if (this.hasMigrationStatusFailedAndExecutionSuccess(response2)) {
                    log.info("Received a successful status for the executionStatus for migrationId [{}], but migrationStatus [{}] took precedence with a failure", (Object)migrationId, (Object)response2.getMigrationStatus());
                    PlatformMigrationStatus platformMigrationStatus3 = response2.getMigrationStatus();
                    platformMigrationStatus = platformMigrationStatus3;
                    Intrinsics.checkNotNull((Object)((Object)platformMigrationStatus3));
                    return platformMigrationStatus;
                }
                log.info("Received a terminal status [{}] in the executionStatus for migrationId [{}]", (Object)response2.getExecutionStatus(), (Object)migrationId);
                platformMigrationStatus = response2.getExecutionStatus();
                return platformMigrationStatus;
            }
        }
        if (response2.getMigrationStatus() != null) {
            platformMigrationStatus = response2.getMigrationStatus();
            return platformMigrationStatus;
        }
        platformMigrationStatus = PlatformMigrationStatus.READY;
        return platformMigrationStatus;
    }

    private final boolean hasMigrationStatusFailedAndExecutionSuccess(ContainersFetchResponse response2) {
        PlatformMigrationStatus platformMigrationStatus = response2.getMigrationStatus();
        return (platformMigrationStatus != null ? platformMigrationStatus.isFailed() : false) && response2.getExecutionStatus() == PlatformMigrationStatus.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<GetTaskStatusResponse.TaskProgress> addSkipStatusForMissingProgressItem(@NotNull List<GetTaskStatusResponse.TaskProgress> status) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(status, (String)"status");
        Iterable $this$map$iv = status;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GetTaskStatusResponse.TaskProgress taskProgress;
            void taskProgress2;
            GetTaskStatusResponse.TaskProgress taskProgress3 = (GetTaskStatusResponse.TaskProgress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (taskProgress2.getProgressItems().isEmpty()) {
                ProgressUnit unit;
                Intrinsics.checkNotNull((Object)((Object)MigrationTaskMapping.INSTANCE.getProgressUnit(taskProgress2.getTask().getMigrationTaskType())));
                TaskCompletionStatus taskCompletionStatus = TaskCompletionStatus.SKIPPED;
                taskProgress = GetTaskStatusResponse.TaskProgress.copy$default((GetTaskStatusResponse.TaskProgress)taskProgress2, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)unit), (Object)new ProgressItem(0L, 0L, unit, true, taskCompletionStatus, null, null, null, null, 480, null))), 1, null);
            } else {
                taskProgress = taskProgress2;
            }
            collection.add(taskProgress);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isV4Migration(MigrationId migrationId) {
        String string = migrationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Migration migration = this.migrationRepository.findByMigrationId(string);
        return (migration != null ? migration.getProtocol() : null) == MigrationProtocol.V4;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<GetTaskStatusResponse.TaskProgress> convert(@NotNull MigrationId migrationId, @NotNull Plan plan2, @NotNull List<? extends AbstractMcsContainer> containers, @NotNull PlatformMigrationStatus migrationStatus) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationStatus), (String)"migrationStatus");
        Iterable $this$flatMap$iv = containers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Map map;
            AbstractMcsContainer container = (AbstractMcsContainer)element$iv$iv;
            boolean bl = false;
            ContainerStatus containerStatus = container.getStatus();
            if (containerStatus == null) {
                containerStatus = ContainerStatus.READY;
            }
            ContainerStatus containerStatus2 = containerStatus.adaptStatus(migrationStatus);
            List<TransferStatusResponse> list2 = container.getTransfers();
            if (list2 != null) {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = list2;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable2 = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                    void it;
                    TransferStatusResponse transferStatusResponse = (TransferStatusResponse)element$iv$iv2;
                    Map map2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string = it.getOperationKey();
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string2 = string.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    map2.put(string2, element$iv$iv2);
                }
                map = destination$iv$iv2;
            } else {
                map = MapsKt.emptyMap();
            }
            Map transfersByOperationKey = map;
            List list3 = (List)this.expectedOperationKeysPerContainerType.get((Object)container.getType());
            if (list3 != null) {
                void $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2 = list3;
                boolean $i$f$flatMap2 = false;
                Iterable capacity$iv = $this$flatMap$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv3 : $this$flatMapTo$iv$iv2) {
                    Object element$iv2;
                    String operationKey;
                    block10: {
                        operationKey = (String)element$iv$iv3;
                        boolean bl3 = false;
                        Object object = this.convertorsForOperationKey.get((Object)operationKey);
                        Intrinsics.checkNotNull((Object)object);
                        Iterable $this$first$iv = (Iterable)object;
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            TransferProgressConvertor it = (TransferProgressConvertor)element$iv2;
                            boolean bl4 = false;
                            if (!it.getSupportedContainerTypes().contains((Object)container.getType())) continue;
                            break block10;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    TransferProgressConvertor convertor = (TransferProgressConvertor)element$iv2;
                    TransferStatusResponse transferStatusResponse = (TransferStatusResponse)transfersByOperationKey.get(operationKey);
                    Object object = transferStatusResponse;
                    if (object == null || (object = ((TransferStatusResponse)object).getStatus()) == null) {
                        object = TransferStatus.READY;
                    }
                    TransferStatus transferStatus = ((TransferStatus)((Object)object)).adaptStatus(containerStatus2);
                    Iterable list$iv$iv = convertor.convert(migrationId, plan2, container, containerStatus2, transferStatus, transferStatusResponse);
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv3;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Plan getStatus$lambda$3(Lazy<Plan> $plan$delegate) {
        Lazy<Plan> lazy = $plan$delegate;
        return (Plan)lazy.getValue();
    }

    public static final /* synthetic */ PlanRepository access$getPlanRepository$p(PlatformStatusService $this) {
        return $this.planRepository;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/progress/v3/PlatformStatusService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

