/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.progress.v3;

import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.JiraSiteMediaUploadV2;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.AbstractMcsContainer;
import com.atlassian.jira.migration.platform.ContainerStatus;
import com.atlassian.jira.migration.platform.ContainerType;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.platform.TransferStatusResponse;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.jira.migration.progress.v3.TransferProgressConvertor;
import com.atlassian.migration.api.MigrationId;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/progress/v3/SiteAttachmentUploadProgressConvertor;", "Lcom/atlassian/jira/migration/progress/v3/TransferProgressConvertor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "operationKey", "", "getOperationKey", "()Ljava/lang/String;", "supportedContainerTypes", "", "Lcom/atlassian/jira/migration/platform/ContainerType;", "getSupportedContainerTypes", "()Ljava/util/List;", "taskProgressOrder", "", "getTaskProgressOrder", "()I", "convert", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "container", "Lcom/atlassian/jira/migration/platform/AbstractMcsContainer;", "containerStatus", "Lcom/atlassian/jira/migration/platform/ContainerStatus;", "transferStatus", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "transfer", "Lcom/atlassian/jira/migration/platform/TransferStatusResponse;", "Companion", "jira-migration-plugin"})
public final class SiteAttachmentUploadProgressConvertor
implements TransferProgressConvertor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final List<ContainerType> supportedContainerTypes;
    @NotNull
    private final String operationKey;
    private final int taskProgressOrder;
    @NotNull
    public static final String OPERATION_KEY = "jiraSiteMediaUpload";

    @Inject
    public SiteAttachmentUploadProgressConvertor(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
        this.supportedContainerTypes = CollectionsKt.listOf((Object)((Object)ContainerType.Site));
        this.operationKey = OPERATION_KEY;
        this.taskProgressOrder = 6;
    }

    @Override
    @NotNull
    public List<ContainerType> getSupportedContainerTypes() {
        return this.supportedContainerTypes;
    }

    @Override
    @NotNull
    public String getOperationKey() {
        return this.operationKey;
    }

    @Override
    public int getTaskProgressOrder() {
        return this.taskProgressOrder;
    }

    @Override
    @NotNull
    public List<GetTaskStatusResponse.TaskProgress> convert(@NotNull MigrationId migrationId, @NotNull Plan plan2, @NotNull AbstractMcsContainer container, @NotNull ContainerStatus containerStatus, @NotNull TransferStatus transferStatus, @Nullable TransferStatusResponse transfer) {
        List list;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)((Object)containerStatus), (String)"containerStatus");
        Intrinsics.checkNotNullParameter((Object)((Object)transferStatus), (String)"transferStatus");
        if (!plan2.isLiftAndShift() || plan2.isTestMigrationWithoutAttachments() && !this.migrationFeatures.getDisableSinglePathWithoutAttachments()) {
            list = CollectionsKt.emptyList();
        } else {
            Map map;
            MigrationTask migrationTask = new JiraSiteMediaUploadV2("Uploading attachments");
            if (transferStatus == TransferStatus.READY) {
                map = MapsKt.emptyMap();
            } else {
                Map<String, Object> maybeTransferProps;
                TransferStatusResponse transferStatusResponse = transfer;
                Map<String, Object> map2 = maybeTransferProps = transferStatusResponse != null ? transferStatusResponse.getProgressProperties() : null;
                Long l = ConvertorHelpers.Companion.asLongOrNull(map2 != null ? map2.get("successfullyMigratedBytes") : null);
                long completed = l != null ? l : 0L;
                Map<String, Object> map3 = maybeTransferProps;
                Long l2 = ConvertorHelpers.Companion.asLongOrNull(map3 != null ? map3.get("totalProjectAttachmentSize") : null);
                long total = l2 != null ? l2 : 0L;
                int percentage = LongExtensionsKt.rangedPercentOf$default(completed, total, 0, 0, 6, null);
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)ProgressUnit.SITE), (Object)new ProgressItem(completed, total, ProgressUnit.SITE, transferStatus.isCompleted(), transferStatus.toTaskCompletionStatus(), null, null, "" + percentage + '%', null, 352, null)));
            }
            list = CollectionsKt.listOf((Object)new GetTaskStatusResponse.TaskProgress(migrationTask, map));
        }
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/progress/v3/SiteAttachmentUploadProgressConvertor$Companion;", "", "()V", "OPERATION_KEY", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

