/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.client;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.common.ObjectMapperFactoryKt;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.lio.model.RecipeExecutionRequest;
import com.atlassian.jira.migration.publicapi.model.ArtifactRequest;
import com.atlassian.jira.migration.publicapi.model.ArtifactResponse;
import com.atlassian.jira.migration.publicapi.model.CreateContainerTokenRequest;
import com.atlassian.jira.migration.publicapi.model.CreateContainerTokenResponse;
import com.atlassian.jira.migration.publicapi.model.JobDetails;
import com.atlassian.jira.migration.publicapi.model.LioExecutionId;
import com.atlassian.jira.migration.publicapi.model.MigrationDefinition;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.migration.publicapi.model.UpdateTaskStatusRequest;
import com.atlassian.jira.migration.publicapi.util.RetryManager;
import com.atlassian.migration.api.ContainerToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u0016\u0010*\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010,\u001a\u00020-*\u00020-2\u0006\u0010\u0015\u001a\u00020.H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;)V", "baseURI", "Ljava/net/URI;", "createContainerToken", "Lcom/atlassian/jira/migration/publicapi/model/CreateContainerTokenResponse;", "requestBody", "Lcom/atlassian/jira/migration/publicapi/model/CreateContainerTokenRequest;", "containerToken", "", "executeMigrationCreationRecipe", "Lcom/atlassian/jira/migration/publicapi/model/LioExecutionId;", "planId", "jobDefinition", "Lcom/atlassian/jira/migration/publicapi/model/MigrationDefinition;", "executeRecipe", "", "migrationId", "recipeExecutionRequest", "Lcom/atlassian/jira/migration/lio/model/RecipeExecutionRequest;", "getMigrationJobDefinition", "jobId", "linkArtifactToTask", "Lcom/atlassian/jira/migration/publicapi/model/ArtifactResponse;", "request", "Lcom/atlassian/jira/migration/publicapi/model/ArtifactRequest;", "toJobDefinition", "jobDetails", "Lcom/atlassian/jira/migration/publicapi/model/JobDetails;", "updateJobTaskStatus", "Lcom/atlassian/jira/migration/publicapi/model/UpdateTaskStatusRequest;", "withDefaultHeaders", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "Lcom/atlassian/migration/api/ContainerToken;", "Companion", "jira-migration-plugin"})
public final class MigrationClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final URI baseURI;
    @NotNull
    private static final String BASE_PATH = "cma";
    @NotNull
    private static final String GET_JOB_DEFINITION = "cma/jobs/{jobId}";
    @NotNull
    private static final String UPDATE_JOB_TASK_STATUS = "cma/jobs/{jobId}/tasks/{taskId}/status";
    @NotNull
    private static final String ADD_ARTIFACT_LINK = "cma/jobs/{jobId}/tasks/{taskId}/artifacts";
    @NotNull
    private static final String CREATE_CONTAINER_TOKEN = "cma/token";
    @NotNull
    private static final String EXECUTE_RECIPE = "cma/migration/{migrationId}/lio/recipes/{recipeName}/executions";
    @NotNull
    private static final String EXECUTE_MIGRATION_CREATION_RECIPE = "cma/migration/executions";
    private static final Logger log = LoggerFactory.getLogger(MigrationClient.class);

    @VisibleForTesting
    public MigrationClient(@NotNull MigrationPluginHttpClient httpClient, @NotNull ObjectMapper objectMapper2, @NotNull MigrationServicesConfiguration migrationServicesConfiguration) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        this.httpClient = httpClient;
        this.objectMapper = objectMapper2;
        this.baseURI = migrationServicesConfiguration.getMapiBaseURI();
        log.info("MAPI base url : " + this.baseURI);
    }

    @Inject
    public MigrationClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this(migrationServicesConfiguration, userAgentProvider, ObjectMapperFactoryKt.safeEnums(ObjectMapperFactoryKt.handleUnknownFields(objectMapperFactory.createObjectMapper())));
    }

    public MigrationClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapper objectMapper2) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        this(new MigrationPluginHttpClient(userAgentProvider, objectMapper2), objectMapper2, migrationServicesConfiguration);
    }

    @NotNull
    public final MigrationDefinition getMigrationJobDefinition(@NotNull String jobId, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Object object = new Integer[]{200, 405};
        Set set = SetsKt.setOf((Object[])object);
        String[] stringArray = new String[]{jobId};
        object = AbstractPluginHttpClientKt.buildURI$default(this.baseURI, GET_JOB_DEFINITION, stringArray, null, 8, null);
        return this.toJobDefinition(this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", (URI)object, set, null, null, null, 56, null), new ContainerToken(containerToken)), JobDetails.class), jobId);
    }

    public final void executeRecipe(@NotNull String containerToken, @NotNull String migrationId, @NotNull RecipeExecutionRequest recipeExecutionRequest) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)recipeExecutionRequest, (String)"recipeExecutionRequest");
        Object object = new String[]{migrationId, recipeExecutionRequest.getName()};
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.baseURI, EXECUTE_RECIPE, object, null, 8, null);
        Object[] objectArray = new Integer[]{202, 200};
        object = SetsKt.setOf((Object[])objectArray);
        this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, (Set)object, recipeExecutionRequest, null, null, 48, null), new ContainerToken(containerToken)));
    }

    public final void updateJobTaskStatus(@NotNull UpdateTaskStatusRequest request, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        RetryManager.withRetry$default(RetryManager.INSTANCE, (Function0)new Function0<Unit>(this, request, containerToken){
            final /* synthetic */ MigrationClient this$0;
            final /* synthetic */ UpdateTaskStatusRequest $request;
            final /* synthetic */ String $containerToken;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$containerToken = $containerToken;
                super(0);
            }

            public final void invoke() {
                Object object = new Integer[]{200, 201};
                Set set = SetsKt.setOf((Object[])object);
                Object object2 = new String[]{this.$request.getJobId(), this.$request.getTaskId()};
                object = AbstractPluginHttpClientKt.buildURI$default(MigrationClient.access$getBaseURI$p(this.this$0), "cma/jobs/{jobId}/tasks/{taskId}/status", object2, null, 8, null);
                object2 = this.$request.getRequestBody();
                MigrationClient.access$getHttpClient$p(this.this$0).execute(MigrationClient.access$withDefaultHeaders(this.this$0, new MigrationPluginHttpRequest("POST", (URI)object, set, object2, null, null, 48, null), new ContainerToken(this.$containerToken)));
            }
        }, null, 0, 6, null);
    }

    @NotNull
    public final ArtifactResponse linkArtifactToTask(@NotNull ArtifactRequest request, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Object object = new Integer[]{200, 201};
        Set set = SetsKt.setOf((Object[])object);
        Object object2 = new String[]{request.getJobId(), request.getTaskId()};
        object = AbstractPluginHttpClientKt.buildURI$default(this.baseURI, ADD_ARTIFACT_LINK, object2, null, 8, null);
        object2 = request.getRequestBody();
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("PUT", (URI)object, set, object2, null, null, 48, null), new ContainerToken(containerToken)), ArtifactResponse.class);
    }

    @NotNull
    public final CreateContainerTokenResponse createContainerToken(@NotNull CreateContainerTokenRequest requestBody, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Set set = SetsKt.setOf((Object)201);
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.baseURI, CREATE_CONTAINER_TOKEN, new String[0], null, 8, null);
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, set, requestBody, null, null, 48, null), new ContainerToken(containerToken)), CreateContainerTokenResponse.class);
    }

    @NotNull
    public final LioExecutionId executeMigrationCreationRecipe(@NotNull String containerToken, @NotNull String planId, @NotNull MigrationDefinition jobDefinition) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)jobDefinition, (String)"jobDefinition");
        URI uRI = AbstractPluginHttpClientKt.buildURI(this.baseURI, EXECUTE_MIGRATION_CREATION_RECIPE, new String[0], CollectionsKt.listOf((Object)TuplesKt.to((Object)"planId", (Object)planId)));
        Object[] objectArray = new Integer[]{202, 200};
        Set set = SetsKt.setOf((Object[])objectArray);
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", uRI, set, jobDefinition, null, null, 48, null), new ContainerToken(containerToken)), LioExecutionId.class);
    }

    private final MigrationDefinition toJobDefinition(JobDetails jobDetails, String jobId) {
        Object $this$toJobDefinition_u24lambda_u240;
        Object object = this;
        try {
            $this$toJobDefinition_u24lambda_u240 = object;
            boolean bl = false;
            $this$toJobDefinition_u24lambda_u240 = Result.constructor-impl((Object)((MigrationDefinition)((MigrationClient)$this$toJobDefinition_u24lambda_u240).objectMapper.readValue(jobDetails.getJobDefinition(), MigrationDefinition.class)));
        }
        catch (Throwable bl) {
            $this$toJobDefinition_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$toJobDefinition_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new PublicApiException.MigrationDefinitionParsingError(jobId, new RuntimeException(it));
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (MigrationDefinition)object2;
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, ContainerToken containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultHeaders_u24lambda_u242 = migrationPluginHttpRequest = $this$withDefaultHeaders;
        boolean bl = false;
        $this$withDefaultHeaders_u24lambda_u242.authorization("Bearer " + (String)((Object)containerToken.getValue()));
        $this$withDefaultHeaders_u24lambda_u242.contentTypeJson();
        $this$withDefaultHeaders_u24lambda_u242.acceptsJson();
        return migrationPluginHttpRequest;
    }

    public static final /* synthetic */ MigrationPluginHttpClient access$getHttpClient$p(MigrationClient $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ MigrationPluginHttpRequest access$withDefaultHeaders(MigrationClient $this, MigrationPluginHttpRequest $receiver, ContainerToken containerToken) {
        return $this.withDefaultHeaders($receiver, containerToken);
    }

    public static final /* synthetic */ URI access$getBaseURI$p(MigrationClient $this) {
        return $this.baseURI;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/publicapi/client/MigrationClient$Companion;", "", "()V", "ADD_ARTIFACT_LINK", "", "BASE_PATH", "CREATE_CONTAINER_TOKEN", "EXECUTE_MIGRATION_CREATION_RECIPE", "EXECUTE_RECIPE", "GET_JOB_DEFINITION", "UPDATE_JOB_TASK_STATUS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

