/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.db;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingEntity;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingTable;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.migration.publicapi.model.TaskStatus;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\fJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\n %*\u0004\u0018\u00010#0#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010'\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "addNewTask", "", "jobId", "", "taskId", "status", "Lcom/atlassian/jira/migration/publicapi/model/TaskStatus;", "taskType", "createPlanInRepository", "", "publicPlanMapping", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMapping;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "get", "getByMigrationId", "migrationId", "getByPlanId", "planId", "getByPreflightExecutionId", "preflightExecutionId", "getIfActiveMigrationTaskForPlanId", "getPlanForJobId", "isPublicApiMigration", "mapFromEntity", "publicPlanMappingEntity", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingEntity;", "setPlanAndJobMapping", "kotlin.jvm.PlatformType", "updateExistingTaskStatus", "updateMigrationIdForPlanId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPublicPlanMappingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicPlanMappingRepository.kt\ncom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n1#2:237\n*E\n"})
public final class PublicPlanMappingRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(PublicPlanMappingRepository.class);

    @Inject
    public PublicPlanMappingRepository(@NotNull ActiveObjects ao, @NotNull PlanRepository planRepository, @NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.ao = ao;
        this.planRepository = planRepository;
        this.databaseAccessor = databaseAccessor;
    }

    public final void createPlanInRepository(@NotNull PublicPlanMapping publicPlanMapping, @NotNull Plan plan2) {
        Object $this$createPlanInRepository_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)publicPlanMapping, (String)"publicPlanMapping");
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Object object = this;
        try {
            $this$createPlanInRepository_u24lambda_u241 = object;
            boolean bl = false;
            ((PublicPlanMappingRepository)$this$createPlanInRepository_u24lambda_u241).ao.executeInTransaction(() -> PublicPlanMappingRepository.createPlanInRepository$lambda$1$lambda$0((PublicPlanMappingRepository)$this$createPlanInRepository_u24lambda_u241, publicPlanMapping, plan2));
            log.info("Created plan for planId = {} and jobId = {}", (Object)plan2.getId(), (Object)publicPlanMapping.getJobId());
            $this$createPlanInRepository_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$createPlanInRepository_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createPlanInRepository_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            String string = it.getMessage();
            boolean bl2 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Unique index or primary key violation", (boolean)false, (int)2, null) : false;
            if (bl2) {
                throw new PublicApiException.DuplicateRequestException(publicPlanMapping.getJobId(), null, 2, null);
            }
            throw it;
        }
    }

    private final PublicPlanMappingEntity setPlanAndJobMapping(PublicPlanMapping publicPlanMapping, Plan plan2) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"JOB_ID", (Object)publicPlanMapping.getJobId()), TuplesKt.to((Object)"PLAN_ID", (Object)publicPlanMapping.getPlanId()), TuplesKt.to((Object)"MIGRATION_ID", (Object)publicPlanMapping.getMigrationId()), TuplesKt.to((Object)"PREFLIGHT_EXECUTION_ID", (Object)plan2.getPreflightCheckExecutionId())};
        return (PublicPlanMappingEntity)this.ao.create(PublicPlanMappingEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    public final boolean addNewTask(@NotNull String jobId, @NotNull String taskId2, @NotNull TaskStatus status, @NotNull String taskType) {
        Object object;
        Object $this$addNewTask_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)taskType, (String)"taskType");
        Object object2 = this;
        try {
            $this$addNewTask_u24lambda_u244 = object2;
            boolean bl = false;
            $this$addNewTask_u24lambda_u244 = Result.constructor-impl((Object)((Boolean)((PublicPlanMappingRepository)$this$addNewTask_u24lambda_u244).databaseAccessor.run(arg_0 -> PublicPlanMappingRepository.addNewTask$lambda$4$lambda$3(taskId2, status, taskType, jobId, arg_0), OnRollback.NOOP)));
        }
        catch (Throwable bl) {
            $this$addNewTask_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$addNewTask_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error in operation addNewTask for jobId = " + jobId + ", taskId = " + taskId2, it);
            object = false;
        }
        return (Boolean)object;
    }

    public final boolean updateExistingTaskStatus(@NotNull String jobId, @NotNull String taskId2, @NotNull TaskStatus status) {
        Object object;
        Object $this$updateExistingTaskStatus_u24lambda_u247;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)taskId2, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Object object2 = this;
        try {
            $this$updateExistingTaskStatus_u24lambda_u247 = object2;
            boolean bl = false;
            $this$updateExistingTaskStatus_u24lambda_u247 = Result.constructor-impl((Object)((Boolean)((PublicPlanMappingRepository)$this$updateExistingTaskStatus_u24lambda_u247).databaseAccessor.run(arg_0 -> PublicPlanMappingRepository.updateExistingTaskStatus$lambda$7$lambda$6(status, jobId, taskId2, arg_0), OnRollback.NOOP)));
        }
        catch (Throwable bl) {
            $this$updateExistingTaskStatus_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$updateExistingTaskStatus_u24lambda_u247;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error in operation updateExistingTaskStatus for jobId = " + jobId + ", taskId = " + taskId2, it);
            object = false;
        }
        return (Boolean)object;
    }

    public final void updateMigrationIdForPlanId(@NotNull String planId, @NotNull String migrationId) {
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            Object object2 = this;
            try {
                Unit unit;
                PublicPlanMappingRepository $this$updateMigrationIdForPlanId_u24lambda_u2410 = object2;
                boolean bl = false;
                Object[] objectArray = new Object[]{planId};
                RawEntity[] rawEntityArray = $this$updateMigrationIdForPlanId_u24lambda_u2410.ao.find(PublicPlanMappingEntity.class, Query.select().where("PLAN_ID = ?", objectArray));
                Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
                PublicPlanMappingEntity publicPlanMappingEntity = (PublicPlanMappingEntity)ArraysKt.getOrNull((Object[])rawEntityArray, (int)0);
                if (publicPlanMappingEntity != null) {
                    PublicPlanMappingEntity it = publicPlanMappingEntity;
                    boolean bl2 = false;
                    it.setMigrationId(migrationId);
                    it.save();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object it = object = throwable;
            boolean bl = false;
            Object[] objectArray = new Object[]{migrationId, planId, it};
            log.error("can not save migration = {} for planId = {}", objectArray);
        }
    }

    public final boolean isPublicApiMigration(@NotNull String migrationId) {
        Object object;
        Object $this$isPublicApiMigration_u24lambda_u2412;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Object object2 = this;
        try {
            $this$isPublicApiMigration_u24lambda_u2412 = object2;
            boolean bl = false;
            Object[] objectArray = new Object[]{migrationId};
            RawEntity[] rawEntityArray = ((PublicPlanMappingRepository)$this$isPublicApiMigration_u24lambda_u2412).ao.find(PublicPlanMappingEntity.class, Query.select().where("MIGRATION_ID = ?", objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
            $this$isPublicApiMigration_u24lambda_u2412 = Result.constructor-impl((Object)(ArraysKt.getOrNull((Object[])rawEntityArray, (int)0) != null ? 1 : 0));
        }
        catch (Throwable bl) {
            $this$isPublicApiMigration_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$isPublicApiMigration_u24lambda_u2412;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            log.error("error while getting mapping for migrationId = {}", (Object)migrationId);
            object = false;
        }
        return (Boolean)object;
    }

    @Nullable
    public final Plan getPlanForJobId(@NotNull String jobId) {
        Plan plan2;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        PublicPlanMapping publicPlanMapping = this.get(jobId);
        if (publicPlanMapping != null) {
            PublicPlanMapping it = publicPlanMapping;
            boolean bl = false;
            plan2 = this.planRepository.get(it.getPlanId());
        } else {
            plan2 = null;
        }
        return plan2;
    }

    @Nullable
    public final PublicPlanMapping get(@NotNull String jobId) {
        PublicPlanMapping publicPlanMapping;
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Object[] objectArray = new Object[]{jobId};
        RawEntity[] rawEntityArray = this.ao.find(PublicPlanMappingEntity.class, Query.select().where("JOB_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        PublicPlanMappingEntity publicPlanMappingEntity = (PublicPlanMappingEntity)ArraysKt.getOrNull((Object[])rawEntityArray, (int)0);
        if (publicPlanMappingEntity != null) {
            PublicPlanMappingEntity it = publicPlanMappingEntity;
            boolean bl = false;
            publicPlanMapping = this.mapFromEntity(it);
        } else {
            publicPlanMapping = null;
        }
        return publicPlanMapping;
    }

    @Nullable
    public final PublicPlanMapping getByPlanId(@NotNull String planId) {
        PublicPlanMapping publicPlanMapping;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Object[] objectArray = new Object[]{planId};
        RawEntity[] rawEntityArray = this.ao.find(PublicPlanMappingEntity.class, Query.select().where("PLAN_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        PublicPlanMappingEntity publicPlanMappingEntity = (PublicPlanMappingEntity)ArraysKt.getOrNull((Object[])rawEntityArray, (int)0);
        if (publicPlanMappingEntity != null) {
            PublicPlanMappingEntity it = publicPlanMappingEntity;
            boolean bl = false;
            publicPlanMapping = this.mapFromEntity(it);
        } else {
            publicPlanMapping = null;
        }
        return publicPlanMapping;
    }

    @Nullable
    public final PublicPlanMapping getByPreflightExecutionId(@NotNull String preflightExecutionId) {
        PublicPlanMapping publicPlanMapping;
        Intrinsics.checkNotNullParameter((Object)preflightExecutionId, (String)"preflightExecutionId");
        Object[] objectArray = new Object[]{preflightExecutionId};
        RawEntity[] rawEntityArray = this.ao.find(PublicPlanMappingEntity.class, Query.select().where("PREFLIGHT_EXECUTION_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        PublicPlanMappingEntity publicPlanMappingEntity = (PublicPlanMappingEntity)ArraysKt.getOrNull((Object[])rawEntityArray, (int)0);
        if (publicPlanMappingEntity != null) {
            PublicPlanMappingEntity it = publicPlanMappingEntity;
            boolean bl = false;
            publicPlanMapping = this.mapFromEntity(it);
        } else {
            publicPlanMapping = null;
        }
        return publicPlanMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final PublicPlanMapping getIfActiveMigrationTaskForPlanId(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Object object = new Object[]{planId};
        RawEntity[] rawEntityArray = this.ao.find(PublicPlanMappingEntity.class, Query.select().where("PLAN_ID = ?", (Object[])object));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object object2 = ArraysKt.getOrNull((Object[])rawEntityArray, (int)0);
        if (object2 == null) return null;
        Object it = object2;
        boolean bl = false;
        PublicPlanMapping publicPlanMapping = this.mapFromEntity((PublicPlanMappingEntity)it);
        if (publicPlanMapping == null) return null;
        it = object = publicPlanMapping;
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)((PublicPlanMapping)it).getTaskType(), (Object)CommandName.MIGRATE.getValue())) return null;
        if (!Intrinsics.areEqual((Object)((PublicPlanMapping)it).getTaskStatus(), (Object)"IN_PROGRESS")) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Object object3 = object;
        return object3;
    }

    @Nullable
    public final PublicPlanMapping getByMigrationId(@NotNull String migrationId) {
        PublicPlanMapping publicPlanMapping;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Object[] objectArray = new Object[]{migrationId};
        RawEntity[] rawEntityArray = this.ao.find(PublicPlanMappingEntity.class, Query.select().where("MIGRATION_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        PublicPlanMappingEntity publicPlanMappingEntity = (PublicPlanMappingEntity)ArraysKt.getOrNull((Object[])rawEntityArray, (int)0);
        if (publicPlanMappingEntity != null) {
            PublicPlanMappingEntity it = publicPlanMappingEntity;
            boolean bl = false;
            publicPlanMapping = this.mapFromEntity(it);
        } else {
            publicPlanMapping = null;
        }
        return publicPlanMapping;
    }

    private final PublicPlanMapping mapFromEntity(PublicPlanMappingEntity publicPlanMappingEntity) {
        String string;
        String string2;
        String string3;
        String string4 = publicPlanMappingEntity.getJobId();
        String string5 = publicPlanMappingEntity.getPlanId();
        String string6 = publicPlanMappingEntity.getMigrationId();
        if (string6 == null) {
            string6 = "";
        }
        if ((string3 = publicPlanMappingEntity.getTaskId()) == null) {
            string3 = "";
        }
        if ((string2 = publicPlanMappingEntity.getTaskStatus()) == null) {
            string2 = "";
        }
        if ((string = publicPlanMappingEntity.getTaskType()) == null) {
            string = "";
        }
        return new PublicPlanMapping(string4, string5, string6, string3, string2, string, publicPlanMappingEntity.getTaskCompletionTime());
    }

    private static final Plan createPlanInRepository$lambda$1$lambda$0(PublicPlanMappingRepository $this_runCatching, PublicPlanMapping $publicPlanMapping, Plan $plan) {
        Intrinsics.checkNotNullParameter((Object)$this_runCatching, (String)"$this_runCatching");
        Intrinsics.checkNotNullParameter((Object)$publicPlanMapping, (String)"$publicPlanMapping");
        Intrinsics.checkNotNullParameter((Object)$plan, (String)"$plan");
        $this_runCatching.setPlanAndJobMapping($publicPlanMapping, $plan);
        return $this_runCatching.planRepository.create($plan);
    }

    private static final Boolean addNewTask$lambda$4$lambda$3(String $taskId, TaskStatus $status, String $taskType, String $jobId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$taskId, (String)"$taskId");
        Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
        Intrinsics.checkNotNullParameter((Object)$taskType, (String)"$taskType");
        Intrinsics.checkNotNullParameter((Object)$jobId, (String)"$jobId");
        Object[] objectArray = new String[]{$taskId};
        BooleanExpression booleanExpression = PublicPlanMappingTable.INSTANCE.getJOB_ID().eq((Object)$jobId).and((Predicate)PublicPlanMappingTable.INSTANCE.getTASK_ID().isNull().or((Predicate)PublicPlanMappingTable.INSTANCE.getTASK_ID().notIn(objectArray)));
        objectArray = new String[]{"IN_PROGRESS"};
        return db.update((RelationalPath)PublicPlanMappingTable.INSTANCE).set((Path)PublicPlanMappingTable.INSTANCE.getTASK_ID(), (Object)$taskId).set((Path)PublicPlanMappingTable.INSTANCE.getTASK_STATUS(), (Object)$status.name()).set((Path)PublicPlanMappingTable.INSTANCE.getTASK_TYPE(), (Object)$taskType).where((Predicate)booleanExpression.and((Predicate)PublicPlanMappingTable.INSTANCE.getTASK_STATUS().isNull().or((Predicate)PublicPlanMappingTable.INSTANCE.getTASK_STATUS().notIn(objectArray)))).execute() > 0L;
    }

    private static final Boolean updateExistingTaskStatus$lambda$7$lambda$6(TaskStatus $status, String $jobId, String $taskId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)((Object)$status), (String)"$status");
        Intrinsics.checkNotNullParameter((Object)$jobId, (String)"$jobId");
        Intrinsics.checkNotNullParameter((Object)$taskId, (String)"$taskId");
        Predicate[] predicateArray = new Predicate[]{PublicPlanMappingTable.INSTANCE.getJOB_ID().eq((Object)$jobId), PublicPlanMappingTable.INSTANCE.getTASK_ID().eq((Object)$taskId)};
        return db.update((RelationalPath)PublicPlanMappingTable.INSTANCE).set((Path)PublicPlanMappingTable.INSTANCE.getTASK_STATUS(), (Object)$status.name()).set((Path)PublicPlanMappingTable.INSTANCE.getTASK_COMPLETION_TIME(), (Object)System.currentTimeMillis()).where(predicateArray).execute() > 0L;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

