/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.model;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \n2\u00060\u0001j\u0002`\u0002:\u0006\b\t\n\u000b\f\rB\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/publicapi/model/PublicApiException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "exception", "Ljava/lang/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "CheckTypeNotExcludable", "CloudSiteDoesNotExist", "Companion", "DuplicateRequestException", "MigrationDefinitionParsingError", "ResourceNotFound", "jira-migration-plugin"})
public class PublicApiException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DUPLICATE_JOB_MESSAGE = "Request has already been processed for JobId = %s";
    @NotNull
    private static final String DUPLICATE_JOB_AND_TASK_MESSAGE = "Request has already been processed for JobId = %s and TaskId = %s";
    @NotNull
    private static final String RESPONSE_PARSING_ERROR_MESSAGE = "Json Parsing Failed for jobId = %s.\n(1) Make sure that you have the latest JCMA version installed.\n(2) Check Jira Logs or contact support, if the issue persists.";
    @NotNull
    private static final String GENERIC_EXCEPTION = "Please check Jira Logs to find the issue or contact support, if the issue persists.";
    @NotNull
    private static final String CLOUD_ID_NOT_FOUND = "Destination cloud URL = \"%s\" is either invalid or not authorised with server. Please check and retry.";
    @NotNull
    private static final String CHECK_TYPE_NOT_EXCLUDABLE = "%s check types are not excludable. Please check and try again.";

    public PublicApiException(@NotNull String message, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message, exception);
    }

    public /* synthetic */ PublicApiException(String string, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = GENERIC_EXCEPTION;
        }
        if ((n & 2) != 0) {
            exception = null;
        }
        this(string, exception);
    }

    public PublicApiException() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/publicapi/model/PublicApiException$CheckTypeNotExcludable;", "Lcom/atlassian/jira/migration/publicapi/model/PublicApiException;", "checkTypes", "", "(Ljava/lang/String;)V", "jira-migration-plugin"})
    public static final class CheckTypeNotExcludable
    extends PublicApiException {
        public CheckTypeNotExcludable(@NotNull String checkTypes) {
            Intrinsics.checkNotNullParameter((Object)checkTypes, (String)"checkTypes");
            String string = PublicApiException.CHECK_TYPE_NOT_EXCLUDABLE;
            Object[] objectArray = new Object[]{checkTypes};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            super(string2, null, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/publicapi/model/PublicApiException$CloudSiteDoesNotExist;", "Lcom/atlassian/jira/migration/publicapi/model/PublicApiException;", "cloudUrl", "", "(Ljava/lang/String;)V", "jira-migration-plugin"})
    public static final class CloudSiteDoesNotExist
    extends PublicApiException {
        public CloudSiteDoesNotExist(@NotNull String cloudUrl) {
            Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
            String string = PublicApiException.CLOUD_ID_NOT_FOUND;
            Object[] objectArray = new Object[]{cloudUrl};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            super(string2, null, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/publicapi/model/PublicApiException$Companion;", "", "()V", "CHECK_TYPE_NOT_EXCLUDABLE", "", "CLOUD_ID_NOT_FOUND", "DUPLICATE_JOB_AND_TASK_MESSAGE", "DUPLICATE_JOB_MESSAGE", "GENERIC_EXCEPTION", "RESPONSE_PARSING_ERROR_MESSAGE", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/publicapi/model/PublicApiException$DuplicateRequestException;", "Lcom/atlassian/jira/migration/publicapi/model/PublicApiException;", "jobId", "", "taskId", "(Ljava/lang/String;Ljava/lang/String;)V", "jira-migration-plugin"})
    public static final class DuplicateRequestException
    extends PublicApiException {
        public DuplicateRequestException(@NotNull String jobId, @Nullable String taskId2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
            CharSequence charSequence = taskId2;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                charSequence = PublicApiException.DUPLICATE_JOB_MESSAGE;
                Object[] objectArray = new Object[]{jobId};
                String string2 = String.format((String)charSequence, Arrays.copyOf(objectArray, objectArray.length));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            } else {
                charSequence = PublicApiException.DUPLICATE_JOB_AND_TASK_MESSAGE;
                Object[] objectArray = new Object[]{jobId, taskId2};
                String string3 = String.format((String)charSequence, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            }
            super(string, null, 2, null);
        }

        public /* synthetic */ DuplicateRequestException(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/publicapi/model/PublicApiException$MigrationDefinitionParsingError;", "Lcom/atlassian/jira/migration/publicapi/model/PublicApiException;", "jobId", "", "exception", "Ljava/lang/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "jira-migration-plugin"})
    public static final class MigrationDefinitionParsingError
    extends PublicApiException {
        public MigrationDefinitionParsingError(@NotNull String jobId, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            String string = PublicApiException.RESPONSE_PARSING_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{jobId};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            super(string2, exception);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/publicapi/model/PublicApiException$ResourceNotFound;", "Lcom/atlassian/jira/migration/publicapi/model/PublicApiException;", "message", "", "(Ljava/lang/String;)V", "jira-migration-plugin"})
    public static final class ResourceNotFound
    extends PublicApiException {
        public ResourceNotFound(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, null, 2, null);
        }
    }
}

