/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.rest;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.prc.PollingService;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.spi.container.ResourceFilters;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.time.Instant;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="public")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0003\r\u000e\u000fB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/publicapi/rest/PublicApiResource;", "", "pollingService", "Lcom/atlassian/jira/migration/prc/PollingService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/prc/PollingService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "attachCloudSiteWithMigrationApi", "Ljavax/ws/rs/core/Response;", "cloudUrl", "", "AttachCloudError", "AttachCloudResponse", "Companion", "jira-migration-plugin"})
public final class PublicApiResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PollingService pollingService;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(PublicApiResource.class);

    @Inject
    public PublicApiResource(@NotNull PollingService pollingService, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)pollingService, (String)"pollingService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.pollingService = pollingService;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @POST
    @Path(value="v1/attach")
    @Operation(description="Attach cloudURL with Migration APIs", responses={@ApiResponse(description="OK", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(description="Invalid data provided", responseCode="400")})
    @NotNull
    public final Response attachCloudSiteWithMigrationApi(@QueryParam(value="cloudUrl") @NotNull String cloudUrl) {
        Object object;
        Object $this$attachCloudSiteWithMigrationApi_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        Object object2 = this;
        try {
            $this$attachCloudSiteWithMigrationApi_u24lambda_u240 = object2;
            boolean bl = false;
            String sanitizedCloudurl = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)cloudUrl)).toString(), (CharSequence)"/");
            Instant pollerExpiryTime = ((PublicApiResource)$this$attachCloudSiteWithMigrationApi_u24lambda_u240).pollingService.startPolling(sanitizedCloudurl);
            $this$attachCloudSiteWithMigrationApi_u24lambda_u240 = Result.constructor-impl((Object)ResponseUtils.INSTANCE.ok(((PublicApiResource)$this$attachCloudSiteWithMigrationApi_u24lambda_u240).objectMapper.writeValueAsString((Object)new AttachCloudResponse(sanitizedCloudurl, pollerExpiryTime))));
        }
        catch (Throwable bl) {
            $this$attachCloudSiteWithMigrationApi_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$attachCloudSiteWithMigrationApi_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable exception = throwable;
            boolean bl = false;
            log.error("Exception in operation attachCloudSiteWithMigrationApi", exception);
            if (exception instanceof PublicApiException.CloudSiteDoesNotExist) {
                String string = this.objectMapper.writeValueAsString((Object)new AttachCloudError("Invalid Request. Reason = " + exception.getMessage()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                object = ResponseUtils.INSTANCE.badRequest(string);
            } else {
                String string = new PublicApiException(null, null, 3, null).getMessage();
                Intrinsics.checkNotNull((Object)string);
                String string2 = this.objectMapper.writeValueAsString((Object)new AttachCloudError(string));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
                object = ResponseUtils.INSTANCE.internalServerError(string2);
            }
        }
        return (Response)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/publicapi/rest/PublicApiResource$AttachCloudError;", "", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class AttachCloudError {
        @NotNull
        private final String message;

        public AttachCloudError(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.message = message;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final AttachCloudError copy(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new AttachCloudError(message);
        }

        public static /* synthetic */ AttachCloudError copy$default(AttachCloudError attachCloudError, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = attachCloudError.message;
            }
            return attachCloudError.copy(string);
        }

        @NotNull
        public String toString() {
            return "AttachCloudError(message=" + this.message + ')';
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttachCloudError)) {
                return false;
            }
            AttachCloudError attachCloudError = (AttachCloudError)other;
            return Intrinsics.areEqual((Object)this.message, (Object)attachCloudError.message);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/publicapi/rest/PublicApiResource$AttachCloudResponse;", "", "cloudUrl", "", "expiryTime", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/time/Instant;)V", "getCloudUrl", "()Ljava/lang/String;", "getExpiryTime", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class AttachCloudResponse {
        @NotNull
        private final String cloudUrl;
        @NotNull
        private final Instant expiryTime;

        public AttachCloudResponse(@NotNull String cloudUrl, @NotNull Instant expiryTime) {
            Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
            Intrinsics.checkNotNullParameter((Object)expiryTime, (String)"expiryTime");
            this.cloudUrl = cloudUrl;
            this.expiryTime = expiryTime;
        }

        @NotNull
        public final String getCloudUrl() {
            return this.cloudUrl;
        }

        @NotNull
        public final Instant getExpiryTime() {
            return this.expiryTime;
        }

        @NotNull
        public final String component1() {
            return this.cloudUrl;
        }

        @NotNull
        public final Instant component2() {
            return this.expiryTime;
        }

        @NotNull
        public final AttachCloudResponse copy(@NotNull String cloudUrl, @NotNull Instant expiryTime) {
            Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
            Intrinsics.checkNotNullParameter((Object)expiryTime, (String)"expiryTime");
            return new AttachCloudResponse(cloudUrl, expiryTime);
        }

        public static /* synthetic */ AttachCloudResponse copy$default(AttachCloudResponse attachCloudResponse, String string, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = attachCloudResponse.cloudUrl;
            }
            if ((n & 2) != 0) {
                instant = attachCloudResponse.expiryTime;
            }
            return attachCloudResponse.copy(string, instant);
        }

        @NotNull
        public String toString() {
            return "AttachCloudResponse(cloudUrl=" + this.cloudUrl + ", expiryTime=" + this.expiryTime + ')';
        }

        public int hashCode() {
            int result2 = this.cloudUrl.hashCode();
            result2 = result2 * 31 + this.expiryTime.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttachCloudResponse)) {
                return false;
            }
            AttachCloudResponse attachCloudResponse = (AttachCloudResponse)other;
            if (!Intrinsics.areEqual((Object)this.cloudUrl, (Object)attachCloudResponse.cloudUrl)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expiryTime, (Object)attachCloudResponse.expiryTime);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/publicapi/rest/PublicApiResource$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

