/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.publicapi.client.MigrationClient;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.publicapi.model.ArtifactPayload;
import com.atlassian.jira.migration.publicapi.model.ArtifactRequest;
import com.atlassian.jira.migration.publicapi.model.ArtifactResponse;
import com.atlassian.jira.migration.publicapi.model.ArtifactSource;
import com.atlassian.jira.migration.publicapi.model.McsArtifactIdentifiers;
import com.atlassian.jira.migration.publicapi.model.McsMigrationScopeArtifactIdentifiers;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ2\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;", "", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "publicPlanMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "migrationClient", "Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;", "(Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;)V", "linkArtifactToTask", "Lcom/atlassian/jira/migration/publicapi/model/ArtifactResponse;", "publicPlan", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMapping;", "cloudId", "", "payload", "Lcom/atlassian/jira/migration/publicapi/model/ArtifactPayload;", "linkMcsArtifact", "", "migrationId", "fileId", "name", "linkMcsMigrationScopeArtifact", "migrationScopeId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nArtifactService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactService.kt\ncom/atlassian/jira/migration/publicapi/service/ArtifactService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class ArtifactService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final PublicPlanMappingRepository publicPlanMappingRepository;
    @NotNull
    private final MigrationClient migrationClient;
    private static final Logger log = LoggerFactory.getLogger(ArtifactService.class);

    @Inject
    public ArtifactService(@NotNull DiscoveryService discoveryService, @NotNull PublicPlanMappingRepository publicPlanMappingRepository, @NotNull MigrationClient migrationClient) {
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)publicPlanMappingRepository, (String)"publicPlanMappingRepository");
        Intrinsics.checkNotNullParameter((Object)migrationClient, (String)"migrationClient");
        this.discoveryService = discoveryService;
        this.publicPlanMappingRepository = publicPlanMappingRepository;
        this.migrationClient = migrationClient;
    }

    public final void linkMcsArtifact(@NotNull String migrationId, @NotNull String cloudId2, @NotNull String fileId, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PublicPlanMapping publicPlanMapping = this.publicPlanMappingRepository.getByMigrationId(migrationId);
        if (publicPlanMapping == null) {
            return;
        }
        PublicPlanMapping publicPlan = publicPlanMapping;
        log.info("Sending artifact link, linked to migration triggered via mapi");
        this.linkArtifactToTask(publicPlan, cloudId2, new ArtifactPayload(name, ArtifactSource.MCS, new McsArtifactIdentifiers(migrationId, fileId)));
    }

    @Nullable
    public final ArtifactResponse linkMcsMigrationScopeArtifact(@Nullable PublicPlanMapping publicPlan, @NotNull String migrationScopeId2, @NotNull String cloudId2, @NotNull String fileId, @NotNull String name) {
        ArtifactResponse artifactResponse;
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PublicPlanMapping publicPlanMapping = publicPlan;
        if (publicPlanMapping != null) {
            PublicPlanMapping $this$linkMcsMigrationScopeArtifact_u24lambda_u240 = publicPlanMapping;
            boolean bl = false;
            log.info("Sending artifact link, linked to migration scope for task triggered via mapi");
            artifactResponse = this.linkArtifactToTask(publicPlan, cloudId2, new ArtifactPayload(name, ArtifactSource.MCS_MIGRATION_SCOPE, new McsMigrationScopeArtifactIdentifiers(migrationScopeId2, fileId)));
        } else {
            artifactResponse = null;
        }
        return artifactResponse;
    }

    private final ArtifactResponse linkArtifactToTask(PublicPlanMapping publicPlan, String cloudId2, ArtifactPayload payload) {
        ArtifactResponse artifactResponse;
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
        if (cloudSite2 == null) {
            return null;
        }
        CloudSite cloudSite3 = cloudSite2;
        ArtifactResponse it = artifactResponse = this.migrationClient.linkArtifactToTask(new ArtifactRequest(publicPlan.getJobId(), publicPlan.getTaskId(), payload), cloudSite3.getContainerToken());
        boolean bl = false;
        log.info("Sent artifact link to mapi for: " + payload);
        return artifactResponse;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/ArtifactService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

