/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PlanCompletionEvent;
import com.atlassian.jira.migration.events.PreflightCheckCompletionEvent;
import com.atlassian.jira.migration.events.PreflightCheckGenericEvent;
import com.atlassian.jira.migration.events.PreflightStartedExecutionEvent;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.publicapi.service.PlanExternalMappingService;
import com.atlassian.jira.migration.publicapi.service.TaskStatusReportingService;
import com.atlassian.migration.prc.model.CommandName;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\fH\u0007J\b\u0010\u0016\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/ExecutionEventListener;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "planMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "taskStatusReportingService", "Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService;", "planExternalMappingService", "Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService;Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;)V", "onPlanCompletionEvent", "", "event", "Lcom/atlassian/jira/migration/events/PlanCompletionEvent;", "onPreflightCompletion", "Lcom/atlassian/jira/migration/events/PreflightCheckCompletionEvent;", "onPreflightStartProgressUpdate", "Lcom/atlassian/jira/migration/events/PreflightStartedExecutionEvent;", "onPreflightStatusUpdate", "Lcom/atlassian/jira/migration/events/PreflightCheckGenericEvent;", "postConstruct", "preDestroy", "Companion", "jira-migration-plugin"})
public final class ExecutionEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final PublicPlanMappingRepository planMappingRepository;
    @NotNull
    private final TaskStatusReportingService taskStatusReportingService;
    @NotNull
    private final PlanExternalMappingService planExternalMappingService;
    private static final Logger log = LoggerFactory.getLogger(ExecutionEventListener.class);

    @Inject
    public ExecutionEventListener(@NotNull MigrationEventBus migrationEventBus, @NotNull PublicPlanMappingRepository planMappingRepository, @NotNull TaskStatusReportingService taskStatusReportingService, @NotNull PlanExternalMappingService planExternalMappingService) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)planMappingRepository, (String)"planMappingRepository");
        Intrinsics.checkNotNullParameter((Object)taskStatusReportingService, (String)"taskStatusReportingService");
        Intrinsics.checkNotNullParameter((Object)planExternalMappingService, (String)"planExternalMappingService");
        this.migrationEventBus = migrationEventBus;
        this.planMappingRepository = planMappingRepository;
        this.taskStatusReportingService = taskStatusReportingService;
        this.planExternalMappingService = planExternalMappingService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @Subscribe
    public final void onPreflightStartProgressUpdate(@NotNull PreflightStartedExecutionEvent event) {
        block4: {
            PublicPlanMapping publicPlanMapping;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PublicPlanMapping publicPlanMapping2 = this.planMappingRepository.getByPreflightExecutionId(event.getPreflightCheckExecutionId());
            if (publicPlanMapping2 == null) break block4;
            PublicPlanMapping $this$onPreflightStartProgressUpdate_u24lambda_u242 = publicPlanMapping = publicPlanMapping2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)$this$onPreflightStartProgressUpdate_u24lambda_u242.getTaskStatus(), (Object)"FINISHED")) {
                Object object;
                Object object2 = $this$onPreflightStartProgressUpdate_u24lambda_u242;
                try {
                    PublicPlanMapping $this$onPreflightStartProgressUpdate_u24lambda_u242_u24lambda_u240 = object2;
                    boolean bl2 = false;
                    this.taskStatusReportingService.updatePreflightStartProgress(event, $this$onPreflightStartProgressUpdate_u24lambda_u242_u24lambda_u240);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Object it = object = throwable;
                    boolean bl3 = false;
                    log.error("Error during updating the preflight start progress to MAPI for event " + event, (Throwable)it);
                }
            }
        }
    }

    @Subscribe
    public final void onPreflightStatusUpdate(@NotNull PreflightCheckGenericEvent event) {
        block4: {
            PublicPlanMapping publicPlanMapping;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PublicPlanMapping publicPlanMapping2 = this.planMappingRepository.getByPreflightExecutionId(event.getPreflightCheckExecutionId());
            if (publicPlanMapping2 == null) break block4;
            PublicPlanMapping $this$onPreflightStatusUpdate_u24lambda_u245 = publicPlanMapping = publicPlanMapping2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)$this$onPreflightStatusUpdate_u24lambda_u245.getTaskStatus(), (Object)"FINISHED") && !event.isPreflightSkipped()) {
                Object object;
                Object object2 = $this$onPreflightStatusUpdate_u24lambda_u245;
                try {
                    PublicPlanMapping $this$onPreflightStatusUpdate_u24lambda_u245_u24lambda_u243 = object2;
                    boolean bl2 = false;
                    this.taskStatusReportingService.updatePreflightStepStatus(event, $this$onPreflightStatusUpdate_u24lambda_u245_u24lambda_u243);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Object it = object = throwable;
                    boolean bl3 = false;
                    log.error("Error during updating the preflight step status to MAPI for event " + event, (Throwable)it);
                }
            }
        }
    }

    @Subscribe
    public final void onPreflightCompletion(@NotNull PreflightCheckCompletionEvent event) {
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object2 = this;
            try {
                PublicPlanMapping publicPlanMapping;
                ExecutionEventListener $this$onPreflightCompletion_u24lambda_u247 = object2;
                boolean bl = false;
                PublicPlanMapping publicPlanMapping2 = $this$onPreflightCompletion_u24lambda_u247.planMappingRepository.getByPreflightExecutionId(event.getPreflightCheckExecutionId());
                if (publicPlanMapping2 != null) {
                    PublicPlanMapping publicPlanMapping3;
                    PublicPlanMapping $this$onPreflightCompletion_u24lambda_u247_u24lambda_u246 = publicPlanMapping3 = publicPlanMapping2;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)$this$onPreflightCompletion_u24lambda_u247_u24lambda_u246.getTaskStatus(), (Object)"IN_PROGRESS")) {
                        if (Intrinsics.areEqual((Object)$this$onPreflightCompletion_u24lambda_u247_u24lambda_u246.getTaskType(), (Object)CommandName.CHECK_PREFLIGHTS.getValue()) || !event.getAllChecksPassed()) {
                            $this$onPreflightCompletion_u24lambda_u247.planExternalMappingService.removeEntities($this$onPreflightCompletion_u24lambda_u247_u24lambda_u246.getJobId());
                        }
                        $this$onPreflightCompletion_u24lambda_u247.taskStatusReportingService.updatePreflightCompletionStatus(event, $this$onPreflightCompletion_u24lambda_u247_u24lambda_u246);
                    }
                    publicPlanMapping = publicPlanMapping3;
                } else {
                    publicPlanMapping = null;
                }
                object = Result.constructor-impl(publicPlanMapping);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block6;
            Object it = object = throwable;
            boolean bl = false;
            log.error("Error during updating the preflight status to MAPI event = " + event, (Throwable)it);
        }
    }

    @Subscribe
    public final void onPlanCompletionEvent(@NotNull PlanCompletionEvent event) {
        block6: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Intrinsics.areEqual((Object)event.getMigrationCreator(), (Object)"mapi")) break block6;
            Object object2 = this;
            try {
                PublicPlanMapping publicPlanMapping;
                block8: {
                    block7: {
                        PublicPlanMapping publicPlanMapping2;
                        ExecutionEventListener $this$onPlanCompletionEvent_u24lambda_u2410 = object2;
                        boolean bl = false;
                        publicPlanMapping = $this$onPlanCompletionEvent_u24lambda_u2410.planMappingRepository.getByMigrationId(event.getMigrationId());
                        if (publicPlanMapping == null) break block7;
                        PublicPlanMapping $this$onPlanCompletionEvent_u24lambda_u2410_u24lambda_u249 = publicPlanMapping2 = publicPlanMapping;
                        boolean bl2 = false;
                        if (!StringsKt.isBlank((CharSequence)$this$onPlanCompletionEvent_u24lambda_u2410_u24lambda_u249.getTaskId()) && Intrinsics.areEqual((Object)$this$onPlanCompletionEvent_u24lambda_u2410_u24lambda_u249.getTaskType(), (Object)CommandName.MIGRATE.getValue()) && Intrinsics.areEqual((Object)$this$onPlanCompletionEvent_u24lambda_u2410_u24lambda_u249.getTaskStatus(), (Object)"IN_PROGRESS")) {
                            $this$onPlanCompletionEvent_u24lambda_u2410.planExternalMappingService.removeEntities($this$onPlanCompletionEvent_u24lambda_u2410_u24lambda_u249.getJobId());
                            $this$onPlanCompletionEvent_u24lambda_u2410.taskStatusReportingService.updatePlanCompletionStatus($this$onPlanCompletionEvent_u24lambda_u2410_u24lambda_u249);
                        }
                        if ((publicPlanMapping = publicPlanMapping2) != null) break block8;
                    }
                    log.error("Public Plan Mapping not fund for planCompletionEvent = " + event);
                    publicPlanMapping = Unit.INSTANCE;
                }
                object = Result.constructor-impl((Object)publicPlanMapping);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block6;
            Object it = object = throwable;
            boolean bl = false;
            log.error("Error in updating status for migration completion event = " + event, (Throwable)it);
        }
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/ExecutionEventListener$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

