/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.csv.PreflightCSVWriter;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.publicapi.model.ArtifactResponse;
import com.atlassian.jira.migration.publicapi.service.ArtifactService;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationScopeId;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\"\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J,\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J*\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0014H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/MapiPreflightArtifactService;", "", "planMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "artifactService", "Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;", "(Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/publicapi/service/ArtifactService;)V", "createCheckCsvFile", "Ljava/io/File;", "executionId", "", "fileName", "checkType", "getArtifactDetails", "Lcom/atlassian/jira/migration/publicapi/model/ArtifactResponse;", "preflightCheckExecutionId", "publicPlan", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMapping;", "checkStatus", "Lcom/atlassian/cmpt/check/dto/Status;", "getCSVFileName", "processAndGetArtifactDetails", "saveResultToCsvFile", "csvMapping", "", "shouldProcessArtifactForCheck", "", "uploadCheckCsvFileToMcs", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "migrationScopeId", "checkCsvFile", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMapiPreflightArtifactService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapiPreflightArtifactService.kt\ncom/atlassian/jira/migration/publicapi/service/MapiPreflightArtifactService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class MapiPreflightArtifactService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicPlanMappingRepository planMappingRepository;
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ArtifactService artifactService;
    private static final Logger log = LoggerFactory.getLogger(MapiPreflightArtifactService.class);

    @Inject
    public MapiPreflightArtifactService(@NotNull PublicPlanMappingRepository planMappingRepository, @NotNull PreflightService preflightService, @NotNull DiscoveryService discoveryService, @NotNull PlatformService platformService, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationFeatures migrationFeatures, @NotNull ArtifactService artifactService) {
        Intrinsics.checkNotNullParameter((Object)planMappingRepository, (String)"planMappingRepository");
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)artifactService, (String)"artifactService");
        this.planMappingRepository = planMappingRepository;
        this.preflightService = preflightService;
        this.discoveryService = discoveryService;
        this.platformService = platformService;
        this.localFileDataOutput = localFileDataOutput;
        this.migrationScopeManager = migrationScopeManager;
        this.migrationFeatures = migrationFeatures;
        this.artifactService = artifactService;
    }

    @Nullable
    public final ArtifactResponse getArtifactDetails(@NotNull String preflightCheckExecutionId, @NotNull PublicPlanMapping publicPlan, @NotNull String checkType, @NotNull Status checkStatus) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)publicPlan, (String)"publicPlan");
        Intrinsics.checkNotNullParameter((Object)checkType, (String)"checkType");
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        return this.shouldProcessArtifactForCheck(checkStatus) ? this.processAndGetArtifactDetails(preflightCheckExecutionId, publicPlan, checkType) : null;
    }

    private final boolean shouldProcessArtifactForCheck(Status checkStatus) {
        return this.migrationFeatures.getEnableCheckCsvFileDownloadForMapi() && (checkStatus == Status.WARNING || checkStatus == Status.ERROR);
    }

    private final ArtifactResponse processAndGetArtifactDetails(String preflightCheckExecutionId, PublicPlanMapping publicPlan, String checkType) {
        ArtifactResponse artifactResponse;
        File checkCsvFile;
        log.info("processing csv artifacts for taskId: " + publicPlan.getTaskId() + " and checkType: " + checkType);
        String fileName = this.getCSVFileName(preflightCheckExecutionId, checkType);
        File file2 = checkCsvFile = this.createCheckCsvFile(preflightCheckExecutionId, fileName, checkType);
        if (file2 != null) {
            File it = file2;
            boolean bl = false;
            Plan plan2 = this.planMappingRepository.getPlanForJobId(publicPlan.getJobId());
            Intrinsics.checkNotNull((Object)plan2);
            Plan plan3 = plan2;
            CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(plan3.getCloudId());
            if (cloudSite2 == null) {
                return null;
            }
            CloudSite cloudSite3 = cloudSite2;
            String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(cloudSite3);
            String fileId = this.uploadCheckCsvFileToMcs(cloudSite3, migrationScopeId2, fileName, checkCsvFile);
            LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, checkCsvFile, null, 2, null);
            String string = fileId;
            if (string != null) {
                String it2 = string;
                boolean bl2 = false;
                artifactResponse = this.artifactService.linkMcsMigrationScopeArtifact(publicPlan, migrationScopeId2, plan3.getCloudId(), fileId, fileName);
            } else {
                artifactResponse = null;
            }
        } else {
            artifactResponse = null;
        }
        return artifactResponse;
    }

    private final String getCSVFileName(String preflightCheckExecutionId, String checkType) {
        return StringsKt.replace$default((String)this.preflightService.getCSVFileName(preflightCheckExecutionId, CheckType.Companion.fromString(checkType), null), (String)" ", (String)"-", (boolean)false, (int)4, null);
    }

    private final File createCheckCsvFile(String executionId, String fileName, String checkType) {
        Map<String, Object> csvMapping = this.preflightService.buildCSVMap(executionId, CheckType.Companion.fromString(checkType));
        return !csvMapping.isEmpty() ? this.saveResultToCsvFile(executionId, fileName, csvMapping) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File saveResultToCsvFile(String executionId, String fileName, Map<String, ? extends Object> csvMapping) {
        Path checkDirectory = this.localFileDataOutput.migrationCheckDirectory(executionId);
        Files.createDirectories(checkDirectory, new FileAttribute[0]);
        File checkCsvFile = checkDirectory.resolve(fileName).toFile();
        PreflightCSVWriter writer = new PreflightCSVWriter();
        Intrinsics.checkNotNull((Object)checkCsvFile);
        Closeable closeable = new FileOutputStream(checkCsvFile);
        Throwable throwable = null;
        try {
            FileOutputStream output = (FileOutputStream)closeable;
            boolean bl = false;
            writer.writeResultsInStream(output, csvMapping);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return checkCsvFile;
    }

    private final String uploadCheckCsvFileToMcs(CloudSite cloudSite2, String migrationScopeId2, String fileName, File checkCsvFile) {
        Object object;
        block2: {
            Object object2;
            log.info("uploading " + fileName + " file to mcs.");
            object = this;
            try {
                MapiPreflightArtifactService $this$uploadCheckCsvFileToMcs_u24lambda_u243 = object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)PlatformUploadServiceInterface.DefaultImpls.uploadMultiPartFileByMigrationScopeId$default($this$uploadCheckCsvFileToMcs_u24lambda_u243.platformService, new ContainerToken(cloudSite2.getContainerToken()), new MigrationScopeId(migrationScopeId2), fileName, null, checkCsvFile, null, 32, null));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            log.error("Failed to upload " + fileName + " file to mcs", (Throwable)it);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/MapiPreflightArtifactService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

