/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.eventHandlers.PlanEventHandler;
import com.atlassian.jira.migration.events.PublicPlanEvent;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.prc.PollerMetadataCache;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.publicapi.model.CheckTypes;
import com.atlassian.jira.migration.publicapi.model.CommandOptions;
import com.atlassian.jira.migration.publicapi.model.MapiCommandPayload;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.migration.publicapi.model.PublicApiExceptionKt;
import com.atlassian.jira.migration.publicapi.service.PlanCreationService;
import com.atlassian.jira.migration.publicapi.service.PlanExternalMappingService;
import com.atlassian.jira.migration.publicapi.service.PlanValidationService;
import com.atlassian.jira.migration.publicapi.service.TaskStatusReportingService;
import com.atlassian.migration.prc.model.CommandName;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J.\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!2\b\b\u0002\u0010,\u001a\u00020-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010*H\u0002J \u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010+\u001a\u00020!H\u0002R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanCheckService;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "planCreationService", "Lcom/atlassian/jira/migration/publicapi/service/PlanCreationService;", "planEventHandler", "Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;", "pollerMetadataCache", "Lcom/atlassian/jira/migration/prc/PollerMetadataCache;", "taskStatusReportingService", "Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService;", "planExternalMappingService", "Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;", "planValidationService", "Lcom/atlassian/jira/migration/publicapi/service/PlanValidationService;", "(Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/publicapi/service/PlanCreationService;Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;Lcom/atlassian/jira/migration/prc/PollerMetadataCache;Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService;Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;Lcom/atlassian/jira/migration/publicapi/service/PlanValidationService;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/publicapi/model/MapiCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "executePreflightChecks", "", "mapiCommandPayload", "executeTask", "commandPayload", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "prcCommandId", "", "getCheckTypes", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "options", "Lcom/atlassian/jira/migration/publicapi/model/CommandOptions;", "getPublicPlanEvent", "Lcom/atlassian/jira/migration/events/PublicPlanEvent;", "jobId", "", "startTime", "statusCode", "", "exception", "reportCheckExecutionError", "it", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanCheckService.kt\ncom/atlassian/jira/migration/publicapi/service/PlanCheckService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class PlanCheckService
implements PrcCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final PlanCreationService planCreationService;
    @NotNull
    private final PlanEventHandler planEventHandler;
    @NotNull
    private final PollerMetadataCache pollerMetadataCache;
    @NotNull
    private final TaskStatusReportingService taskStatusReportingService;
    @NotNull
    private final PlanExternalMappingService planExternalMappingService;
    @NotNull
    private final PlanValidationService planValidationService;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<MapiCommandPayload> payloadClassType;
    private static final Logger log = LoggerFactory.getLogger(PlanCheckService.class);
    @NotNull
    private static final String CLOUD_URL_NOT_ATTACHED = "Please reattach corresponding destination cloudUrl with JCMA Plugin.";
    @NotNull
    private static final String UNKNOWN = "UNKNOWN ERROR";
    @NotNull
    private static final String EXECUTION_ERROR = "Execution failure at JCMA, please check plugin logs.";

    @Inject
    public PlanCheckService(@NotNull PreflightService preflightService, @NotNull PlanCreationService planCreationService, @NotNull PlanEventHandler planEventHandler, @NotNull PollerMetadataCache pollerMetadataCache, @NotNull TaskStatusReportingService taskStatusReportingService, @NotNull PlanExternalMappingService planExternalMappingService, @NotNull PlanValidationService planValidationService) {
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)planCreationService, (String)"planCreationService");
        Intrinsics.checkNotNullParameter((Object)planEventHandler, (String)"planEventHandler");
        Intrinsics.checkNotNullParameter((Object)pollerMetadataCache, (String)"pollerMetadataCache");
        Intrinsics.checkNotNullParameter((Object)taskStatusReportingService, (String)"taskStatusReportingService");
        Intrinsics.checkNotNullParameter((Object)planExternalMappingService, (String)"planExternalMappingService");
        Intrinsics.checkNotNullParameter((Object)planValidationService, (String)"planValidationService");
        this.preflightService = preflightService;
        this.planCreationService = planCreationService;
        this.planEventHandler = planEventHandler;
        this.pollerMetadataCache = pollerMetadataCache;
        this.taskStatusReportingService = taskStatusReportingService;
        this.planExternalMappingService = planExternalMappingService;
        this.planValidationService = planValidationService;
        this.commandName = CommandName.CHECK_PREFLIGHTS;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(MapiCommandPayload.class);
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @NotNull
    public KClass<MapiCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        this.executePreflightChecks((MapiCommandPayload)commandPayload);
    }

    private final void executePreflightChecks(MapiCommandPayload mapiCommandPayload) {
        Object $this$executePreflightChecks_u24lambda_u241;
        long startTime = System.currentTimeMillis();
        Object object = this;
        try {
            $this$executePreflightChecks_u24lambda_u241 = object;
            boolean bl = false;
            EnumSet<CheckType> checkTypes = ((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).getCheckTypes(mapiCommandPayload.getOptions());
            ((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).pollerMetadataCache.setUserContextOrThrow(mapiCommandPayload.getDestId(), new PublicApiException(CLOUD_URL_NOT_ATTACHED, null, 2, null));
            Plan it = ((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).planCreationService.getOrCreatePlan(mapiCommandPayload.getJobId(), mapiCommandPayload.getDestId());
            boolean bl2 = false;
            PlanCreationService planCreationService = ((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).planCreationService;
            EnumSet<CheckType> enumSet = EnumSet.noneOf(CheckType.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
            Plan plan2 = planCreationService.updatePlanOverrideChecks(it, enumSet);
            ((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).taskStatusReportingService.addTaskForExecutionOrThrow(mapiCommandPayload, plan2.getId(), CommandName.CHECK_PREFLIGHTS);
            CommandOptions commandOptions = mapiCommandPayload.getOptions();
            ((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).planExternalMappingService.submitEntities(mapiCommandPayload.getJobId(), commandOptions != null ? commandOptions.getExternalMappings() : null);
            PreflightService.executeChecksForPlan$default(((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).preflightService, plan2.getId(), checkTypes, null, null, null, 28, null);
            ((PlanCheckService)$this$executePreflightChecks_u24lambda_u241).planEventHandler.sendPublicPlanCheckScheduled(PlanCheckService.getPublicPlanEvent$default((PlanCheckService)$this$executePreflightChecks_u24lambda_u241, mapiCommandPayload.getJobId(), startTime, 0, null, 12, null));
            log.info("executePreflightChecks Started for Job = " + mapiCommandPayload + ", and planId = " + plan2.getId());
            $this$executePreflightChecks_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$executePreflightChecks_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$executePreflightChecks_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error while Scheduling preflight Execution for job = " + mapiCommandPayload, it);
            this.reportCheckExecutionError(it, mapiCommandPayload, startTime);
            throw it;
        }
    }

    private final void reportCheckExecutionError(Throwable it, MapiCommandPayload mapiCommandPayload, long startTime) {
        if (!(it instanceof PublicApiException.DuplicateRequestException)) {
            String errorReason2 = it instanceof PublicApiException ? it.getMessage() : EXECUTION_ERROR;
            this.taskStatusReportingService.updateFailedToSchedule(mapiCommandPayload, errorReason2, CommandName.CHECK_PREFLIGHTS);
            String string = mapiCommandPayload.getJobId();
            int n = PublicApiExceptionKt.publicApiErrorCode(it);
            String string2 = it.getMessage();
            if (string2 == null) {
                string2 = UNKNOWN;
            }
            this.planEventHandler.sendPublicPlanCheckScheduled(this.getPublicPlanEvent(string, startTime, n, string2));
        }
    }

    private final PublicPlanEvent getPublicPlanEvent(String jobId, long startTime, int statusCode, String exception) {
        return new PublicPlanEvent(jobId, PublicPlanEvent.Action.EXECUTE_PREFLIGHT_CHECKS, statusCode, System.currentTimeMillis() - startTime, 0L, null, null, exception, false, 368, null);
    }

    static /* synthetic */ PublicPlanEvent getPublicPlanEvent$default(PlanCheckService planCheckService, String string, long l, int n, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 200;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        return planCheckService.getPublicPlanEvent(string, l, n, string2);
    }

    @VisibleForTesting
    @NotNull
    public final EnumSet<CheckType> getCheckTypes(@Nullable CommandOptions options) {
        Collection<Object> collection;
        block11: {
            block6: {
                Collection<Object> collection2;
                Collection<Object> includeKeysCheckTypeSet;
                block10: {
                    block9: {
                        Object checkTypesNode;
                        block8: {
                            Collection<Object> collection3;
                            block7: {
                                Object object = options;
                                if (object == null || (object = ((CommandOptions)object).getCheckTypes()) == null) break block6;
                                checkTypesNode = object;
                                boolean bl = false;
                                collection3 = ((CheckTypes)checkTypesNode).getIncludedKeys();
                                if (collection3 == null) break block7;
                                List<String> it = collection3;
                                boolean bl2 = false;
                                EnumSet<CheckType> enumSet = this.planValidationService.getCheckTypeSetFromKeysList(it);
                                collection3 = enumSet;
                                if (enumSet != null) break block8;
                            }
                            collection3 = includeKeysCheckTypeSet = CheckType.Companion.getEmptyCheckTypeSet();
                        }
                        if ((collection2 = ((CheckTypes)checkTypesNode).getExcludedKeys()) == null) break block9;
                        List<String> it = collection2;
                        boolean bl = false;
                        EnumSet<CheckType> enumSet = this.planValidationService.getCheckTypeSetFromKeysList(it);
                        collection2 = enumSet;
                        if (enumSet != null) break block10;
                    }
                    collection2 = CheckType.Companion.getEmptyCheckTypeSet();
                }
                Collection<Object> excludeKeysCheckTypeSet = collection2;
                collection = !((Collection)includeKeysCheckTypeSet).isEmpty() ? includeKeysCheckTypeSet : (!((Collection)excludeKeysCheckTypeSet).isEmpty() ? EnumSet.copyOf((Collection)CollectionsKt.subtract((Iterable)CheckType.Companion.getAllCheckTypesSet(), (Iterable)excludeKeysCheckTypeSet)) : CheckType.Companion.getEmptyCheckTypeSet());
                break block11;
            }
            collection = null;
        }
        EnumSet<CheckType> enumSet = collection;
        return enumSet == null ? CheckType.Companion.getEmptyCheckTypeSet() : enumSet;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanCheckService$Companion;", "", "()V", "CLOUD_URL_NOT_ATTACHED", "", "EXECUTION_ERROR", "UNKNOWN", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

