/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.advancedroadmaps.AdvancedRoadmapsProjectsService;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.AppDto;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.eventHandlers.PlanEventHandler;
import com.atlassian.jira.migration.events.PublicPlanEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.httpclient.exceptions.HttpProtocolException;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.plan.AdvancedRoadmapPlanMigrationMode;
import com.atlassian.jira.migration.plan.AdvancedRoadmapsMigrationOption;
import com.atlassian.jira.migration.plan.AppsMigrationOption;
import com.atlassian.jira.migration.plan.AttachmentFilters;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.plan.IssueFilters;
import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.plan.PlanSource;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.publicapi.client.MigrationClient;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.publicapi.model.AppsSpecifications;
import com.atlassian.jira.migration.publicapi.model.ArPlanMode;
import com.atlassian.jira.migration.publicapi.model.MapiCrossProjectBoardsAndFiltersMigrationMode;
import com.atlassian.jira.migration.publicapi.model.MapiDashboardsMigrationMode;
import com.atlassian.jira.migration.publicapi.model.MigrationDefinition;
import com.atlassian.jira.migration.publicapi.model.MigrationScope;
import com.atlassian.jira.migration.publicapi.model.ProjectMigrationType;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.migration.publicapi.model.PublicApiExceptionKt;
import com.atlassian.jira.migration.publicapi.service.PlanValidationService;
import com.atlassian.jira.migration.utils.CloudUtil;
import com.atlassian.jira.migration.validation.PlanValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 [2\u00020\u0001:\u0001[BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J6\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u000204H\u0002J\u0018\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u000207H\u0002J\u0018\u00108\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0016\u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0018\u0010:\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010;\u001a\u0002012\u0006\u0010(\u001a\u00020)H\u0002JD\u0010<\u001a\u00020=2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020?2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010B2\b\b\u0002\u0010C\u001a\u00020D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010N\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020?H\u0002J \u0010P\u001a\u00020Q2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020?2\u0006\u0010R\u001a\u00020\u0018H\u0002J\u0010\u0010S\u001a\u00020&2\u0006\u0010H\u001a\u00020IH\u0002J\u001c\u0010T\u001a\u00020\u00182\u0006\u0010R\u001a\u00020\u00182\f\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VJ\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010Y\u001a\u00020Q2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010Z\u001a\u00020Q2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanCreationService;", "", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationClient", "Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;", "planEventHandler", "Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;", "planMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "planValidationService", "Lcom/atlassian/jira/migration/publicapi/service/PlanValidationService;", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "cloudUtil", "Lcom/atlassian/jira/migration/utils/CloudUtil;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "advancedRoadmapsProjectsService", "Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/publicapi/service/PlanValidationService;Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/utils/CloudUtil;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "createAndSavePlan", "Lcom/atlassian/jira/migration/plan/Plan;", "jobId", "", "cloudId", "migrationData", "Lcom/atlassian/jira/migration/publicapi/model/MigrationDefinition;", "createPlan", "generatePlan", "migrationDefinition", "validProjectKeys", "", "arPlanMigrationMode", "Lcom/atlassian/jira/migration/plan/AdvancedRoadmapPlanMigrationMode;", "includeArchivedIssues", "", "getAdvancedRoadmapPlanMigrationMode", "projectMigrationType", "Lcom/atlassian/jira/migration/publicapi/model/ProjectMigrationType;", "mode", "Lcom/atlassian/jira/migration/publicapi/model/ArPlanMode;", "getAppsMigrationOption", "Lcom/atlassian/jira/migration/plan/AppsMigrationOption;", "apps", "Lcom/atlassian/jira/migration/publicapi/model/AppsSpecifications;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "getCrossProjectBoardsAndFiltersMigrationOption", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardsAndFiltersMigrationOption;", "Lcom/atlassian/jira/migration/publicapi/model/MapiCrossProjectBoardsAndFiltersMigrationMode;", "getDashboardsMigrationMode", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "Lcom/atlassian/jira/migration/publicapi/model/MapiDashboardsMigrationMode;", "getMigrationData", "getOrCreatePlan", "getPlanFromMigrationDefinition", "getProjectDataMigrationMode", "getPublicPlanEvent", "Lcom/atlassian/jira/migration/events/PublicPlanEvent;", "startTime", "", "createTime", "publicPlanMapping", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMapping;", "statusCode", "", "exception", "getUsersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "scope", "Lcom/atlassian/jira/migration/publicapi/model/MigrationScope;", "handleMigrationClientException", "", "throwable", "", "handlePlanCreationError", "start", "sendPlanEvents", "", "plan", "shouldIncludeArchivedIssues", "updatePlanOverrideChecks", "overrideChecks", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "validateAndGetProjectKeys", "validateFilterSpec", "validatePlanDoesNotExist", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanCreationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanCreationService.kt\ncom/atlassian/jira/migration/publicapi/service/PlanCreationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n1549#2:358\n1620#2,3:359\n*S KotlinDebug\n*F\n+ 1 PlanCreationService.kt\ncom/atlassian/jira/migration/publicapi/service/PlanCreationService\n*L\n315#1:358\n315#1:359,3\n*E\n"})
public final class PlanCreationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationClient migrationClient;
    @NotNull
    private final PlanEventHandler planEventHandler;
    @NotNull
    private final PublicPlanMappingRepository planMappingRepository;
    @NotNull
    private final PlanValidationService planValidationService;
    @NotNull
    private final AppAssessmentService appAssessmentService;
    @NotNull
    private final CloudUtil cloudUtil;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private static final Logger log = LoggerFactory.getLogger(PlanCreationService.class);
    @NotNull
    private static final PlanValidationException UNAUTHORISED_DESTINATION = new PlanValidationException("Destination cloud site is not authorised with server. Please Authorise the CloudSite and retry.");
    @NotNull
    private static final PlanValidationException JOB_ID_NOT_FOUND = new PlanValidationException("Migration Job Definition not found for JobId. Please recheck JobId and try again.");
    @NotNull
    private static final String UNKNOWN = "UNKNOWN ERROR";
    @NotNull
    private static final String INVALID_APPS_EXCEPTION = "Migration includes invalid app keys = %s. Available apps = %s. Make sure Apps Keys are valid, marked as 'Needed in Cloud' and having automatic migration path available.";

    @Inject
    public PlanCreationService(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationClient migrationClient, @NotNull PlanEventHandler planEventHandler, @NotNull PublicPlanMappingRepository planMappingRepository, @NotNull PlanValidationService planValidationService, @NotNull AppAssessmentService appAssessmentService, @NotNull CloudUtil cloudUtil, @NotNull PlanRepository planRepository, @NotNull AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationClient, (String)"migrationClient");
        Intrinsics.checkNotNullParameter((Object)planEventHandler, (String)"planEventHandler");
        Intrinsics.checkNotNullParameter((Object)planMappingRepository, (String)"planMappingRepository");
        Intrinsics.checkNotNullParameter((Object)planValidationService, (String)"planValidationService");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)cloudUtil, (String)"cloudUtil");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsProjectsService, (String)"advancedRoadmapsProjectsService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationClient = migrationClient;
        this.planEventHandler = planEventHandler;
        this.planMappingRepository = planMappingRepository;
        this.planValidationService = planValidationService;
        this.appAssessmentService = appAssessmentService;
        this.cloudUtil = cloudUtil;
        this.planRepository = planRepository;
        this.advancedRoadmapsProjectsService = advancedRoadmapsProjectsService;
        this.migrationFeatures = migrationFeatures;
    }

    @NotNull
    public final Plan getOrCreatePlan(@NotNull String jobId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Plan plan2 = this.planMappingRepository.getPlanForJobId(jobId);
        if (plan2 == null) {
            Object object;
            Object $this$getOrCreatePlan_u24lambda_u240;
            Object object2 = this;
            try {
                $this$getOrCreatePlan_u24lambda_u240 = object2;
                boolean bl = false;
                $this$getOrCreatePlan_u24lambda_u240 = Result.constructor-impl((Object)super.createPlan(jobId, cloudId2));
            }
            catch (Throwable bl) {
                $this$getOrCreatePlan_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$getOrCreatePlan_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                Throwable it = throwable;
                boolean bl = false;
                Throwable throwable2 = it;
                if (throwable2 instanceof PublicApiException.DuplicateRequestException) {
                    Plan plan3 = this.planMappingRepository.getPlanForJobId(jobId);
                    object = plan3;
                    Intrinsics.checkNotNull((Object)plan3);
                } else {
                    if (throwable2 instanceof PlanValidationException) {
                        String string = it.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        throw new PublicApiException(string, null, 2, null);
                    }
                    throw it;
                }
            }
            plan2 = (Plan)object;
        }
        return plan2;
    }

    private final Plan createPlan(String jobId, String cloudId2) {
        Object $this$createPlan_u24lambda_u242;
        long start = System.currentTimeMillis();
        Object object = this;
        try {
            $this$createPlan_u24lambda_u242 = object;
            boolean bl = false;
            super.validatePlanDoesNotExist(jobId);
            MigrationDefinition migrationData = super.getMigrationData(jobId, cloudId2);
            ((PlanCreationService)$this$createPlan_u24lambda_u242).planValidationService.validateServerId(migrationData.getSource().getServerId());
            Plan plan2 = super.createAndSavePlan(jobId, cloudId2, migrationData);
            log.info("created Plan for jobId = " + jobId + ", planId = " + plan2.getId());
            super.sendPlanEvents(jobId, start, plan2);
            $this$createPlan_u24lambda_u242 = Result.constructor-impl((Object)plan2);
        }
        catch (Throwable bl) {
            $this$createPlan_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createPlan_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.handlePlanCreationError(it, jobId, start);
            throw new KotlinNothingValueException();
        }
        return (Plan)object;
    }

    private final void validatePlanDoesNotExist(String jobId) {
        if (this.planMappingRepository.get(jobId) != null) {
            throw new PublicApiException.DuplicateRequestException(jobId, null, 2, null);
        }
    }

    private final Plan createAndSavePlan(String jobId, String cloudId2, MigrationDefinition migrationData) {
        Plan plan2 = this.getPlanFromMigrationDefinition(migrationData, cloudId2);
        PublicPlanMapping publicPlanMapping = new PublicPlanMapping(jobId, plan2.getId(), null, null, null, null, 0L, 124, null);
        this.planMappingRepository.createPlanInRepository(publicPlanMapping, plan2);
        return plan2;
    }

    private final void sendPlanEvents(String jobId, long start, Plan plan2) {
        this.planEventHandler.sendEventAsync(() -> PlanCreationService.sendPlanEvents$lambda$4(this, plan2));
        this.planEventHandler.sendPublicPlanSaveEvent(PlanCreationService.getPublicPlanEvent$default(this, jobId, start, plan2.getCreatedTimestamp(), new PublicPlanMapping(jobId, plan2.getId(), null, null, null, null, 0L, 124, null), 0, null, 48, null));
    }

    private final Void handlePlanCreationError(Throwable throwable, String jobId, long start) {
        log.error("Error while creating plan for jobId = " + jobId + ", Exception = " + ExceptionsKt.stackTraceToString((Throwable)throwable));
        this.planEventHandler.sendPublicPlanSaveEvent(PlanCreationService.getPublicPlanEvent$default(this, jobId, start, 0L, null, PublicApiExceptionKt.publicApiErrorCode(throwable), throwable.getMessage(), 12, null));
        throw throwable;
    }

    @NotNull
    public final Plan updatePlanOverrideChecks(@NotNull Plan plan2, @NotNull EnumSet<CheckType> overrideChecks) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        Intrinsics.checkNotNullParameter(overrideChecks, (String)"overrideChecks");
        List planOverrideChecks = CollectionsKt.toList((Iterable)plan2.getPreflightChecksToOverride());
        if (planOverrideChecks.containsAll((Collection)overrideChecks) && overrideChecks.containsAll(planOverrideChecks)) {
            return plan2;
        }
        plan2.getPreflightChecksToOverride().clear();
        plan2.getPreflightChecksToOverride().addAll((Collection<CheckType>)overrideChecks);
        return this.planRepository.update(plan2);
    }

    private final MigrationDefinition getMigrationData(String jobId, String cloudId2) {
        Object $this$getMigrationData_u24lambda_u245;
        Object object = this.cloudSiteRepository.getSite(cloudId2);
        if (object == null || (object = object.getContainerToken()) == null) {
            throw UNAUTHORISED_DESTINATION;
        }
        Object containerToken = object;
        Object object2 = this;
        try {
            $this$getMigrationData_u24lambda_u245 = object2;
            boolean bl = false;
            $this$getMigrationData_u24lambda_u245 = Result.constructor-impl((Object)((PlanCreationService)$this$getMigrationData_u24lambda_u245).migrationClient.getMigrationJobDefinition(jobId, (String)containerToken));
        }
        catch (Throwable bl) {
            $this$getMigrationData_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getMigrationData_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.handleMigrationClientException(it, jobId);
            throw new KotlinNothingValueException();
        }
        return (MigrationDefinition)object2;
    }

    private final Void handleMigrationClientException(Throwable throwable, String jobId) {
        Throwable throwable2;
        if (throwable instanceof UnexpectedStatusCodeException) {
            RuntimeException runtimeException;
            switch (((UnexpectedStatusCodeException)throwable).getStatusCode()) {
                case 401: {
                    runtimeException = UNAUTHORISED_DESTINATION;
                    break;
                }
                case 403: {
                    runtimeException = UNAUTHORISED_DESTINATION;
                    break;
                }
                case 404: {
                    runtimeException = JOB_ID_NOT_FOUND;
                    break;
                }
                default: {
                    runtimeException = (RuntimeException)throwable;
                }
            }
            throwable2 = runtimeException;
        } else {
            throwable2 = throwable instanceof HttpProtocolException ? (Throwable)new PublicApiException.MigrationDefinitionParsingError(jobId, (Exception)throwable) : throwable;
        }
        throw throwable2;
    }

    private final Plan getPlanFromMigrationDefinition(MigrationDefinition migrationDefinition, String cloudId2) {
        List<String> validProjectKeys = this.validateAndGetProjectKeys(migrationDefinition.getScope());
        AdvancedRoadmapPlanMigrationMode arPlanMigrationMode = this.getAdvancedRoadmapPlanMigrationMode(migrationDefinition.getScope().getProjects().getIncludedData(), migrationDefinition.getScope().getAr().getMode());
        boolean includeArchivedIssues = this.shouldIncludeArchivedIssues(migrationDefinition.getScope());
        if (this.migrationFeatures.getEnableDataFilters()) {
            this.validateFilterSpec(migrationDefinition.getScope());
        }
        return this.generatePlan(migrationDefinition, cloudId2, validProjectKeys, arPlanMigrationMode, includeArchivedIssues);
    }

    private final void validateFilterSpec(MigrationScope scope) {
        this.planValidationService.validateFilterSpec(scope.getIssueFilters(), scope.getAttachmentFilters());
    }

    private final List<String> validateAndGetProjectKeys(MigrationScope scope) {
        return this.planValidationService.validateAndGetProjectData(scope);
    }

    private final boolean shouldIncludeArchivedIssues(MigrationScope scope) {
        return scope.getProjects().getIncludedData() == ProjectMigrationType.ALL && scope.getProjects().getIncludeArchivedIssues();
    }

    private final Plan generatePlan(MigrationDefinition migrationDefinition, String cloudId2, List<String> validProjectKeys, AdvancedRoadmapPlanMigrationMode arPlanMigrationMode, boolean includeArchivedIssues) {
        ProjectDataMigrationMode migrationMode = this.getProjectDataMigrationMode(migrationDefinition.getScope().getProjects().getIncludedData());
        String string = UUID.randomUUID().toString();
        String string2 = this.planValidationService.getPlanName(migrationDefinition.getName());
        String string3 = migrationDefinition.getDestination().getUrl();
        List list = AdvancedRoadmapsProjectsService.DefaultImpls.getPlanIds$default(this.advancedRoadmapsProjectsService, validProjectKeys, arPlanMigrationMode, null, 4, null);
        UsersGroupsMigrationOption usersGroupsMigrationOption = this.getUsersGroupsMigrationOption(migrationDefinition.getScope());
        AppsMigrationOption appsMigrationOption = this.getAppsMigrationOption(migrationDefinition.getScope().getApps(), migrationDefinition.getScope().getProjects().getIncludedData(), migrationMode);
        String string4 = UUID.randomUUID().toString();
        long l = System.currentTimeMillis();
        PlanSource planSource = PlanSource.MIGRATION_API;
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption = this.getCrossProjectBoardsAndFiltersMigrationOption(migrationDefinition.getScope().getProjects().getIncludedData(), migrationDefinition.getScope().getBoardsAndFilters().getMode());
        DashboardsMigrationMode dashboardsMigrationMode = this.getDashboardsMigrationMode(migrationDefinition.getScope().getProjects().getIncludedData(), migrationDefinition.getScope().getDashboards().getMode());
        String string5 = this.cloudUtil.getCloudSiteRegion(cloudId2);
        AdvancedRoadmapsMigrationOption advancedRoadmapsMigrationOption = new AdvancedRoadmapsMigrationOption(arPlanMigrationMode, 0L, 2, null);
        IssueFilters issueFilters = new IssueFilters(migrationDefinition.getScope().getIssueFilters().getSystemAttributes(), migrationDefinition.getScope().getIssueFilters().getCustomAttributes());
        AttachmentFilters attachmentFilters = new AttachmentFilters(migrationDefinition.getScope().getAttachmentFilters().getSystemAttributes());
        Intrinsics.checkNotNull((Object)string);
        Boolean bl = false;
        Intrinsics.checkNotNull((Object)string4);
        return new Plan(string, string2, cloudId2, string3, validProjectKeys, list, usersGroupsMigrationOption, appsMigrationOption, migrationMode, bl, null, string4, null, null, null, l, null, null, null, null, null, crossProjectBoardsAndFiltersMigrationOption, dashboardsMigrationMode, null, null, planSource, null, includeArchivedIssues, null, null, null, null, null, string5, null, null, advancedRoadmapsMigrationOption, null, issueFilters, attachmentFilters, -174099456, 45, null);
    }

    private final CrossProjectBoardsAndFiltersMigrationOption getCrossProjectBoardsAndFiltersMigrationOption(ProjectMigrationType projectMigrationType, MapiCrossProjectBoardsAndFiltersMigrationMode mode) {
        CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode;
        if (projectMigrationType == ProjectMigrationType.ATTACHMENTS) {
            log.warn("Since only project attachments are selected, no cross-project boards and filters can be migrated");
            return new CrossProjectBoardsAndFiltersMigrationOption(CrossProjectBoardAndFiltersMigrationMode.NONE, 0L, 0L, 6, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                crossProjectBoardAndFiltersMigrationMode = CrossProjectBoardAndFiltersMigrationMode.ALL;
                break;
            }
            case 2: {
                crossProjectBoardAndFiltersMigrationMode = CrossProjectBoardAndFiltersMigrationMode.SELECTED_PROJECTS;
                break;
            }
            default: {
                crossProjectBoardAndFiltersMigrationMode = CrossProjectBoardAndFiltersMigrationMode.NONE;
            }
        }
        return new CrossProjectBoardsAndFiltersMigrationOption(crossProjectBoardAndFiltersMigrationMode, 0L, 0L, 6, null);
    }

    private final DashboardsMigrationMode getDashboardsMigrationMode(ProjectMigrationType projectMigrationType, MapiDashboardsMigrationMode mode) {
        DashboardsMigrationMode dashboardsMigrationMode;
        if (projectMigrationType == ProjectMigrationType.ATTACHMENTS) {
            log.warn("Since only project attachments are selected, no dashboards can be migrated");
            return DashboardsMigrationMode.NONE;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[mode.ordinal()]) {
            case 1: {
                dashboardsMigrationMode = DashboardsMigrationMode.ALL;
                break;
            }
            case 2: {
                dashboardsMigrationMode = DashboardsMigrationMode.SELECTED_PROJECTS;
                break;
            }
            default: {
                dashboardsMigrationMode = DashboardsMigrationMode.NONE;
            }
        }
        return dashboardsMigrationMode;
    }

    private final AdvancedRoadmapPlanMigrationMode getAdvancedRoadmapPlanMigrationMode(ProjectMigrationType projectMigrationType, ArPlanMode mode) {
        AdvancedRoadmapPlanMigrationMode advancedRoadmapPlanMigrationMode;
        if (projectMigrationType == ProjectMigrationType.ATTACHMENTS) {
            log.warn("Since only project attachments are selected, no ar plans can be migrated");
            return AdvancedRoadmapPlanMigrationMode.NONE;
        }
        switch (WhenMappings.$EnumSwitchMapping$2[mode.ordinal()]) {
            case 1: {
                advancedRoadmapPlanMigrationMode = AdvancedRoadmapPlanMigrationMode.ALL;
                break;
            }
            case 2: {
                advancedRoadmapPlanMigrationMode = AdvancedRoadmapPlanMigrationMode.SELECTED_PROJECTS;
                break;
            }
            default: {
                advancedRoadmapPlanMigrationMode = AdvancedRoadmapPlanMigrationMode.NONE;
            }
        }
        return advancedRoadmapPlanMigrationMode;
    }

    private final UsersGroupsMigrationOption getUsersGroupsMigrationOption(MigrationScope scope) {
        if (ProjectMigrationType.ATTACHMENTS == scope.getProjects().getIncludedData()) {
            log.warn("Since only project attachments are selected, no users, groups, or group membership can be migrated.");
            return new UsersGroupsMigrationOption(UsersGroupsMigrationOption.MigrationMode.NONE, false, false, false, null, 28, null);
        }
        return new UsersGroupsMigrationOption(UsersGroupsMigrationOption.MigrationMode.Companion.fromString(scope.getUsersAndGroups().getMode().name()), scope.getUsersAndGroups().getPreserveMemberships(), scope.getUsersAndGroups().getIncludeUsersInGroups(), scope.getUsersAndGroups().getIncludeRoleActors(), new JsdCustomersMigrationOption(JsdCustomersMigrationOption.JsdCustomersMigrationMode.Companion.fromString(scope.getJsm().getCustomers().getMode().name())));
    }

    /*
     * WARNING - void declaration
     */
    private final AppsMigrationOption getAppsMigrationOption(AppsSpecifications apps, ProjectMigrationType projectMigrationType, ProjectDataMigrationMode projectDataMigrationMode) {
        AppsMigrationOption appsMigrationOption;
        Set includedKeys;
        Collection collection;
        if (ProjectMigrationType.ATTACHMENTS == projectMigrationType && !((collection = (Collection)apps.getIncludedKeys()) == null || collection.isEmpty())) {
            log.warn("Since only project attachments are selected, no apps can be migrated");
        }
        if (ProjectMigrationType.ATTACHMENTS == projectMigrationType || (collection = (Collection)apps.getIncludedKeys()) == null || collection.isEmpty()) {
            return new AppsMigrationOption(false, null, null, null, false, null, 62, null);
        }
        AppsMigrationOption appMigrationOption = this.appAssessmentService.getUpdatedAppsMigrationOption(new AppsMigrationOption(projectMigrationType == ProjectMigrationType.ALL, null, null, null, false, null, 62, null), projectDataMigrationMode, includedKeys = CollectionsKt.toSet((Iterable)apps.getIncludedKeys()));
        Set set = appMigrationOption.getIncludedApps();
        if (set == null) {
            set = SetsKt.emptySet();
        }
        AppsMigrationOption it = appsMigrationOption = AppsMigrationOption.copy$default(appMigrationOption, false, SetsKt.minus((Set)includedKeys, (Iterable)CollectionsKt.toSet((Iterable)set)), null, null, false, null, 61, null);
        boolean bl = false;
        if (!((Collection)it.getExcludedAppsRequested()).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.appAssessmentService.getAppsNeededInCloud().getApps();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void app;
                AppDto appDto = (AppDto)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(app.getKey());
            }
            List appsNeeded = (List)destination$iv$iv;
            String string = INVALID_APPS_EXCEPTION;
            Object[] objectArray = new Object[]{it.getExcludedAppsRequested().toString(), appsNeeded};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new PlanValidationException(string2);
        }
        return appsMigrationOption;
    }

    private final ProjectDataMigrationMode getProjectDataMigrationMode(ProjectMigrationType projectMigrationType) {
        return ProjectMigrationType.ALL == projectMigrationType ? ProjectDataMigrationMode.ALL : (ProjectMigrationType.ATTACHMENTS == projectMigrationType ? ProjectDataMigrationMode.ATTACHMENTS_ONLY_V2 : (ProjectMigrationType.APP_DATA_PRELOAD == projectMigrationType ? ProjectDataMigrationMode.APP_DATA_PRELOAD : ProjectDataMigrationMode.CONFIG_ONLY));
    }

    private final PublicPlanEvent getPublicPlanEvent(String jobId, long startTime, long createTime, PublicPlanMapping publicPlanMapping, int statusCode, String exception) {
        long l = System.currentTimeMillis() - startTime;
        PublicPlanMapping publicPlanMapping2 = publicPlanMapping;
        String string = publicPlanMapping2 != null ? publicPlanMapping2.getPlanId() : null;
        PublicPlanMapping publicPlanMapping3 = publicPlanMapping;
        String string2 = publicPlanMapping3 != null ? publicPlanMapping3.getMigrationId() : null;
        String string3 = exception;
        if (string3 == null) {
            string3 = UNKNOWN;
        }
        return new PublicPlanEvent(jobId, PublicPlanEvent.Action.ATTACH_JOB, statusCode, l, createTime, string, string2, string3, false, 256, null);
    }

    static /* synthetic */ PublicPlanEvent getPublicPlanEvent$default(PlanCreationService planCreationService, String string, long l, long l2, PublicPlanMapping publicPlanMapping, int n, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            l2 = System.currentTimeMillis();
        }
        if ((n2 & 8) != 0) {
            publicPlanMapping = null;
        }
        if ((n2 & 0x10) != 0) {
            n = 201;
        }
        if ((n2 & 0x20) != 0) {
            string2 = null;
        }
        return planCreationService.getPublicPlanEvent(string, l, l2, publicPlanMapping, n, string2);
    }

    private static final void sendPlanEvents$lambda$4(PlanCreationService this$0, Plan $plan) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$plan, (String)"$plan");
        this$0.planEventHandler.sendPlanSavedEvent($plan);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanCreationService$Companion;", "", "()V", "INVALID_APPS_EXCEPTION", "", "JOB_ID_NOT_FOUND", "Lcom/atlassian/jira/migration/validation/PlanValidationException;", "getJOB_ID_NOT_FOUND", "()Lcom/atlassian/jira/migration/validation/PlanValidationException;", "UNAUTHORISED_DESTINATION", "getUNAUTHORISED_DESTINATION", "UNKNOWN", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlanValidationException getUNAUTHORISED_DESTINATION() {
            return UNAUTHORISED_DESTINATION;
        }

        @NotNull
        public final PlanValidationException getJOB_ID_NOT_FOUND() {
            return JOB_ID_NOT_FOUND;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[MapiCrossProjectBoardsAndFiltersMigrationMode.values().length];
            try {
                nArray[MapiCrossProjectBoardsAndFiltersMigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapiCrossProjectBoardsAndFiltersMigrationMode.SCOPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MapiDashboardsMigrationMode.values().length];
            try {
                nArray[MapiDashboardsMigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MapiDashboardsMigrationMode.SCOPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ArPlanMode.values().length];
            try {
                nArray[ArPlanMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArPlanMode.SCOPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

