/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.externalMapping.model.ExternalEntity;
import com.atlassian.jira.migration.externalMapping.service.ExternalMappingCache;
import com.atlassian.jira.migration.externalMapping.util.ExternalMappingUtil;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.publicapi.model.ExternalMapping;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.migration.publicapi.service.PlanExternalMappingService;
import com.atlassian.migration.core.MigrationCoreMriRegistry;
import com.atlassian.migration.jira.classic.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\u0016\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0018\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0019\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u001a\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;", "", "externalMappingCache", "Lcom/atlassian/jira/migration/externalMapping/service/ExternalMappingCache;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "publicPlanMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "(Lcom/atlassian/jira/migration/externalMapping/service/ExternalMappingCache;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;)V", "getMappedProjectIdsForPlanId", "", "", "planId", "", "getMappedUsersKeysForPlanId", "removeEntities", "", "jobId", "submitEntities", "externalEntities", "", "Lcom/atlassian/jira/migration/publicapi/model/ExternalMapping;", "throwIfContainAmbiguousMappings", "externalMappings", "throwIfContainsUnsupportedEntityTypes", "throwIfContainsUnsupportedExportChildrenProperty", "validateExternalMappings", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanExternalMappingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanExternalMappingService.kt\ncom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,126:1\n1549#2:127\n1620#2,3:128\n766#2:131\n857#2,2:132\n1549#2:134\n1620#2,3:135\n766#2:138\n857#2,2:139\n1549#2:141\n1620#2,3:142\n1#3:145\n1003#4:146\n1037#4,3:147\n1040#4,3:157\n372#5,7:150\n526#5:160\n511#5,6:161\n*S KotlinDebug\n*F\n+ 1 PlanExternalMappingService.kt\ncom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService\n*L\n35#1:127\n35#1:128,3\n45#1:131\n45#1:132,2\n46#1:134\n46#1:135,3\n63#1:138\n63#1:139,2\n64#1:141\n64#1:142,3\n109#1:146\n109#1:147,3\n109#1:157,3\n109#1:150,7\n112#1:160\n112#1:161,6\n*E\n"})
public final class PlanExternalMappingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExternalMappingCache externalMappingCache;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final PublicPlanMappingRepository publicPlanMappingRepository;
    @NotNull
    private static final String UNSUPPORTED_ENTITY_TYPE = "Invalid entityTypes = %s. Only supported entities are = %s";
    @NotNull
    private static final String UNSUPPORTED_EXPORT_CHILDREN_FOR_ENTITY_TYPE = "Invalid property 'exportChildren' set for entityTypes = %s";
    @NotNull
    private static final String AMBIGUOUS_ENTITY_MAPPINGS = "Same (type + sourceId) associated with different destinations. Ambiguous Mappings = %s";

    @Inject
    public PlanExternalMappingService(@NotNull ExternalMappingCache externalMappingCache, @NotNull MigrationFeatures migrationFeatures, @NotNull PublicPlanMappingRepository publicPlanMappingRepository) {
        Intrinsics.checkNotNullParameter((Object)externalMappingCache, (String)"externalMappingCache");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)publicPlanMappingRepository, (String)"publicPlanMappingRepository");
        this.externalMappingCache = externalMappingCache;
        this.migrationFeatures = migrationFeatures;
        this.publicPlanMappingRepository = publicPlanMappingRepository;
    }

    /*
     * WARNING - void declaration
     */
    public final void submitEntities(@NotNull String jobId, @Nullable List<ExternalMapping> externalEntities) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        this.removeEntities(jobId);
        Iterable iterable = externalEntities;
        if (!(iterable == null || iterable.isEmpty()) && !this.migrationFeatures.getDisableExternalEntitiesMapiMigration()) {
            Collection<ExternalEntity> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.validateExternalMappings(externalEntities);
            iterable = CollectionsKt.distinct((Iterable)externalEntities);
            String string = jobId;
            ExternalMappingCache externalMappingCache = this.externalMappingCache;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExternalMapping externalMapping = (ExternalMapping)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ExternalEntity(it.getType(), it.getSourceId(), it.getDestinationId(), it.getExportChildren()));
            }
            collection = (List)destination$iv$iv;
            externalMappingCache.putExternalMappings(string, (List<ExternalEntity>)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Long> getMappedProjectIdsForPlanId(@Nullable String planId) {
        Object object;
        block8: {
            block6: {
                block7: {
                    Set set;
                    if (planId == null || !this.migrationFeatures.getEnableExcludeMappedProjectsFromPreflightCheck()) break block6;
                    object = this.publicPlanMappingRepository.getByPlanId(planId);
                    if (object == null) break block7;
                    Object plan2 = object;
                    boolean bl = false;
                    List<ExternalEntity> list = this.externalMappingCache.get$jira_migration_plugin(((PublicPlanMapping)plan2).getJobId());
                    if (list != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ExternalEntity it;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        List<ExternalEntity> cache2 = list;
                        boolean bl2 = false;
                        Iterable iterable = cache2;
                        boolean $i$f$filter = false;
                        void var8_8 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (ExternalEntity)element$iv$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)Project.Companion.getEntityType().fullName())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (ExternalEntity)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            collection.add(Long.parseLong(it.getSourceId()));
                        }
                        set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    } else {
                        set = null;
                    }
                    object = set;
                    if (set != null) break block8;
                }
                object = SetsKt.emptySet();
                break block8;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Set<String> getMappedUsersKeysForPlanId(@Nullable String planId) {
        Set set;
        List<ExternalEntity> cacheForJobId;
        String string;
        if (planId != null && !this.migrationFeatures.getIncludeUsersMappingInExportViaMapiMigration()) {
            PublicPlanMapping publicPlanMapping = this.publicPlanMappingRepository.getByPlanId(planId);
            string = publicPlanMapping != null ? publicPlanMapping.getJobId() : null;
        } else {
            string = null;
        }
        String jobId = string;
        List<ExternalEntity> list = cacheForJobId = jobId != null ? this.externalMappingCache.get$jira_migration_plugin(jobId) : null;
        if (cacheForJobId != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = cacheForJobId;
            boolean $i$f$filter22 = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExternalEntity it = (ExternalEntity)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MigrationCoreMriRegistry.INSTANCE.getUser().fullName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExternalEntity bl = (ExternalEntity)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getSourceId());
            }
            Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            if (set2 != null) {
                set = set2;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    public final void removeEntities(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        this.externalMappingCache.remove(jobId);
    }

    private final void validateExternalMappings(List<ExternalMapping> externalMappings) {
        this.throwIfContainsUnsupportedEntityTypes(externalMappings);
        this.throwIfContainsUnsupportedExportChildrenProperty(externalMappings);
        this.throwIfContainAmbiguousMappings(externalMappings);
    }

    private final void throwIfContainsUnsupportedEntityTypes(List<ExternalMapping> externalMappings) {
        List list;
        List list2;
        List it = list2 = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)externalMappings), (Function1)throwIfContainsUnsupportedEntityTypes.1.INSTANCE), (Function1)throwIfContainsUnsupportedEntityTypes.2.INSTANCE)));
        boolean bl = false;
        List list3 = list = !((Collection)it).isEmpty() ? list2 : null;
        if (list != null) {
            it = list;
            boolean bl2 = false;
            String string = UNSUPPORTED_ENTITY_TYPE;
            Object[] objectArray = new Object[]{it.toString(), ExternalMappingUtil.INSTANCE.getAllSupportedEntities().toString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new PublicApiException(string2, null, 2, null);
        }
    }

    private final void throwIfContainsUnsupportedExportChildrenProperty(List<ExternalMapping> externalMappings) {
        List list;
        List list2;
        List it = list2 = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)externalMappings), (Function1)throwIfContainsUnsupportedExportChildrenProperty.1.INSTANCE), (Function1)throwIfContainsUnsupportedExportChildrenProperty.2.INSTANCE)));
        boolean bl = false;
        List list3 = list = !((Collection)it).isEmpty() ? list2 : null;
        if (list != null) {
            it = list;
            boolean bl2 = false;
            String string = UNSUPPORTED_EXPORT_CHILDREN_FOR_ENTITY_TYPE;
            Object[] objectArray = new Object[]{it.toString(), ExternalMappingUtil.INSTANCE.getAllSupportedEntities().toString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new PublicApiException(string2, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void throwIfContainAmbiguousMappings(List<ExternalMapping> externalMappings) {
        Map map;
        Map map2;
        void $this$filterTo$iv$iv;
        Object it;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Sequence $this$groupBy$iv = SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)externalMappings));
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it2;
            Object object;
            element$iv$iv = iterator2.next();
            it = (ExternalMapping)element$iv$iv;
            boolean $i$a$-groupBy-PlanExternalMappingService$throwIfContainAmbiguousMappings$32 = false;
            String key$iv$iv = "[type = " + ((ExternalMapping)it).getType() + ", sourceId = " + ((ExternalMapping)it).getSourceId() + "], destinations ";
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            ExternalMapping $i$a$-groupBy-PlanExternalMappingService$throwIfContainAmbiguousMappings$32 = (ExternalMapping)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(it2.getDestinationId());
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map it3 = map2 = destination$iv$iv;
        boolean bl = false;
        Map map3 = map = !it3.isEmpty() ? map2 : null;
        if (map != null) {
            it3 = map;
            boolean bl2 = false;
            String string = AMBIGUOUS_ENTITY_MAPPINGS;
            Object[] objectArray = new Object[]{it3.toString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new PublicApiException(string2, null, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService$Companion;", "", "()V", "AMBIGUOUS_ENTITY_MAPPINGS", "", "UNSUPPORTED_ENTITY_TYPE", "UNSUPPORTED_EXPORT_CHILDREN_FOR_ENTITY_TYPE", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

