/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.eventHandlers.PlanEventHandler;
import com.atlassian.jira.migration.events.PublicPlanEvent;
import com.atlassian.jira.migration.execution.PlanExecutionService;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.prc.PollerMetadataCache;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.publicapi.model.CommandOptions;
import com.atlassian.jira.migration.publicapi.model.MapiCommandPayload;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.migration.publicapi.model.PublicApiExceptionKt;
import com.atlassian.jira.migration.publicapi.service.PlanCreationService;
import com.atlassian.jira.migration.publicapi.service.PlanExternalMappingService;
import com.atlassian.jira.migration.publicapi.service.PlanValidationService;
import com.atlassian.jira.migration.publicapi.service.TaskStatusReportingService;
import com.atlassian.migration.prc.model.CommandName;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J6\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010&H\u0002J(\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u00100\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u00172\b\b\u0002\u0010*\u001a\u00020+J(\u00101\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J(\u00102\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\"2\u0006\u00103\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u00104\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanMigrationService;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "planCreationService", "Lcom/atlassian/jira/migration/publicapi/service/PlanCreationService;", "execution", "Lcom/atlassian/jira/migration/execution/PlanExecutionService;", "planEventHandler", "Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;", "pollerMetadataCache", "Lcom/atlassian/jira/migration/prc/PollerMetadataCache;", "taskStatusReportingService", "Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService;", "planExternalMappingService", "Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;", "planValidationService", "Lcom/atlassian/jira/migration/publicapi/service/PlanValidationService;", "(Lcom/atlassian/jira/migration/publicapi/service/PlanCreationService;Lcom/atlassian/jira/migration/execution/PlanExecutionService;Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;Lcom/atlassian/jira/migration/prc/PollerMetadataCache;Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService;Lcom/atlassian/jira/migration/publicapi/service/PlanExternalMappingService;Lcom/atlassian/jira/migration/publicapi/service/PlanValidationService;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/publicapi/model/MapiCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "createAndValidatePlan", "Lcom/atlassian/jira/migration/plan/Plan;", "mapiCommandPayload", "executeTask", "", "commandPayload", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "prcCommandId", "", "getPublicPlanEvent", "Lcom/atlassian/jira/migration/events/PublicPlanEvent;", "jobId", "", "startTime", "statusCode", "", "isDeliveredByLiO", "", "exception", "handleMigrationError", "it", "", "migrate", "reportMigrateExecutionError", "sendMigrationStartedEvent", "planId", "validateUserContext", "Companion", "jira-migration-plugin"})
public final class PlanMigrationService
implements PrcCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanCreationService planCreationService;
    @NotNull
    private final PlanExecutionService execution;
    @NotNull
    private final PlanEventHandler planEventHandler;
    @NotNull
    private final PollerMetadataCache pollerMetadataCache;
    @NotNull
    private final TaskStatusReportingService taskStatusReportingService;
    @NotNull
    private final PlanExternalMappingService planExternalMappingService;
    @NotNull
    private final PlanValidationService planValidationService;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<MapiCommandPayload> payloadClassType;
    private static final Logger log = LoggerFactory.getLogger(PlanMigrationService.class);
    @NotNull
    private static final String CLOUD_URL_NOT_ATTACHED = "Please reattach corresponding destination cloudUrl with JCMA Plugin.";
    @NotNull
    private static final String UNKNOWN = "UNKNOWN ERROR";
    @NotNull
    private static final String EXECUTION_ERROR = "Execution failure at JCMA, please check plugin logs.";

    @Inject
    public PlanMigrationService(@NotNull PlanCreationService planCreationService, @NotNull PlanExecutionService execution, @NotNull PlanEventHandler planEventHandler, @NotNull PollerMetadataCache pollerMetadataCache, @NotNull TaskStatusReportingService taskStatusReportingService, @NotNull PlanExternalMappingService planExternalMappingService, @NotNull PlanValidationService planValidationService) {
        Intrinsics.checkNotNullParameter((Object)planCreationService, (String)"planCreationService");
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Intrinsics.checkNotNullParameter((Object)planEventHandler, (String)"planEventHandler");
        Intrinsics.checkNotNullParameter((Object)pollerMetadataCache, (String)"pollerMetadataCache");
        Intrinsics.checkNotNullParameter((Object)taskStatusReportingService, (String)"taskStatusReportingService");
        Intrinsics.checkNotNullParameter((Object)planExternalMappingService, (String)"planExternalMappingService");
        Intrinsics.checkNotNullParameter((Object)planValidationService, (String)"planValidationService");
        this.planCreationService = planCreationService;
        this.execution = execution;
        this.planEventHandler = planEventHandler;
        this.pollerMetadataCache = pollerMetadataCache;
        this.taskStatusReportingService = taskStatusReportingService;
        this.planExternalMappingService = planExternalMappingService;
        this.planValidationService = planValidationService;
        this.commandName = CommandName.MIGRATE;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(MapiCommandPayload.class);
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @NotNull
    public KClass<MapiCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        MapiCommandPayload cfr_ignored_0 = (MapiCommandPayload)commandPayload;
        if (Intrinsics.areEqual((Object)((MapiCommandPayload)commandPayload).getShouldBeExecutedByLiO(), (Object)true)) {
            log.info("Skipping command execution on V3 for jobId = " + ((MapiCommandPayload)commandPayload).getJobId() + " and taskId = " + ((MapiCommandPayload)commandPayload).getTaskId());
            return;
        }
        PlanMigrationService.migrate$default(this, (MapiCommandPayload)commandPayload, false, 2, null);
    }

    @NotNull
    public final String migrate(@NotNull MapiCommandPayload mapiCommandPayload, boolean isDeliveredByLiO) {
        Object $this$migrate_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)mapiCommandPayload, (String)"mapiCommandPayload");
        long startTime = System.currentTimeMillis();
        Object object = this;
        try {
            $this$migrate_u24lambda_u240 = object;
            boolean bl = false;
            super.validateUserContext(mapiCommandPayload);
            Plan plan2 = super.createAndValidatePlan(mapiCommandPayload);
            ((PlanMigrationService)$this$migrate_u24lambda_u240).taskStatusReportingService.addTaskForExecutionOrThrow(mapiCommandPayload, plan2.getId(), CommandName.MIGRATE);
            CommandOptions commandOptions = mapiCommandPayload.getOptions();
            ((PlanMigrationService)$this$migrate_u24lambda_u240).planExternalMappingService.submitEntities(mapiCommandPayload.getJobId(), commandOptions != null ? commandOptions.getExternalMappings() : null);
            ((PlanMigrationService)$this$migrate_u24lambda_u240).execution.scheduleClassicPlanExecution(plan2);
            super.sendMigrationStartedEvent(mapiCommandPayload.getJobId(), startTime, plan2.getId(), isDeliveredByLiO);
            $this$migrate_u24lambda_u240 = Result.constructor-impl((Object)plan2.getId());
        }
        catch (Throwable bl) {
            $this$migrate_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$migrate_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.handleMigrationError(it, mapiCommandPayload, startTime, isDeliveredByLiO);
            throw it;
        }
        return (String)object;
    }

    public static /* synthetic */ String migrate$default(PlanMigrationService planMigrationService, MapiCommandPayload mapiCommandPayload, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return planMigrationService.migrate(mapiCommandPayload, bl);
    }

    private final void validateUserContext(MapiCommandPayload mapiCommandPayload) {
        this.pollerMetadataCache.setUserContextOrThrow(mapiCommandPayload.getDestId(), new PublicApiException(CLOUD_URL_NOT_ATTACHED, null, 2, null));
    }

    private final Plan createAndValidatePlan(MapiCommandPayload mapiCommandPayload) {
        Plan it = this.planCreationService.getOrCreatePlan(mapiCommandPayload.getJobId(), mapiCommandPayload.getDestId());
        boolean bl = false;
        EnumSet<CheckType> overrideChecks = this.planValidationService.validateAndGetOverrideChecks(mapiCommandPayload.getOptions());
        return this.planCreationService.updatePlanOverrideChecks(it, overrideChecks);
    }

    private final void sendMigrationStartedEvent(String jobId, long startTime, String planId, boolean isDeliveredByLiO) {
        this.planEventHandler.sendPublicPlanMigrationStarted(PlanMigrationService.getPublicPlanEvent$default(this, jobId, startTime, 0, isDeliveredByLiO, null, 20, null));
        log.info("Migration Started for Job Id = " + jobId + " and planId = " + planId);
    }

    private final void handleMigrationError(Throwable it, MapiCommandPayload mapiCommandPayload, long startTime, boolean isDeliveredByLiO) {
        log.error("Error while starting migration for Job = " + mapiCommandPayload, it);
        this.reportMigrateExecutionError(it, mapiCommandPayload, startTime, isDeliveredByLiO);
    }

    private final void reportMigrateExecutionError(Throwable it, MapiCommandPayload mapiCommandPayload, long startTime, boolean isDeliveredByLiO) {
        if (!(it instanceof PublicApiException.DuplicateRequestException)) {
            String errorReason2 = it instanceof PublicApiException ? it.getMessage() : EXECUTION_ERROR;
            this.taskStatusReportingService.updateFailedToSchedule(mapiCommandPayload, errorReason2, CommandName.MIGRATE);
            String string = mapiCommandPayload.getJobId();
            int n = PublicApiExceptionKt.publicApiErrorCode(it);
            String string2 = it.getMessage();
            if (string2 == null) {
                string2 = UNKNOWN;
            }
            this.planEventHandler.sendPublicPlanMigrationStarted(this.getPublicPlanEvent(string, startTime, n, isDeliveredByLiO, string2));
        }
    }

    private final PublicPlanEvent getPublicPlanEvent(String jobId, long startTime, int statusCode, boolean isDeliveredByLiO, String exception) {
        return new PublicPlanEvent(jobId, PublicPlanEvent.Action.MIGRATION_STARTED, statusCode, System.currentTimeMillis() - startTime, 0L, null, null, exception, isDeliveredByLiO, 112, null);
    }

    static /* synthetic */ PublicPlanEvent getPublicPlanEvent$default(PlanMigrationService planMigrationService, String string, long l, int n, boolean bl, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 201;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        return planMigrationService.getPublicPlanEvent(string, l, n, bl, string2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanMigrationService$Companion;", "", "()V", "CLOUD_URL_NOT_ATTACHED", "", "EXECUTION_ERROR", "UNKNOWN", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

