/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.prc.PollerMetadataCache;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.client.PrcHttpClient;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.publicapi.model.MapiCommandPayloadV2;
import com.atlassian.jira.migration.publicapi.service.PlanMigrationService;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.prc.model.CommandSource;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import com.atlassian.migration.statusrouter.model.CommandStatusRequest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanMigrationServiceV2;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "planMigrationService", "Lcom/atlassian/jira/migration/publicapi/service/PlanMigrationService;", "pollerMetadataCache", "Lcom/atlassian/jira/migration/prc/PollerMetadataCache;", "prcHttpClient", "Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/publicapi/service/PlanMigrationService;Lcom/atlassian/jira/migration/prc/PollerMetadataCache;Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/publicapi/model/MapiCommandPayloadV2;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "executeTask", "", "commandPayload", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "prcCommandId", "", "ExecutionResult", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanMigrationServiceV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanMigrationServiceV2.kt\ncom/atlassian/jira/migration/publicapi/service/PlanMigrationServiceV2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class PlanMigrationServiceV2
implements PrcCommandExecutor {
    @NotNull
    private final PlanMigrationService planMigrationService;
    @NotNull
    private final PollerMetadataCache pollerMetadataCache;
    @NotNull
    private final PrcHttpClient prcHttpClient;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<MapiCommandPayloadV2> payloadClassType;

    @Inject
    public PlanMigrationServiceV2(@NotNull PlanMigrationService planMigrationService, @NotNull PollerMetadataCache pollerMetadataCache, @NotNull PrcHttpClient prcHttpClient, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)planMigrationService, (String)"planMigrationService");
        Intrinsics.checkNotNullParameter((Object)pollerMetadataCache, (String)"pollerMetadataCache");
        Intrinsics.checkNotNullParameter((Object)prcHttpClient, (String)"prcHttpClient");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.planMigrationService = planMigrationService;
        this.pollerMetadataCache = pollerMetadataCache;
        this.prcHttpClient = prcHttpClient;
        this.objectMapper = objectMapperFactory.createObjectMapper();
        this.commandName = CommandName.START_MIGRATION;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(MapiCommandPayloadV2.class);
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @NotNull
    public KClass<MapiCommandPayloadV2> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Object object;
        Object $this$executeTask_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        MapiCommandPayloadV2 cfr_ignored_0 = (MapiCommandPayloadV2)commandPayload;
        Throwable executionException = null;
        Object object2 = this;
        try {
            $this$executeTask_u24lambda_u240 = object2;
            boolean bl = false;
            String jcmaPlanId = ((PlanMigrationServiceV2)$this$executeTask_u24lambda_u240).planMigrationService.migrate(((MapiCommandPayloadV2)commandPayload).getMapiTaskPayload(), true);
            $this$executeTask_u24lambda_u240 = Result.constructor-impl((Object)new ExecutionResult("Migration Execution started for planId = " + jcmaPlanId, true));
        }
        catch (Throwable bl) {
            $this$executeTask_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$executeTask_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            executionException = it;
            object = new ExecutionResult("Error while starting the migration = " + it.getMessage(), false);
        }
        ExecutionResult executionResult = (ExecutionResult)object;
        String string = String.valueOf(prcCommandId);
        CommandStatus commandStatus = executionResult.isSuccess() ? CommandStatus.SUCCESS : CommandStatus.FAILED;
        String string2 = ((MapiCommandPayloadV2)commandPayload).getSourceCommandId();
        ObjectNode objectNode = this.objectMapper.createObjectNode().put("result", executionResult.getResultMessage());
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"put(...)");
        this.prcHttpClient.publishFinalStatus(string, new CommandStatusRequest(CommandSource.LIO, commandStatus, string2, (JsonNode)objectNode), this.pollerMetadataCache.getContainerTokenForCloudId(((MapiCommandPayloadV2)commandPayload).getMapiTaskPayload().getDestId()));
        object2 = executionException;
        if (object2 != null) {
            Object it = object2;
            boolean bl = false;
            throw it;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanMigrationServiceV2$ExecutionResult;", "", "resultMessage", "", "isSuccess", "", "(Ljava/lang/String;Z)V", "()Z", "getResultMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    private static final class ExecutionResult {
        @NotNull
        private final String resultMessage;
        private final boolean isSuccess;

        public ExecutionResult(@NotNull String resultMessage, boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)resultMessage, (String)"resultMessage");
            this.resultMessage = resultMessage;
            this.isSuccess = isSuccess;
        }

        @NotNull
        public final String getResultMessage() {
            return this.resultMessage;
        }

        public final boolean isSuccess() {
            return this.isSuccess;
        }

        @NotNull
        public final String component1() {
            return this.resultMessage;
        }

        public final boolean component2() {
            return this.isSuccess;
        }

        @NotNull
        public final ExecutionResult copy(@NotNull String resultMessage, boolean isSuccess) {
            Intrinsics.checkNotNullParameter((Object)resultMessage, (String)"resultMessage");
            return new ExecutionResult(resultMessage, isSuccess);
        }

        public static /* synthetic */ ExecutionResult copy$default(ExecutionResult executionResult, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = executionResult.resultMessage;
            }
            if ((n & 2) != 0) {
                bl = executionResult.isSuccess;
            }
            return executionResult.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "ExecutionResult(resultMessage=" + this.resultMessage + ", isSuccess=" + this.isSuccess + ')';
        }

        public int hashCode() {
            int result2 = this.resultMessage.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isSuccess);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExecutionResult)) {
                return false;
            }
            ExecutionResult executionResult = (ExecutionResult)other;
            if (!Intrinsics.areEqual((Object)this.resultMessage, (Object)executionResult.resultMessage)) {
                return false;
            }
            return this.isSuccess == executionResult.isSuccess;
        }
    }
}

