/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.plan.AdvancedRoadmapPlanMigrationMode;
import com.atlassian.jira.migration.plan.AdvancedRoadmapsMigrationOption;
import com.atlassian.jira.migration.plan.AttachmentFilters;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.plan.IssueFilters;
import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.publicapi.model.AdvancedRoadmapSpecifications;
import com.atlassian.jira.migration.publicapi.model.AppsSpecifications;
import com.atlassian.jira.migration.publicapi.model.ArPlanMode;
import com.atlassian.jira.migration.publicapi.model.AttachmentFilterSpecification;
import com.atlassian.jira.migration.publicapi.model.CloudDetails;
import com.atlassian.jira.migration.publicapi.model.CrossProjectBoardsAndFiltersSpecifications;
import com.atlassian.jira.migration.publicapi.model.CustomerSelection;
import com.atlassian.jira.migration.publicapi.model.DashboardsSpecifications;
import com.atlassian.jira.migration.publicapi.model.IssueFilterSpecification;
import com.atlassian.jira.migration.publicapi.model.JsmSpecifications;
import com.atlassian.jira.migration.publicapi.model.MapiCrossProjectBoardsAndFiltersMigrationMode;
import com.atlassian.jira.migration.publicapi.model.MapiDashboardsMigrationMode;
import com.atlassian.jira.migration.publicapi.model.MigrationDefinition;
import com.atlassian.jira.migration.publicapi.model.MigrationMode;
import com.atlassian.jira.migration.publicapi.model.MigrationScope;
import com.atlassian.jira.migration.publicapi.model.ProjectData;
import com.atlassian.jira.migration.publicapi.model.ProjectMigrationType;
import com.atlassian.jira.migration.publicapi.model.ServerDetails;
import com.atlassian.jira.migration.publicapi.model.UsersAndGroups;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanTransformationService;", "", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "(Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;)V", "getArPlanMode", "Lcom/atlassian/jira/migration/publicapi/model/ArPlanMode;", "mode", "Lcom/atlassian/jira/migration/plan/AdvancedRoadmapPlanMigrationMode;", "getCrossProjectBoardsAndFiltersMode", "Lcom/atlassian/jira/migration/publicapi/model/MapiCrossProjectBoardsAndFiltersMigrationMode;", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "getDashboardMigrationMode", "Lcom/atlassian/jira/migration/publicapi/model/MapiDashboardsMigrationMode;", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "getJsmCustomerOption", "Lcom/atlassian/jira/migration/publicapi/model/MigrationMode;", "Lcom/atlassian/jira/migration/plan/JsdCustomersMigrationOption$JsdCustomersMigrationMode;", "getProjectIncludedData", "Lcom/atlassian/jira/migration/publicapi/model/ProjectMigrationType;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "getUserAndGroupMigrationMode", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption$MigrationMode;", "transform", "Lcom/atlassian/jira/migration/publicapi/model/MigrationDefinition;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "jira-migration-plugin"})
public final class PlanTransformationService {
    @NotNull
    private final JiraMetadataService jiraMetadataService;

    @Inject
    public PlanTransformationService(@NotNull JiraMetadataService jiraMetadataService) {
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        this.jiraMetadataService = jiraMetadataService;
    }

    @NotNull
    public final MigrationDefinition transform(@NotNull Plan plan2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        String string = plan2.getPlanName();
        ServerDetails serverDetails = new ServerDetails(this.jiraMetadataService.getJiraServerId());
        CloudDetails cloudDetails = new CloudDetails(plan2.getCloudUrl());
        Boolean bl = plan2.getMigrateArchivedIssues();
        ProjectData projectData = new ProjectData(plan2.getProjectKeys(), this.getProjectIncludedData(plan2.getProjectDataMigrationMode()), bl != null ? bl : false);
        UsersAndGroups usersAndGroups = new UsersAndGroups(this.getUserAndGroupMigrationMode(plan2.getUsersGroupsMigrationOption().getMode()), plan2.getUsersGroupsMigrationOption().getMemberships(), plan2.getUsersGroupsMigrationOption().getIncludeUsersInGroups(), plan2.getUsersGroupsMigrationOption().getIncludeRoleActors());
        JsdCustomersMigrationOption jsdCustomersMigrationOption = plan2.getUsersGroupsMigrationOption().getJsdCustomersMigrationOption();
        JsmSpecifications jsmSpecifications = new JsmSpecifications(new CustomerSelection(this.getJsmCustomerOption(jsdCustomersMigrationOption != null ? jsdCustomersMigrationOption.getMode() : null)));
        if (!plan2.getAppsMigrationOption().getMigrate() || plan2.getAppsMigrationOption().getIncludedApps() == null) {
            list = CollectionsKt.emptyList();
        } else {
            Set<String> set = plan2.getAppsMigrationOption().getIncludedApps();
            Intrinsics.checkNotNull(set);
            list = CollectionsKt.toList((Iterable)set);
        }
        AppsSpecifications appsSpecifications = new AppsSpecifications(list);
        AdvancedRoadmapsMigrationOption advancedRoadmapsMigrationOption = plan2.getAdvancedRoadmapsMigrationOption();
        AdvancedRoadmapSpecifications advancedRoadmapSpecifications = new AdvancedRoadmapSpecifications(this.getArPlanMode(advancedRoadmapsMigrationOption != null ? advancedRoadmapsMigrationOption.getAdvancedRoadmapsMigrationMode() : null));
        DashboardsSpecifications dashboardsSpecifications = new DashboardsSpecifications(this.getDashboardMigrationMode(plan2.getDashboardsMigrationMode()));
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption = plan2.getCrossProjectBoardsAndFiltersMigrationOption();
        CrossProjectBoardsAndFiltersSpecifications crossProjectBoardsAndFiltersSpecifications = new CrossProjectBoardsAndFiltersSpecifications(this.getCrossProjectBoardsAndFiltersMode(crossProjectBoardsAndFiltersMigrationOption != null ? crossProjectBoardsAndFiltersMigrationOption.getBoardsAndFiltersMigrationMode() : null));
        IssueFilters issueFilters = plan2.getIssueFilters();
        IssueFilters issueFilters2 = plan2.getIssueFilters();
        IssueFilterSpecification issueFilterSpecification = new IssueFilterSpecification(issueFilters != null ? issueFilters.getSystemAttributes() : null, issueFilters2 != null ? issueFilters2.getCustomAttributes() : null);
        AttachmentFilters attachmentFilters = plan2.getAttachmentFilters();
        AttachmentFilterSpecification attachmentFilterSpecification = new AttachmentFilterSpecification(attachmentFilters != null ? attachmentFilters.getSystemAttributes() : null);
        return new MigrationDefinition(null, string, serverDetails, cloudDetails, new MigrationScope(projectData, usersAndGroups, jsmSpecifications, advancedRoadmapSpecifications, appsSpecifications, dashboardsSpecifications, crossProjectBoardsAndFiltersSpecifications, issueFilterSpecification, attachmentFilterSpecification), 1, null);
    }

    private final ProjectMigrationType getProjectIncludedData(ProjectDataMigrationMode projectDataMigrationMode) {
        ProjectMigrationType projectMigrationType;
        switch (WhenMappings.$EnumSwitchMapping$0[projectDataMigrationMode.ordinal()]) {
            case 1: {
                projectMigrationType = ProjectMigrationType.APP_DATA_PRELOAD;
                break;
            }
            case 2: {
                projectMigrationType = ProjectMigrationType.ATTACHMENTS;
                break;
            }
            case 3: {
                projectMigrationType = ProjectMigrationType.ATTACHMENTS;
                break;
            }
            case 4: {
                projectMigrationType = ProjectMigrationType.CONFIG;
                break;
            }
            default: {
                projectMigrationType = ProjectMigrationType.ALL;
            }
        }
        return projectMigrationType;
    }

    private final MigrationMode getUserAndGroupMigrationMode(UsersGroupsMigrationOption.MigrationMode mode) {
        MigrationMode migrationMode;
        switch (WhenMappings.$EnumSwitchMapping$1[mode.ordinal()]) {
            case 1: {
                migrationMode = MigrationMode.ALL;
                break;
            }
            case 2: {
                migrationMode = MigrationMode.REFERENCED;
                break;
            }
            case 3: {
                migrationMode = MigrationMode.NONE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return migrationMode;
    }

    private final MigrationMode getJsmCustomerOption(JsdCustomersMigrationOption.JsdCustomersMigrationMode mode) {
        MigrationMode migrationMode;
        JsdCustomersMigrationOption.JsdCustomersMigrationMode jsdCustomersMigrationMode = mode;
        switch (jsdCustomersMigrationMode == null ? -1 : WhenMappings.$EnumSwitchMapping$2[jsdCustomersMigrationMode.ordinal()]) {
            case -1: 
            case 1: {
                migrationMode = MigrationMode.NONE;
                break;
            }
            case 2: {
                migrationMode = MigrationMode.ALL;
                break;
            }
            case 3: {
                migrationMode = MigrationMode.REFERENCED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return migrationMode;
    }

    private final MapiDashboardsMigrationMode getDashboardMigrationMode(DashboardsMigrationMode mode) {
        MapiDashboardsMigrationMode mapiDashboardsMigrationMode;
        DashboardsMigrationMode dashboardsMigrationMode = mode;
        switch (dashboardsMigrationMode == null ? -1 : WhenMappings.$EnumSwitchMapping$3[dashboardsMigrationMode.ordinal()]) {
            case -1: 
            case 1: {
                mapiDashboardsMigrationMode = MapiDashboardsMigrationMode.NONE;
                break;
            }
            case 2: {
                mapiDashboardsMigrationMode = MapiDashboardsMigrationMode.ALL;
                break;
            }
            case 3: {
                mapiDashboardsMigrationMode = MapiDashboardsMigrationMode.SCOPED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mapiDashboardsMigrationMode;
    }

    private final ArPlanMode getArPlanMode(AdvancedRoadmapPlanMigrationMode mode) {
        ArPlanMode arPlanMode;
        AdvancedRoadmapPlanMigrationMode advancedRoadmapPlanMigrationMode = mode;
        switch (advancedRoadmapPlanMigrationMode == null ? -1 : WhenMappings.$EnumSwitchMapping$4[advancedRoadmapPlanMigrationMode.ordinal()]) {
            case -1: 
            case 1: {
                arPlanMode = ArPlanMode.NONE;
                break;
            }
            case 2: {
                arPlanMode = ArPlanMode.ALL;
                break;
            }
            case 3: {
                arPlanMode = ArPlanMode.SCOPED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return arPlanMode;
    }

    private final MapiCrossProjectBoardsAndFiltersMigrationMode getCrossProjectBoardsAndFiltersMode(CrossProjectBoardAndFiltersMigrationMode mode) {
        MapiCrossProjectBoardsAndFiltersMigrationMode mapiCrossProjectBoardsAndFiltersMigrationMode;
        CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode = mode;
        switch (crossProjectBoardAndFiltersMigrationMode == null ? -1 : WhenMappings.$EnumSwitchMapping$5[crossProjectBoardAndFiltersMigrationMode.ordinal()]) {
            case -1: 
            case 1: {
                mapiCrossProjectBoardsAndFiltersMigrationMode = MapiCrossProjectBoardsAndFiltersMigrationMode.NONE;
                break;
            }
            case 2: {
                mapiCrossProjectBoardsAndFiltersMigrationMode = MapiCrossProjectBoardsAndFiltersMigrationMode.ALL;
                break;
            }
            case 3: {
                mapiCrossProjectBoardsAndFiltersMigrationMode = MapiCrossProjectBoardsAndFiltersMigrationMode.SCOPED;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mapiCrossProjectBoardsAndFiltersMigrationMode;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[ProjectDataMigrationMode.values().length];
            try {
                nArray[ProjectDataMigrationMode.APP_DATA_PRELOAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectDataMigrationMode.ATTACHMENTS_ONLY_V2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectDataMigrationMode.ATTACHMENTS_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectDataMigrationMode.CONFIG_ONLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UsersGroupsMigrationOption.MigrationMode.values().length];
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.REFERENCED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsersGroupsMigrationOption.MigrationMode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[JsdCustomersMigrationOption.JsdCustomersMigrationMode.values().length];
            try {
                nArray[JsdCustomersMigrationOption.JsdCustomersMigrationMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsdCustomersMigrationOption.JsdCustomersMigrationMode.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsdCustomersMigrationOption.JsdCustomersMigrationMode.REFERENCED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[DashboardsMigrationMode.values().length];
            try {
                nArray[DashboardsMigrationMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DashboardsMigrationMode.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DashboardsMigrationMode.SELECTED_PROJECTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[AdvancedRoadmapPlanMigrationMode.values().length];
            try {
                nArray[AdvancedRoadmapPlanMigrationMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdvancedRoadmapPlanMigrationMode.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdvancedRoadmapPlanMigrationMode.SELECTED_PROJECTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[CrossProjectBoardAndFiltersMigrationMode.values().length];
            try {
                nArray[CrossProjectBoardAndFiltersMigrationMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossProjectBoardAndFiltersMigrationMode.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossProjectBoardAndFiltersMigrationMode.SELECTED_PROJECTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

