/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.publicapi.model.AttachmentFilterSpecification;
import com.atlassian.jira.migration.publicapi.model.CommandOptions;
import com.atlassian.jira.migration.publicapi.model.IssueFilterSpecification;
import com.atlassian.jira.migration.publicapi.model.MigrationScope;
import com.atlassian.jira.migration.publicapi.validation.FilterSpecValidation;
import com.atlassian.jira.migration.publicapi.validation.PlanMetadataValidation;
import com.atlassian.jira.migration.publicapi.validation.PreflightCheckValidation;
import com.atlassian.jira.migration.publicapi.validation.ProjectValidation;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/PlanValidationService;", "", "projectValidation", "Lcom/atlassian/jira/migration/publicapi/validation/ProjectValidation;", "planMetadataValidation", "Lcom/atlassian/jira/migration/publicapi/validation/PlanMetadataValidation;", "preflightCheckValidation", "Lcom/atlassian/jira/migration/publicapi/validation/PreflightCheckValidation;", "filterSpecValidation", "Lcom/atlassian/jira/migration/publicapi/validation/FilterSpecValidation;", "(Lcom/atlassian/jira/migration/publicapi/validation/ProjectValidation;Lcom/atlassian/jira/migration/publicapi/validation/PlanMetadataValidation;Lcom/atlassian/jira/migration/publicapi/validation/PreflightCheckValidation;Lcom/atlassian/jira/migration/publicapi/validation/FilterSpecValidation;)V", "getCheckTypeSetFromKeysList", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "keysList", "", "", "getPlanName", "planName", "validateAndGetOverrideChecks", "options", "Lcom/atlassian/jira/migration/publicapi/model/CommandOptions;", "validateAndGetProjectData", "scope", "Lcom/atlassian/jira/migration/publicapi/model/MigrationScope;", "validateFilterSpec", "", "issueFilters", "Lcom/atlassian/jira/migration/publicapi/model/IssueFilterSpecification;", "attachmentFilters", "Lcom/atlassian/jira/migration/publicapi/model/AttachmentFilterSpecification;", "validateServerId", "requiredServerId", "jira-migration-plugin"})
public final class PlanValidationService {
    @NotNull
    private final ProjectValidation projectValidation;
    @NotNull
    private final PlanMetadataValidation planMetadataValidation;
    @NotNull
    private final PreflightCheckValidation preflightCheckValidation;
    @NotNull
    private final FilterSpecValidation filterSpecValidation;

    @Inject
    public PlanValidationService(@NotNull ProjectValidation projectValidation, @NotNull PlanMetadataValidation planMetadataValidation, @NotNull PreflightCheckValidation preflightCheckValidation, @NotNull FilterSpecValidation filterSpecValidation) {
        Intrinsics.checkNotNullParameter((Object)projectValidation, (String)"projectValidation");
        Intrinsics.checkNotNullParameter((Object)planMetadataValidation, (String)"planMetadataValidation");
        Intrinsics.checkNotNullParameter((Object)preflightCheckValidation, (String)"preflightCheckValidation");
        Intrinsics.checkNotNullParameter((Object)filterSpecValidation, (String)"filterSpecValidation");
        this.projectValidation = projectValidation;
        this.planMetadataValidation = planMetadataValidation;
        this.preflightCheckValidation = preflightCheckValidation;
        this.filterSpecValidation = filterSpecValidation;
    }

    @NotNull
    public final List<String> validateAndGetProjectData(@NotNull MigrationScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.projectValidation.validateAndGetProjectData(scope);
    }

    public final void validateServerId(@NotNull String requiredServerId) {
        Intrinsics.checkNotNullParameter((Object)requiredServerId, (String)"requiredServerId");
        this.planMetadataValidation.validateServerId(requiredServerId);
    }

    @NotNull
    public final String getPlanName(@NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        return this.planMetadataValidation.getPlanName(planName);
    }

    @NotNull
    public final EnumSet<CheckType> validateAndGetOverrideChecks(@Nullable CommandOptions options) {
        return this.preflightCheckValidation.validateAndGetOverrideChecks(options);
    }

    @NotNull
    public final EnumSet<CheckType> getCheckTypeSetFromKeysList(@Nullable List<String> keysList) {
        return this.preflightCheckValidation.getCheckTypeSetFromKeysList(keysList);
    }

    public final void validateFilterSpec(@NotNull IssueFilterSpecification issueFilters, @NotNull AttachmentFilterSpecification attachmentFilters) {
        Intrinsics.checkNotNullParameter((Object)issueFilters, (String)"issueFilters");
        Intrinsics.checkNotNullParameter((Object)attachmentFilters, (String)"attachmentFilters");
        this.filterSpecValidation.validateFilterSpec(issueFilters, attachmentFilters);
    }
}

