/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.service;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.events.ChecksProgressData;
import com.atlassian.jira.migration.events.PreflightCheckCompletionEvent;
import com.atlassian.jira.migration.events.PreflightCheckGenericEvent;
import com.atlassian.jira.migration.events.PreflightStartedExecutionEvent;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.utils.CheckOverrideUtils;
import com.atlassian.jira.migration.publicapi.client.MigrationClient;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMapping;
import com.atlassian.jira.migration.publicapi.db.PublicPlanMappingRepository;
import com.atlassian.jira.migration.publicapi.model.ArtifactResponse;
import com.atlassian.jira.migration.publicapi.model.MapiCommandPayload;
import com.atlassian.jira.migration.publicapi.model.ProgressData;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.migration.publicapi.model.TaskLevelProgressDetails;
import com.atlassian.jira.migration.publicapi.model.TaskLevelStatus;
import com.atlassian.jira.migration.publicapi.model.TaskLevelStatusDetails;
import com.atlassian.jira.migration.publicapi.model.TaskStatus;
import com.atlassian.jira.migration.publicapi.model.UpdateTaskStatusRequest;
import com.atlassian.jira.migration.publicapi.service.MapiPreflightArtifactService;
import com.atlassian.migration.prc.model.CommandName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 c2\u00020\u0001:\u0001cBG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!2\u0006\u0010$\u001a\u00020\u0017H\u0002J<\u0010%\u001a\b\u0012\u0004\u0012\u00020&0!2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017H\u0002J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170!2\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0018\u00101\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010!2\u0006\u00102\u001a\u00020\"H\u0002J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u0002042\u0006\u00105\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0018\u0010;\u001a\u00020\u00172\u0006\u00105\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010\"2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010=\u001a\u00020>H\u0007J\u0012\u0010?\u001a\u0004\u0018\u00010\u00172\u0006\u0010@\u001a\u00020\u0001H\u0002J*\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010=\u001a\u00020>2\u0006\u00102\u001a\u00020\"H\u0002J(\u0010C\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020E2\u0006\u0010+\u001a\u00020,H\u0002J<\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00172\u0006\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010\u00172\b\u0010M\u001a\u0004\u0018\u0001042\u0006\u0010+\u001a\u00020,H\u0002J<\u0010N\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00172\u0006\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010\u00172\b\u0010M\u001a\u0004\u0018\u0001042\u0006\u0010+\u001a\u00020,H\u0002JD\u0010O\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010=\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00172\b\u00102\u001a\u0004\u0018\u00010\"2\b\u0010M\u001a\u0004\u0018\u0001042\u0006\u0010+\u001a\u00020,H\u0002JH\u0010P\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00172\u0006\u0010J\u001a\u00020K2\u0006\u0010*\u001a\u00020\u00172\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010Q\u001a\u0004\u0018\u0001042\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010R\u001a\u00020\u00172\u0006\u0010=\u001a\u00020>H\u0002J\u0014\u0010S\u001a\u0004\u0018\u0001042\b\u0010T\u001a\u0004\u0018\u00010UH\u0007J\u0018\u0010V\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\u0006\u0010W\u001a\u00020\u0017H\u0002J\u0018\u0010X\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010I\u001a\u00020\u0017H\u0002J\"\u0010Y\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010Z\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010[\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)J\u0016\u0010\\\u001a\u00020\u001a2\u0006\u00105\u001a\u0002082\u0006\u0010(\u001a\u00020)J\u0016\u0010]\u001a\u00020\u001a2\u0006\u00105\u001a\u00020^2\u0006\u0010(\u001a\u00020)J\u0016\u0010_\u001a\u00020\u001a2\u0006\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020)J\u0018\u0010`\u001a\u00020\u001a2\u0006\u0010a\u001a\u00020H2\u0006\u0010b\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService;", "", "planMappingRepository", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;", "migrationClient", "Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "mapiPreflightArtifactService", "Lcom/atlassian/jira/migration/publicapi/service/MapiPreflightArtifactService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMappingRepository;Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/publicapi/service/MapiPreflightArtifactService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "preflightProgressData", "", "", "Lcom/atlassian/jira/migration/events/ChecksProgressData;", "addTaskForExecutionOrThrow", "", "mapiCommandPayload", "Lcom/atlassian/jira/migration/publicapi/model/MapiCommandPayload;", "planId", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "filterStatusesSentToMapi", "", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkExecutionStatuses", "taskId", "getAllExecutions", "Lcom/atlassian/jira/migration/publicapi/model/TaskLevelStatus;", "preflightCheckExecutionId", "publicPlan", "Lcom/atlassian/jira/migration/publicapi/db/PublicPlanMapping;", "taskType", "version", "", "getContainerToken", "cloudId", "getContainerTokenForPlanId", "getLevelForTask", "getOccurrences", "checkResult", "getOutcomeFromStepEvent", "Lcom/atlassian/jira/migration/publicapi/model/TaskStatus$TaskOutcome;", "event", "Lcom/atlassian/jira/migration/events/PreflightCheckGenericEvent;", "getPreflightOutcomeFromEvent", "Lcom/atlassian/jira/migration/events/PreflightCheckCompletionEvent;", "hasWarning", "", "getPreflightResultFromEvent", "getPreflightStepResult", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getStringFromPreflightDetails", "details", "getTaskLevelStatusDetails", "Lcom/atlassian/jira/migration/publicapi/model/TaskLevelStatusDetails;", "getTaskLevelStatusWithProgress", "total", "", "processed", "getUpdateRequestForMigration", "Lcom/atlassian/jira/migration/publicapi/model/UpdateTaskStatusRequest;", "jobId", "taskStatus", "Lcom/atlassian/jira/migration/publicapi/model/TaskStatus;", "message", "checkOutcome", "getUpdateRequestForPreflights", "getUpdateTaskRequestForPreflightStep", "getUpdateTaskStatusRequest", "taskOutcome", "getWarningMessage", "mapToPreflightStepOutcome", "status", "Lcom/atlassian/cmpt/check/dto/Status;", "throwIfIllegalExecution", "newTaskId", "throwIfJobIsAlreadyMigrated", "updateFailedToSchedule", "reason", "updatePlanCompletionStatus", "updatePreflightCompletionStatus", "updatePreflightStartProgress", "Lcom/atlassian/jira/migration/events/PreflightStartedExecutionEvent;", "updatePreflightStepStatus", "updateTaskStatusToMapi", "updateTaskStatusRequest", "containerToken", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTaskStatusReportingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskStatusReportingService.kt\ncom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,508:1\n372#2,7:509\n372#2,7:524\n1549#3:516\n1620#3,3:517\n1549#3:520\n1620#3,3:521\n766#3:532\n857#3,2:533\n1747#3,3:535\n819#3:538\n847#3,2:539\n1549#3:541\n1620#3,3:542\n1549#3:545\n1620#3,3:546\n288#3,2:549\n1#4:531\n*S KotlinDebug\n*F\n+ 1 TaskStatusReportingService.kt\ncom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService\n*L\n100#1:509,7\n125#1:524,7\n109#1:516\n109#1:517,3\n112#1:520\n112#1:521,3\n154#1:532\n154#1:533,2\n158#1:535,3\n191#1:538\n191#1:539,2\n223#1:541\n223#1:542,3\n337#1:545\n337#1:546,3\n465#1:549,2\n*E\n"})
public final class TaskStatusReportingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicPlanMappingRepository planMappingRepository;
    @NotNull
    private final MigrationClient migrationClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final MapiPreflightArtifactService mapiPreflightArtifactService;
    @NotNull
    private Map<String, ChecksProgressData> preflightProgressData;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final String PREFLIGHT_STATUS_UPDATE = "updating Preflight status for public plan = %s with executionSuccess = %s and allChecksPassed = %s";
    @NotNull
    private static final String TASK_NOT_ALLOWED = "Task Not Allowed, migration has already been processed for JobId = %s";
    @NotNull
    private static final String CONFLICTED_TASK = "Task = %s is already Running for JobId = %s";
    @NotNull
    private static final String EXECUTION_ERROR = "Execution failure at JCMA, please check plugin logs.";
    @NotNull
    private static final String ALL_SUCCESS = "All Preflight checks have passed%s.";
    @NotNull
    private static final String WITH_WARNINGS = " with warning";
    @NotNull
    private static final String FAILED = "At least one Preflight check has failed.";
    private static final int OCCURRENCE_LIMIT = 100;
    private static final int MAPI_REQUEST_CHUNK_SIZE = 50;
    @NotNull
    private static final List<String> OCCURRENCE_ATTRIBUTES;
    @NotNull
    public static final String ANON_PERMISSION_WARNING_MESSAGE = "Some items like projects, boards or filters have settings that allow anonymous access. In case you exclude this check, such items will have public access on cloud, This means they will be available to anyone on the internet after you migrate.";
    @NotNull
    public static final String MISSING_ATTACHMENT_WARNING_MESSAGE = "In case you exclude this check, your projects will be migrated without the missing attachments.";
    private static final Logger log;

    @Inject
    public TaskStatusReportingService(@NotNull PublicPlanMappingRepository planMappingRepository, @NotNull MigrationClient migrationClient, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull PlanRepository planRepository, @NotNull PreflightService preflightService, @NotNull MigrationRepository migrationRepository, @NotNull MapiPreflightArtifactService mapiPreflightArtifactService, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)planMappingRepository, (String)"planMappingRepository");
        Intrinsics.checkNotNullParameter((Object)migrationClient, (String)"migrationClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)mapiPreflightArtifactService, (String)"mapiPreflightArtifactService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.planMappingRepository = planMappingRepository;
        this.migrationClient = migrationClient;
        this.cloudSiteRepository = cloudSiteRepository;
        this.planRepository = planRepository;
        this.preflightService = preflightService;
        this.migrationRepository = migrationRepository;
        this.mapiPreflightArtifactService = mapiPreflightArtifactService;
        this.preflightProgressData = new ConcurrentHashMap();
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    public final void addTaskForExecutionOrThrow(@NotNull MapiCommandPayload mapiCommandPayload, @NotNull String planId, @NotNull CommandName commandName) {
        Intrinsics.checkNotNullParameter((Object)mapiCommandPayload, (String)"mapiCommandPayload");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        MapiCommandPayload $this$addTaskForExecutionOrThrow_u24lambda_u240 = mapiCommandPayload;
        boolean bl = false;
        this.throwIfJobIsAlreadyMigrated(planId, $this$addTaskForExecutionOrThrow_u24lambda_u240.getJobId());
        boolean isUpdated = this.planMappingRepository.addNewTask($this$addTaskForExecutionOrThrow_u24lambda_u240.getJobId(), $this$addTaskForExecutionOrThrow_u24lambda_u240.getTaskId(), TaskStatus.IN_PROGRESS, commandName.getValue());
        if (!isUpdated) {
            PublicPlanMapping publicPlanMapping = this.planMappingRepository.get($this$addTaskForExecutionOrThrow_u24lambda_u240.getJobId());
            Intrinsics.checkNotNull((Object)publicPlanMapping);
            this.throwIfIllegalExecution(publicPlanMapping, $this$addTaskForExecutionOrThrow_u24lambda_u240.getTaskId());
            throw new PublicApiException(null, null, 3, null);
        }
        UpdateTaskStatusRequest updateTaskStatusRequest = TaskStatusReportingService.getUpdateTaskStatusRequest$default(this, $this$addTaskForExecutionOrThrow_u24lambda_u240.getJobId(), $this$addTaskForExecutionOrThrow_u24lambda_u240.getTaskId(), TaskStatus.IN_PROGRESS, commandName.getValue(), null, null, -1L, 48, null);
        this.updateTaskStatusToMapi(updateTaskStatusRequest, this.getContainerToken($this$addTaskForExecutionOrThrow_u24lambda_u240.getDestId()));
        log.info("Added taskId = " + $this$addTaskForExecutionOrThrow_u24lambda_u240.getTaskId() + " in planMappingRepository for jobId = " + $this$addTaskForExecutionOrThrow_u24lambda_u240.getJobId() + " to execute");
    }

    public final void updateFailedToSchedule(@NotNull MapiCommandPayload mapiCommandPayload, @Nullable String reason, @NotNull CommandName commandName) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)mapiCommandPayload, (String)"mapiCommandPayload");
            Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
            MapiCommandPayload $this$updateFailedToSchedule_u24lambda_u243 = mapiCommandPayload;
            boolean bl = false;
            Object object2 = $this$updateFailedToSchedule_u24lambda_u243;
            try {
                MapiCommandPayload $this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241 = object2;
                boolean bl2 = false;
                boolean isUpdated = this.planMappingRepository.updateExistingTaskStatus($this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getJobId(), $this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getTaskId(), TaskStatus.FINISHED);
                if (!isUpdated) {
                    log.error("Error while updating the task status to 'FAILED' for jobId = " + $this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getJobId() + ", taskId = " + $this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getTaskId());
                }
                String containerToken = this.getContainerToken($this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getDestId());
                UpdateTaskStatusRequest updateTaskStatusRequest = this.getUpdateTaskStatusRequest($this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getJobId(), $this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getTaskId(), TaskStatus.FINISHED, commandName.getValue(), reason, TaskStatus.TaskOutcome.FAILED, System.currentTimeMillis());
                this.updateTaskStatusToMapi(updateTaskStatusRequest, containerToken);
                object = Result.constructor-impl((Object)this.preflightProgressData.remove($this$updateFailedToSchedule_u24lambda_u243_u24lambda_u241.getTaskId()));
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl3 = false;
            log.error("Error during updating the task status in database", (Throwable)it);
        }
    }

    public static /* synthetic */ void updateFailedToSchedule$default(TaskStatusReportingService taskStatusReportingService, MapiCommandPayload mapiCommandPayload, String string, CommandName commandName, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        taskStatusReportingService.updateFailedToSchedule(mapiCommandPayload, string, commandName);
    }

    /*
     * WARNING - void declaration
     */
    public final void updatePreflightStartProgress(@NotNull PreflightStartedExecutionEvent event, @NotNull PublicPlanMapping publicPlan) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)publicPlan, (String)"publicPlan");
        PublicPlanMapping $this$updatePreflightStartProgress_u24lambda_u247 = publicPlan;
        boolean bl = false;
        int skippedChecks = event.getChecksToSkip().size();
        int totalChecks = event.getChecksToRun().size() + event.getChecksToSkip().size();
        Map<String, ChecksProgressData> map = this.preflightProgressData;
        String key$iv = $this$updatePreflightStartProgress_u24lambda_u247.getTaskId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl2 = false;
            ChecksProgressData answer$iv = new ChecksProgressData(totalChecks, new AtomicInteger(0), null, 4, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ChecksProgressData checksProgressData = (ChecksProgressData)object;
        checksProgressData.setTotalChecks(totalChecks);
        int processedChecks = checksProgressData.getProcessedChecks().addAndGet(skippedChecks);
        List preflightTaskLevelStatus = CollectionsKt.listOf((Object)this.getTaskLevelStatusWithProgress($this$updatePreflightStartProgress_u24lambda_u247.getTaskType(), totalChecks, processedChecks, 0L));
        Iterable $this$map$iv = event.getChecksToRun();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CheckType checkType = (CheckType)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new TaskLevelStatus(CollectionsKt.plus((Collection)this.getLevelForTask($this$updatePreflightStartProgress_u24lambda_u247.getTaskType()), (Iterable)CollectionsKt.listOf((Object)it.name())), TaskStatus.IN_PROGRESS, true, null, null, null, null, 0L, 112, null));
        }
        List inProgressCheckStatuses = (List)destination$iv$iv;
        Iterable $this$map$iv2 = event.getChecksToSkip();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CheckType bl3 = (CheckType)((Object)item$iv$iv);
            collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add(new TaskLevelStatus(CollectionsKt.plus((Collection)this.getLevelForTask($this$updatePreflightStartProgress_u24lambda_u247.getTaskType()), (Iterable)CollectionsKt.listOf((Object)it.name())), TaskStatus.FINISHED, true, TaskStatus.TaskOutcome.SKIPPED, null, null, null, 0L, 112, null));
        }
        List skippedCheckStatuses = (List)destination$iv$iv2;
        UpdateTaskStatusRequest updateTaskStatusRequest = new UpdateTaskStatusRequest($this$updatePreflightStartProgress_u24lambda_u247.getJobId(), $this$updatePreflightStartProgress_u24lambda_u247.getTaskId(), CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)preflightTaskLevelStatus, (Iterable)inProgressCheckStatuses), (Iterable)skippedCheckStatuses));
        this.updateTaskStatusToMapi(updateTaskStatusRequest, this.getContainerTokenForPlanId($this$updatePreflightStartProgress_u24lambda_u247.getPlanId()));
    }

    /*
     * WARNING - void declaration
     */
    public final void updatePreflightStepStatus(@NotNull PreflightCheckGenericEvent event, @NotNull PublicPlanMapping publicPlan) {
        CheckResultDto checkResult;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)publicPlan, (String)"publicPlan");
        PublicPlanMapping $this$updatePreflightStepStatus_u24lambda_u249 = publicPlan;
        boolean bl = false;
        Map<String, ChecksProgressData> map = this.preflightProgressData;
        String key$iv = $this$updatePreflightStepStatus_u24lambda_u249.getTaskId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl2 = false;
            ChecksProgressData answer$iv = new ChecksProgressData(0, new AtomicInteger(0), null, 4, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ChecksProgressData checksProgressData = (ChecksProgressData)object;
        int checksProcessed = checksProgressData.getProcessedChecks().addAndGet(1);
        int totalChecks = checksProgressData.getTotalChecks();
        CheckResultDto checkResultDto = checkResult = this.getPreflightStepResult(event.getPreflightCheckExecutionId(), event.getCheckType());
        TaskStatus.TaskOutcome taskOutcome = this.mapToPreflightStepOutcome((Status)(checkResultDto != null ? checkResultDto.getStatus() : null));
        if (taskOutcome == null) {
            taskOutcome = this.getOutcomeFromStepEvent(event);
        }
        TaskStatus.TaskOutcome stepOutcome = taskOutcome;
        Object[] objectArray = new TaskLevelStatus[]{this.getTaskLevelStatusWithProgress($this$updatePreflightStepStatus_u24lambda_u249.getTaskType(), totalChecks, checksProcessed, checksProcessed), this.getUpdateTaskRequestForPreflightStep(event.getPreflightCheckExecutionId(), $this$updatePreflightStepStatus_u24lambda_u249, event.getCheckType().name(), $this$updatePreflightStepStatus_u24lambda_u249.getTaskType(), checkResult, stepOutcome, checksProcessed)};
        UpdateTaskStatusRequest updateTaskStatusRequest = new UpdateTaskStatusRequest($this$updatePreflightStepStatus_u24lambda_u249.getJobId(), $this$updatePreflightStepStatus_u24lambda_u249.getTaskId(), CollectionsKt.listOf((Object[])objectArray));
        this.updateTaskStatusToMapi(updateTaskStatusRequest, this.getContainerTokenForPlanId($this$updatePreflightStepStatus_u24lambda_u249.getPlanId()));
        checksProgressData.getChecksProcessedSet().add(event.getCheckType().name());
    }

    /*
     * Unable to fully structure code
     */
    public final void updatePreflightCompletionStatus(@NotNull PreflightCheckCompletionEvent event, @NotNull PublicPlanMapping publicPlan) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)publicPlan, (String)"publicPlan");
            var3_3 = "updating Preflight status for public plan = %s with executionSuccess = %s and allChecksPassed = %s";
            var4_4 = new Object[]{publicPlan.toString(), event.getExecutionSuccess(), event.getAllChecksPassed()};
            v0 = String.format(var3_3, Arrays.copyOf(var4_4, var4_4.length));
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"format(...)");
            TaskStatusReportingService.log.info(v0);
            $this$updatePreflightCompletionStatus_u24lambda_u2414 = publicPlan;
            $i$a$-with-TaskStatusReportingService$updatePreflightCompletionStatus$1 = false;
            var5_6 = this.preflightService.getStatus(event.getPreflightCheckExecutionId());
            if (var5_6 == null) ** GOTO lbl-1000
            it = var5_6;
            $i$a$-let-TaskStatusReportingService$updatePreflightCompletionStatus$1$checkExecutionStatuses$1 = false;
            var8_12 = this.preflightService.toCheckResultDto(it).getChecks();
            if (var8_12 != null) {
                $this$filter$iv = var8_12;
                $i$f$filter = false;
                var9_13 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CheckResultDto)element$iv$iv;
                    $i$a$-filter-TaskStatusReportingService$updatePreflightCompletionStatus$1$checkExecutionStatuses$2 = false;
                    v1 = event.getCheckTypes();
                    v2 = it.getCheckType();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCheckType(...)");
                    if (!v1.contains((Object)CheckType.valueOf(v2))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v3 = (List)destination$iv$iv;
            } else lbl-1000:
            // 2 sources

            {
                v3 = CollectionsKt.emptyList();
            }
            checkExecutionStatuses = v3;
            $this$any$iv = checkExecutionStatuses;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v4 = false;
            } else {
                for (E element$iv : $this$any$iv) {
                    it = (CheckResultDto)element$iv;
                    $i$a$-any-TaskStatusReportingService$updatePreflightCompletionStatus$1$hasWarning$1 = false;
                    v5 = it;
                    if (!((v5 != null ? v5.getStatus() : null) == Status.WARNING)) continue;
                    v4 = true;
                    break block7;
                }
                v4 = false;
            }
        }
        hasWarning = v4;
        result = this.getPreflightResultFromEvent(event, hasWarning);
        taskOutcome = this.getPreflightOutcomeFromEvent(event, hasWarning);
        if (Intrinsics.areEqual((Object)$this$updatePreflightCompletionStatus_u24lambda_u2414.getTaskType(), (Object)CommandName.CHECK_PREFLIGHTS.getValue()) || taskOutcome == TaskStatus.TaskOutcome.FAILED) {
            this.planMappingRepository.updateExistingTaskStatus($this$updatePreflightCompletionStatus_u24lambda_u2414.getJobId(), $this$updatePreflightCompletionStatus_u24lambda_u2414.getTaskId(), TaskStatus.FINISHED);
        }
        checkStatusesNotSentToMapi = this.filterStatusesSentToMapi(checkExecutionStatuses, $this$updatePreflightCompletionStatus_u24lambda_u2414.getTaskId());
        this.preflightProgressData.remove($this$updatePreflightCompletionStatus_u24lambda_u2414.getTaskId());
        it = this.getUpdateTaskStatusRequest($this$updatePreflightCompletionStatus_u24lambda_u2414.getJobId(), $this$updatePreflightCompletionStatus_u24lambda_u2414.getTaskId(), TaskStatus.FINISHED, $this$updatePreflightCompletionStatus_u24lambda_u2414.getTaskType(), result, taskOutcome, System.currentTimeMillis());
        $i$a$-let-TaskStatusReportingService$updatePreflightCompletionStatus$1$mapiRequest$1 = false;
        mapiRequest = UpdateTaskStatusRequest.copy$default(it, null, null, CollectionsKt.plus((Collection)it.getRequestBody(), (Iterable)this.getAllExecutions(event.getPreflightCheckExecutionId(), $this$updatePreflightCompletionStatus_u24lambda_u2414, checkStatusesNotSentToMapi, $this$updatePreflightCompletionStatus_u24lambda_u2414.getTaskType(), System.currentTimeMillis())), 3, null);
        this.updateTaskStatusToMapi(mapiRequest, this.getContainerTokenForPlanId($this$updatePreflightCompletionStatus_u24lambda_u2414.getPlanId()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<CheckResultDto> filterStatusesSentToMapi(List<? extends CheckResultDto> checkExecutionStatuses, String taskId2) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = CollectionsKt.filterNotNull((Iterable)checkExecutionStatuses);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            CheckResultDto it = (CheckResultDto)element$iv$iv;
            boolean bl = false;
            Object object = this.preflightProgressData.get(taskId2);
            if (object != null && (object = ((ChecksProgressData)object).getChecksProcessedSet()) != null ? object.contains(it.getCheckType()) : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void updatePlanCompletionStatus(@NotNull PublicPlanMapping publicPlan) {
        Intrinsics.checkNotNullParameter((Object)publicPlan, (String)"publicPlan");
        PublicPlanMapping $this$updatePlanCompletionStatus_u24lambda_u2416 = publicPlan;
        boolean bl = false;
        this.planMappingRepository.updateExistingTaskStatus($this$updatePlanCompletionStatus_u24lambda_u2416.getJobId(), $this$updatePlanCompletionStatus_u24lambda_u2416.getTaskId(), TaskStatus.FINISHED);
        this.preflightProgressData.remove($this$updatePlanCompletionStatus_u24lambda_u2416.getTaskId());
    }

    private final void throwIfJobIsAlreadyMigrated(String planId, String jobId) {
        if (this.migrationRepository.findLatestByPlanId(planId) != null) {
            String string = TASK_NOT_ALLOWED;
            Object[] objectArray = new Object[]{jobId};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new PublicApiException(string2, null, 2, null);
        }
    }

    private final void throwIfIllegalExecution(PublicPlanMapping publicPlan, String newTaskId) {
        if (Intrinsics.areEqual((Object)publicPlan.getTaskId(), (Object)newTaskId)) {
            throw new PublicApiException.DuplicateRequestException(publicPlan.getJobId(), publicPlan.getTaskId());
        }
        if (Intrinsics.areEqual((Object)publicPlan.getTaskStatus(), (Object)"IN_PROGRESS")) {
            String string = CONFLICTED_TASK;
            Object[] objectArray = new Object[]{publicPlan.getTaskId(), publicPlan.getJobId()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new PublicApiException(string2, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TaskLevelStatus> getAllExecutions(String preflightCheckExecutionId, PublicPlanMapping publicPlan, List<? extends CheckResultDto> checkExecutionStatuses, String taskType, long version) {
        Object object;
        Object $this$getAllExecutions_u24lambda_u2419;
        Object object2 = this;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getAllExecutions_u24lambda_u2419 = object2;
            boolean bl = false;
            Iterable iterable = checkExecutionStatuses;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void checkResult;
                CheckResultDto checkResultDto = (CheckResultDto)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object $this$getAllExecutions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417 = $this$getAllExecutions_u24lambda_u2419;
                boolean bl3 = false;
                String string = checkResult.getCheckType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCheckType(...)");
                collection.add(super.getUpdateTaskRequestForPreflightStep(preflightCheckExecutionId, publicPlan, string, taskType, (CheckResultDto)checkResult, ((TaskStatusReportingService)$this$getAllExecutions_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417).mapToPreflightStepOutcome(checkResult.getStatus()), version));
            }
            $this$getAllExecutions_u24lambda_u2419 = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable bl) {
            $this$getAllExecutions_u24lambda_u2419 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getAllExecutions_u24lambda_u2419;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error during operation getAllExecutionFailures", it);
            object = CollectionsKt.emptyList();
        }
        return (List)object;
    }

    private final TaskLevelStatus getUpdateTaskRequestForPreflightStep(String preflightCheckExecutionId, PublicPlanMapping publicPlan, String checkType, String taskType, CheckResultDto checkResult, TaskStatus.TaskOutcome checkOutcome, long version) {
        TaskLevelStatusDetails taskLevelStatusDetails;
        List list = CollectionsKt.plus((Collection)this.getLevelForTask(taskType), (Iterable)CollectionsKt.listOf((Object)checkType));
        TaskStatus taskStatus = TaskStatus.FINISHED;
        CheckResultDto checkResultDto = checkResult;
        String string = checkResultDto != null ? checkResultDto.getDescription() : null;
        CheckResultDto checkResultDto2 = checkResult;
        if (checkResultDto2 != null) {
            CheckResultDto it = checkResultDto2;
            boolean bl = false;
            taskLevelStatusDetails = this.getTaskLevelStatusDetails(preflightCheckExecutionId, publicPlan, CheckType.Companion.fromString(checkType), checkResult);
        } else {
            taskLevelStatusDetails = null;
        }
        TaskLevelStatusDetails taskLevelStatusDetails2 = taskLevelStatusDetails;
        return new TaskLevelStatus(list, taskStatus, true, checkOutcome, string, taskLevelStatusDetails2, null, version, 64, null);
    }

    private final TaskLevelStatusDetails getTaskLevelStatusDetails(String preflightCheckExecutionId, PublicPlanMapping publicPlan, CheckType checkType, CheckResultDto checkResult) {
        List<String> list;
        List<String> list2 = this.getOccurrences(checkResult);
        if (list2 != null) {
            List<String> list3;
            List<String> it = list3 = list2;
            boolean bl = false;
            list = !((Collection)it).isEmpty() ? list3 : null;
        } else {
            list = null;
        }
        List<String> occurrences = list;
        String string = checkResult.getCheckType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCheckType(...)");
        Status status = checkResult.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)status, (String)"getStatus(...)");
        ArtifactResponse artifactResponse = this.mapiPreflightArtifactService.getArtifactDetails(preflightCheckExecutionId, publicPlan, string, status);
        boolean bl = false;
        ArtifactResponse artifactResponse2 = artifactResponse;
        List artifactDetails = artifactResponse2 != null ? CollectionsKt.listOf((Object)artifactResponse2) : null;
        Status status2 = checkResult.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)status2, (String)"getStatus(...)");
        if (CheckOverrideUtils.INSTANCE.isCheckOverridable(status2, checkType)) {
            return new TaskLevelStatusDetails(occurrences, true, this.getWarningMessage(checkType), null, artifactDetails, 8, null);
        }
        if (CheckType.Companion.isAppVendorCheckType(checkType.name())) {
            CheckDetailsDto checkDetailsDto = checkResult.getDetails();
            return new TaskLevelStatusDetails(occurrences, null, null, checkDetailsDto != null ? checkDetailsDto.getInfo() : null, artifactDetails);
        }
        return occurrences == null && artifactDetails == null ? null : new TaskLevelStatusDetails(occurrences, null, null, null, artifactDetails, 14, null);
    }

    private final String getWarningMessage(CheckType checkType) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[checkType.ordinal()]) {
            case 1: {
                string = ANON_PERMISSION_WARNING_MESSAGE;
                break;
            }
            case 2: {
                string = MISSING_ATTACHMENT_WARNING_MESSAGE;
                break;
            }
            default: {
                string = "The given checkType doesn't exist";
            }
        }
        return string;
    }

    private final List<String> getLevelForTask(String taskType) {
        return Intrinsics.areEqual((Object)taskType, (Object)CommandName.MIGRATE.getValue()) ? CollectionsKt.listOf((Object)CommandName.CHECK_PREFLIGHTS.getValue()) : CollectionsKt.emptyList();
    }

    @VisibleForTesting
    @Nullable
    public final CheckResultDto getPreflightStepResult(@NotNull String preflightCheckExecutionId, @NotNull CheckType checkType) {
        CheckResultDto checkResultDto;
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)((Object)checkType), (String)"checkType");
        CheckExecutionStatus checkExecutionStatus = this.preflightService.getStatus(preflightCheckExecutionId, checkType);
        if (checkExecutionStatus != null) {
            List list;
            CheckExecutionStatus it = checkExecutionStatus;
            boolean bl = false;
            List list2 = list = this.preflightService.toCheckResultDto(it).getChecks();
            if (list2 != null) {
                Intrinsics.checkNotNull((Object)list2);
                checkResultDto = (CheckResultDto)CollectionsKt.firstOrNull((List)list);
            } else {
                checkResultDto = null;
            }
        } else {
            checkResultDto = null;
        }
        return checkResultDto;
    }

    @VisibleForTesting
    @Nullable
    public final TaskStatus.TaskOutcome mapToPreflightStepOutcome(@Nullable Status status) {
        TaskStatus.TaskOutcome taskOutcome;
        Status status2 = status;
        switch (status2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[status2.ordinal()]) {
            case 1: {
                taskOutcome = TaskStatus.TaskOutcome.WARNING;
                break;
            }
            case 2: {
                taskOutcome = TaskStatus.TaskOutcome.FAILED;
                break;
            }
            case 3: {
                taskOutcome = TaskStatus.TaskOutcome.FAILED;
                break;
            }
            case 4: {
                taskOutcome = TaskStatus.TaskOutcome.SUCCESS;
                break;
            }
            default: {
                taskOutcome = null;
            }
        }
        return taskOutcome;
    }

    private final TaskStatus.TaskOutcome getOutcomeFromStepEvent(PreflightCheckGenericEvent event) {
        return event.getSuccess() ? TaskStatus.TaskOutcome.SUCCESS : (event.getBlocksMigration() ? TaskStatus.TaskOutcome.FAILED : TaskStatus.TaskOutcome.WARNING);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateTaskStatusToMapi(UpdateTaskStatusRequest updateTaskStatusRequest, String containerToken) {
        Object $this$updateTaskStatusToMapi_u24lambda_u2426;
        Object object = this;
        try {
            void $this$mapTo$iv$iv;
            $this$updateTaskStatusToMapi_u24lambda_u2426 = object;
            boolean bl = false;
            List<TaskLevelStatus> updates = updateTaskStatusRequest.getRequestBody();
            Iterable $this$map$iv = CollectionsKt.chunked((Iterable)updates, (int)50);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                UpdateTaskStatusRequest chunkedRequest = UpdateTaskStatusRequest.copy$default(updateTaskStatusRequest, null, null, (List)it, 3, null);
                log.info("updating status to MAPI = " + chunkedRequest);
                ((TaskStatusReportingService)$this$updateTaskStatusToMapi_u24lambda_u2426).migrationClient.updateJobTaskStatus(chunkedRequest, containerToken);
                collection.add(Unit.INSTANCE);
            }
            $this$updateTaskStatusToMapi_u24lambda_u2426 = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable bl) {
            $this$updateTaskStatusToMapi_u24lambda_u2426 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$updateTaskStatusToMapi_u24lambda_u2426;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error while updating task status to MAPI", it);
        }
    }

    private final TaskLevelStatus getTaskLevelStatusWithProgress(String taskType, int total, int processed, long version) {
        Double progressPercent = total != 0 ? Double.valueOf((double)processed / (double)total * 100.0) : null;
        List<String> list = this.getLevelForTask(taskType);
        TaskStatus taskStatus = TaskStatus.IN_PROGRESS;
        TaskLevelProgressDetails taskLevelProgressDetails = new TaskLevelProgressDetails(true, progressPercent, CollectionsKt.listOf((Object)new ProgressData("Preflight Checks", total, processed)));
        return new TaskLevelStatus(list, taskStatus, false, null, null, null, taskLevelProgressDetails, version, 48, null);
    }

    private final UpdateTaskStatusRequest getUpdateTaskStatusRequest(String jobId, String taskId2, TaskStatus taskStatus, String taskType, String message, TaskStatus.TaskOutcome taskOutcome, long version) {
        if (Intrinsics.areEqual((Object)taskType, (Object)CommandName.MIGRATE.getValue())) {
            return this.getUpdateRequestForMigration(jobId, taskId2, taskStatus, message, taskOutcome, version);
        }
        return this.getUpdateRequestForPreflights(jobId, taskId2, taskStatus, message, taskOutcome, version);
    }

    static /* synthetic */ UpdateTaskStatusRequest getUpdateTaskStatusRequest$default(TaskStatusReportingService taskStatusReportingService, String string, String string2, TaskStatus taskStatus, String string3, String string4, TaskStatus.TaskOutcome taskOutcome, long l, int n, Object object) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            taskOutcome = null;
        }
        return taskStatusReportingService.getUpdateTaskStatusRequest(string, string2, taskStatus, string3, string4, taskOutcome, l);
    }

    private final UpdateTaskStatusRequest getUpdateRequestForMigration(String jobId, String taskId2, TaskStatus taskStatus, String message, TaskStatus.TaskOutcome checkOutcome, long version) {
        TaskStatus.TaskOutcome taskOutcome;
        TaskStatus migrationOverallStatus = checkOutcome == TaskStatus.TaskOutcome.FAILED ? taskStatus : TaskStatus.IN_PROGRESS;
        TaskStatus.TaskOutcome taskOutcome2 = checkOutcome;
        if (taskOutcome2 != null) {
            TaskStatus.TaskOutcome taskOutcome3;
            TaskStatus.TaskOutcome it = taskOutcome3 = taskOutcome2;
            boolean bl = false;
            taskOutcome = it == TaskStatus.TaskOutcome.FAILED ? taskOutcome3 : null;
        } else {
            taskOutcome = null;
        }
        TaskStatus.TaskOutcome migrationOverallOutcome = taskOutcome;
        TaskLevelProgressDetails progressDetails = taskStatus == TaskStatus.IN_PROGRESS ? new TaskLevelProgressDetails(true, null, null, 6, null) : null;
        Object[] objectArray = new TaskLevelStatus[2];
        objectArray[0] = new TaskLevelStatus(CollectionsKt.emptyList(), migrationOverallStatus, true, migrationOverallOutcome, message, null, null, version, 96, null);
        List list = CollectionsKt.listOf((Object)CommandName.CHECK_PREFLIGHTS.getValue());
        objectArray[1] = new TaskLevelStatus(list, taskStatus, true, checkOutcome, message, null, progressDetails, version, 32, null);
        return new UpdateTaskStatusRequest(jobId, taskId2, CollectionsKt.listOf((Object[])objectArray));
    }

    private final UpdateTaskStatusRequest getUpdateRequestForPreflights(String jobId, String taskId2, TaskStatus taskStatus, String message, TaskStatus.TaskOutcome checkOutcome, long version) {
        TaskLevelProgressDetails progressDetails = taskStatus == TaskStatus.IN_PROGRESS ? new TaskLevelProgressDetails(true, null, null, 6, null) : null;
        List list = CollectionsKt.emptyList();
        return new UpdateTaskStatusRequest(jobId, taskId2, CollectionsKt.listOf((Object)new TaskLevelStatus(list, taskStatus, true, checkOutcome, message, null, progressDetails, version, 32, null)));
    }

    private final List<String> getOccurrences(CheckResultDto checkResult) {
        CheckDetailsDto checkDetailsDto = checkResult.getDetails();
        if ((checkDetailsDto != null ? checkDetailsDto.getListOfOccurrences() : null) == null) {
            return null;
        }
        List list = checkResult.getDetails().getListOfOccurrences();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getListOfOccurrences(...)");
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)list)), (Function1)((Function1)new Function1<Object, String>(this){
            final /* synthetic */ TaskStatusReportingService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TaskStatusReportingService.access$getStringFromPreflightDetails(this.this$0, it);
            }
        })), (int)100));
    }

    private final String getStringFromPreflightDetails(Object details2) {
        Object object;
        block7: {
            Object object2;
            if (details2 instanceof String) {
                return (String)details2;
            }
            object = this;
            try {
                String string;
                Object v0;
                JsonNode jsonValue;
                block6: {
                    TaskStatusReportingService $this$getStringFromPreflightDetails_u24lambda_u2431 = object;
                    boolean bl = false;
                    jsonValue = $this$getStringFromPreflightDetails_u24lambda_u2431.objectMapper.valueToTree(details2);
                    Iterable $this$firstOrNull$iv = OCCURRENCE_ATTRIBUTES;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String occurrence = (String)element$iv;
                        boolean bl2 = false;
                        if (!jsonValue.has(occurrence)) continue;
                        v0 = element$iv;
                        break block6;
                    }
                    v0 = null;
                }
                String string2 = v0;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    string = jsonValue.get(it).asText();
                } else {
                    string = null;
                }
                object2 = Result.constructor-impl(string);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block7;
            Object it = object2 = throwable;
            boolean bl = false;
            log.error("Error while calculating occurrence for details = " + details2, (Throwable)it);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final String getContainerTokenForPlanId(String planId) {
        Plan plan2 = this.planRepository.get(planId);
        Intrinsics.checkNotNull((Object)plan2);
        return this.getContainerToken(plan2.getCloudId());
    }

    private final String getContainerToken(String cloudId2) {
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        Intrinsics.checkNotNull((Object)cloudSite2);
        return cloudSite2.getContainerToken();
    }

    private final String getPreflightResultFromEvent(PreflightCheckCompletionEvent event, boolean hasWarning) {
        String string;
        if (event.getExecutionSuccess() && event.getAllChecksPassed()) {
            String string2 = ALL_SUCCESS;
            Object[] objectArray = new Object[]{hasWarning ? WITH_WARNINGS : ""};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string = event.getExecutionSuccess() ? FAILED : EXECUTION_ERROR;
        }
        return string;
    }

    private final TaskStatus.TaskOutcome getPreflightOutcomeFromEvent(PreflightCheckCompletionEvent event, boolean hasWarning) {
        return event.getExecutionSuccess() && event.getAllChecksPassed() && hasWarning ? TaskStatus.TaskOutcome.WARNING : (event.getExecutionSuccess() && event.getAllChecksPassed() ? TaskStatus.TaskOutcome.SUCCESS : TaskStatus.TaskOutcome.FAILED);
    }

    public static final /* synthetic */ String access$getStringFromPreflightDetails(TaskStatusReportingService $this, Object details2) {
        return $this.getStringFromPreflightDetails(details2);
    }

    static {
        Object[] objectArray = new String[]{"key", "name", "projectKey", "serverKey"};
        OCCURRENCE_ATTRIBUTES = CollectionsKt.listOf((Object[])objectArray);
        log = LoggerFactory.getLogger(TaskStatusReportingService.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/publicapi/service/TaskStatusReportingService$Companion;", "", "()V", "ALL_SUCCESS", "", "ANON_PERMISSION_WARNING_MESSAGE", "CONFLICTED_TASK", "EXECUTION_ERROR", "FAILED", "MAPI_REQUEST_CHUNK_SIZE", "", "MISSING_ATTACHMENT_WARNING_MESSAGE", "OCCURRENCE_ATTRIBUTES", "", "OCCURRENCE_LIMIT", "PREFLIGHT_STATUS_UPDATE", "TASK_NOT_ALLOWED", "WITH_WARNINGS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CheckType.values().length];
            try {
                nArray[CheckType.AnonPermission.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CheckType.MissingAttachments.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Status.values().length];
            try {
                nArray[Status.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

