/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.util;

import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/publicapi/util/RetryManager;", "", "()V", "DEFAULT_RETRIES", "", "DEFAULT_RETRY_CODES", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "withRetry", "T", "action", "Lkotlin/Function0;", "retryableCodes", "maxRetry", "(Lkotlin/jvm/functions/Function0;Ljava/util/List;I)Ljava/lang/Object;", "jira-migration-plugin"})
public final class RetryManager {
    @NotNull
    public static final RetryManager INSTANCE = new RetryManager();
    private static final Logger log = LoggerFactory.getLogger(RetryManager.class);
    private static final int DEFAULT_RETRIES = 5;
    @NotNull
    private static final List<Integer> DEFAULT_RETRY_CODES;

    private RetryManager() {
    }

    public final <T> T withRetry(@NotNull Function0<? extends T> action, @NotNull List<Integer> retryableCodes, int maxRetry) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(retryableCodes, (String)"retryableCodes");
        int i = 1;
        if (i <= maxRetry) {
            while (true) {
                try {
                    return (T)action.invoke();
                }
                catch (UnexpectedStatusCodeException ex) {
                    log.error("Error executing the action with retry.", (Throwable)ex);
                    if (!retryableCodes.contains(ex.getStatusCode())) {
                        throw ex;
                    }
                    log.info("Retrying the action , retry time = " + i);
                    if (i == maxRetry) break;
                    ++i;
                    continue;
                }
                break;
            }
        }
        return (T)action.invoke();
    }

    public static /* synthetic */ Object withRetry$default(RetryManager retryManager, Function0 function0, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list = DEFAULT_RETRY_CODES;
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        return retryManager.withRetry(function0, list, n);
    }

    static {
        Object[] objectArray = new Integer[]{500, 502, 503, 504};
        DEFAULT_RETRY_CODES = CollectionsKt.listOf((Object[])objectArray);
    }
}

