/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.validation;

import com.atlassian.jira.migration.datafilters.model.CustomAttributeFilter;
import com.atlassian.jira.migration.datafilters.model.DataFilter;
import com.atlassian.jira.migration.datafilters.model.OperatorType;
import com.atlassian.jira.migration.datafilters.model.SystemAttributeFilter;
import com.atlassian.jira.migration.datafilters.model.SystemAttributeType;
import com.atlassian.jira.migration.publicapi.model.AttachmentFilterSpecification;
import com.atlassian.jira.migration.publicapi.model.IssueFilterSpecification;
import com.atlassian.jira.migration.validation.PlanValidationException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J$\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J$\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J&\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J4\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/FilterSpecValidation;", "", "()V", "formatExceptions", "", "exceptions", "", "validateAttachmentFilters", "", "attachmentFilters", "Lcom/atlassian/jira/migration/publicapi/model/AttachmentFilterSpecification;", "", "validateAttachmentSize", "attachmentSizes", "validateCustomAttribute", "operator", "validateDateRange", "dates", "validateFilterSpec", "issueFilters", "Lcom/atlassian/jira/migration/publicapi/model/IssueFilterSpecification;", "validateIssueFilters", "validateOperatorType", "type", "Lcom/atlassian/jira/migration/datafilters/model/OperatorType;", "validateSystemAttribute", "Lcom/atlassian/jira/migration/datafilters/model/SystemAttributeType;", "value", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nFilterSpecValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterSpecValidation.kt\ncom/atlassian/jira/migration/publicapi/validation/FilterSpecValidation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1855#2,2:131\n1855#2,2:133\n1855#2,2:135\n1549#2:137\n1620#2,3:138\n*S KotlinDebug\n*F\n+ 1 FilterSpecValidation.kt\ncom/atlassian/jira/migration/publicapi/validation/FilterSpecValidation\n*L\n31#1:131,2\n34#1:133,2\n43#1:135,2\n113#1:137\n113#1:138,3\n*E\n"})
public final class FilterSpecValidation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DATE_RANGE_ERROR = "Date range must consist of exactly two dates: a start date and an end date.";
    @NotNull
    private static final String DATE_ORDER_ERROR = "Start date '%s' must be less than or equal to end date '%s'.";
    @NotNull
    private static final String DATE_FORMAT_ERROR = "One or both date values are invalid. Ensure they follow the 'YYYY-MM-DD' format and contain valid year, month, and day values.";
    @NotNull
    private static final String ATTACHMENT_SIZE_ERROR = "Attachment size exceeds the maximum allowed size of 2500 MB. Provided size: %s MB.";
    @NotNull
    private static final String INVALID_SIZE_FORMAT_ERROR = "Invalid size format: '%s'. Size must be a numeric value.";
    @NotNull
    private static final String SIZE_LIST_INVALID_ERROR = "Attachment size list must contain exactly one size value.";
    private static final double MAX_MB_SIZE_FOR_ATTACHMENT_FILE = 2500.0;
    private static final int SINGLE_ATTACHMENT_SIZE = 1;

    public final void validateFilterSpec(@NotNull IssueFilterSpecification issueFilters, @NotNull AttachmentFilterSpecification attachmentFilters) {
        Intrinsics.checkNotNullParameter((Object)issueFilters, (String)"issueFilters");
        Intrinsics.checkNotNullParameter((Object)attachmentFilters, (String)"attachmentFilters");
        List exceptions = new ArrayList();
        this.validateIssueFilters(issueFilters, exceptions);
        this.validateAttachmentFilters(attachmentFilters, exceptions);
        if (!((Collection)exceptions).isEmpty()) {
            throw new PlanValidationException(this.formatExceptions(exceptions));
        }
    }

    private final void validateIssueFilters(IssueFilterSpecification issueFilters, List<String> exceptions) {
        block3: {
            DataFilter it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            List<SystemAttributeFilter> list = issueFilters.getSystemAttributes();
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (SystemAttributeFilter)element$iv;
                    boolean bl = false;
                    this.validateSystemAttribute(((SystemAttributeFilter)it).getOperator(), ((SystemAttributeFilter)it).getType(), ((SystemAttributeFilter)it).getValue(), exceptions);
                }
            }
            List<CustomAttributeFilter> list2 = issueFilters.getCustomAttributes();
            if (list2 == null) break block3;
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CustomAttributeFilter)element$iv;
                boolean bl = false;
                this.validateCustomAttribute(((CustomAttributeFilter)it).getOperator(), exceptions);
            }
        }
    }

    private final void validateAttachmentFilters(AttachmentFilterSpecification attachmentFilters, List<String> exceptions) {
        block1: {
            List<SystemAttributeFilter> list = attachmentFilters.getSystemAttributes();
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SystemAttributeFilter it = (SystemAttributeFilter)element$iv;
                boolean bl = false;
                this.validateSystemAttribute(it.getOperator(), it.getType(), it.getValue(), exceptions);
            }
        }
    }

    private final void validateSystemAttribute(String operator, SystemAttributeType type, List<String> value, List<String> exceptions) {
        this.validateOperatorType(operator, type.getOperatorType(), exceptions);
        if (type == SystemAttributeType.ISSUECREATEDDATE || type == SystemAttributeType.ATTACHMENTCREATEDDATE) {
            this.validateDateRange(value, exceptions);
        }
        if (type == SystemAttributeType.ATTACHMENTSIZE) {
            this.validateAttachmentSize(value, exceptions);
        }
    }

    private final void validateAttachmentSize(List<String> attachmentSizes, List<String> exceptions) {
        if (attachmentSizes.isEmpty() || attachmentSizes.size() > 1) {
            exceptions.add(SIZE_LIST_INVALID_ERROR);
            return;
        }
        try {
            double sizeInMB = Double.parseDouble(attachmentSizes.get(0));
            if (sizeInMB > 2500.0) {
                String string = ATTACHMENT_SIZE_ERROR;
                Object[] objectArray = new Object[]{attachmentSizes.get(0)};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                exceptions.add(string2);
            }
        }
        catch (NumberFormatException e) {
            String string = INVALID_SIZE_FORMAT_ERROR;
            Object[] objectArray = new Object[]{attachmentSizes.get(0)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            exceptions.add(string3);
        }
    }

    private final void validateCustomAttribute(String operator, List<String> exceptions) {
        this.validateOperatorType(operator, OperatorType.CUSTOM_FIELDS, exceptions);
    }

    private final void validateDateRange(List<String> dates, List<String> exceptions) {
        if (dates.size() != 2) {
            exceptions.add(DATE_RANGE_ERROR);
            return;
        }
        try {
            LocalDate startDate = LocalDate.parse(dates.get(0));
            LocalDate endDate = LocalDate.parse(dates.get(1));
            if (startDate.isAfter(endDate)) {
                String string = DATE_ORDER_ERROR;
                Object[] objectArray = new Object[]{startDate, endDate};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                exceptions.add(string2);
            }
        }
        catch (DateTimeParseException e) {
            exceptions.add(DATE_FORMAT_ERROR);
        }
    }

    private final void validateOperatorType(String operator, OperatorType type, List<String> exceptions) {
        String result2 = type.validate(operator, type.name());
        if (((CharSequence)result2).length() > 0) {
            exceptions.add(result2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String formatExceptions(List<String> exceptions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = exceptions;
        StringBuilder stringBuilder = new StringBuilder().append("Issues while Attaching Migration: ");
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add('`' + (String)it + '`');
        }
        return stringBuilder.append((List)destination$iv$iv).toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/FilterSpecValidation$Companion;", "", "()V", "ATTACHMENT_SIZE_ERROR", "", "DATE_FORMAT_ERROR", "DATE_ORDER_ERROR", "DATE_RANGE_ERROR", "INVALID_SIZE_FORMAT_ERROR", "MAX_MB_SIZE_FOR_ATTACHMENT_FILE", "", "SINGLE_ATTACHMENT_SIZE", "", "SIZE_LIST_INVALID_ERROR", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

