/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.validation;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.validation.PlanValidationException;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/PlanMetadataValidation;", "", "applicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "(Lcom/atlassian/jira/config/properties/ApplicationProperties;Lcom/atlassian/jira/migration/plan/PlanRepository;)V", "getCurrentServerId", "", "getPlanName", "planName", "isPlanNameDuplicate", "", "isServerIdValid", "currentServerId", "requiredServerId", "throwInvalidServerIdException", "", "validateServerId", "Companion", "jira-migration-plugin"})
public final class PlanMetadataValidation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private static final String SERVER_ID = "com.atlassian.analytics.client.configuration.serverid";
    @NotNull
    private static final String INVALID_SOURCE_MESSAGE = "Your SERVER_ID:%s does not match with expected server id provided in job definition.";
    @NotNull
    private static final String INVALID_PLAN_NAME = "Field {name} already exists. Please choose a unique name (or leave blank to autogenerate).";

    @Inject
    public PlanMetadataValidation(@NotNull ApplicationProperties applicationProperties, @NotNull PlanRepository planRepository) {
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        this.applicationProperties = applicationProperties;
        this.planRepository = planRepository;
    }

    public final void validateServerId(@NotNull String requiredServerId) {
        Intrinsics.checkNotNullParameter((Object)requiredServerId, (String)"requiredServerId");
        String currentServerId = this.getCurrentServerId();
        if (!this.isServerIdValid(currentServerId, requiredServerId)) {
            this.throwInvalidServerIdException(currentServerId);
        }
    }

    private final String getCurrentServerId() {
        String string = this.applicationProperties.getText(SERVER_ID);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final boolean isServerIdValid(String currentServerId, String requiredServerId) {
        return currentServerId.equals(requiredServerId);
    }

    private final void throwInvalidServerIdException(String currentServerId) {
        String string = INVALID_SOURCE_MESSAGE;
        Object[] objectArray = new Object[]{currentServerId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        throw new PlanValidationException(string2);
    }

    @NotNull
    public final String getPlanName(@NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        String trimmedName = ((Object)StringsKt.trim((CharSequence)planName)).toString();
        if (this.isPlanNameDuplicate(trimmedName)) {
            throw new PlanValidationException(INVALID_PLAN_NAME);
        }
        return trimmedName;
    }

    private final boolean isPlanNameDuplicate(String planName) {
        return this.planRepository.getByName(planName) != null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/PlanMetadataValidation$Companion;", "", "()V", "INVALID_PLAN_NAME", "", "INVALID_SOURCE_MESSAGE", "SERVER_ID", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

