/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.validation;

import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.utils.CheckOverrideUtils;
import com.atlassian.jira.migration.publicapi.model.CheckTypes;
import com.atlassian.jira.migration.publicapi.model.CommandOptions;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002J.\u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/PreflightCheckValidation;", "", "()V", "createEnumSetFromValidKeys", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "present", "", "", "getCheckTypeSetFromKeysList", "keysList", "getEnumCheckTypeValuesSet", "", "partitionKeys", "Lkotlin/Pair;", "throwInvalidKeysException", "", "notPresent", "validateAndGetOverrideChecks", "options", "Lcom/atlassian/jira/migration/publicapi/model/CommandOptions;", "validateOverrideChecks", "overrideChecks", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreflightCheckValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreflightCheckValidation.kt\ncom/atlassian/jira/migration/publicapi/validation/PreflightCheckValidation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,57:1\n3190#2,10:58\n1549#2:72\n1620#2,3:73\n11065#3:68\n11400#3,3:69\n*S KotlinDebug\n*F\n+ 1 PreflightCheckValidation.kt\ncom/atlassian/jira/migration/publicapi/validation/PreflightCheckValidation\n*L\n38#1:58,10\n47#1:72\n47#1:73,3\n41#1:68\n41#1:69,3\n*E\n"})
public final class PreflightCheckValidation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PREFLIGHT_CHECK_KEYS_NOT_FOUND = "Invalid checkTypes %s.";

    @NotNull
    public final EnumSet<CheckType> validateAndGetOverrideChecks(@Nullable CommandOptions options) {
        Object object = options;
        List<String> excludedChecks = object != null && (object = ((CommandOptions)object).getCheckTypes()) != null ? ((CheckTypes)object).getExcludedKeys() : null;
        EnumSet<CheckType> overrideChecks = this.getCheckTypeSetFromKeysList(excludedChecks);
        this.validateOverrideChecks(overrideChecks);
        return overrideChecks;
    }

    @NotNull
    public final EnumSet<CheckType> getCheckTypeSetFromKeysList(@Nullable List<String> keysList) {
        Pair<List<String>, List<String>> pair = (Pair<List<String>, List<String>>)keysList;
        if (pair == null || pair.isEmpty()) {
            return CheckType.Companion.getEmptyCheckTypeSet();
        }
        pair = this.partitionKeys(keysList);
        List present = (List)pair.component1();
        List notPresent = (List)pair.component2();
        if (!((Collection)notPresent).isEmpty()) {
            this.throwInvalidKeysException(notPresent);
        }
        return this.createEnumSetFromValidKeys(present);
    }

    private final Pair<List<String>, List<String>> partitionKeys(List<String> keysList) {
        Set<String> enumCheckTypeValuesSet = this.getEnumCheckTypeValuesSet();
        Iterable $this$partition$iv = keysList;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (enumCheckTypeValuesSet.contains(string)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        return new Pair(first$iv, second$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getEnumCheckTypeValuesSet() {
        void $this$mapTo$iv$iv;
        CheckType[] $this$map$iv = CheckType.values();
        boolean $i$f$map = false;
        CheckType[] checkTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final void throwInvalidKeysException(List<String> notPresent) {
        String string = PREFLIGHT_CHECK_KEYS_NOT_FOUND;
        Object[] objectArray = new Object[]{notPresent};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        throw new PublicApiException(string2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final EnumSet<CheckType> createEnumSetFromValidKeys(List<String> present) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = present;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CheckType.Companion.fromString((String)it));
        }
        EnumSet<CheckType> enumSet = EnumSet.copyOf((Collection)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(...)");
        return enumSet;
    }

    private final void validateOverrideChecks(EnumSet<CheckType> overrideChecks) {
        CheckOverrideUtils.INSTANCE.validateOverrideChecks(overrideChecks);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/PreflightCheckValidation$Companion;", "", "()V", "PREFLIGHT_CHECK_KEYS_NOT_FOUND", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

