/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.publicapi.validation;

import com.atlassian.jira.migration.export.core.workflow.SwfExportFacadeKt;
import com.atlassian.jira.migration.publicapi.model.ArPlanMode;
import com.atlassian.jira.migration.publicapi.model.MigrationMode;
import com.atlassian.jira.migration.publicapi.model.MigrationScope;
import com.atlassian.jira.migration.publicapi.model.ProjectMigrationType;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.migration.serverdataextractors.ServerProject;
import com.atlassian.jira.migration.validation.PlanValidation;
import com.atlassian.jira.migration.validation.PlanValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0002J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u001b\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0002J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u001f\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002J,\u0010\"\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/ProjectValidation;", "", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "planValidation", "Lcom/atlassian/jira/migration/validation/PlanValidation;", "(Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/jira/migration/validation/PlanValidation;)V", "checkArMode", "", "scope", "Lcom/atlassian/jira/migration/publicapi/model/MigrationScope;", "attachmentOnlyError", "", "", "checkJsmCustomersMode", "checkUsersAndGroupsMode", "formatExceptions", "exceptions", "", "getInvalidProjectKeys", "", "uniqueProjectKeys", "serverProjectData", "Lcom/atlassian/jira/migration/serverdataextractors/ServerProject;", "getServerProjectData", "getServiceDeskProjectKeys", "getUniqueProjectKeys", "validateAllDataMigration", "serviceDeskProjectKeys", "validateAndGetProjectData", "validateAttachmentOnlyMigration", "validateJsmMigrationMode", "validateProjectKeys", "invalidProjectKeys", "validateUserMigrationMode", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectValidation.kt\ncom/atlassian/jira/migration/publicapi/validation/ProjectValidation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1549#2:120\n1620#2,3:121\n1549#2:124\n1620#2,3:125\n1603#2,9:128\n1855#2:137\n1856#2:139\n1612#2:140\n1549#2:141\n1620#2,3:142\n766#2:145\n857#2,2:146\n1549#2:148\n1620#2,3:149\n1549#2:152\n1620#2,3:153\n1#3:138\n*S KotlinDebug\n*F\n+ 1 ProjectValidation.kt\ncom/atlassian/jira/migration/publicapi/validation/ProjectValidation\n*L\n32#1:120\n32#1:121,3\n93#1:124\n93#1:125,3\n96#1:128,9\n96#1:137\n96#1:139\n96#1:140\n99#1:141\n99#1:142,3\n102#1:145\n102#1:146,2\n102#1:148\n102#1:149,3\n111#1:152\n111#1:153,3\n96#1:138\n*E\n"})
public final class ProjectValidation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final PlanValidation planValidation;
    @NotNull
    private static final String JIRA_SERVICE_DESK_KEY = "serviceDesk";
    @NotNull
    private static final String INVALID_PROJECT_KEYS = "Migration includes invalid project keys %s";
    @NotNull
    private static final String INVALID_JSM_MIGRATION_MODE = "Migration includes JSM project keys %s. Field {scope.jsm.customers.mode} cannot be NONE.";
    @NotNull
    private static final String INVALID_USER_MIGRATION_MODE = "Field {scope.usersAndGroups.mode} cannot be NONE.";
    @NotNull
    private static final String ATTACHMENT_ONLY_ERROR = "Field(s) %s will be considered as NONE for attachment only Migration.";

    @Inject
    public ProjectValidation(@NotNull ProjectsReader projectsReader, @NotNull PlanValidation planValidation) {
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)planValidation, (String)"planValidation");
        this.projectsReader = projectsReader;
        this.planValidation = planValidation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> validateAndGetProjectData(@NotNull MigrationScope scope) {
        Collection destination$iv$iv;
        PlanValidation planValidation;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Set<String> uniqueProjectKeys = this.getUniqueProjectKeys(scope);
        List<ServerProject> serverProjectData = this.getServerProjectData(uniqueProjectKeys);
        Set<String> invalidProjectKeys = this.getInvalidProjectKeys(uniqueProjectKeys, serverProjectData);
        List<String> serviceDeskProjectKeys = this.getServiceDeskProjectKeys(serverProjectData);
        List<String> exceptions = this.validateProjectKeys(invalidProjectKeys);
        this.validateAllDataMigration(exceptions, scope, serviceDeskProjectKeys);
        this.validateAttachmentOnlyMigration(scope);
        if (exceptions.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = serverProjectData;
            planValidation = this.planValidation;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ServerProject serverProject = (ServerProject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
        } else {
            throw new PlanValidationException(this.formatExceptions(exceptions));
        }
        return planValidation.sortProjectsByIssueCount((List)destination$iv$iv);
    }

    private final void validateAllDataMigration(List<String> exceptions, MigrationScope scope, List<String> serviceDeskProjectKeys) {
        if (scope.getProjects().getIncludedData() != ProjectMigrationType.ALL) {
            return;
        }
        this.validateJsmMigrationMode(exceptions, scope, serviceDeskProjectKeys);
        this.validateUserMigrationMode(exceptions, scope, serviceDeskProjectKeys);
    }

    private final void validateJsmMigrationMode(List<String> exceptions, MigrationScope scope, List<String> serviceDeskProjectKeys) {
        if (!((Collection)serviceDeskProjectKeys).isEmpty() && scope.getJsm().getCustomers().getMode() == MigrationMode.NONE) {
            String string = INVALID_JSM_MIGRATION_MODE;
            Object[] objectArray = new Object[]{serviceDeskProjectKeys.toString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            exceptions.add(string2);
        }
    }

    private final void validateUserMigrationMode(List<String> exceptions, MigrationScope scope, List<String> serviceDeskProjectKeys) {
        if (scope.getUsersAndGroups().getMode() == MigrationMode.NONE) {
            String string = INVALID_USER_MIGRATION_MODE;
            Object[] objectArray = new Object[]{serviceDeskProjectKeys.toString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            exceptions.add(string2);
        }
    }

    private final void validateAttachmentOnlyMigration(MigrationScope scope) {
        if (scope.getProjects().getIncludedData() != ProjectMigrationType.ATTACHMENTS) {
            return;
        }
        List attachmentOnlyError = new ArrayList();
        this.checkArMode(scope, attachmentOnlyError);
        this.checkUsersAndGroupsMode(scope, attachmentOnlyError);
        this.checkJsmCustomersMode(scope, attachmentOnlyError);
        if (!((Collection)attachmentOnlyError).isEmpty()) {
            Logger logger2 = SwfExportFacadeKt.getLog();
            String string = ATTACHMENT_ONLY_ERROR;
            Object[] objectArray = new Object[]{attachmentOnlyError};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger2.warn(string2);
        }
    }

    private final void checkArMode(MigrationScope scope, List<String> attachmentOnlyError) {
        if (scope.getAr().getMode() != ArPlanMode.NONE) {
            attachmentOnlyError.add("scope.ar.mode");
        }
    }

    private final void checkUsersAndGroupsMode(MigrationScope scope, List<String> attachmentOnlyError) {
        if (scope.getUsersAndGroups().getMode() != MigrationMode.NONE) {
            attachmentOnlyError.add("scope.usersAndGroups.mode");
        }
    }

    private final void checkJsmCustomersMode(MigrationScope scope, List<String> attachmentOnlyError) {
        if (scope.getJsm().getCustomers().getMode() != MigrationMode.NONE) {
            attachmentOnlyError.add("scope.jsm.customers.mode");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getUniqueProjectKeys(MigrationScope scope) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = scope.getProjects().getIncludedKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            collection.add(string2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServerProject> getServerProjectData(Set<String> uniqueProjectKeys) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = uniqueProjectKeys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ServerProject it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.projectsReader.getServerProjectByKey(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getInvalidProjectKeys(Set<String> uniqueProjectKeys, List<ServerProject> serverProjectData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = serverProjectData;
        Set<String> set = uniqueProjectKeys;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerProject serverProject = (ServerProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        return SetsKt.minus(set, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getServiceDeskProjectKeys(List<ServerProject> serverProjectData) {
        void $this$mapTo$iv$iv;
        ServerProject it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = serverProjectData;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ServerProject)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)JIRA_SERVICE_DESK_KEY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ServerProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        return (List)destination$iv$iv;
    }

    private final List<String> validateProjectKeys(Set<String> invalidProjectKeys) {
        List exceptions = new ArrayList();
        if (!((Collection)invalidProjectKeys).isEmpty()) {
            String string = INVALID_PROJECT_KEYS;
            Object[] objectArray = new Object[]{invalidProjectKeys.toString()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            exceptions.add(string2);
        }
        return exceptions;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatExceptions(List<String> exceptions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = exceptions;
        StringBuilder stringBuilder = new StringBuilder().append("Issues while Attaching Migration: ");
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add('`' + (String)it + '`');
        }
        return stringBuilder.append((List)destination$iv$iv).toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/publicapi/validation/ProjectValidation$Companion;", "", "()V", "ATTACHMENT_ONLY_ERROR", "", "INVALID_JSM_MIGRATION_MODE", "INVALID_PROJECT_KEYS", "INVALID_USER_MIGRATION_MODE", "JIRA_SERVICE_DESK_KEY", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

