/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.recon;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/recon/ReconFileOutput;", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;)V", "createDuplicateEntityMappingFile", "Ljava/io/File;", "executionId", "", "createUploadFile", "cloudId", "getDuplicateEntityFile", "getReconFilePrefix", "getUploadedFile", "Companion", "jira-migration-plugin"})
public final class ReconFileOutput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    public static final String UPLOAD_FILE_SUFFIX = "-uploaded.csv";
    @NotNull
    public static final String DUPLICATE_ENTITY_FILE_SUFFIX = "-duplicate.csv";
    @NotNull
    private static final Logger log;

    @Inject
    public ReconFileOutput(@NotNull LocalFileDataOutput localFileDataOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        this.localFileDataOutput = localFileDataOutput;
    }

    @NotNull
    public final File createUploadFile(@NotNull String executionId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        log.info("Creating upload file for " + executionId + " and " + cloudId2);
        String uploadFileName = this.getReconFilePrefix(executionId) + UPLOAD_FILE_SUFFIX;
        File uploadFile2 = this.localFileDataOutput.outputFileForRecon(uploadFileName);
        return uploadFile2;
    }

    @Nullable
    public final File getUploadedFile(@NotNull String executionId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        log.info("Getting uploaded file for " + executionId + " and " + cloudId2);
        String uploadFileName = this.getReconFilePrefix(executionId) + UPLOAD_FILE_SUFFIX;
        File uploadFile2 = this.localFileDataOutput.readFileForRecon(uploadFileName);
        return uploadFile2;
    }

    @Nullable
    public final File getDuplicateEntityFile(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        String uploadFileName = this.getReconFilePrefix(executionId) + DUPLICATE_ENTITY_FILE_SUFFIX;
        File uploadFile2 = this.localFileDataOutput.readFileForRecon(uploadFileName);
        return uploadFile2;
    }

    @NotNull
    public final File createDuplicateEntityMappingFile(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        String duplicateEntityMappingFileName = this.getReconFilePrefix(executionId) + DUPLICATE_ENTITY_FILE_SUFFIX;
        File duplicateEntityMappingFile = this.localFileDataOutput.outputFileForRecon(duplicateEntityMappingFileName);
        return duplicateEntityMappingFile;
    }

    private final String getReconFilePrefix(String executionId) {
        return String.valueOf(executionId);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(ReconFileOutput.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/recon/ReconFileOutput$Companion;", "", "()V", "DUPLICATE_ENTITY_FILE_SUFFIX", "", "UPLOAD_FILE_SUFFIX", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

