/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.recon.rest;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.recon.StartReconRequest;
import com.atlassian.jira.migration.recon.model.CloudEntityProgressTracker;
import com.atlassian.jira.migration.recon.service.MonitorService;
import com.atlassian.jira.migration.recon.service.ReconService;
import com.atlassian.jira.migration.recon.service.UploadCsvData;
import com.atlassian.jira.migration.utils.CsvUtil;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.spi.container.ResourceFilters;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="recon")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0007J\u001c\u0010\u0014\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0007J\u001c\u0010\u0015\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0007J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J.\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00122\b\b\u0001\u0010\u001e\u001a\u00020\u0012H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/recon/rest/ReconResource;", "", "reconService", "Lcom/atlassian/jira/migration/recon/service/ReconService;", "monitorService", "Lcom/atlassian/jira/migration/recon/service/MonitorService;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/recon/service/ReconService;Lcom/atlassian/jira/migration/recon/service/MonitorService;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMonitorService", "()Lcom/atlassian/jira/migration/recon/service/MonitorService;", "getReconService", "()Lcom/atlassian/jira/migration/recon/service/ReconService;", "downloadFile", "Ljavax/ws/rs/core/Response;", "executionId", "", "cloudId", "downloadUploadedFile", "monitorStatus", "sanitizeInput", "input", "startRecon", "request", "Lcom/atlassian/jira/migration/recon/StartReconRequest;", "uploadFile", "file", "Ljava/io/InputStream;", "fileName", "Companion", "jira-migration-plugin"})
public final class ReconResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReconService reconService;
    @NotNull
    private final MonitorService monitorService;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private static final Logger log;

    @Inject
    public ReconResource(@NotNull ReconService reconService, @NotNull MonitorService monitorService, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)reconService, (String)"reconService");
        Intrinsics.checkNotNullParameter((Object)monitorService, (String)"monitorService");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.reconService = reconService;
        this.monitorService = monitorService;
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ReconService getReconService() {
        return this.reconService;
    }

    @NotNull
    public final MonitorService getMonitorService() {
        return this.monitorService;
    }

    @POST
    @Path(value="/start")
    @Operation(description="Generate a Duplicate Entities Report", responses={@ApiResponse(description="Report generation started", responseCode="202", content={@Content(mediaType="application/json")})})
    @Produces(value={"application/json"})
    @NotNull
    public final Response startRecon(@NotNull StartReconRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.reconService.generateDuplicateConfigEntitiesFile(request.getExecutionId(), request.getCloudId(), request.getProjectKeys());
        Response response2 = Response.status((Response.Status)Response.Status.ACCEPTED).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/monitor/status/{executionId}/{cloudId}")
    @NotNull
    public final Response monitorStatus(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        log.info("Monitoring status API for executionId: " + executionId + " and cloudId: " + cloudId2);
        CloudEntityProgressTracker progressTracker = this.monitorService.getCache(executionId);
        if (progressTracker == null) {
            Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)"No Duplicate Entity file generation in progress found").build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        return ResponseUtils.INSTANCE.ok(this.mapper.writeValueAsString((Object)progressTracker));
    }

    @POST
    @Path(value="upload/report/{executionId}/{cloudId}")
    @Consumes(value={"application/octet-stream"})
    @NotNull
    public final Response uploadFile(@NotNull InputStream file2, @PathParam(value="executionId") @NotNull String executionId, @PathParam(value="cloudId") @NotNull String cloudId2, @QueryParam(value="fileName") @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!CsvUtil.INSTANCE.isFileCsv(fileName)) {
            Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"File must be a CSV").build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        String sanitizedExecutionId = this.sanitizeInput(executionId);
        String sanitizedCloudId = this.sanitizeInput(cloudId2);
        byte[] fileContent = ByteStreamsKt.readBytes((InputStream)file2);
        UploadCsvData uploadCsvData = this.reconService.validateUploadCsv(fileContent);
        if (!uploadCsvData.isValid()) {
            Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)uploadCsvData.getReason()).build();
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
            return response3;
        }
        Response result2 = this.reconService.uploadFile(new ByteArrayInputStream(fileContent), sanitizedExecutionId, sanitizedCloudId);
        return result2;
    }

    @GET
    @Path(value="/download/report/{executionId}/{cloudId}")
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final Response downloadFile(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        String sanitizedExecutionId = this.sanitizeInput(executionId);
        String sanitizedCloudId = this.sanitizeInput(cloudId2);
        File file2 = this.reconService.getDupConfigFileForDownload(sanitizedExecutionId, sanitizedCloudId);
        if (file2 != null) {
            Response response2 = Response.ok((Object)new FileInputStream(file2)).header("Content-Disposition", (Object)("attachment; filename=\"" + file2.getName() + '\"')).build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        Response response3 = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"File not found").build();
        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        return response3;
    }

    @GET
    @Path(value="/download/uploaded/report/{executionId}/{cloudId}")
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final Response downloadUploadedFile(@PathParam(value="executionId") @NotNull String executionId, @PathParam(value="cloudId") @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        String sanitizedExecutionId = this.sanitizeInput(executionId);
        String sanitizedCloudId = this.sanitizeInput(cloudId2);
        File file2 = this.reconService.getUploadedFileForDownload(sanitizedExecutionId, sanitizedCloudId);
        if (file2 != null) {
            Response response2 = Response.ok((Object)new FileInputStream(file2)).header("Content-Disposition", (Object)("attachment; filename=\"" + file2.getName() + '\"')).build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        Response response3 = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"File not found").build();
        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        return response3;
    }

    @NotNull
    public final String sanitizeInput(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CharSequence charSequence = input;
        Regex regex = new Regex("[^a-zA-Z0-9_-]");
        String string = "";
        return regex.replace(charSequence, string);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(ReconResource.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/recon/rest/ReconResource$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

