/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.recon.service;

import com.atlassian.jira.migration.duplicates.configOnly.CloudEntityType;
import com.atlassian.jira.migration.recon.model.CloudEntityProgressTracker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J6\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/recon/service/MonitorService;", "", "()V", "dupEntityGenerationMonitorCache", "", "", "Lcom/atlassian/jira/migration/recon/model/CloudEntityProgressTracker;", "generateCache", "", "executionId", "cloudId", "getCache", "getCacheName", "updateCache", "key", "value", "totalEntityCount", "", "processedEntityCount", "updateResult", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMonitorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitorService.kt\ncom/atlassian/jira/migration/recon/service/MonitorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1726#2,3:79\n1747#2,3:82\n*S KotlinDebug\n*F\n+ 1 MonitorService.kt\ncom/atlassian/jira/migration/recon/service/MonitorService\n*L\n50#1:79,3\n52#1:82,3\n*E\n"})
public final class MonitorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, CloudEntityProgressTracker> dupEntityGenerationMonitorCache = new LinkedHashMap();
    @NotNull
    public static final String NOTSTARTED = "NOT_STARTED";
    @NotNull
    public static final String INPROGRESS = "IN_PROGRESS";
    @NotNull
    public static final String COMPLETED = "COMPLETED";
    public static final int SIZE = 100;
    @NotNull
    private static final Logger log;

    public final void generateCache(@NotNull String executionId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        log.info("Generating cache for " + executionId + " and " + cloudId2);
        String cacheName = this.getCacheName(executionId);
        Cache cache2 = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.DAYS).build();
        for (CloudEntityType key : CloudEntityType.values()) {
            cache2.put((Object)key.name(), (Object)NOTSTARTED);
        }
        if (this.dupEntityGenerationMonitorCache.get(cacheName) == null) {
            Intrinsics.checkNotNull((Object)cache2);
            this.dupEntityGenerationMonitorCache.put(cacheName, new CloudEntityProgressTracker(NOTSTARTED, cache2, 0, 0, 12, null));
        }
    }

    public final void updateCache(@NotNull String executionId, @NotNull String cloudId2, @NotNull String key, @NotNull Object value, int totalEntityCount, int processedEntityCount) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String cacheName = this.getCacheName(executionId);
        Cache<String, Object> cache2 = this.dupEntityGenerationMonitorCache.get(cacheName);
        if (cache2 != null && (cache2 = cache2.getEntityProgress()) != null) {
            cache2.put((Object)key, value);
        }
        CloudEntityProgressTracker cloudEntityProgressTracker = this.dupEntityGenerationMonitorCache.get(cacheName);
        if (cloudEntityProgressTracker != null) {
            cloudEntityProgressTracker.setTotalEntityCount(totalEntityCount);
        }
        CloudEntityProgressTracker cloudEntityProgressTracker2 = this.dupEntityGenerationMonitorCache.get(cacheName);
        if (cloudEntityProgressTracker2 != null) {
            cloudEntityProgressTracker2.setProcessedEntityCount(processedEntityCount);
        }
        this.updateResult(executionId, cloudId2);
    }

    private final void updateResult(String executionId, String cloudId2) {
        block12: {
            Object it;
            Object element$iv;
            Iterator iterator2;
            boolean bl;
            CloudEntityProgressTracker it2;
            block10: {
                log.info("Updating result for " + executionId + " and " + cloudId2);
                String cacheName = this.getCacheName(executionId);
                CloudEntityProgressTracker cloudEntityProgressTracker = this.dupEntityGenerationMonitorCache.get(cacheName);
                if (cloudEntityProgressTracker == null) break block12;
                it2 = cloudEntityProgressTracker;
                boolean bl2 = false;
                Iterable $this$all$iv = it2.getEntityProgress().asMap().values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (Intrinsics.areEqual(it, (Object)COMPLETED)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                it2.setResult(COMPLETED);
            } else {
                boolean bl4;
                block11: {
                    Iterable $this$any$iv = it2.getEntityProgress().asMap().values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            it = element$iv = iterator2.next();
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual(it, (Object)INPROGRESS)) continue;
                            bl4 = true;
                            break block11;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) {
                    it2.setResult(INPROGRESS);
                } else {
                    it2.setResult(NOTSTARTED);
                }
            }
        }
    }

    @Nullable
    public final CloudEntityProgressTracker getCache(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        String cacheName = this.getCacheName(executionId);
        return this.dupEntityGenerationMonitorCache.get(cacheName);
    }

    private final String getCacheName(String executionId) {
        return String.valueOf(executionId);
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(MonitorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/recon/service/MonitorService$Companion;", "", "()V", "COMPLETED", "", "INPROGRESS", "NOTSTARTED", "SIZE", "", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

