/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.recon.service;

import com.atlassian.jira.migration.analytics.ReconEventHandler;
import com.atlassian.jira.migration.duplicates.model.CloudIdEntityType;
import com.atlassian.jira.migration.events.ReconEvent;
import com.atlassian.jira.migration.preflight.reports.BaseEntityRowRecon;
import com.atlassian.jira.migration.preflight.reports.ComparisonType;
import com.atlassian.jira.migration.preflight.reports.DuplicateEntitiesReportService;
import com.atlassian.jira.migration.recon.ReconFileOutput;
import com.atlassian.jira.migration.recon.model.DuplicateEntityMapping;
import com.atlassian.jira.migration.recon.service.UploadCsvData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0007\u0018\u0000 42\u00020\u0001:\u0003456B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J$\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dJ\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\u000eJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001d2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ \u0010+\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fJ(\u0010-\u001a\u00020,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0002J(\u0010/\u001a\u00020,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/atlassian/jira/migration/recon/service/ReconService;", "", "duplicateEntitiesReportService", "Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService;", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "reconFileOutput", "Lcom/atlassian/jira/migration/recon/ReconFileOutput;", "reconEventHandler", "Lcom/atlassian/jira/migration/analytics/ReconEventHandler;", "(Lcom/atlassian/jira/migration/preflight/reports/DuplicateEntitiesReportService;Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/migration/recon/ReconFileOutput;Lcom/atlassian/jira/migration/analytics/ReconEventHandler;)V", "duplicateEntityReconCache", "", "Lcom/atlassian/jira/migration/preflight/reports/ComparisonType;", "", "", "Lcom/atlassian/jira/migration/duplicates/model/CloudIdEntityType;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "createDuplicateEntityCacheForRecon", "", "file", "Ljava/io/File;", "executionId", "cloudId", "generateDuplicateConfigEntitiesFile", "projectKeys", "", "getDupConfigFileForDownload", "getDuplicateEntityReconCache", "getUploadedFileForDownload", "readCSV", "Lcom/atlassian/jira/migration/recon/model/DuplicateEntityMapping;", "readContent", "", "inputStream", "Ljava/io/InputStream;", "readCsvLine", "reader", "Lorg/supercsv/io/CsvBeanReader;", "readDuplicateConfigEntitiesFileAndCreateCache", "uploadFile", "Ljavax/ws/rs/core/Response;", "uploadValidDuplicateEntity", "correctedRecords", "validateAndUploadContent", "validateUploadCsv", "Lcom/atlassian/jira/migration/recon/service/UploadCsvData;", "fileContent", "", "Companion", "JsonProcessor", "ListProcessor", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nReconService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReconService.kt\ncom/atlassian/jira/migration/recon/service/ReconService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n1855#3,2:253\n1855#3,2:255\n*S KotlinDebug\n*F\n+ 1 ReconService.kt\ncom/atlassian/jira/migration/recon/service/ReconService\n*L\n134#1:253,2\n176#1:255,2\n*E\n"})
public final class ReconService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DuplicateEntitiesReportService duplicateEntitiesReportService;
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final ReconFileOutput reconFileOutput;
    @NotNull
    private final ReconEventHandler reconEventHandler;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Map<ComparisonType, Map<String, CloudIdEntityType>> duplicateEntityReconCache;
    @NotNull
    private static final String[] HEADERS;
    @NotNull
    private static final JsonProcessor[] PROCESSORS;
    @NotNull
    private static final String[] NAME_MAPPING;
    @NotNull
    private static final Logger log;

    @Inject
    public ReconService(@NotNull DuplicateEntitiesReportService duplicateEntitiesReportService, @NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull ReconFileOutput reconFileOutput, @NotNull ReconEventHandler reconEventHandler) {
        Intrinsics.checkNotNullParameter((Object)duplicateEntitiesReportService, (String)"duplicateEntitiesReportService");
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)reconFileOutput, (String)"reconFileOutput");
        Intrinsics.checkNotNullParameter((Object)reconEventHandler, (String)"reconEventHandler");
        this.duplicateEntitiesReportService = duplicateEntitiesReportService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.reconFileOutput = reconFileOutput;
        this.reconEventHandler = reconEventHandler;
        this.objectMapper = new ObjectMapper();
        this.duplicateEntityReconCache = new LinkedHashMap();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public final void generateDuplicateConfigEntitiesFile(@NotNull String executionId, @NotNull String cloudId2, @NotNull List<String> projectKeys) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        ApplicationUser currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        new Thread(() -> ReconService.generateDuplicateConfigEntitiesFile$lambda$0(this, executionId, cloudId2, projectKeys, currentUser)).start();
    }

    @NotNull
    public final Response uploadFile(@NotNull InputStream file2, @NotNull String executionId, @Nullable String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        List<DuplicateEntityMapping> correctedRecords = this.readContent(file2);
        return this.validateAndUploadContent(correctedRecords, executionId, cloudId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<DuplicateEntityMapping> readContent(@NotNull InputStream inputStream) {
        List list;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Closeable closeable = (Closeable)new CsvBeanReader((Reader)new InputStreamReader(inputStream), CsvPreference.STANDARD_PREFERENCE);
        Throwable throwable = null;
        try {
            List correctedRecords;
            List list2;
            block9: {
                block8: {
                    CsvBeanReader reader = (CsvBeanReader)closeable;
                    boolean bl = false;
                    reader.getHeader(true);
                    list2 = this.readCsvLine(reader);
                    if (list2 == null) break block8;
                    List it = list2;
                    boolean bl2 = false;
                    List list3 = CollectionsKt.toMutableList((Collection)it);
                    list2 = list3;
                    if (list3 != null) break block9;
                }
                list2 = new ArrayList();
            }
            list = correctedRecords = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public final UploadCsvData validateUploadCsv(@NotNull byte[] fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent);
        CsvBeanReader reader = new CsvBeanReader((Reader)new InputStreamReader(inputStream), CsvPreference.STANDARD_PREFERENCE);
        try {
            Object[] actualHeaders = reader.getHeader(true);
            if (!Arrays.equals(actualHeaders, HEADERS)) {
                return new UploadCsvData(false, "Invalid CSV format. Expected headers: " + ArraysKt.joinToString$default((Object[])HEADERS, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            int lineNumber = 1;
            JsonProcessor[] jsonProcessorArray = PROCESSORS;
            DuplicateEntityMapping csvRow = (DuplicateEntityMapping)reader.read(DuplicateEntityMapping.class, NAME_MAPPING, (CellProcessor[])Arrays.copyOf(jsonProcessorArray, jsonProcessorArray.length));
            while (csvRow != null) {
                String resolutionValue;
                ++lineNumber;
                String string = csvRow.getResolution();
                if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                    string = "";
                }
                if (((CharSequence)(resolutionValue = string)).length() > 0 && !Intrinsics.areEqual((Object)resolutionValue, (Object)"TARGET")) {
                    return new UploadCsvData(false, "Invalid value in 'Resolution' column at line " + lineNumber + ". Must be empty or 'TARGET'.");
                }
                JsonProcessor[] jsonProcessorArray2 = PROCESSORS;
                csvRow = (DuplicateEntityMapping)reader.read(DuplicateEntityMapping.class, NAME_MAPPING, (CellProcessor[])Arrays.copyOf(jsonProcessorArray2, jsonProcessorArray2.length));
            }
        }
        catch (Exception e) {
            return new UploadCsvData(false, "Error reading CSV file: " + e.getMessage());
        }
        return new UploadCsvData(true, null, 2, null);
    }

    private final List<DuplicateEntityMapping> readCsvLine(CsvBeanReader reader) {
        List records = new ArrayList();
        DuplicateEntityMapping record = null;
        while (true) {
            DuplicateEntityMapping it;
            Object object = PROCESSORS;
            object = reader.read(DuplicateEntityMapping.class, NAME_MAPPING, (CellProcessor[])Arrays.copyOf(object, ((JsonProcessor[])object).length));
            DuplicateEntityMapping it2 = (DuplicateEntityMapping)object;
            boolean bl = false;
            record = it2;
            if (object == null) break;
            if (record == null) continue;
            boolean bl2 = false;
            records.add(it);
        }
        return records;
    }

    private final Response validateAndUploadContent(List<DuplicateEntityMapping> correctedRecords, String executionId, String cloudId2) {
        return this.uploadValidDuplicateEntity(correctedRecords, executionId, cloudId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response uploadValidDuplicateEntity(List<DuplicateEntityMapping> correctedRecords, String executionId, String cloudId2) {
        Response response2;
        String string = cloudId2;
        Intrinsics.checkNotNull((Object)string);
        this.reconEventHandler.sendReconEvent(new ReconEvent(string, executionId, ReconEvent.STATE.START_UPLOAD.getValue(), ReconEvent.STATUS.CREATED.getValue(), null, 0L, 48, null));
        File targetFile = this.reconFileOutput.createUploadFile(executionId, cloudId2);
        try {
            Closeable closeable = new FileOutputStream(targetFile);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object = charset;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new CsvBeanWriter((Writer)writer2, CsvPreference.EXCEL_PREFERENCE);
                Throwable throwable = null;
                try {
                    CsvBeanWriter csvWriter = (CsvBeanWriter)closeable2;
                    boolean bl2 = false;
                    String[] stringArray = HEADERS;
                    csvWriter.writeHeader(Arrays.copyOf(stringArray, stringArray.length));
                    Iterable $this$forEach$iv = correctedRecords;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DuplicateEntityMapping it = (DuplicateEntityMapping)element$iv;
                        boolean bl3 = false;
                        csvWriter.write((Object)it, NAME_MAPPING, (CellProcessor[])PROCESSORS);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            this.reconEventHandler.sendReconEvent(new ReconEvent(cloudId2, executionId, ReconEvent.STATE.START_UPLOAD.getValue(), ReconEvent.STATUS.SUCCESS.getValue(), null, 0L, 48, null));
            response2 = Response.status((Response.Status)Response.Status.CREATED).entity((Object)"File uploaded successfully").build();
            Intrinsics.checkNotNull((Object)response2);
        }
        catch (Exception e) {
            this.reconEventHandler.sendReconEvent(new ReconEvent(cloudId2, executionId, ReconEvent.STATE.START_UPLOAD.getValue(), ReconEvent.STATUS.FAILURE.getValue(), null, 0L, 48, null));
            Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("File upload failed: " + e.getMessage())).build();
            Intrinsics.checkNotNull((Object)response3);
            response2 = response3;
        }
        return response2;
    }

    @Nullable
    public final File getDupConfigFileForDownload(@NotNull String executionId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        log.info("Getting Duplicate Entities Report file for executionId " + executionId + ", cloudId " + cloudId2);
        File file2 = this.reconFileOutput.getDuplicateEntityFile(executionId);
        return file2;
    }

    @Nullable
    public final File getUploadedFileForDownload(@NotNull String executionId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        File file2 = this.reconFileOutput.getUploadedFile(executionId, cloudId2);
        return file2;
    }

    public final void readDuplicateConfigEntitiesFileAndCreateCache(@Nullable String executionId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        if (executionId == null) {
            log.warn("ExecutionId is null, cannot read Duplicate Entities Report file for cloudId " + cloudId2);
            return;
        }
        File file2 = this.reconFileOutput.getUploadedFile(executionId, cloudId2);
        if (file2 != null) {
            this.createDuplicateEntityCacheForRecon(file2, executionId, cloudId2);
        } else {
            log.warn("Duplicate Entities Report file does not exist for executionId " + executionId + ", cloudId " + cloudId2);
        }
    }

    private final void createDuplicateEntityCacheForRecon(File file2, String executionId, String cloudId2) {
        Iterable $this$forEach$iv = this.readCSV(file2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map existingMap;
            ComparisonType type;
            DuplicateEntityMapping it = (DuplicateEntityMapping)element$iv;
            boolean bl = false;
            String serverEntityJson = it.getServerEntity();
            String cloudEntityJson = it.getCloudEntity();
            BaseEntityRowRecon serverEntity = (BaseEntityRowRecon)this.objectMapper.readValue(serverEntityJson, BaseEntityRowRecon.class);
            BaseEntityRowRecon cloudEntity = (BaseEntityRowRecon)this.objectMapper.readValue(cloudEntityJson, BaseEntityRowRecon.class);
            String serverEntityId = serverEntity.getId();
            String cloudEntityId = cloudEntity.getId();
            ComparisonType comparisonType = ComparisonType.Companion.fromString(it.getComparisonType());
            Map<String, CloudIdEntityType> map = this.duplicateEntityReconCache.get((Object)comparisonType);
            boolean bl2 = map != null ? map.containsKey(serverEntityId) : false;
            if (bl2) {
                log.warn("Duplicate Entity Recon Cache already contains serverEntityId " + serverEntityId + ", cloudEntityId " + cloudEntityId + ", comparison for executionId " + executionId + ", cloudId " + cloudId2);
            }
            if (comparisonType == null) continue;
            boolean bl3 = false;
            Map map2 = this.duplicateEntityReconCache.get((Object)type);
            if (map2 == null || (map2 = MapsKt.toMutableMap(map2)) == null) {
                map2 = existingMap = (Map)new LinkedHashMap();
            }
            if (!Intrinsics.areEqual((Object)it.getResolution(), (Object)"TARGET")) continue;
            existingMap.put(serverEntityId, new CloudIdEntityType(cloudEntityId, it.getEntityType()));
            this.duplicateEntityReconCache.put(type, existingMap);
        }
        Map<String, CloudIdEntityType> map = this.duplicateEntityReconCache.get((Object)ComparisonType.SERVER_TO_CLOUD);
        log.warn("size of cache is " + (map != null ? Integer.valueOf(map.size()) : null));
    }

    @NotNull
    public final Map<ComparisonType, Map<String, CloudIdEntityType>> getDuplicateEntityReconCache() {
        return this.duplicateEntityReconCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<DuplicateEntityMapping> readCSV(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List rows = new ArrayList();
        Closeable closeable = (Closeable)new CsvBeanReader((Reader)new FileReader(file2), CsvPreference.EXCEL_PREFERENCE);
        Throwable throwable = null;
        try {
            CsvBeanReader csvReader = (CsvBeanReader)closeable;
            boolean bl = false;
            csvReader.getHeader(true);
            DuplicateEntityMapping row = null;
            while (true) {
                Object object = PROCESSORS;
                object = csvReader.read(DuplicateEntityMapping.class, NAME_MAPPING, (CellProcessor[])Arrays.copyOf(object, ((JsonProcessor[])object).length));
                DuplicateEntityMapping it = (DuplicateEntityMapping)object;
                boolean bl2 = false;
                row = it;
                if (object == null) break;
                DuplicateEntityMapping duplicateEntityMapping = row;
                Intrinsics.checkNotNull((Object)duplicateEntityMapping);
                rows.add(duplicateEntityMapping);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return rows;
    }

    private static final void generateDuplicateConfigEntitiesFile$lambda$0(ReconService this$0, String $executionId, String $cloudId, List $projectKeys, ApplicationUser $currentUser) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$cloudId, (String)"$cloudId");
        Intrinsics.checkNotNullParameter((Object)$projectKeys, (String)"$projectKeys");
        DuplicateEntitiesReportService duplicateEntitiesReportService = this$0.duplicateEntitiesReportService;
        Intrinsics.checkNotNull((Object)$currentUser);
        duplicateEntitiesReportService.createDuplicateEntitiesReport($executionId, $cloudId, $projectKeys, $currentUser);
    }

    static {
        Object[] objectArray = new String[]{"Entity Type", "Fields Compared", "Comparison Type", "Entity 1", "Entity 2", "Resolution"};
        HEADERS = objectArray;
        objectArray = new JsonProcessor[]{null, null, null, JsonProcessor.INSTANCE, JsonProcessor.INSTANCE, null};
        PROCESSORS = objectArray;
        objectArray = new String[]{"entityType", "comparedFields", "comparisonType", "serverEntity", "cloudEntity", "resolution"};
        NAME_MAPPING = objectArray;
        Logger logger2 = LoggerFactory.getLogger(ReconService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\n\u0010\u0007R\u001b\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/recon/service/ReconService$Companion;", "", "()V", "HEADERS", "", "", "getHEADERS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "NAME_MAPPING", "getNAME_MAPPING", "PROCESSORS", "Lcom/atlassian/jira/migration/recon/service/ReconService$JsonProcessor;", "getPROCESSORS", "()[Lcom/atlassian/jira/migration/recon/service/ReconService$JsonProcessor;", "[Lcom/atlassian/jira/migration/recon/service/ReconService$JsonProcessor;", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getHEADERS() {
            return HEADERS;
        }

        @NotNull
        public final JsonProcessor[] getPROCESSORS() {
            return PROCESSORS;
        }

        @NotNull
        public final String[] getNAME_MAPPING() {
            return NAME_MAPPING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/recon/service/ReconService$JsonProcessor;", "Lorg/supercsv/cellprocessor/CellProcessorAdaptor;", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "execute", "T", "value", "", "context", "Lorg/supercsv/util/CsvContext;", "(Ljava/lang/Object;Lorg/supercsv/util/CsvContext;)Ljava/lang/Object;", "jira-migration-plugin"})
    public static final class JsonProcessor
    extends CellProcessorAdaptor {
        @NotNull
        public static final JsonProcessor INSTANCE = new JsonProcessor();
        @NotNull
        private static final ObjectMapper objectMapper = new ObjectMapper();

        private JsonProcessor() {
        }

        public <T> T execute(@Nullable Object value, @Nullable CsvContext context) {
            return (T)JsonProcessor.INSTANCE.next.execute(value, context);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/recon/service/ReconService$ListProcessor;", "Lorg/supercsv/cellprocessor/CellProcessorAdaptor;", "()V", "execute", "T", "value", "", "context", "Lorg/supercsv/util/CsvContext;", "(Ljava/lang/Object;Lorg/supercsv/util/CsvContext;)Ljava/lang/Object;", "jira-migration-plugin"})
    public static final class ListProcessor
    extends CellProcessorAdaptor {
        @NotNull
        public static final ListProcessor INSTANCE = new ListProcessor();

        private ListProcessor() {
        }

        public <T> T execute(@Nullable Object value, @Nullable CsvContext context) {
            String processedValue = value == null || !(value instanceof List) ? "-" : CollectionsKt.joinToString$default((Iterable)((Iterable)value), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            return (T)ListProcessor.INSTANCE.next.execute((Object)processedValue, context);
        }
    }
}

