/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.s3;

import com.atlassian.jira.migration.platform.DownloadSignedUrl;
import com.atlassian.jira.migration.platform.DownloadedFile;
import com.atlassian.jira.migration.platform.EnterpriseGatewayClient;
import com.atlassian.jira.migration.s3.exception.S3FileReadException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ \u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/s3/S3FileDownloader;", "", "enterpriseGatewayClient", "Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;", "(Lcom/atlassian/jira/migration/platform/EnterpriseGatewayClient;)V", "downloadBySignedUrl", "Lcom/atlassian/jira/migration/platform/DownloadedFile;", "downloadSignedUrl", "Lcom/atlassian/jira/migration/platform/DownloadSignedUrl;", "path", "Ljava/nio/file/Path;", "downloadFileFromS3", "containerToken", "", "migrationScopeId", "fileId", "getSignedS3Url", "Companion", "jira-migration-plugin"})
public final class S3FileDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnterpriseGatewayClient enterpriseGatewayClient;
    private static final Logger log = LoggerFactory.getLogger(S3FileDownloader.class);
    @NotNull
    private static final String ERROR_MESSAGE = "Failed to download S3 file. Error details: {}";

    @Inject
    public S3FileDownloader(@NotNull EnterpriseGatewayClient enterpriseGatewayClient) {
        Intrinsics.checkNotNullParameter((Object)enterpriseGatewayClient, (String)"enterpriseGatewayClient");
        this.enterpriseGatewayClient = enterpriseGatewayClient;
    }

    @NotNull
    public final DownloadedFile downloadFileFromS3(@NotNull String containerToken, @NotNull String migrationScopeId2, @NotNull String fileId, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        log.info("Downloading and parsing file for migrationScopeId: " + migrationScopeId2 + " and fileId: " + fileId);
        DownloadSignedUrl downloadSignedUrl = this.getSignedS3Url(containerToken, migrationScopeId2, fileId);
        return this.downloadBySignedUrl(downloadSignedUrl, path);
    }

    private final DownloadSignedUrl getSignedS3Url(String containerToken, String migrationScopeId2, String fileId) {
        return this.enterpriseGatewayClient.getSignedS3UrlByMigrationScopeId(containerToken, migrationScopeId2, fileId);
    }

    private final DownloadedFile downloadBySignedUrl(DownloadSignedUrl downloadSignedUrl, Path path) {
        try {
            this.enterpriseGatewayClient.downloadBySignedUrl(downloadSignedUrl.getDownloadUrl(), path);
            log.info("Downloaded file with name: " + path.getFileName());
            return new DownloadedFile(path);
        }
        catch (IOException e) {
            String string = ERROR_MESSAGE;
            Object[] objectArray = new Object[]{e};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            log.error(string2);
            string = ERROR_MESSAGE;
            objectArray = new Object[]{e};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new S3FileReadException(string3);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/s3/S3FileDownloader$Companion;", "", "()V", "ERROR_MESSAGE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

