/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.scale;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.progress.TaskList;
import com.atlassian.jira.migration.scale.MigrationScaleTotalEntitiesEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/scale/MigrationScaleEventService;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "calculateTotalEntities", "", "migrationTaskType", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "status", "Lcom/atlassian/jira/migration/progress/TaskList;", "sendFinalTotalEntitiesMigrated", "", "migrationId", "", "cloudId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationScaleEventService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationScaleEventService.kt\ncom/atlassian/jira/migration/scale/MigrationScaleEventService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n766#2:49\n857#2,2:50\n1#3:52\n*S KotlinDebug\n*F\n+ 1 MigrationScaleEventService.kt\ncom/atlassian/jira/migration/scale/MigrationScaleEventService\n*L\n41#1:49\n41#1:50,2\n*E\n"})
public final class MigrationScaleEventService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private static final Logger log = LoggerFactory.getLogger(MigrationScaleEventService.class);

    @Inject
    public MigrationScaleEventService(@NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.migrationEventBus = migrationEventBus;
    }

    public final void sendFinalTotalEntitiesMigrated(@NotNull String migrationId, @NotNull String cloudId2, @NotNull TaskList status) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        try {
            long totalEntitiesFromProjects = this.calculateTotalEntities(MigrationTaskType.PROJECT_DATA_MIGRATION, status);
            long totalEntitiesFromCrossProjectData = this.calculateTotalEntities(MigrationTaskType.CROSS_PROJECT_DATA_MIGRATION, status);
            long totalEntities = totalEntitiesFromProjects + totalEntitiesFromCrossProjectData;
            log.info("Migration " + migrationId + " completed " + totalEntitiesFromProjects + " jira project entities and " + totalEntitiesFromCrossProjectData + " cross project entities ");
            this.migrationEventBus.post(new MigrationScaleTotalEntitiesEvent(migrationId, cloudId2, totalEntitiesFromProjects, totalEntitiesFromCrossProjectData, totalEntities));
        }
        catch (Exception e) {
            log.warn("Could not send total entities migrated stats due to exception " + e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long calculateTotalEntities(MigrationTaskType migrationTaskType, TaskList status) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = status.getTaskProgressList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GetTaskStatusResponse.TaskProgress it = (GetTaskStatusResponse.TaskProgress)element$iv$iv;
            boolean bl = false;
            if (!(migrationTaskType == it.getTask().getMigrationTaskType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        long l = 0L;
        for (Object t : iterable2) {
            void task;
            GetTaskStatusResponse.TaskProgress taskProgress = (GetTaskStatusResponse.TaskProgress)t;
            long l2 = l;
            boolean bl = false;
            Iterable iterable3 = task.getProgressItems().values();
            long l3 = 0L;
            for (Object t2 : iterable3) {
                void it;
                ProgressItem progressItem = (ProgressItem)t2;
                long l4 = l3;
                boolean bl2 = false;
                long l5 = it.getTotal();
                l3 = l4 + l5;
            }
            long l6 = l3;
            l = l2 + l6;
        }
        return l;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/scale/MigrationScaleEventService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

