/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.scope;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.scope.MigrationScopeRepository;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "", "migrationScopeRepository", "Lcom/atlassian/jira/migration/scope/MigrationScopeRepository;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "(Lcom/atlassian/jira/migration/scope/MigrationScopeRepository;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMigrationScope", "", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "jira-migration-plugin"})
public final class MigrationScopeManager {
    @NotNull
    private final MigrationScopeRepository migrationScopeRepository;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final JiraMetadataService jiraMetadataService;
    private final Logger log;

    @Inject
    public MigrationScopeManager(@NotNull MigrationScopeRepository migrationScopeRepository, @NotNull MigrationServiceClient migrationServiceClient, @NotNull PlatformService platformService, @NotNull JiraMetadataService jiraMetadataService) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeRepository, (String)"migrationScopeRepository");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        this.migrationScopeRepository = migrationScopeRepository;
        this.migrationServiceClient = migrationServiceClient;
        this.platformService = platformService;
        this.jiraMetadataService = jiraMetadataService;
        this.log = LoggerFactory.getLogger(MigrationScopeManager.class);
    }

    @NotNull
    public final String getMigrationScope(@NotNull CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        try {
            String currServerUrl = this.jiraMetadataService.getServerUrl();
            String activationId = this.migrationServiceClient.getActivationId(cloudSite2.getContainerToken());
            boolean bl = false;
            return this.migrationScopeRepository.getOrCreate(cloudSite2.getCloudId(), activationId, currServerUrl, (Function0<String>)((Function0)new Function0<String>(this, cloudSite2, activationId){
                final /* synthetic */ MigrationScopeManager this$0;
                final /* synthetic */ CloudSite $cloudSite;
                final /* synthetic */ String $activationId;
                {
                    this.this$0 = $receiver;
                    this.$cloudSite = $cloudSite;
                    this.$activationId = $activationId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    MigrationScopeManager.access$getLog$p(this.this$0).info("requesting new migration scope from Cloud for cloud site " + this.$cloudSite.getCloudId() + " (" + this.$cloudSite.getCloudUrl() + ") and activationId " + this.$activationId);
                    String string = MigrationScopeManager.access$getPlatformService$p(this.this$0).createMigrationScope(this.$cloudSite).getMigrationScopeId().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return string;
                }
            }));
        }
        catch (UnexpectedStatusCodeException e) {
            this.log.warn("Error while fetching activationId. Container token might be invalid.", (Throwable)e);
            return "dummyMigrationScopeId";
        }
    }

    public static final /* synthetic */ Logger access$getLog$p(MigrationScopeManager $this) {
        return $this.log;
    }

    public static final /* synthetic */ PlatformService access$getPlatformService$p(MigrationScopeManager $this) {
        return $this.platformService;
    }
}

