/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.scope;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.scope.MigrationScopeDao;
import com.atlassian.jira.migration.scope.MigrationScopeRecord;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012J,\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0002J8\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/scope/MigrationScopeRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "dao", "Lcom/atlassian/jira/migration/scope/MigrationScopeDao;", "features", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/scope/MigrationScopeDao;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getOrCreate", "", "cloudId", "activationId", "serverUrl", "supplier", "Lkotlin/Function0;", "getOrCreateEmptyLocally", "db", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseConnection;", "getOrRequestFromCloudWithLocking", "jira-migration-plugin"})
public final class MigrationScopeRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final MigrationScopeDao dao;
    @NotNull
    private final MigrationFeatures features;
    private final Logger log;

    @Inject
    public MigrationScopeRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull MigrationScopeDao dao, @NotNull MigrationFeatures features) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        this.databaseAccessor = databaseAccessor;
        this.dao = dao;
        this.features = features;
        this.log = LoggerFactory.getLogger(MigrationScopeRepository.class);
    }

    @NotNull
    public final String getOrCreate(@NotNull String cloudId2, @NotNull String activationId, @NotNull String serverUrl, @NotNull Function0<String> supplier) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)activationId, (String)"activationId");
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        String string = (String)this.databaseAccessor.run(arg_0 -> MigrationScopeRepository.getOrCreate$lambda$0(this, cloudId2, activationId, serverUrl, arg_0), MigrationScopeRepository::getOrCreate$lambda$1);
        if (string == null) {
            Object object = this.databaseAccessor.run(arg_0 -> MigrationScopeRepository.getOrCreate$lambda$2(this, cloudId2, activationId, serverUrl, supplier, arg_0), MigrationScopeRepository::getOrCreate$lambda$3);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
            string = (String)object;
        }
        return string;
    }

    private final String getOrCreateEmptyLocally(DatabaseConnection db, String cloudId2, String activationId, String serverUrl) {
        String string;
        MigrationScopeRecord rec = MigrationScopeDao.select$default(this.dao, db, cloudId2, false, 4, null);
        boolean bl = false;
        if (rec == null) {
            try {
                this.dao.insertEmpty(db, cloudId2);
            }
            catch (QueryException e) {
                this.log.warn("Failed to insert empty migration scope record, ignoring...", (Throwable)e);
            }
            string = null;
        } else {
            string = Intrinsics.areEqual((Object)rec.getActivationId(), (Object)activationId) && (!this.features.getEnableSourceUrlCheckForSourceIdCreation() || Intrinsics.areEqual((Object)serverUrl, (Object)rec.getServerUrl())) ? rec.getScopeId() : null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getOrRequestFromCloudWithLocking(DatabaseConnection db, String cloudId2, String activationId, String serverUrl, Function0<String> supplier) {
        Object object;
        block11: {
            block10: {
                String string;
                boolean isServerUrlMismatched;
                object = this.dao.select(db, cloudId2, true);
                if (object == null) break block10;
                MigrationScopeRecord rec = object;
                boolean bl = false;
                boolean bl2 = isServerUrlMismatched = this.features.getEnableSourceUrlCheckForSourceIdCreation() && !Intrinsics.areEqual((Object)serverUrl, (Object)rec.getServerUrl());
                if (rec.getScopeId() == null || !Intrinsics.areEqual((Object)activationId, (Object)rec.getActivationId()) || isServerUrlMismatched) {
                    void $this$getOrRequestFromCloudWithLocking_u24lambda_u246_u24lambda_u245;
                    StringBuilder stringBuilder;
                    String scopeId = (String)supplier.invoke();
                    this.dao.update(db, cloudId2, activationId, scopeId, serverUrl);
                    StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                    Logger logger2 = this.log;
                    boolean bl3 = false;
                    $this$getOrRequestFromCloudWithLocking_u24lambda_u246_u24lambda_u245.append("created new migration scope " + scopeId + " for cloudId " + cloudId2 + ", activationId " + activationId);
                    if (!Intrinsics.areEqual((Object)activationId, (Object)rec.getActivationId())) {
                        $this$getOrRequestFromCloudWithLocking_u24lambda_u246_u24lambda_u245.append(" replacing existing one for activationId " + rec.getActivationId());
                    }
                    $this$getOrRequestFromCloudWithLocking_u24lambda_u246_u24lambda_u245.append(" and serverUrl " + serverUrl);
                    if (isServerUrlMismatched) {
                        StringBuilder stringBuilder3 = new StringBuilder().append(" replacing existing one for serverUrl ");
                        String string2 = rec.getServerUrl();
                        if (string2 == null) {
                            string2 = "<N/A>";
                        }
                        $this$getOrRequestFromCloudWithLocking_u24lambda_u246_u24lambda_u245.append(stringBuilder3.append(string2).toString());
                    }
                    String string3 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    logger2.info(string3);
                    string = scopeId;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("found existing migration scope ").append(rec.getScopeId()).append(" for cloudId ").append(cloudId2).append(", activationId ").append(activationId).append(" and serverUrl ");
                    String string4 = serverUrl;
                    if (string4 == null) {
                        string4 = "<N/A>";
                    }
                    this.log.info(stringBuilder.append(string4).toString());
                    string = rec.getScopeId();
                }
                object = string;
                if (string != null) break block11;
            }
            StringBuilder stringBuilder = new StringBuilder().append("No migration scope record is present in DB for cloudId ").append(cloudId2).append(", activationId ").append(activationId).append(" and serverUrl ");
            String string = serverUrl;
            if (string == null) {
                string = "<N/A>";
            }
            throw new IllegalStateException(stringBuilder.append(string).toString().toString());
        }
        return object;
    }

    private static final String getOrCreate$lambda$0(MigrationScopeRepository this$0, String $cloudId, String $activationId, String $serverUrl, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cloudId, (String)"$cloudId");
        Intrinsics.checkNotNullParameter((Object)$activationId, (String)"$activationId");
        Intrinsics.checkNotNullParameter((Object)$serverUrl, (String)"$serverUrl");
        Intrinsics.checkNotNull((Object)db);
        return this$0.getOrCreateEmptyLocally(db, $cloudId, $activationId, $serverUrl);
    }

    private static final void getOrCreate$lambda$1() {
    }

    private static final String getOrCreate$lambda$2(MigrationScopeRepository this$0, String $cloudId, String $activationId, String $serverUrl, Function0 $supplier, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cloudId, (String)"$cloudId");
        Intrinsics.checkNotNullParameter((Object)$activationId, (String)"$activationId");
        Intrinsics.checkNotNullParameter((Object)$serverUrl, (String)"$serverUrl");
        Intrinsics.checkNotNullParameter((Object)$supplier, (String)"$supplier");
        Intrinsics.checkNotNull((Object)db);
        return this$0.getOrRequestFromCloudWithLocking(db, $cloudId, $activationId, $serverUrl, (Function0<String>)$supplier);
    }

    private static final void getOrCreate$lambda$3() {
    }
}

