/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.sen;

import com.atlassian.jira.migration.common.Hosting;
import com.atlassian.jira.migration.sen.JiraLicenseInfo;
import com.atlassian.jira.migration.sen.JiraSenInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/sen/SENSupplier;", "", "licenseHandler", "Lcom/atlassian/sal/api/license/LicenseHandler;", "(Lcom/atlassian/sal/api/license/LicenseHandler;)V", "getFirstSen", "", "getHosting", "Lcom/atlassian/jira/migration/common/Hosting;", "getLicenses", "Lcom/atlassian/jira/migration/sen/JiraLicenseInfo;", "getMaxNumberOfUsersFromLicenses", "", "getSens", "Lcom/atlassian/jira/migration/sen/JiraSenInfo;", "isEnterprise", "", "jira-migration-plugin"})
public final class SENSupplier {
    @NotNull
    private final LicenseHandler licenseHandler;

    @Inject
    public SENSupplier(@NotNull LicenseHandler licenseHandler) {
        Intrinsics.checkNotNullParameter((Object)licenseHandler, (String)"licenseHandler");
        this.licenseHandler = licenseHandler;
    }

    @Nullable
    public final String getFirstSen() {
        SortedSet sortedSet = this.licenseHandler.getAllSupportEntitlementNumbers();
        Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"getAllSupportEntitlementNumbers(...)");
        return (String)CollectionsKt.firstOrNull((Iterable)sortedSet);
    }

    @NotNull
    public final JiraSenInfo getSens() {
        SingleProductLicenseDetailsView singleProductLicenseDetailsView = this.licenseHandler.getProductLicenseDetails("jira-core");
        SingleProductLicenseDetailsView singleProductLicenseDetailsView2 = this.licenseHandler.getProductLicenseDetails("jira-servicedesk");
        SingleProductLicenseDetailsView singleProductLicenseDetailsView3 = this.licenseHandler.getProductLicenseDetails("jira-software");
        return new JiraSenInfo(singleProductLicenseDetailsView != null ? singleProductLicenseDetailsView.getSupportEntitlementNumber() : null, singleProductLicenseDetailsView2 != null ? singleProductLicenseDetailsView2.getSupportEntitlementNumber() : null, singleProductLicenseDetailsView3 != null ? singleProductLicenseDetailsView3.getSupportEntitlementNumber() : null);
    }

    @NotNull
    public final Hosting getHosting() {
        return this.licenseHandler.getAllProductLicenses().stream().anyMatch(arg_0 -> SENSupplier.getHosting$lambda$0(getHosting.1.INSTANCE, arg_0)) ? Hosting.DATACENTER : Hosting.SERVER;
    }

    @NotNull
    public final JiraLicenseInfo getLicenses() {
        SingleProductLicenseDetailsView singleProductLicenseDetailsView = this.licenseHandler.getProductLicenseDetails("jira-core");
        SingleProductLicenseDetailsView singleProductLicenseDetailsView2 = this.licenseHandler.getProductLicenseDetails("jira-servicedesk");
        SingleProductLicenseDetailsView singleProductLicenseDetailsView3 = this.licenseHandler.getProductLicenseDetails("jira-software");
        return new JiraLicenseInfo(singleProductLicenseDetailsView != null ? Integer.valueOf(singleProductLicenseDetailsView.getNumberOfUsers()) : null, singleProductLicenseDetailsView2 != null ? Integer.valueOf(singleProductLicenseDetailsView2.getNumberOfUsers()) : null, singleProductLicenseDetailsView3 != null ? Integer.valueOf(singleProductLicenseDetailsView3.getNumberOfUsers()) : null);
    }

    public final long getMaxNumberOfUsersFromLicenses() {
        SingleProductLicenseDetailsView singleProductLicenseDetailsView = this.licenseHandler.getProductLicenseDetails("jira-core");
        long l = singleProductLicenseDetailsView != null ? (long)singleProductLicenseDetailsView.getNumberOfUsers() : 0L;
        SingleProductLicenseDetailsView singleProductLicenseDetailsView2 = this.licenseHandler.getProductLicenseDetails("jira-servicedesk");
        long l2 = singleProductLicenseDetailsView2 != null ? (long)singleProductLicenseDetailsView2.getNumberOfUsers() : 0L;
        SingleProductLicenseDetailsView singleProductLicenseDetailsView3 = this.licenseHandler.getProductLicenseDetails("jira-software");
        long l3 = singleProductLicenseDetailsView3 != null ? (long)singleProductLicenseDetailsView3.getNumberOfUsers() : 0L;
        return Math.max(l, Math.max(l2, l3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEnterprise() {
        SingleProductLicenseDetailsView singleProductLicenseDetailsView = this.licenseHandler.getProductLicenseDetails("jira-core");
        if (singleProductLicenseDetailsView != null ? singleProductLicenseDetailsView.isEnterpriseLicensingAgreement() : false) return true;
        SingleProductLicenseDetailsView singleProductLicenseDetailsView2 = this.licenseHandler.getProductLicenseDetails("jira-servicedesk");
        if (singleProductLicenseDetailsView2 != null ? singleProductLicenseDetailsView2.isEnterpriseLicensingAgreement() : false) return true;
        SingleProductLicenseDetailsView singleProductLicenseDetailsView3 = this.licenseHandler.getProductLicenseDetails("jira-software");
        if (singleProductLicenseDetailsView3 == null) return false;
        boolean bl = singleProductLicenseDetailsView3.isEnterpriseLicensingAgreement();
        if (!bl) return false;
        return true;
    }

    private static final boolean getHosting$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

