/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors;

import com.atlassian.jira.migration.advancedroadmaps.AdvancedRoadmapsProjectsService;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanData;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.plan.AdvancedRoadmapPlanMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.AdvancedRoadmapsPlanDto;
import com.atlassian.jira.migration.serverdataextractors.AdvancedRoadmapsPlansResult;
import com.atlassian.jira.migration.serverdataextractors.AdvancedRoadmapsPlansSortKey;
import com.atlassian.jira.migration.serverdataextractors.GetPlanProjectsCount;
import com.atlassian.jira.migration.serverdataextractors.PlanIdDto;
import com.atlassian.jira.migration.serverdataextractors.PlanProjects;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import com.atlassian.jira.migration.serverdataextractors.SortOrder;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="advanced-roadmaps")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J=\u0010\t\u001a\u00020\u00062\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0006H\u0007J\u0018\u0010\u0016\u001a\u00020\u00062\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/AdvancedRoadmapsDataResource;", "", "advancedRoadmapsProjectsService", "Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;", "(Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;)V", "getAdvancedRoadmapPlansCount", "Ljavax/ws/rs/core/Response;", "getPlanProjectsCount", "Lcom/atlassian/jira/migration/serverdataextractors/GetPlanProjectsCount;", "listPlans", "offset", "", "limit", "sortKey", "Lcom/atlassian/jira/migration/serverdataextractors/AdvancedRoadmapsPlansSortKey;", "sortOrder", "Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;", "(Ljava/lang/Integer;Ljava/lang/Integer;Lcom/atlassian/jira/migration/serverdataextractors/AdvancedRoadmapsPlansSortKey;Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;)Ljavax/ws/rs/core/Response;", "listProjectsForPlans", "planIdDto", "Lcom/atlassian/jira/migration/serverdataextractors/PlanIdDto;", "mapProjectsForAllPlans", "mapProjectsForPlans", "planIds", "", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAdvancedRoadmapsDataResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedRoadmapsDataResource.kt\ncom/atlassian/jira/migration/serverdataextractors/AdvancedRoadmapsDataResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1549#2:101\n1620#2,2:102\n1549#2:104\n1620#2,3:105\n1622#2:108\n1549#2:109\n1620#2,2:110\n1549#2:112\n1620#2,3:113\n1622#2:116\n1549#2:117\n1620#2,3:118\n*S KotlinDebug\n*F\n+ 1 AdvancedRoadmapsDataResource.kt\ncom/atlassian/jira/migration/serverdataextractors/AdvancedRoadmapsDataResource\n*L\n49#1:101\n49#1:102,2\n50#1:104\n50#1:105,3\n49#1:108\n61#1:109\n61#1:110,2\n62#1:112\n62#1:113,3\n61#1:116\n80#1:117\n80#1:118,3\n*E\n"})
public final class AdvancedRoadmapsDataResource {
    @NotNull
    private final AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService;

    @Inject
    public AdvancedRoadmapsDataResource(@NotNull AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService) {
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsProjectsService, (String)"advancedRoadmapsProjectsService");
        this.advancedRoadmapsProjectsService = advancedRoadmapsProjectsService;
    }

    @POST
    @Path(value="projects")
    @NotNull
    public final Response listProjectsForPlans(@Nullable PlanIdDto planIdDto) {
        if (planIdDto == null || planIdDto.getPlanIds() == null) {
            Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
            return response2;
        }
        Response response3 = Response.ok(this.advancedRoadmapsProjectsService.getProjectsFromPlans(planIdDto.getPlanIds())).build();
        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        return response3;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="plan-projects-map")
    @NotNull
    public final Response mapProjectsForPlans(@QueryParam(value="planIds") @NotNull List<Long> planIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(planIds, (String)"planIds");
        Iterable $this$map$iv = planIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void planId;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = this.advancedRoadmapsProjectsService.getProjectsFromPlans(CollectionsKt.listOf((Object)((long)planId)));
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                ServerProjectDto serverProjectDto = (ServerProjectDto)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(it.getKey());
            }
            List projectKeysForPlan = (List)destination$iv$iv2;
            collection.add(new PlanProjects((long)planId, projectKeysForPlan));
        }
        Response response2 = Response.ok((Object)((List)destination$iv$iv)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="all-plan-projects-map")
    @NotNull
    public final Response mapProjectsForAllPlans() {
        void $this$mapTo$iv$iv;
        List<Long> planIds = this.advancedRoadmapsProjectsService.getAllPlanIds();
        Iterable $this$map$iv = planIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void planId;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = this.advancedRoadmapsProjectsService.getProjectsFromPlans(CollectionsKt.listOf((Object)((long)planId)));
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                ServerProjectDto serverProjectDto = (ServerProjectDto)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(it.getKey());
            }
            List projectKeysForPlan = (List)destination$iv$iv2;
            collection.add(new PlanProjects((long)planId, projectKeysForPlan));
        }
        Response response2 = Response.ok((Object)((List)destination$iv$iv)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="plans")
    @NotNull
    public final Response listPlans(@QueryParam(value="offset") @DefaultValue(value="0") @Nullable Integer offset, @QueryParam(value="limit") @Nullable Integer limit, @QueryParam(value="sortKey") @Nullable AdvancedRoadmapsPlansSortKey sortKey, @QueryParam(value="sortOrder") @Nullable SortOrder sortOrder) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.advancedRoadmapsProjectsService.getPaginatedPlans(offset, limit, sortOrder);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void arPlan;
            AdvancedRoadmapsPlanData advancedRoadmapsPlanData = (AdvancedRoadmapsPlanData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AdvancedRoadmapsPlanDto(arPlan.getId(), arPlan.getTitle(), "secure/PortfolioPlanView.jspa?id=" + arPlan.getId()));
        }
        long l = AdvancedRoadmapsProjectsService.DefaultImpls.getPlansCount$default(this.advancedRoadmapsProjectsService, AdvancedRoadmapPlanMigrationMode.ALL, null, 2, null);
        List list = (List)destination$iv$iv;
        Response response2 = Response.ok((Object)new AdvancedRoadmapsPlansResult(list, l)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @POST
    @Path(value="plan-project-count")
    @Consumes(value={"application/json"})
    @NotNull
    public final Response getAdvancedRoadmapPlansCount(@NotNull GetPlanProjectsCount getPlanProjectsCount) {
        Object object;
        Object $this$getAdvancedRoadmapPlansCount_u24lambda_u245;
        Intrinsics.checkNotNullParameter((Object)getPlanProjectsCount, (String)"getPlanProjectsCount");
        Object object2 = this;
        try {
            $this$getAdvancedRoadmapPlansCount_u24lambda_u245 = object2;
            boolean bl = false;
            long plansCount = ((AdvancedRoadmapsDataResource)$this$getAdvancedRoadmapPlansCount_u24lambda_u245).advancedRoadmapsProjectsService.getPlansCount(getPlanProjectsCount.getAdvancedRoadmapPlanMigrationMode(), getPlanProjectsCount.getProjectKeys());
            $this$getAdvancedRoadmapPlansCount_u24lambda_u245 = Result.constructor-impl((Object)ResponseUtils.INSTANCE.ok(plansCount));
        }
        catch (Throwable bl) {
            $this$getAdvancedRoadmapPlansCount_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getAdvancedRoadmapPlansCount_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = ResponseUtils.INSTANCE.internalServerError("Failed to retrieve plans count: " + it.getMessage());
        }
        return (Response)object;
    }
}

