/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesRequestItem;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesResponseItem;
import com.atlassian.jira.migration.mediaclient.MediaClient;
import com.atlassian.jira.migration.mediaclient.Upload;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\fR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/BandwidthCalculator;", "", "mediaClient", "Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "(Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;)V", "uploadTimeLimit", "", "(Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;J)V", "cachedBandwidth", "Lcom/google/common/cache/LoadingCache;", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "calculateBandwidth", "size", "", "containerToken", "calculateOptimalBandwidth", "getOrCalculateBandwidth", "cloudId", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBandwidthCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BandwidthCalculator.kt\ncom/atlassian/jira/migration/serverdataextractors/BandwidthCalculator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1#2:143\n17#3,6:144\n1855#4,2:150\n*S KotlinDebug\n*F\n+ 1 BandwidthCalculator.kt\ncom/atlassian/jira/migration/serverdataextractors/BandwidthCalculator\n*L\n108#1:144,6\n68#1:150,2\n*E\n"})
public final class BandwidthCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MediaClient mediaClient;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    private final long uploadTimeLimit;
    private final Logger log;
    @NotNull
    private final LoadingCache<String, Long> cachedBandwidth;
    private static final long UPLOAD_TIME_LIMIT = 15L;
    public static final long NO_CALCULATED_BANDWIDTH = -1L;
    private static final int FIVE_MB_FILE_SIZE = 0x500000;
    private static final int HUNDRED_KB_FILE_SIZE = 102400;
    private static final int ONE_MB_FILE_SIZE = 0x100000;
    @NotNull
    private static final Collection<Integer> UPLOAD_SIZES;
    private static final int NUM_PROGRESSIVE_UPLOADS;
    private static final int PART_NUMBER = 1;
    @NotNull
    private static final String DUMMY_FILE_NAME = "DummyFileName";

    @VisibleForTesting
    public BandwidthCalculator(@NotNull MediaClient mediaClient, @NotNull CloudSiteRepository cloudSiteRepository, long uploadTimeLimit) {
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        this.mediaClient = mediaClient;
        this.cloudSiteRepository = cloudSiteRepository;
        this.uploadTimeLimit = uploadTimeLimit;
        this.log = LoggerFactory.getLogger(BandwidthCalculator.class);
        LoadingCache loadingCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(arg_0 -> BandwidthCalculator.cachedBandwidth$lambda$0(this, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.cachedBandwidth = loadingCache;
    }

    @Inject
    public BandwidthCalculator(@NotNull MediaClient mediaClient, @NotNull CloudSiteRepository cloudSiteRepository) {
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        this(mediaClient, cloudSiteRepository, 15L);
    }

    public final long getOrCalculateBandwidth(@NotNull String cloudId2) {
        Long l;
        String string;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        if (cloudSite2 != null && (string = cloudSite2.getContainerToken()) != null) {
            String token = string;
            boolean bl = false;
            l = (Long)this.cachedBandwidth.get((Object)token);
        } else {
            l = null;
        }
        Long l2 = l;
        return l2 == null ? -1L : l2;
    }

    @VisibleForTesting
    public final long calculateOptimalBandwidth(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Ref.LongRef bandwidth = new Ref.LongRef();
        bandwidth.element = -1L;
        try {
            if (this.uploadTimeLimit > 0L) {
                CompletableFuture.supplyAsync(() -> BandwidthCalculator.calculateOptimalBandwidth$lambda$3(bandwidth, this, containerToken)).get(this.uploadTimeLimit, TimeUnit.SECONDS);
            }
        }
        catch (TimeoutException e) {
            this.log.debug("\n                    During the calculation of bandwidth, the server took too long to upload one of the test files and timed out.\n                    JCMA will continue to perform as normal.\n                ");
        }
        this.log.info("The server bandwidth calculated is " + bandwidth.element + " bytes per second.");
        return bandwidth.element;
    }

    @VisibleForTesting
    public final long calculateBandwidth(int size, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        byte[] dummyFile = Random.Default.nextBytes(size);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String dummyFileId = string;
        Upload upload = new Upload(((CreateWithFilesResponseItem)CollectionsKt.first(this.mediaClient.createUploadWithFiles(containerToken, CollectionsKt.listOf((Object)new CreateWithFilesRequestItem(dummyFileId))))).getUploadId());
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.mediaClient.uploadChunk(containerToken, dummyFile, upload.getId(), 1);
        double timeElapsedInSeconds = (double)(System.currentTimeMillis() - start$iv) / (double)1000;
        this.mediaClient.createFileFromUpload(containerToken, upload, DUMMY_FILE_NAME, dummyFileId);
        return MathKt.roundToLong((double)((double)size / timeElapsedInSeconds));
    }

    private static final Long cachedBandwidth$lambda$0(BandwidthCalculator this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = key;
        Intrinsics.checkNotNull((Object)string);
        return this$0.calculateOptimalBandwidth(string);
    }

    private static final Unit calculateOptimalBandwidth$lambda$3(Ref.LongRef $bandwidth, BandwidthCalculator this$0, String $containerToken) {
        Intrinsics.checkNotNullParameter((Object)$bandwidth, (String)"$bandwidth");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$containerToken, (String)"$containerToken");
        Iterable $this$forEach$iv = UPLOAD_SIZES;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int size = ((Number)element$iv).intValue();
            boolean bl = false;
            $bandwidth.element = this$0.calculateBandwidth(size, $containerToken);
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Integer[]{102400, 0x100000, 0x500000};
        UPLOAD_SIZES = CollectionsKt.listOf((Object[])objectArray);
        NUM_PROGRESSIVE_UPLOADS = UPLOAD_SIZES.size();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R\u001c\u0010\u000b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/BandwidthCalculator$Companion;", "", "()V", "DUMMY_FILE_NAME", "", "FIVE_MB_FILE_SIZE", "", "HUNDRED_KB_FILE_SIZE", "NO_CALCULATED_BANDWIDTH", "", "getNO_CALCULATED_BANDWIDTH$annotations", "NUM_PROGRESSIVE_UPLOADS", "getNUM_PROGRESSIVE_UPLOADS$annotations", "getNUM_PROGRESSIVE_UPLOADS", "()I", "ONE_MB_FILE_SIZE", "PART_NUMBER", "UPLOAD_SIZES", "", "getUPLOAD_SIZES", "()Ljava/util/Collection;", "UPLOAD_TIME_LIMIT", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getNO_CALCULATED_BANDWIDTH$annotations() {
        }

        @NotNull
        public final Collection<Integer> getUPLOAD_SIZES() {
            return UPLOAD_SIZES;
        }

        public final int getNUM_PROGRESSIVE_UPLOADS() {
            return NUM_PROGRESSIVE_UPLOADS;
        }

        @VisibleForTesting
        public static /* synthetic */ void getNUM_PROGRESSIVE_UPLOADS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

