/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors;

import com.atlassian.jira.migration.serverdataextractors.ServerProject;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.opensymphony.module.propertyset.PropertySet;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "projectPropertiesManager", "Lcom/atlassian/jira/project/ProjectPropertiesManager;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/project/ProjectPropertiesManager;)V", "getProject", "Lcom/atlassian/jira/project/Project;", "projectKey", "", "getProjectById", "projectId", "", "getServerProjectByKey", "Lcom/atlassian/jira/migration/serverdataextractors/ServerProject;", "key", "jira-migration-plugin"})
public final class ProjectsReader {
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final ProjectPropertiesManager projectPropertiesManager;

    @Inject
    public ProjectsReader(@NotNull ProjectManager projectManager, @NotNull ProjectPropertiesManager projectPropertiesManager) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)projectPropertiesManager, (String)"projectPropertiesManager");
        this.projectManager = projectManager;
        this.projectPropertiesManager = projectPropertiesManager;
    }

    @Nullable
    public final ServerProject getServerProjectByKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Project project = this.projectManager.getProjectByCurrentKey(key);
        if (project != null) {
            Project it = project;
            boolean bl = false;
            PropertySet propertySet = this.projectPropertiesManager.getPropertySet(it);
            boolean isArchived = propertySet != null ? propertySet.exists("jira.archiving.projects") : false;
            return new ServerProject(it, isArchived);
        }
        return null;
    }

    @NotNull
    public final Project getProject(@NotNull String projectKey) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProjectByCurrentKey(...)");
        return project;
    }

    @Nullable
    public final Project getProjectById(long projectId) {
        return this.projectManager.getProjectObj(Long.valueOf(projectId));
    }
}

