/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.common.PluginAccessorExtensionsKt;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.allinonpbp.AllInOnPbpTasklistProjectsEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.sen.JiraLicenseInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.serverdataextractors.AttachmentStatsDto;
import com.atlassian.jira.migration.serverdataextractors.JiraProductType;
import com.atlassian.jira.migration.serverdataextractors.JiraServerStatsReader;
import com.atlassian.jira.migration.serverdataextractors.ProductExistenceDto;
import com.atlassian.jira.migration.serverdataextractors.ProjectSearchMetadataDto;
import com.atlassian.jira.migration.serverdataextractors.ProjectSearchResultDto;
import com.atlassian.jira.migration.serverdataextractors.ProjectTypeFilter;
import com.atlassian.jira.migration.serverdataextractors.ProjectTypeStatsDto;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import com.atlassian.jira.migration.serverdataextractors.SortKey;
import com.atlassian.jira.migration.serverdataextractors.SortOptions;
import com.atlassian.jira.migration.serverdataextractors.SortOrder;
import com.atlassian.jira.migration.serverdataextractors.StatsDto;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserGroupCount;
import com.atlassian.jira.migration.utility.JsmUtility;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 y2\u00020\u0001:\u0001yBA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020#0(H\u0002J\u0016\u0010*\u001a\u00020+2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(H\u0002J\u0016\u0010,\u001a\u00020-2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(H\u0002J\u001a\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020#2\b\u00101\u001a\u0004\u0018\u000102H\u0002J\u001a\u00103\u001a\u00020/2\u0006\u00100\u001a\u00020#2\b\u00104\u001a\u0004\u0018\u00010\u0013H\u0002J \u00105\u001a\b\u0012\u0004\u0012\u00020#0(2\u0010\b\u0002\u00106\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u000107H\u0002J\f\u00108\u001a\b\u0012\u0004\u0012\u00020#0(J\b\u00109\u001a\u00020+H\u0002J\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020#0(2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00130(J$\u0010;\u001a\u00020<2\u0010\b\u0002\u00106\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u0001072\n\b\u0002\u0010=\u001a\u0004\u0018\u00010>J\u000f\u0010?\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020+H\u0002J\u000f\u0010B\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010@J\u000f\u0010C\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010@J\u000f\u0010D\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010@J\u000f\u0010E\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010@J\b\u0010F\u001a\u00020GH\u0002J\u0006\u0010H\u001a\u00020/J\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LJ\b\u0010M\u001a\u00020+H\u0002J\b\u0010N\u001a\u00020+H\u0002J\b\u0010O\u001a\u00020+H\u0002J\b\u0010P\u001a\u00020+H\u0002J\b\u0010Q\u001a\u00020+H\u0002J\u0010\u0010R\u001a\u00020\u00012\u0006\u0010S\u001a\u00020\u0013H\u0002J\b\u0010T\u001a\u00020+H\u0002J\b\u0010U\u001a\u00020GH\u0002J\u000e\u0010V\u001a\u0002022\u0006\u0010W\u001a\u000202J\u000e\u0010V\u001a\u00020\u00132\u0006\u0010W\u001a\u00020\u0013JC\u0010X\u001a\u00020Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020#0[2\b\u0010\\\u001a\u0004\u0018\u00010-2\b\u0010]\u001a\u0004\u0018\u00010-2\b\u0010^\u001a\u0004\u0018\u00010!2\b\u0010_\u001a\u0004\u0018\u00010`H\u0002\u00a2\u0006\u0002\u0010aJ\u0006\u0010b\u001a\u00020cJS\u0010d\u001a\u00020Y2\b\u00104\u001a\u0004\u0018\u00010\u00132\b\u0010\\\u001a\u0004\u0018\u00010-2\b\u0010]\u001a\u0004\u0018\u00010-2\b\u0010e\u001a\u0004\u0018\u00010f2\b\u0010g\u001a\u0004\u0018\u0001022\b\u0010h\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010i\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u0010jJ\u0006\u0010k\u001a\u00020lJ\b\u0010m\u001a\u00020cH\u0007J:\u0010n\u001a\u00020c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(2\"\u0010o\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020q0pj\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020q`rH\u0002J\u001c\u0010s\u001a\u00020/*\u00020#2\u0006\u0010t\u001a\u00020+2\u0006\u0010u\u001a\u00020vH\u0002J\u0014\u0010w\u001a\u00020/*\u00020#2\u0006\u0010x\u001a\u00020/H\u0002R(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020!\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020#0\"j\b\u0012\u0004\u0012\u00020#`$0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;", "", "jiraServerStatsReader", "Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;", "jsmUtility", "Lcom/atlassian/jira/migration/utility/JsmUtility;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "executor", "Ljava/util/concurrent/ExecutorService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/utility/JsmUtility;Lcom/atlassian/plugin/PluginAccessor;Lcom/atlassian/jira/migration/features/MigrationFeatures;Ljava/util/concurrent/ExecutorService;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "cachedStats", "Lcom/google/common/cache/LoadingCache;", "", "getCachedStats$annotations", "()V", "getCachedStats", "()Lcom/google/common/cache/LoadingCache;", "loader", "Lcom/google/common/cache/CacheLoader;", "getLoader", "()Lcom/google/common/cache/CacheLoader;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sortKeyMap", "Ljava/util/EnumMap;", "Lcom/atlassian/jira/migration/serverdataextractors/SortKey;", "Ljava/util/Comparator;", "Lcom/atlassian/jira/migration/serverdataextractors/ServerProjectDto;", "Lkotlin/Comparator;", "computeAttachmentsStats", "Lcom/atlassian/jira/migration/serverdataextractors/AttachmentStatsDto;", "filteredProjectStats", "", "computeProjectStats", "computeTotalIssues", "", "computeTotalProjects", "", "filterProjectsByProjectFilterType", "", "project", "projectFilterType", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectTypeFilter;", "filterProjectsBySearchText", "searchText", "getFilteredProjectStats", "projectKeys", "", "getOrComputeProjectStats", "getPlanBaseEstimateSeconds", "getProjects", "getServerStats", "Lcom/atlassian/jira/migration/serverdataextractors/StatsDto;", "singlePathMode", "Lcom/atlassian/jira/migration/plan/SinglePathMode;", "getTotalCustomers", "()Ljava/lang/Long;", "getTotalDashboards", "getTotalFilters", "getTotalObjectSchemas", "getTotalObjects", "getTotalRapidViews", "getUsersAndGroups", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserGroupCount;", "isAdvancedRoadmapsAvailable", "isProductPresent", "Lcom/atlassian/jira/migration/serverdataextractors/ProductExistenceDto;", "productType", "Lcom/atlassian/jira/migration/serverdataextractors/JiraProductType;", "loadAllDashboardsCount", "loadAllFiltersCount", "loadAllObjectSchemasCount", "loadAllObjectsCount", "loadAllRapidViewsCount", "loadCache", "key", "loadJsmUsersCount", "loadUsersAndGroupsCount", "mapToJiraProjectType", "projectTypeToTransform", "paginateServerProjectDtos", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectSearchResultDto;", "serverProjectDtoStream", "Lkotlin/sequences/Sequence;", "offset", "limit", "sortKey", "sortOrder", "Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;", "(Lkotlin/sequences/Sequence;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/atlassian/jira/migration/serverdataextractors/SortKey;Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;)Lcom/atlassian/jira/migration/serverdataextractors/ProjectSearchResultDto;", "resetCache", "", "searchProjects", "sortOptions", "Lcom/atlassian/jira/migration/serverdataextractors/SortOptions;", "projectTypeFilter", "category", "selectAllDataMode", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/atlassian/jira/migration/serverdataextractors/SortOptions;Lcom/atlassian/jira/migration/serverdataextractors/ProjectTypeFilter;Ljava/lang/String;Ljava/lang/Boolean;)Lcom/atlassian/jira/migration/serverdataextractors/ProjectSearchResultDto;", "searchProjectsMetadata", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectSearchMetadataDto;", "shutdown", "updateProjectStatsOf", "projectStatsOf", "Ljava/util/HashMap;", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectTypeStatsDto;", "Lkotlin/collections/HashMap;", "isActiveSince", "amount", "unit", "Ljava/time/temporal/TemporalUnit;", "isJiraProject", "archived", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServerDataAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerDataAggregator.kt\ncom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,446:1\n1#2:447\n1#2:461\n766#3:448\n857#3,2:449\n1603#3,9:451\n1855#3:460\n1856#3:462\n1612#3:463\n766#3:464\n857#3,2:465\n1855#3,2:467\n*S KotlinDebug\n*F\n+ 1 ServerDataAggregator.kt\ncom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator\n*L\n220#1:461\n201#1:448\n201#1:449,2\n220#1:451,9\n220#1:460\n220#1:462\n220#1:463\n281#1:464\n281#1:465,2\n301#1:467,2\n*E\n"})
public final class ServerDataAggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraServerStatsReader jiraServerStatsReader;
    @NotNull
    private final JsmUtility jsmUtility;
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private final Logger log;
    @NotNull
    private final EnumMap<SortKey, Comparator<ServerProjectDto>> sortKeyMap;
    @NotNull
    private final CacheLoader<String, Object> loader;
    @NotNull
    private final LoadingCache<String, Object> cachedStats;
    private static final long MAXIMUM_CACHE_SIZE = 6L;
    private static final long REFRESH_TIME = 5L;
    private static final long EXPIRE_TIME = 60L;
    private static final long DAYS_30 = 30L;
    private static final long DAYS_90 = 90L;
    @NotNull
    public static final String ADVANCED_ROADMAPS_PLUGIN_KEY = "com.radiantminds.roadmaps-jira";

    /*
     * WARNING - void declaration
     */
    @Inject
    public ServerDataAggregator(@NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull JsmUtility jsmUtility, @NotNull PluginAccessor pluginAccessor, @NotNull MigrationFeatures migrationFeatures, @NotNull ExecutorService executor, @NotNull SENSupplier senSupplier, @NotNull MigrationEventBus migrationEventBus) {
        void $this$sortKeyMap_u24lambda_u246;
        EnumMap enumMap;
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)jsmUtility, (String)"jsmUtility");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.jiraServerStatsReader = jiraServerStatsReader;
        this.jsmUtility = jsmUtility;
        this.pluginAccessor = pluginAccessor;
        this.migrationFeatures = migrationFeatures;
        this.executor = executor;
        this.senSupplier = senSupplier;
        this.migrationEventBus = migrationEventBus;
        this.log = LoggerFactory.getLogger(ServerDataAggregator.class);
        EnumMap enumMap2 = enumMap = new EnumMap(SortKey.class);
        ServerDataAggregator serverDataAggregator = this;
        boolean bl = false;
        Comparator comparator = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        $this$sortKeyMap_u24lambda_u246.put((Enum)SortKey.NAME, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                ServerProjectDto serverProjectDto = (ServerProjectDto)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                ServerProjectDto p0 = (ServerProjectDto)b;
                String string = p0.getName();
                bl = false;
                String string2 = p0.getName();
                return comparator.compare(string, string2);
            }
        });
        comparator = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        $this$sortKeyMap_u24lambda_u246.put((Enum)SortKey.KEY, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                ServerProjectDto serverProjectDto = (ServerProjectDto)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                ServerProjectDto p0 = (ServerProjectDto)b;
                String string = p0.getKey();
                bl = false;
                String string2 = p0.getKey();
                return comparator.compare(string, string2);
            }
        });
        comparator = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        $this$sortKeyMap_u24lambda_u246.put((Enum)SortKey.LEAD, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                ServerProjectDto it;
                ServerProjectDto serverProjectDto = (ServerProjectDto)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                String string = it.getLead();
                if (string == null) {
                    string = "";
                }
                it = (ServerProjectDto)b;
                String string2 = string;
                bl = false;
                String string3 = it.getLead();
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = string3;
                return comparator.compare(string2, string4);
            }
        });
        $this$sortKeyMap_u24lambda_u246.put((Enum)SortKey.ISSUE, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ServerProjectDto p0 = (ServerProjectDto)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getTotalIssues());
                p0 = (ServerProjectDto)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getTotalIssues()));
            }
        });
        $this$sortKeyMap_u24lambda_u246.put((Enum)SortKey.ATTACHMENT, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ServerProjectDto it = (ServerProjectDto)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getAttachments().getTotalSizeBytes());
                it = (ServerProjectDto)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getAttachments().getTotalSizeBytes()));
            }
        });
        $this$sortKeyMap_u24lambda_u246.put((Enum)SortKey.EST_TIME, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ServerProjectDto p0 = (ServerProjectDto)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(p0.getMigrationEstimateSeconds());
                p0 = (ServerProjectDto)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getMigrationEstimateSeconds()));
            }
        });
        $this$sortKeyMap_u24lambda_u246.put((Enum)SortKey.LAST_ACTIVE, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ServerProjectDto p0 = (ServerProjectDto)a;
                boolean bl = false;
                Comparable comparable = p0.getLastActive();
                p0 = (ServerProjectDto)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)p0.getLastActive());
            }
        });
        serverDataAggregator.sortKeyMap = enumMap;
        this.loader = (CacheLoader)new CacheLoader<String, Object>(this){
            final /* synthetic */ ServerDataAggregator this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Object load(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return ServerDataAggregator.access$loadCache(this.this$0, key);
            }
        };
        LoadingCache loadingCache = CacheBuilder.newBuilder().maximumSize(6L).refreshAfterWrite(5L, TimeUnit.MINUTES).expireAfterWrite(60L, TimeUnit.MINUTES).build(CacheLoader.asyncReloading(this.loader, (Executor)this.executor));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.cachedStats = loadingCache;
    }

    public /* synthetic */ ServerDataAggregator(JiraServerStatsReader jiraServerStatsReader, JsmUtility jsmUtility, PluginAccessor pluginAccessor, MigrationFeatures migrationFeatures, ExecutorService executorService, SENSupplier sENSupplier, MigrationEventBus migrationEventBus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            ExecutorService executorService2 = Executors.newFixedThreadPool(1, new GroupedThreadFactory("ServerDataAggregator"));
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newFixedThreadPool(...)");
            executorService = executorService2;
        }
        this(jiraServerStatsReader, jsmUtility, pluginAccessor, migrationFeatures, executorService, sENSupplier, migrationEventBus);
    }

    @NotNull
    public final CacheLoader<String, Object> getLoader() {
        return this.loader;
    }

    @NotNull
    public final LoadingCache<String, Object> getCachedStats() {
        return this.cachedStats;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCachedStats$annotations() {
    }

    private final Object loadCache(String key) {
        Object object;
        switch (key) {
            case "STATS": {
                object = this.computeProjectStats();
                break;
            }
            case "USERS": {
                UserGroupCount userGroupCount;
                UserGroupCount count2 = userGroupCount = this.loadUsersAndGroupsCount();
                boolean bl = false;
                this.log.info("Number of users and groups loaded {}, {}", (Object)count2.getUsersCount(), (Object)count2.getGroupsCount());
                object = userGroupCount;
                break;
            }
            case "JSM_COUNT": {
                Long l = this.loadJsmUsersCount();
                long count3 = ((Number)l).longValue();
                boolean bl = false;
                this.log.info("Number of customers loaded {}", (Object)count3);
                object = l;
                break;
            }
            case "ALL_RAPID_VIEWS_COUNT": {
                Long l = this.loadAllRapidViewsCount();
                long count4 = ((Number)l).longValue();
                boolean bl = false;
                this.log.info("Number of RapidViews loaded {}", (Object)count4);
                object = l;
                break;
            }
            case "ALL_FILTERS_COUNT": {
                Long l = this.loadAllFiltersCount();
                long count5 = ((Number)l).longValue();
                boolean bl = false;
                this.log.info("Number of filters loaded {}", (Object)count5);
                object = l;
                break;
            }
            case "ALL_DASHBOARDS_COUNT": {
                Long l = this.loadAllDashboardsCount();
                long count6 = ((Number)l).longValue();
                boolean bl = false;
                this.log.info("Number of Dashboards loaded {}", (Object)count6);
                object = l;
                break;
            }
            case "ALL_OBJECT_SCHEMAS_COUNT": {
                Long l = this.loadAllObjectSchemasCount();
                long count7 = ((Number)l).longValue();
                boolean bl = false;
                this.log.info("Number of object schemas loaded {}", (Object)count7);
                object = l;
                break;
            }
            case "ALL_OBJECTS_COUNT": {
                Long l = this.loadAllObjectsCount();
                long count8 = ((Number)l).longValue();
                boolean bl = false;
                this.log.info("Number of objects loaded {}", (Object)count8);
                object = l;
                break;
            }
            default: {
                throw new IllegalStateException(("Unhandled cache key " + key).toString());
            }
        }
        return object;
    }

    private final long loadAllRapidViewsCount() {
        return this.migrationFeatures.getEnableCrossProjectBoardsAndFilters() ? this.jiraServerStatsReader.fetchAllRapidViewsCount() : -1L;
    }

    private final long loadAllFiltersCount() {
        return this.migrationFeatures.getEnableCrossProjectBoardsAndFilters() ? this.jiraServerStatsReader.fetchAllFiltersCount() : -1L;
    }

    private final long loadAllDashboardsCount() {
        return this.jiraServerStatsReader.calculateNumberOfPortalPage();
    }

    private final long loadAllObjectSchemasCount() {
        return this.jiraServerStatsReader.calculateNumberOfObjectSchema();
    }

    private final long loadAllObjectsCount() {
        return this.jiraServerStatsReader.calculateNumberOfObject();
    }

    public final void resetCache() {
        this.cachedStats.invalidateAll();
    }

    private final List<ServerProjectDto> computeProjectStats() {
        return JiraServerStatsReader.computeProjectStats$default(this.jiraServerStatsReader, null, 1, null);
    }

    private final UserGroupCount loadUsersAndGroupsCount() {
        return new UserGroupCount(JiraServerStatsReader.getAllUsersCount$default(this.jiraServerStatsReader, null, 1, null), this.jiraServerStatsReader.getAllGroupsCount());
    }

    private final long loadJsmUsersCount() {
        return this.jiraServerStatsReader.getAllJSMCustomerCount();
    }

    @NotNull
    public final ProjectSearchResultDto searchProjects(@Nullable String searchText, @Nullable Integer offset, @Nullable Integer limit, @Nullable SortOptions sortOptions, @Nullable ProjectTypeFilter projectTypeFilter, @Nullable String category, @Nullable Boolean selectAllDataMode) {
        List<ServerProjectDto> allProjectServerStats = this.getOrComputeProjectStats();
        if (this.migrationFeatures.getEnableAllInOnPbpFeature() && Intrinsics.areEqual((Object)selectAllDataMode, (Object)true)) {
            this.log.info("Fetched " + allProjectServerStats.size() + " projects info for SELECT ALL DATA mode");
            this.migrationEventBus.post(new AllInOnPbpTasklistProjectsEvent(allProjectServerStats));
            return new ProjectSearchResultDto(allProjectServerStats.size(), 0, Integer.MAX_VALUE, allProjectServerStats);
        }
        Sequence filteredServerProjectDtos2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allProjectServerStats), (Function1)((Function1)new Function1<ServerProjectDto, Boolean>(this, searchText){
            final /* synthetic */ ServerDataAggregator this$0;
            final /* synthetic */ String $searchText;
            {
                this.this$0 = $receiver;
                this.$searchText = $searchText;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ServerProjectDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ServerDataAggregator.access$filterProjectsBySearchText(this.this$0, it, this.$searchText);
            }
        })), (Function1)((Function1)new Function1<ServerProjectDto, Boolean>(category){
            final /* synthetic */ String $category;
            {
                this.$category = $category;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ServerProjectDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CharSequence charSequence = this.$category;
                return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)it.getCategory(), (Object)this.$category);
            }
        })), (Function1)((Function1)new Function1<ServerProjectDto, Boolean>(this, projectTypeFilter){
            final /* synthetic */ ServerDataAggregator this$0;
            final /* synthetic */ ProjectTypeFilter $projectTypeFilter;
            {
                this.this$0 = $receiver;
                this.$projectTypeFilter = $projectTypeFilter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ServerProjectDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ServerDataAggregator.access$filterProjectsByProjectFilterType(this.this$0, it, this.$projectTypeFilter);
            }
        }));
        SortOptions sortOptions2 = sortOptions;
        SortOptions sortOptions3 = sortOptions;
        return this.paginateServerProjectDtos((Sequence<ServerProjectDto>)filteredServerProjectDtos2, offset, limit, sortOptions2 != null ? sortOptions2.getSortKey() : null, sortOptions3 != null ? sortOptions3.getSortOrder() : null);
    }

    public static /* synthetic */ ProjectSearchResultDto searchProjects$default(ServerDataAggregator serverDataAggregator, String string, Integer n, Integer n2, SortOptions sortOptions, ProjectTypeFilter projectTypeFilter, String string2, Boolean bl, int n3, Object object) {
        if ((n3 & 0x40) != 0) {
            bl = null;
        }
        return serverDataAggregator.searchProjects(string, n, n2, sortOptions, projectTypeFilter, string2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean filterProjectsBySearchText(ServerProjectDto project, String searchText) {
        CharSequence charSequence = searchText;
        if (charSequence == null) return true;
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (StringsKt.contains((CharSequence)project.getName(), (CharSequence)searchText, (boolean)true)) return true;
        if (StringsKt.contains((CharSequence)project.getKey(), (CharSequence)searchText, (boolean)true)) return true;
        String string = project.getLead();
        if (string == null) return false;
        boolean bl2 = StringsKt.contains((CharSequence)string, (CharSequence)searchText, (boolean)true);
        if (!bl2) return false;
        return true;
    }

    private final boolean filterProjectsByProjectFilterType(ServerProjectDto project, ProjectTypeFilter projectFilterType) {
        boolean bl;
        ProjectTypeFilter projectTypeFilter = projectFilterType;
        switch (projectTypeFilter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[projectTypeFilter.ordinal()]) {
            case -1: {
                bl = true;
                break;
            }
            case 1: {
                if (Intrinsics.areEqual((Object)ProjectTypeFilter.BUSINESS.getType(), (Object)project.getType()) && project.isArchived()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)ProjectTypeFilter.SOFTWARE.getType(), (Object)project.getType()) && project.isArchived()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)ProjectTypeFilter.SERVICE_DESK.getType(), (Object)project.getType()) && project.isArchived()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                bl = this.isJiraProject(project, false);
                break;
            }
            case 5: {
                bl = this.isJiraProject(project, true);
                break;
            }
            case 6: {
                if (!this.isActiveSince(project, 30L, ChronoUnit.DAYS)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                if (!this.isActiveSince(project, 90L, ChronoUnit.DAYS)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = Intrinsics.areEqual((Object)project.getType(), (Object)projectFilterType.getType()) && !project.isArchived();
            }
        }
        return bl;
    }

    private final boolean isJiraProject(ServerProjectDto $this$isJiraProject, boolean archived) {
        return (Intrinsics.areEqual((Object)ProjectTypeFilter.BUSINESS.getType(), (Object)$this$isJiraProject.getType()) || Intrinsics.areEqual((Object)ProjectTypeFilter.SOFTWARE.getType(), (Object)$this$isJiraProject.getType())) && $this$isJiraProject.isArchived() == archived;
    }

    private final boolean isActiveSince(ServerProjectDto $this$isActiveSince, long amount, TemporalUnit unit) {
        return $this$isActiveSince.getLastActive() != null && $this$isActiveSince.getLastActive().isAfter(Instant.now().minus(amount, unit));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ServerProjectDto> getProjects(@NotNull List<String> projectKeys) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        Iterable $this$filter$iv = this.getOrComputeProjectStats();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerProjectDto it = (ServerProjectDto)element$iv$iv;
            boolean bl = false;
            if (!projectKeys.contains(it.getKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProjectSearchMetadataDto searchProjectsMetadata() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List<ServerProjectDto> serverProjectDtos = this.getOrComputeProjectStats();
        Iterable iterable = serverProjectDtos;
        List list = CollectionsKt.emptyList();
        List list2 = SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)serverProjectDtos), (Function1)((Function1)new Function1<ServerProjectDto, ProjectTypeFilter>((Object)ProjectTypeFilter.Companion){

            @NotNull
            public final ProjectTypeFilter invoke(@NotNull ServerProjectDto p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ProjectTypeFilter.Companion)this.receiver).fromProjectDto(p0);
            }
        })), (Function1)((Function1)new Function1<ProjectTypeFilter, ProjectTypeFilter>(this){
            final /* synthetic */ ServerDataAggregator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ProjectTypeFilter invoke(@NotNull ProjectTypeFilter it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return this.this$0.mapToJiraProjectType(it);
            }
        })))), (Object)((Object)ProjectTypeFilter.INACTIVE_30)), (Object)((Object)ProjectTypeFilter.INACTIVE_90)));
        long l = this.getPlanBaseEstimateSeconds();
        boolean $i$f$mapNotNull = false;
        void var4_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ServerProjectDto it = (ServerProjectDto)element$iv$iv;
            boolean bl2 = false;
            if (it.getCategory() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List list4 = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)list3));
        List list5 = list;
        List list6 = list2;
        long l2 = l;
        return new ProjectSearchMetadataDto(l2, list6, list5, list4);
    }

    @NotNull
    public final ProjectTypeFilter mapToJiraProjectType(@NotNull ProjectTypeFilter projectTypeToTransform) {
        ProjectTypeFilter projectTypeFilter;
        Intrinsics.checkNotNullParameter((Object)((Object)projectTypeToTransform), (String)"projectTypeToTransform");
        switch (WhenMappings.$EnumSwitchMapping$0[projectTypeToTransform.ordinal()]) {
            case 8: 
            case 9: {
                projectTypeFilter = ProjectTypeFilter.JIRA;
                break;
            }
            case 1: 
            case 2: {
                projectTypeFilter = ProjectTypeFilter.JIRA_ARCHIVED;
                break;
            }
            default: {
                projectTypeFilter = projectTypeToTransform;
            }
        }
        return projectTypeFilter;
    }

    @NotNull
    public final String mapToJiraProjectType(@NotNull String projectTypeToTransform) {
        Intrinsics.checkNotNullParameter((Object)projectTypeToTransform, (String)"projectTypeToTransform");
        String string = projectTypeToTransform;
        return (Intrinsics.areEqual((Object)string, (Object)ProjectTypeFilter.BUSINESS.getType()) ? true : Intrinsics.areEqual((Object)string, (Object)ProjectTypeFilter.SOFTWARE.getType())) ? ProjectTypeFilter.JIRA.getType() : ((Intrinsics.areEqual((Object)string, (Object)ProjectTypeFilter.BUSINESS_ARCHIVED.getType()) ? true : Intrinsics.areEqual((Object)string, (Object)ProjectTypeFilter.SOFTWARE_ARCHIVED.getType())) ? ProjectTypeFilter.JIRA_ARCHIVED.getType() : projectTypeToTransform);
    }

    @NotNull
    public final List<ServerProjectDto> getOrComputeProjectStats() {
        Object object = this.cachedStats.get((Object)"STATS");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<com.atlassian.jira.migration.serverdataextractors.ServerProjectDto>");
        return (List)object;
    }

    private final long getPlanBaseEstimateSeconds() {
        Object object = this.cachedStats.get((Object)"USERS");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.serverdataextractors.usergroup.UserGroupCount");
        UserGroupCount usersGroupsCount = (UserGroupCount)object;
        return JiraServerStatsReader.estimatedMigrationTimeSeconds$default(this.jiraServerStatsReader, 0L, null, usersGroupsCount.getGroupsCount() + usersGroupsCount.getUsersCount(), 0L, false, 27, null);
    }

    private final ProjectSearchResultDto paginateServerProjectDtos(Sequence<ServerProjectDto> serverProjectDtoStream, Integer offset, Integer limit, SortKey sortKey, SortOrder sortOrder) {
        Comparator<ServerProjectDto> comparator;
        block3: {
            block2: {
                comparator = this.sortKeyMap.get((Object)sortKey);
                if (comparator == null) break block2;
                Comparator<ServerProjectDto> comparator2 = comparator;
                boolean bl = false;
                Comparator<ServerProjectDto> comparator3 = sortOrder == SortOrder.DESC ? comparator2.reversed() : comparator2;
                Intrinsics.checkNotNull(comparator3);
                List list = SequencesKt.toList((Sequence)SequencesKt.sortedWith(serverProjectDtoStream, comparator3));
                comparator = list;
                if (list != null) break block3;
            }
            comparator = SequencesKt.toList(serverProjectDtoStream);
        }
        Comparator<ServerProjectDto> sortedServerProjectDtos = comparator;
        Integer n = limit;
        int safeLimit = n != null ? n : Integer.MAX_VALUE;
        Integer n2 = offset;
        int safeOffset = n2 != null ? n2 : 0;
        List<ServerProjectDto> paginatedServerProjectDto = sortedServerProjectDtos.subList(Math.min(safeOffset, sortedServerProjectDtos.size()), Math.min(safeOffset + safeLimit, sortedServerProjectDtos.size()));
        return new ProjectSearchResultDto(sortedServerProjectDtos.size(), safeOffset, safeLimit, paginatedServerProjectDto);
    }

    public final boolean isAdvancedRoadmapsAvailable() {
        return this.pluginAccessor.getPlugin(ADVANCED_ROADMAPS_PLUGIN_KEY) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServerProjectDto> getFilteredProjectStats(Collection<String> projectKeys) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOrComputeProjectStats();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerProjectDto it = (ServerProjectDto)element$iv$iv;
            boolean bl = false;
            boolean bl2 = projectKeys == null ? true : projectKeys.contains(it.getKey());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getFilteredProjectStats$default(ServerDataAggregator serverDataAggregator, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            collection = null;
        }
        return serverDataAggregator.getFilteredProjectStats(collection);
    }

    private final AttachmentStatsDto computeAttachmentsStats(List<ServerProjectDto> filteredProjectStats) {
        long l;
        ServerProjectDto it;
        long l2;
        Iterable iterable = filteredProjectStats;
        long l3 = 0L;
        for (Object t : iterable) {
            ServerProjectDto serverProjectDto = (ServerProjectDto)t;
            l2 = l3;
            boolean bl = false;
            l = it.getAttachments().getTotalAttachments();
            l3 = l2 + l;
        }
        iterable = filteredProjectStats;
        l2 = l3;
        l3 = 0L;
        for (Object t : iterable) {
            it = (ServerProjectDto)t;
            l = l3;
            boolean bl = false;
            long l4 = it.getAttachments().getTotalSizeBytes();
            l3 = l + l4;
        }
        long l5 = l = l3;
        long l6 = l2;
        return new AttachmentStatsDto(l6, l5);
    }

    /*
     * WARNING - void declaration
     */
    private final long computeTotalIssues(List<ServerProjectDto> filteredProjectStats) {
        Iterable iterable = filteredProjectStats;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            ServerProjectDto serverProjectDto = (ServerProjectDto)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getTotalIssues();
            l = l2 + l3;
        }
        return l;
    }

    private final int computeTotalProjects(List<ServerProjectDto> filteredProjectStats) {
        return ((Collection)filteredProjectStats).size();
    }

    private final void updateProjectStatsOf(List<ServerProjectDto> filteredProjectStats, HashMap<String, ProjectTypeStatsDto> projectStatsOf) {
        Iterable $this$forEach$iv = filteredProjectStats;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerProjectDto it = (ServerProjectDto)element$iv;
            boolean bl = false;
            projectStatsOf.computeIfPresent(this.mapToJiraProjectType(it.getType()), (arg_0, arg_1) -> ServerDataAggregator.updateProjectStatsOf$lambda$23$lambda$21((Function2)new Function2<String, ProjectTypeStatsDto, ProjectTypeStatsDto>(it){
                final /* synthetic */ ServerProjectDto $it;
                {
                    this.$it = $it;
                    super(2);
                }

                @Nullable
                public final ProjectTypeStatsDto invoke(@NotNull String string, @NotNull ProjectTypeStatsDto existingValue) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)existingValue, (String)"existingValue");
                    existingValue.setTotalProjects(existingValue.getTotalProjects() + 1L);
                    existingValue.setTotalIssues(existingValue.getTotalIssues() + this.$it.getTotalIssues());
                    existingValue.setAttachments(existingValue.getAttachments().plus(new AttachmentStatsDto(this.$it.getAttachments().getTotalAttachments(), this.$it.getAttachments().getTotalSizeBytes())));
                    return existingValue;
                }
            }, arg_0, arg_1));
            projectStatsOf.computeIfAbsent(this.mapToJiraProjectType(it.getType()), arg_0 -> ServerDataAggregator.updateProjectStatsOf$lambda$23$lambda$22((Function1)new Function1<String, ProjectTypeStatsDto>(it){
                final /* synthetic */ ServerProjectDto $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final ProjectTypeStatsDto invoke(@NotNull String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    return new ProjectTypeStatsDto(1L, this.$it.getTotalIssues(), new AttachmentStatsDto(this.$it.getAttachments().getTotalAttachments(), this.$it.getAttachments().getTotalSizeBytes()));
                }
            }, arg_0));
        }
    }

    private final UserGroupCount getUsersAndGroups() {
        Object object = this.cachedStats.get((Object)"USERS");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.serverdataextractors.usergroup.UserGroupCount");
        return (UserGroupCount)object;
    }

    private final Long getTotalCustomers() {
        Long l;
        if (this.jsmUtility.isJsmInstalled()) {
            Object object = this.cachedStats.get((Object)"JSM_COUNT", () -> ServerDataAggregator.getTotalCustomers$lambda$24(this));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            l = (Long)object;
        } else {
            l = null;
        }
        return l;
    }

    private final Long getTotalRapidViews() {
        Long l;
        JiraLicenseInfo licenses = this.senSupplier.getLicenses();
        if (licenses.getJiraSoftwareLicense() != null && this.migrationFeatures.getEnableCrossProjectBoardsAndFilters() && PluginAccessorExtensionsKt.hasJswInstalled(this.pluginAccessor)) {
            Object object = this.cachedStats.get((Object)"ALL_RAPID_VIEWS_COUNT");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            l = (Long)object;
        } else {
            l = null;
        }
        return l;
    }

    private final Long getTotalFilters() {
        Long l;
        if (this.migrationFeatures.getEnableCrossProjectBoardsAndFilters()) {
            Object object = this.cachedStats.get((Object)"ALL_FILTERS_COUNT");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            l = (Long)object;
        } else {
            l = null;
        }
        return l;
    }

    private final long getTotalDashboards() {
        Object object = this.cachedStats.get((Object)"ALL_DASHBOARDS_COUNT");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    private final Long getTotalObjectSchemas() {
        Long l;
        if (this.migrationFeatures.getEnableAssetsMigration()) {
            Object object = this.cachedStats.get((Object)"ALL_OBJECT_SCHEMAS_COUNT");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            l = (Long)object;
        } else {
            l = null;
        }
        return l;
    }

    private final Long getTotalObjects() {
        Long l;
        if (this.migrationFeatures.getEnableAssetsMigration()) {
            Object object = this.cachedStats.get((Object)"ALL_OBJECTS_COUNT");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            l = (Long)object;
        } else {
            l = null;
        }
        return l;
    }

    @NotNull
    public final StatsDto getServerStats(@Nullable Collection<String> projectKeys, @Nullable SinglePathMode singlePathMode) {
        HashMap<String, ProjectTypeStatsDto> hashMap;
        HashMap<String, ProjectTypeStatsDto> $this$getServerStats_u24lambda_u2425 = hashMap = new HashMap<String, ProjectTypeStatsDto>();
        boolean bl = false;
        $this$getServerStats_u24lambda_u2425.put(ProjectTypeFilter.JIRA.getType(), new ProjectTypeStatsDto(0L, 0L, new AttachmentStatsDto(0L, 0L)));
        $this$getServerStats_u24lambda_u2425.put(ProjectTypeFilter.SERVICE_DESK.getType(), new ProjectTypeStatsDto(0L, 0L, new AttachmentStatsDto(0L, 0L)));
        HashMap<String, ProjectTypeStatsDto> projectStatsOf = hashMap;
        if (singlePathMode == SinglePathMode.LIFT_AND_SHIFT) {
            return new StatsDto(new AttachmentStatsDto(0L, 0L), 0L, 0, 0L, 0L, 0L, 0L, projectStatsOf, null, null, null, null, null, 7936, null);
        }
        List<ServerProjectDto> filteredProjectStats = this.getFilteredProjectStats(projectKeys);
        this.updateProjectStatsOf(filteredProjectStats, projectStatsOf);
        AttachmentStatsDto attachmentData = this.computeAttachmentsStats(filteredProjectStats);
        long totalIssues = this.computeTotalIssues(filteredProjectStats);
        Long totalCustomers = this.getTotalCustomers();
        UserGroupCount usersAndGroups = this.getUsersAndGroups();
        long totalUsers = usersAndGroups.getUsersCount();
        long totalGroups = usersAndGroups.getGroupsCount();
        Long l = totalCustomers;
        return new StatsDto(attachmentData, JiraServerStatsReader.estimatedMigrationTimeSeconds$default(this.jiraServerStatsReader, totalIssues, attachmentData, totalUsers + totalGroups, l != null ? l : 0L, false, 16, null), this.computeTotalProjects(filteredProjectStats), totalIssues, totalUsers, totalGroups, totalCustomers, (Map<String, ProjectTypeStatsDto>)projectStatsOf, this.getTotalRapidViews(), this.getTotalFilters(), this.getTotalDashboards(), this.getTotalObjectSchemas(), this.getTotalObjects());
    }

    public static /* synthetic */ StatsDto getServerStats$default(ServerDataAggregator serverDataAggregator, Collection collection, SinglePathMode singlePathMode, int n, Object object) {
        if ((n & 1) != 0) {
            collection = null;
        }
        if ((n & 2) != 0) {
            singlePathMode = null;
        }
        return serverDataAggregator.getServerStats(collection, singlePathMode);
    }

    @NotNull
    public final ProductExistenceDto isProductPresent(@NotNull JiraProductType productType) {
        ProductExistenceDto productExistenceDto;
        Intrinsics.checkNotNullParameter((Object)((Object)productType), (String)"productType");
        switch (WhenMappings.$EnumSwitchMapping$1[productType.ordinal()]) {
            case 1: {
                productExistenceDto = new ProductExistenceDto(productType.toString(), this.jsmUtility.isJsmInstalled());
                break;
            }
            case 2: {
                productExistenceDto = new ProductExistenceDto(productType.toString(), this.jsmUtility.isJswInstalled());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return productExistenceDto;
    }

    @PreDestroy
    public final void shutdown() {
        this.executor.shutdownNow();
    }

    private static final ProjectTypeStatsDto updateProjectStatsOf$lambda$23$lambda$21(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProjectTypeStatsDto)$tmp0.invoke(p0, p1);
    }

    private static final ProjectTypeStatsDto updateProjectStatsOf$lambda$23$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProjectTypeStatsDto)$tmp0.invoke(p0);
    }

    private static final Object getTotalCustomers$lambda$24(ServerDataAggregator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.loadJsmUsersCount();
    }

    public static final /* synthetic */ boolean access$filterProjectsBySearchText(ServerDataAggregator $this, ServerProjectDto project, String searchText) {
        return $this.filterProjectsBySearchText(project, searchText);
    }

    public static final /* synthetic */ boolean access$filterProjectsByProjectFilterType(ServerDataAggregator $this, ServerProjectDto project, ProjectTypeFilter projectFilterType) {
        return $this.filterProjectsByProjectFilterType(project, projectFilterType);
    }

    public static final /* synthetic */ Object access$loadCache(ServerDataAggregator $this, String key) {
        return $this.loadCache(key);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator$Companion;", "", "()V", "ADVANCED_ROADMAPS_PLUGIN_KEY", "", "DAYS_30", "", "DAYS_90", "EXPIRE_TIME", "MAXIMUM_CACHE_SIZE", "REFRESH_TIME", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProjectTypeFilter.values().length];
            try {
                nArray[ProjectTypeFilter.BUSINESS_ARCHIVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.SOFTWARE_ARCHIVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.SERVICE_DESK_ARCHIVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.JIRA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.JIRA_ARCHIVED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.INACTIVE_30.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.INACTIVE_90.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.BUSINESS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectTypeFilter.SOFTWARE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JiraProductType.values().length];
            try {
                nArray[JiraProductType.JSM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JiraProductType.JSW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

