/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.serverdataextractors;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.serverdataextractors.ApiModelKt;
import com.atlassian.jira.migration.serverdataextractors.CountDto;
import com.atlassian.jira.migration.serverdataextractors.GetPlanStats;
import com.atlassian.jira.migration.serverdataextractors.JiraProductType;
import com.atlassian.jira.migration.serverdataextractors.ManualImportDuplicatedFileDto;
import com.atlassian.jira.migration.serverdataextractors.ManualInterventionValidationDto;
import com.atlassian.jira.migration.serverdataextractors.ProjectTypeFilter;
import com.atlassian.jira.migration.serverdataextractors.ServerDataAggregator;
import com.atlassian.jira.migration.serverdataextractors.SortKey;
import com.atlassian.jira.migration.serverdataextractors.SortOptions;
import com.atlassian.jira.migration.serverdataextractors.SortOrder;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.DuplicatedFile;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ManualInterventionValidationResult;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ManualInterventionValidator;
import com.atlassian.jira.migration.serverdataextractors.liftandshift.ValidationStatus;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ServiceDeskUserReader;
import com.atlassian.jira.migration.utility.JsmUtility;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/")
@Produces(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0016H\u0007J\b\u0010\u0018\u001a\u00020\u0016H\u0007J\b\u0010\u0019\u001a\u00020\u0016H\u0007J\b\u0010\u001a\u001a\u00020\u0016H\u0007J\u0012\u0010\u001b\u001a\u00020\u00162\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0007Jm\u0010\u001e\u001a\u00020\u00162\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\"2\n\b\u0001\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0001\u0010*\u001a\u0004\u0018\u00010 2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,H\u0007\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u000200H\u0007J\b\u00101\u001a\u00020\u0016H\u0007J\b\u00102\u001a\u00020\u0016H\u0007J \u00103\u001a\u00020\u00162\n\b\u0001\u00104\u001a\u0004\u0018\u00010 2\n\b\u0001\u00105\u001a\u0004\u0018\u00010 H\u0007J \u00106\u001a\u00020\u00162\n\b\u0001\u00104\u001a\u0004\u0018\u00010 2\n\b\u0001\u00107\u001a\u0004\u0018\u00010 H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/atlassian/jira/migration/serverdataextractors/ServerDataResource;", "", "serverDataAggregator", "Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;", "serviceDeskUserReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ServiceDeskUserReader;", "jsmCustomerReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;", "jsmUtility", "Lcom/atlassian/jira/migration/utility/JsmUtility;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "manualInterventionValidator", "Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "(Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ServiceDeskUserReader;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;Lcom/atlassian/jira/migration/utility/JsmUtility;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/serverdataextractors/liftandshift/ManualInterventionValidator;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "advancedRoadmapsStats", "Ljavax/ws/rs/core/Response;", "getHostingType", "getImportFileDirectory", "getJsdCustomersCount", "getJsdUsersCount", "isProductTypePresentOnTheServer", "productType", "Lcom/atlassian/jira/migration/serverdataextractors/JiraProductType;", "listProjects", "searchText", "", "offset", "", "limit", "sortKey", "Lcom/atlassian/jira/migration/serverdataextractors/SortKey;", "sortOrder", "Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;", "type", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectTypeFilter;", "category", "selectAllDataMode", "", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/atlassian/jira/migration/serverdataextractors/SortKey;Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;Lcom/atlassian/jira/migration/serverdataextractors/ProjectTypeFilter;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "planStats", "getPlanStats", "Lcom/atlassian/jira/migration/serverdataextractors/GetPlanStats;", "searchMetadata", "serverStats", "validateImportFile", "directory", "filename", "validateImportFolder", "folderName", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServerDataResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerDataResource.kt\ncom/atlassian/jira/migration/serverdataextractors/ServerDataResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1549#2:194\n1620#2,3:195\n1549#2:198\n1620#2,3:199\n*S KotlinDebug\n*F\n+ 1 ServerDataResource.kt\ncom/atlassian/jira/migration/serverdataextractors/ServerDataResource\n*L\n94#1:194\n94#1:195,3\n182#1:198\n182#1:199,3\n*E\n"})
public final class ServerDataResource {
    @NotNull
    private final ServerDataAggregator serverDataAggregator;
    @NotNull
    private final ServiceDeskUserReader serviceDeskUserReader;
    @NotNull
    private final JsmCustomerReader jsmCustomerReader;
    @NotNull
    private final JsmUtility jsmUtility;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ManualInterventionValidator manualInterventionValidator;
    @NotNull
    private final SENSupplier senSupplier;

    @Inject
    public ServerDataResource(@NotNull ServerDataAggregator serverDataAggregator, @NotNull ServiceDeskUserReader serviceDeskUserReader, @NotNull JsmCustomerReader jsmCustomerReader, @NotNull JsmUtility jsmUtility, @NotNull ProjectManager projectManager, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull MigrationFeatures migrationFeatures, @NotNull ManualInterventionValidator manualInterventionValidator, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter((Object)serverDataAggregator, (String)"serverDataAggregator");
        Intrinsics.checkNotNullParameter((Object)serviceDeskUserReader, (String)"serviceDeskUserReader");
        Intrinsics.checkNotNullParameter((Object)jsmCustomerReader, (String)"jsmCustomerReader");
        Intrinsics.checkNotNullParameter((Object)jsmUtility, (String)"jsmUtility");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)manualInterventionValidator, (String)"manualInterventionValidator");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this.serverDataAggregator = serverDataAggregator;
        this.serviceDeskUserReader = serviceDeskUserReader;
        this.jsmCustomerReader = jsmCustomerReader;
        this.jsmUtility = jsmUtility;
        this.projectManager = projectManager;
        this.localFileDataOutput = localFileDataOutput;
        this.migrationFeatures = migrationFeatures;
        this.manualInterventionValidator = manualInterventionValidator;
        this.senSupplier = senSupplier;
    }

    @GET
    @Path(value="projects")
    @NotNull
    public final Response listProjects(@QueryParam(value="searchText") @Nullable String searchText, @QueryParam(value="offset") @DefaultValue(value="0") @Nullable Integer offset, @QueryParam(value="limit") @Nullable Integer limit, @QueryParam(value="sortKey") @Nullable SortKey sortKey, @QueryParam(value="sortOrder") @Nullable SortOrder sortOrder, @QueryParam(value="type") @Nullable ProjectTypeFilter type, @QueryParam(value="category") @Nullable String category, @QueryParam(value="selectAllDataMode") @Nullable Boolean selectAllDataMode) {
        Response response2 = Response.ok((Object)this.serverDataAggregator.searchProjects(searchText, offset, limit, new SortOptions(sortKey, sortOrder), type, category, selectAllDataMode)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="projects/search-metadata")
    @NotNull
    public final Response searchMetadata() {
        return ResponseUtils.INSTANCE.ok(this.serverDataAggregator.searchProjectsMetadata());
    }

    @GET
    @Path(value="stats/server")
    @NotNull
    public final Response serverStats() {
        return ResponseUtils.INSTANCE.ok(ServerDataAggregator.getServerStats$default(this.serverDataAggregator, null, null, 3, null));
    }

    /*
     * WARNING - void declaration
     */
    @POST
    @Path(value="stats/plan")
    @Consumes(value={"application/json"})
    @NotNull
    public final Response planStats(@NotNull GetPlanStats getPlanStats) {
        Intrinsics.checkNotNullParameter((Object)getPlanStats, (String)"getPlanStats");
        List projectKeys = getPlanStats.getProjectKeys();
        if (getPlanStats.getSinglePathMode() == SinglePathMode.LIFT_AND_SHIFT) {
            void $this$mapTo$iv$iv;
            List list = this.projectManager.getProjects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProjects(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Project project = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            projectKeys = (List)destination$iv$iv;
        }
        return ResponseUtils.INSTANCE.ok(this.serverDataAggregator.getServerStats(projectKeys, getPlanStats.getSinglePathMode()));
    }

    @GET
    @Path(value="stats/advanced-roadmaps")
    @NotNull
    public final Response advancedRoadmapsStats() {
        return ResponseUtils.INSTANCE.ok(this.serverDataAggregator.isAdvancedRoadmapsAvailable());
    }

    @Path(value="stats/jsmUsers")
    @NotNull
    public final Response getJsdUsersCount() {
        return this.jsmUtility.isJsmInstalled() ? ResponseUtils.INSTANCE.ok(new CountDto(this.serviceDeskUserReader.getAllServiceDeskUsersCount())) : ResponseUtils.INSTANCE.notFound();
    }

    @GET
    @Path(value="stats/customers")
    @NotNull
    public final Response getJsdCustomersCount() {
        return this.jsmUtility.isJsmInstalled() ? ResponseUtils.INSTANCE.ok(new CountDto(this.jsmCustomerReader.getAllJsmCustomersCount())) : ResponseUtils.INSTANCE.notFound();
    }

    @GET
    @Path(value="server/product/{productType}")
    @NotNull
    public final Response isProductTypePresentOnTheServer(@PathParam(value="productType") @NotNull JiraProductType productType) {
        Intrinsics.checkNotNullParameter((Object)((Object)productType), (String)"productType");
        return ResponseUtils.INSTANCE.ok(this.serverDataAggregator.isProductPresent(productType));
    }

    @GET
    @Path(value="import/directory")
    @NotNull
    public final Response getImportFileDirectory() {
        return this.migrationFeatures.getEnableSinglePathManualIntervention() ? ResponseUtils.INSTANCE.ok(((Object)this.localFileDataOutput.exportDirectory()).toString()) : ResponseUtils.INSTANCE.notFound();
    }

    @GET
    @Path(value="import/validate")
    @NotNull
    public final Response validateImportFile(@QueryParam(value="directory") @Nullable String directory, @QueryParam(value="filename") @Nullable String filename) {
        Response response2;
        if (!this.migrationFeatures.getEnableSinglePathManualIntervention()) {
            response2 = ResponseUtils.INSTANCE.notFound();
        } else {
            CharSequence charSequence = directory;
            if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)filename) == null || charSequence.length() == 0) {
                response2 = ResponseUtils.INSTANCE.badRequest("Mandatory directory and/or filename parameter(s) missing");
            } else {
                File zipFile = new File(directory, filename);
                if (!FilesKt.startsWith((File)FilesKt.normalize((File)zipFile), (String)directory)) {
                    response2 = ResponseUtils.INSTANCE.badRequest("Could not locate " + zipFile + " under directory " + directory);
                } else {
                    String string = zipFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                    ManualInterventionValidationResult validationResult = this.manualInterventionValidator.validate(string);
                    ValidationStatus validationStatus = validationResult.getValidationStatus();
                    String string2 = zipFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    response2 = ResponseUtils.INSTANCE.ok(new ManualInterventionValidationDto(validationStatus, string2, null, 4, null));
                }
            }
        }
        return response2;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="import/folder/validate")
    @NotNull
    public final Response validateImportFolder(@QueryParam(value="directory") @Nullable String directory, @QueryParam(value="folderName") @Nullable String folderName) {
        Response response2;
        if (!this.migrationFeatures.getEnableSinglePathManualIntervention() || !this.migrationFeatures.getEnableSinglePathLZ4MCS()) {
            response2 = ResponseUtils.INSTANCE.notFound();
        } else {
            CharSequence charSequence = directory;
            if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)folderName) == null || charSequence.length() == 0) {
                response2 = ResponseUtils.INSTANCE.badRequest("Mandatory directory and/or folderName parameter(s) missing");
            } else {
                String[] stringArray = new String[]{folderName};
                java.nio.file.Path folder = Paths.get(directory, stringArray);
                if (!folder.normalize().startsWith(directory)) {
                    response2 = ResponseUtils.INSTANCE.badRequest("Could not locate " + folderName + " under directory " + directory);
                } else {
                    Collection<ManualImportDuplicatedFileDto> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNull((Object)folder);
                    ManualInterventionValidationResult validationResult = this.manualInterventionValidator.validate(((Object)folder).toString());
                    Iterable iterable = validationResult.getValidationDetails().getDuplicatedFiles();
                    String string = ((Object)folder).toString();
                    ValidationStatus validationStatus = validationResult.getValidationStatus();
                    ResponseUtils responseUtils = ResponseUtils.INSTANCE;
                    boolean $i$f$map = false;
                    void var7_10 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DuplicatedFile duplicatedFile = (DuplicatedFile)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(ApiModelKt.fromDuplicatedFile((DuplicatedFile)it));
                    }
                    Collection<ManualImportDuplicatedFileDto> collection2 = collection = (List)destination$iv$iv;
                    String string2 = string;
                    ValidationStatus validationStatus2 = validationStatus;
                    response2 = responseUtils.ok(new ManualInterventionValidationDto(validationStatus2, string2, (List<ManualImportDuplicatedFileDto>)collection2));
                }
            }
        }
        return response2;
    }

    @GET
    @Path(value="hostingType")
    @NotNull
    public final Response getHostingType() {
        return ResponseUtils.INSTANCE.ok(this.senSupplier.getHosting());
    }
}

